/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.log.Logger;

class BlockTable {
    private static final Logger log = Logger.getLogger(BlockTable.class);
    private static final int BLOCKS_TABLE_START = 32;
    private static final int ENTRY_SIZE = 512;
    private static final int TABLE_SIZE = 240;
    private int curroff;
    private final List<char[]> blocks = new ArrayList<char[]>(200);
    private char[] currTable;

    BlockTable() {
    }

    public void writeTable(ByteBuffer buf, int n) {
        char[] cbuf = this.blocks.get(n);
        log.debug("block with length", cbuf.length);
        for (char c : cbuf) {
            buf.putChar(c);
        }
    }

    public void readTable(ByteBuffer buf) {
        buf.position(32);
        buf.limit(512);
        char[] cbuf = this.newTable();
        for (int i = 0; i < cbuf.length; ++i) {
            char c;
            cbuf[i] = c = buf.getChar();
        }
    }

    public void addBlock(int n) {
        char[] thisTable = this.currTable;
        if (this.curroff >= 240 || this.currTable == null) {
            thisTable = this.newTable();
        }
        thisTable[this.curroff++] = (char)n;
    }

    public int physFromLogical(int lblock) {
        int blockNum = lblock / 240;
        int offset = lblock - blockNum * 240;
        if (blockNum >= this.blocks.size()) {
            return 65535;
        }
        char[] cbuf = this.blocks.get(blockNum);
        return cbuf[offset];
    }

    public int getNBlockTables() {
        return this.blocks.size();
    }

    private char[] newTable() {
        char[] table = new char[240];
        Arrays.fill(table, '\uffff');
        this.curroff = 0;
        this.blocks.add(table);
        this.currTable = table;
        return table;
    }
}

