/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.BlockManager;
import uk.me.parabola.imgfmt.sys.BlockTable;
import uk.me.parabola.log.Logger;

class Dirent
implements DirectoryEntry {
    protected static final Logger log = Logger.getLogger(Dirent.class);
    static final int MAX_FILE_LEN = 8;
    static final int MAX_EXT_LEN = 3;
    static final int OFF_FILE_USED = 0;
    static final int OFF_NAME = 1;
    static final int OFF_EXT = 9;
    static final int OFF_FLAG = 16;
    static final int OFF_FILE_PART = 17;
    private static final int OFF_SIZE = 12;
    private String name;
    private String ext;
    private int size;
    private final BlockManager blockManager;
    private final BlockTable blockTable;
    private boolean special;
    private static final int OFF_USED_FLAG = 0;
    private boolean initialized;

    Dirent(String name, BlockManager blockManager) {
        this.blockManager = blockManager;
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            throw new IllegalArgumentException("Filename did not have dot");
        }
        this.setName(name.substring(0, dot));
        this.setExt(name.substring(dot + 1));
        this.blockTable = new BlockTable();
    }

    void sync(ImgChannel file) throws IOException {
        int ntables = this.blockTable.getNBlockTables();
        ByteBuffer buf = ByteBuffer.allocate(512 * ntables);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int part = 0; part < ntables; ++part) {
            log.debug("position at part", part, "is", buf.position());
            buf.put((byte)1);
            buf.put(Utils.toBytes(this.name, 8, (byte)32));
            buf.put(Utils.toBytes(this.ext, 3, (byte)32));
            if (part == 0) {
                log.debug("dirent", this.name, Character.valueOf('.'), this.ext, "size is going to", this.size);
                buf.putInt(this.size);
            } else {
                buf.putInt(0);
            }
            buf.put((byte)(this.special ? 3 : 0));
            buf.putChar((char)part);
            buf.position(512 * part + 32);
            this.blockTable.writeTable(buf, part);
        }
        buf.flip();
        file.write(buf);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExt() {
        return this.ext;
    }

    @Override
    public String getFullName() {
        return this.name + '.' + this.ext;
    }

    void initBlocks(ByteBuffer buf) {
        byte used = buf.get(0);
        if (used != 1) {
            return;
        }
        int part = buf.get(17) & 0xFF;
        if (part == 0 || this.isSpecial() && part == 3) {
            this.size = buf.getInt(12);
        }
        this.blockTable.readTable(buf);
        this.initialized = true;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void setName(String name) {
        int len = name.length();
        if (len > 8) {
            this.name = name.substring(0, 8);
        } else if (len < 8) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 8 - len; ++i) {
                sb.append('0');
            }
            sb.append(name);
            this.name = sb.toString();
        } else {
            this.name = name;
        }
    }

    private void setExt(String ext) {
        log.debug("ext len", ext.length());
        if (ext.length() != 3) {
            throw new IllegalArgumentException("File extension is wrong size");
        }
        this.ext = ext;
    }

    int numberHeaderBlocks() {
        return this.blockTable.getNBlockTables();
    }

    void setSize(int size) {
        if (log.isDebugEnabled()) {
            log.debug("setting size", this.getName(), this.getExt(), "to", size);
        }
        this.size = size;
    }

    void addBlock(int n) {
        this.blockTable.addBlock(n);
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    public int getPhysicalBlock(int lblock) {
        return this.blockTable.physFromLogical(lblock);
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }
}

