/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Highway;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.net.NETFile;
import uk.me.parabola.imgfmt.app.net.NODFile;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.RGNFile;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREFile;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.build.LayerFilterChain;
import uk.me.parabola.mkgmap.build.Locator;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.build.MapArea;
import uk.me.parabola.mkgmap.build.MapSplitter;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.filters.BaseFilter;
import uk.me.parabola.mkgmap.filters.DouglasPeuckerFilter;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.LineMergeFilter;
import uk.me.parabola.mkgmap.filters.LinePreparerFilter;
import uk.me.parabola.mkgmap.filters.LineSplitterFilter;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.PolygonSplitterFilter;
import uk.me.parabola.mkgmap.filters.PreserveHorizontalAndVerticalLinesFilter;
import uk.me.parabola.mkgmap.filters.RemoveEmpty;
import uk.me.parabola.mkgmap.filters.RemoveObsoletePointsFilter;
import uk.me.parabola.mkgmap.filters.RoundCoordsFilter;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.filters.SizeFilter;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapExitPoint;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.overview.OverviewMapDataSource;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public class MapBuilder
implements Configurable {
    private static final Logger log = Logger.getLogger(MapBuilder.class);
    private static final int CLEAR_TOP_BITS = 17;
    private static final int MIN_SIZE_LINE = 1;
    private final java.util.Map<MapPoint, POIRecord> poimap = new HashMap<MapPoint, POIRecord>();
    private final java.util.Map<MapPoint, City> cityMap = new HashMap<MapPoint, City>();
    private List<String> mapInfo = new ArrayList<String>();
    private List<String> copyrights = new ArrayList<String>();
    private boolean doRoads;
    private Boolean driveOnLeft;
    private Locator locator;
    private final java.util.Map<String, Highway> highways = new HashMap<String, Highway>();
    private static final String UNKNOWN_CITY_NAME = "";
    private Country defaultCountry;
    private String countryName = "COUNTRY";
    private String countryAbbr = "ABC";
    private String regionName = null;
    private String regionAbbr;
    private Set<String> locationAutofill = Collections.emptySet();
    private int minSizePolygon;
    private String polygonSizeLimitsOpt;
    private HashMap<Integer, Integer> polygonSizeLimits = null;
    private double reducePointError;
    private double reducePointErrorPolygon;
    private boolean mergeLines;
    private boolean mergeShapes;
    private boolean poiAddresses;
    private int poiDisplayFlags;
    private boolean enableLineCleanFilters = true;
    private boolean makePOIIndex;
    private int routeCenterBoundaryType;
    private LBLFile lblFile;
    private String licenseFileName;

    public MapBuilder() {
        this.locator = new Locator();
    }

    @Override
    public void config(EnhancedProperties props) {
        this.countryName = props.getProperty("country-name", this.countryName);
        this.countryAbbr = props.getProperty("country-abbr", this.countryAbbr);
        this.regionName = props.getProperty("region-name", null);
        this.regionAbbr = props.getProperty("region-abbr", null);
        this.minSizePolygon = props.getProperty("min-size-polygon", 8);
        this.polygonSizeLimitsOpt = props.getProperty("polygon-size-limits", null);
        this.reducePointError = props.getProperty("reduce-point-density", 2.6);
        this.reducePointErrorPolygon = props.getProperty("reduce-point-density-polygon", -1);
        if (this.reducePointErrorPolygon == -1.0) {
            this.reducePointErrorPolygon = this.reducePointError;
        }
        this.mergeLines = props.containsKey("merge-lines");
        this.mergeShapes = !props.getProperty("no-mergeshapes", false);
        this.makePOIIndex = props.getProperty("make-poi-index", false);
        if (props.getProperty("poi-address") != null) {
            this.poiAddresses = true;
        }
        this.routeCenterBoundaryType = props.getProperty("route-center-boundary", 0);
        this.licenseFileName = props.getProperty("license-file", null);
        this.locationAutofill = LocatorUtil.parseAutofillOption(props);
        this.locator = new Locator(props);
        this.locator.setDefaultCountry(this.countryName, this.countryAbbr);
        String driveOn = props.getProperty("drive-on", null);
        if ("left".equals(driveOn)) {
            this.driveOnLeft = true;
        }
        if ("right".equals(driveOn)) {
            this.driveOnLeft = false;
        }
    }

    public void makeMap(Map map, LoadableMapDataSource src) {
        RGNFile rgnFile = map.getRgnFile();
        TREFile treFile = map.getTreFile();
        this.lblFile = map.getLblFile();
        NETFile netFile = map.getNetFile();
        if (this.routeCenterBoundaryType != 0 && netFile != null && src instanceof MapperBasedMapDataSource) {
            for (RouteCenter rc : src.getRoadNetwork().getCenters()) {
                ((MapperBasedMapDataSource)((Object)src)).addBoundaryLine(rc.getArea(), this.routeCenterBoundaryType, rc.reportSizes());
            }
        }
        if (this.mapInfo.isEmpty()) {
            this.getMapInfo();
        }
        this.normalizeCountries(src);
        this.processCities(map, src);
        this.processRoads(map, src);
        this.processPOIs(map, src);
        this.processOverviews(map, src);
        this.processInfo(map, src);
        this.makeMapAreas(map, src);
        if (this.driveOnLeft == null && src instanceof MapperBasedMapDataSource) {
            this.driveOnLeft = ((MapperBasedMapDataSource)((Object)src)).getDriveOnLeft();
        }
        if (this.driveOnLeft == null) {
            this.driveOnLeft = false;
        }
        treFile.setDriveOnLeft(this.driveOnLeft);
        treFile.setLastRgnPos(rgnFile.position() - 125);
        rgnFile.write();
        treFile.write(rgnFile.haveExtendedTypes());
        treFile.writePost();
        this.lblFile.write();
        this.lblFile.writePost();
        if (netFile != null) {
            RoadNetwork network = src.getRoadNetwork();
            netFile.setNetwork(network.getRoadDefs());
            NODFile nodFile = map.getNodFile();
            if (nodFile != null) {
                nodFile.setNetwork(network.getCenters(), network.getRoadDefs(), network.getBoundary());
                nodFile.setDriveOnLeft(this.driveOnLeft);
                nodFile.write();
            }
            netFile.write(this.lblFile.numCities(), this.lblFile.numZips());
            if (nodFile != null) {
                nodFile.writePost();
            }
            netFile.writePost(rgnFile.getWriter());
        }
    }

    private Country getDefaultCountry() {
        if (this.defaultCountry == null && this.lblFile != null) {
            this.defaultCountry = this.lblFile.createCountry(this.countryName, this.countryAbbr);
        }
        return this.defaultCountry;
    }

    private Region getDefaultRegion(Country country) {
        if (this.lblFile == null || this.regionName == null) {
            return null;
        }
        if (country == null) {
            if (this.getDefaultCountry() == null) {
                return null;
            }
            return this.lblFile.createRegion(this.getDefaultCountry(), this.regionName, this.regionAbbr);
        }
        return this.lblFile.createRegion(country, this.regionName, this.regionAbbr);
    }

    private void normalizeCountries(MapDataSource src) {
        String countryStr;
        for (MapPoint p : src.getPoints()) {
            countryStr = p.getCountry();
            if (countryStr == null) continue;
            countryStr = this.locator.normalizeCountry(countryStr);
            p.setCountry(countryStr);
        }
        for (MapLine l : src.getLines()) {
            countryStr = l.getCountry();
            if (countryStr == null) continue;
            countryStr = this.locator.normalizeCountry(countryStr);
            l.setCountry(countryStr);
        }
    }

    private void processCities(Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        if (!this.locationAutofill.isEmpty()) {
            for (MapPoint p : src.getPoints()) {
                if (!p.isCity() || p.getName() == null) continue;
                this.locator.addCityOrPlace(p);
            }
            this.locator.autofillCities();
        }
        for (MapPoint p : src.getPoints()) {
            if (!p.isCity() || p.getName() == null) continue;
            String countryStr = p.getCountry();
            Country thisCountry = countryStr != null ? lbl.createCountry(countryStr, this.locator.getCountryISOCode(countryStr)) : this.getDefaultCountry();
            String regionStr = p.getRegion();
            Region thisRegion = regionStr != null ? lbl.createRegion(thisCountry, regionStr, null) : this.getDefaultRegion(thisCountry);
            City thisCity = thisRegion != null ? lbl.createCity(thisRegion, p.getName(), true) : lbl.createCity(thisCountry, p.getName(), true);
            this.cityMap.put(p, thisCity);
        }
    }

    private void processRoads(Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        MapPoint searchPoint = new MapPoint();
        for (MapLine line : src.getLines()) {
            if (!line.isRoad()) continue;
            String cityName = line.getCity();
            String cityCountryName = line.getCountry();
            String cityRegionName = line.getRegion();
            String zipStr = line.getZip();
            if (cityName == null && this.locationAutofill.contains("nearest")) {
                searchPoint.setLocation(line.getLocation());
                MapPoint nextCity = this.locator.findNextPoint(searchPoint);
                if (nextCity != null) {
                    cityName = nextCity.getCity();
                    cityCountryName = nextCity.getCountry();
                    cityRegionName = nextCity.getRegion();
                    if (zipStr == null) {
                        zipStr = nextCity.getZip();
                    }
                }
            }
            if (cityName == null && (cityCountryName != null || cityRegionName != null)) {
                cityName = UNKNOWN_CITY_NAME;
            }
            if (cityName != null) {
                Region cr;
                Country cc = cityCountryName == null ? this.getDefaultCountry() : lbl.createCountry(cityCountryName, this.locator.getCountryISOCode(cityCountryName));
                Region region = cr = cityRegionName == null ? this.getDefaultRegion(cc) : lbl.createRegion(cc, cityRegionName, null);
                if (cr != null) {
                    ((MapRoad)line).setRoadCity(lbl.createCity(cr, cityName, false));
                } else {
                    ((MapRoad)line).setRoadCity(lbl.createCity(cc, cityName, false));
                }
            }
            if (zipStr == null) continue;
            ((MapRoad)line).setRoadZip(lbl.createZip(zipStr));
        }
    }

    private void processPOIs(Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        boolean checkedForPoiDispFlag = false;
        for (MapPoint p : src.getPoints()) {
            String phone;
            String houseNumber;
            if (p.isExit()) {
                this.processExit(map, (MapExitPoint)p);
                continue;
            }
            if (p.isCity() || p.hasExtendedType() || !p.isRoadNamePOI() && !this.poiAddresses) continue;
            String countryStr = p.getCountry();
            String regionStr = p.getRegion();
            String zipStr = p.getZip();
            String cityStr = p.getCity();
            if (this.locationAutofill.contains("nearest") && (countryStr == null || regionStr == null || zipStr == null && cityStr == null)) {
                MapPoint nextCity = this.locator.findNearbyCityByName(p);
                if (nextCity == null) {
                    nextCity = this.locator.findNextPoint(p);
                }
                if (nextCity != null) {
                    String cityZipStr;
                    if (countryStr == null) {
                        countryStr = nextCity.getCountry();
                    }
                    if (regionStr == null) {
                        regionStr = nextCity.getRegion();
                    }
                    if (zipStr == null && (cityZipStr = nextCity.getZip()) != null && cityZipStr.indexOf(44) < 0) {
                        zipStr = cityZipStr;
                    }
                    if (cityStr == null) {
                        cityStr = nextCity.getCity();
                    }
                }
            }
            if (countryStr != null && !checkedForPoiDispFlag) {
                this.poiDisplayFlags = this.locator.getPOIDispFlag(countryStr);
                checkedForPoiDispFlag = true;
            }
            if (p.isRoadNamePOI() && cityStr != null) {
                p.setStreet(p.getName());
                p.setName(p.getName() + "/" + cityStr);
            }
            POIRecord r = lbl.createPOI(p.getName());
            if (cityStr == null && (countryStr != null || regionStr != null)) {
                cityStr = UNKNOWN_CITY_NAME;
            }
            if (cityStr != null) {
                Country thisCountry = countryStr != null ? lbl.createCountry(countryStr, this.locator.getCountryISOCode(countryStr)) : this.getDefaultCountry();
                Region thisRegion = regionStr != null ? lbl.createRegion(thisCountry, regionStr, null) : this.getDefaultRegion(thisCountry);
                City city = thisRegion != null ? lbl.createCity(thisRegion, cityStr, false) : lbl.createCity(thisCountry, cityStr, false);
                r.setCity(city);
            }
            if (zipStr != null) {
                Zip zip = lbl.createZip(zipStr);
                r.setZip(zip);
            }
            if (p.getStreet() != null) {
                Label streetName = lbl.newLabel(p.getStreet());
                r.setStreetName(streetName);
            }
            if ((houseNumber = p.getHouseNumber()) != null && !houseNumber.isEmpty() && !r.setSimpleStreetNumber(houseNumber)) {
                r.setComplexStreetNumber(lbl.newLabel(houseNumber));
            }
            if ((phone = p.getPhone()) != null && !phone.isEmpty() && !r.setSimplePhoneNumber(phone)) {
                r.setComplexPhoneNumber(lbl.newLabel(phone));
            }
            this.poimap.put(p, r);
        }
        lbl.allPOIsDone();
    }

    private void processExit(Map map, MapExitPoint mep) {
        LBLFile lbl = map.getLblFile();
        String ref = mep.getMotorwayRef();
        String OSMId = mep.getOSMId();
        if (ref != null) {
            Highway hw = this.highways.get(ref);
            if (hw == null) {
                hw = this.makeHighway(map, ref);
            }
            if (hw == null) {
                log.warn("Can't create exit", mep.getName(), "(OSM id", OSMId, ") on unknown highway", ref);
                return;
            }
            String exitName = mep.getName();
            String exitTo = mep.getTo();
            Exit exit = new Exit(hw);
            String facilityDescription = mep.getFacilityDescription();
            log.info("Creating", ref, "exit", exitName, "(OSM id", OSMId + ") to", exitTo, "with facility", facilityDescription == null ? "(none)" : facilityDescription);
            if (facilityDescription != null) {
                String[] atts = facilityDescription.split(",");
                int type = 0;
                if (atts.length > 0) {
                    type = Integer.decode(atts[0]);
                }
                char direction = ' ';
                if (atts.length > 1 && (direction = (char)atts[1].charAt(0)) == '\'' && atts[1].length() > 1) {
                    direction = atts[1].charAt(1);
                }
                int facilities = 0;
                if (atts.length > 2) {
                    facilities = Integer.decode(atts[2]);
                }
                String description = UNKNOWN_CITY_NAME;
                if (atts.length > 3) {
                    description = atts[3];
                }
                boolean last = true;
                ExitFacility ef = lbl.createExitFacility(type, direction, facilities, description, last);
                exit.addFacility(ef);
            }
            mep.setExit(exit);
            POIRecord r = lbl.createExitPOI(exitName, exit);
            if (exitTo != null) {
                Label ed = lbl.newLabel(exitTo);
                exit.setDescription(ed);
            }
            this.poimap.put(mep, r);
        }
    }

    private void makeMapAreas(Map map, LoadableMapDataSource src) {
        Subdivision topdiv;
        LevelInfo[] levels = null;
        levels = src instanceof OverviewMapDataSource ? src.mapLevels() : (OverviewBuilder.isOverviewImg(map.getFilename()) ? src.overviewMapLevels() : src.mapLevels());
        if (levels == null) {
            throw new ExitException("no info about levels available.");
        }
        LevelInfo levelInfo = levels[0];
        if (levelInfo.isTop()) {
            levels = Arrays.copyOfRange(levels, 1, levels.length);
            Zoom zoom = map.createZoom(levelInfo.getLevel(), levelInfo.getBits());
            topdiv = MapBuilder.makeTopArea(src, map, zoom);
        } else {
            int maxBits = MapBuilder.getMaxBits(src);
            if (levelInfo.getBits() <= maxBits) {
                maxBits = levelInfo.getBits() - 1;
            }
            Zoom zoom = map.createZoom(levelInfo.getLevel() + 1, maxBits);
            topdiv = MapBuilder.makeTopArea(src, map, zoom);
        }
        List<SourceSubdiv> srcList = Collections.singletonList(new SourceSubdiv(src, topdiv));
        for (LevelInfo linfo : levels) {
            ArrayList<SourceSubdiv> nextList = new ArrayList<SourceSubdiv>();
            Zoom zoom = map.createZoom(linfo.getLevel(), linfo.getBits());
            for (SourceSubdiv srcDivPair : srcList) {
                MapSplitter splitter = new MapSplitter(srcDivPair.getSource(), zoom);
                MapArea[] areas = splitter.split();
                log.info("Map region", srcDivPair.getSource().getBounds(), "split into", areas.length, "areas at resolution", zoom.getResolution());
                for (MapArea area : areas) {
                    Subdivision parent = srcDivPair.getSubdiv();
                    Subdivision div = this.makeSubdivision(map, parent, area, zoom);
                    if (log.isDebugEnabled()) {
                        log.debug("ADD parent-subdiv", parent, srcDivPair.getSource(), ", z=", zoom, " new=", div);
                    }
                    nextList.add(new SourceSubdiv(area, div));
                }
                if (nextList.size() <= 0) continue;
                Subdivision lastdiv = ((SourceSubdiv)nextList.get(nextList.size() - 1)).getSubdiv();
                lastdiv.setLast(true);
            }
            srcList = nextList;
        }
    }

    private static Subdivision makeTopArea(MapDataSource src, Map map, Zoom zoom) {
        Subdivision topdiv = map.topLevelSubdivision(src.getBounds(), zoom);
        topdiv.setLast(true);
        return topdiv;
    }

    private Subdivision makeSubdivision(Map map, Subdivision parent, MapArea ma, Zoom z) {
        List<MapPoint> points = ma.getPoints();
        List<MapLine> lines = ma.getLines();
        List<MapShape> shapes = ma.getShapes();
        Subdivision div = map.createSubdivision(parent, ma.getFullBounds(), z);
        if (ma.hasPoints()) {
            div.setHasPoints(true);
        }
        if (ma.hasIndPoints()) {
            div.setHasIndPoints(true);
        }
        if (ma.hasLines()) {
            div.setHasPolylines(true);
        }
        if (ma.hasShapes()) {
            div.setHasPolygons(true);
        }
        div.startDivision();
        this.processPoints(map, div, points);
        this.processLines(map, div, lines);
        this.processShapes(map, div, shapes);
        div.endDivision();
        return div;
    }

    protected void processOverviews(Map map, MapDataSource src) {
        List<Overview> features = src.getOverviews();
        for (Overview ov : features) {
            switch (ov.getKind()) {
                case 1: {
                    map.addPointOverview((PointOverview)ov);
                    break;
                }
                case 2: {
                    map.addPolylineOverview((PolylineOverview)ov);
                    break;
                }
                case 3: {
                    map.addPolygonOverview((PolygonOverview)ov);
                    break;
                }
            }
        }
    }

    protected void getMapInfo() {
        if (this.licenseFileName != null) {
            File file = new File(this.licenseFileName);
            try {
                String text;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((text = reader.readLine()) != null) {
                    if (text.isEmpty()) continue;
                    this.mapInfo.add(text);
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                throw new ExitException("Could not open license file " + this.licenseFileName);
            }
            catch (IOException e) {
                throw new ExitException("Error reading license file " + this.licenseFileName);
            }
        } else {
            this.mapInfo.add("Map data (c) OpenStreetMap and its contributors");
            this.mapInfo.add("http://www.openstreetmap.org/copyright");
            this.mapInfo.add(UNKNOWN_CITY_NAME);
            this.mapInfo.add("This map data is made available under the Open Database License:");
            this.mapInfo.add("http://opendatacommons.org/licenses/odbl/1.0/");
            this.mapInfo.add("Any rights in individual contents of the database are licensed under the");
            this.mapInfo.add("Database Contents License: http://opendatacommons.org/licenses/dbcl/1.0/");
            this.mapInfo.add(UNKNOWN_CITY_NAME);
            this.mapInfo.add("Map created with mkgmap-r" + String.format("%-10s", Version.VERSION));
            this.mapInfo.add("Program released under the GPL");
        }
    }

    public void setMapInfo(List<String> msgs) {
        this.mapInfo = msgs;
    }

    public void setCopyrights(List<String> msgs) {
        this.copyrights = msgs;
    }

    protected void processInfo(Map map, LoadableMapDataSource src) {
        map.setBounds(src.getBounds());
        if (this.poiDisplayFlags != 0) {
            map.addPoiDisplayFlags(this.poiDisplayFlags);
        }
        String info = UNKNOWN_CITY_NAME;
        for (String s : this.mapInfo) {
            info = info + s.trim() + "\n";
        }
        if (!info.isEmpty()) {
            map.addInfo(info);
        }
        if (this.copyrights.isEmpty()) {
            String[] copyrightMessages = src.copyrightMessages();
            if (copyrightMessages.length < 2) {
                map.addCopyright("program licenced under GPL v2");
            }
            for (String cm : copyrightMessages) {
                map.addCopyright(cm);
            }
        } else {
            for (String cm : this.copyrights) {
                map.addCopyright(cm);
            }
        }
    }

    private void processPoints(Map map, Subdivision div, List<MapPoint> points) {
        Coord coord;
        Point p;
        String name;
        LBLFile lbl = map.getLblFile();
        div.startPoints();
        int res = div.getResolution();
        boolean haveIndPoints = false;
        int pointIndex = 1;
        for (MapPoint point : points) {
            if (!point.isCity() || point.getMinResolution() > res || point.getMaxResolution() < res) continue;
            ++pointIndex;
            haveIndPoints = true;
        }
        for (MapPoint point : points) {
            ExtTypeAttributes eta;
            if (point.isCity() || point.getMinResolution() > res || point.getMaxResolution() < res) continue;
            name = point.getName();
            p = div.createPoint(name);
            p.setType(point.getType());
            if (point.hasExtendedType() && (eta = point.getExtTypeAttributes()) != null) {
                eta.processLabels(lbl);
                p.setExtTypeAttributes(eta);
            }
            coord = point.getLocation();
            try {
                p.setLatitude(coord.getLatitude());
                p.setLongitude(coord.getLongitude());
            }
            catch (AssertionError ae) {
                log.error((Object)("Problem with point of type 0x" + Integer.toHexString(point.getType()) + " at " + coord.toOSMURL()));
                log.error((Object)("  Subdivision shift is " + div.getShift() + " and its centre is at " + div.getCenter().toOSMURL()));
                log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
                continue;
            }
            POIRecord r = this.poimap.get(point);
            if (r != null) {
                p.setPOIRecord(r);
            }
            map.addMapObject(p);
            if (point.hasExtendedType()) continue;
            if (name != null && div.getZoom().getLevel() == 0) {
                if (pointIndex > 255) {
                    log.error((Object)("Too many POIs at location " + div.getCenter().toOSMURL() + " - " + name + " will be ignored"));
                } else if (point.isExit()) {
                    Exit e = ((MapExitPoint)point).getExit();
                    if (e != null) {
                        e.getHighway().addExitPoint(name, pointIndex, div);
                    }
                } else if (this.makePOIIndex) {
                    lbl.createPOIIndex(name, pointIndex, div, point.getType());
                }
            }
            ++pointIndex;
        }
        if (haveIndPoints) {
            div.startIndPoints();
            pointIndex = 1;
            for (MapPoint point : points) {
                if (!point.isCity() || point.getMinResolution() > res || point.getMaxResolution() < res) continue;
                name = point.getName();
                p = div.createPoint(name);
                p.setType(point.getType());
                coord = point.getLocation();
                try {
                    p.setLatitude(coord.getLatitude());
                    p.setLongitude(coord.getLongitude());
                }
                catch (AssertionError ae) {
                    log.error((Object)("Problem with point of type 0x" + Integer.toHexString(point.getType()) + " at " + coord.toOSMURL()));
                    log.error((Object)("  Subdivision shift is " + div.getShift() + " and its centre is at " + div.getCenter().toOSMURL()));
                    log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
                    continue;
                }
                map.addMapObject(p);
                if (name != null && div.getZoom().getLevel() == 0) {
                    City c = this.cityMap.get(point);
                    if (pointIndex > 255) {
                        System.err.println("Can't set city point index for " + name + " (too many indexed points in division)\n");
                    } else {
                        c.setPointIndex((byte)pointIndex);
                        c.setSubdivision(div);
                    }
                }
                ++pointIndex;
            }
        }
    }

    private void processLines(Map map, Subdivision div, List<MapLine> lines) {
        div.startLines();
        int res = div.getResolution();
        FilterConfig config = new FilterConfig();
        config.setResolution(res);
        config.setLevel(div.getZoom().getLevel());
        config.setRoutable(this.doRoads);
        if (this.mergeLines) {
            LineMergeFilter merger = new LineMergeFilter();
            lines = merger.merge(lines, res);
        }
        LayerFilterChain filters = new LayerFilterChain(config);
        if (this.enableLineCleanFilters && res < 24) {
            filters.addFilter(new RoundCoordsFilter());
            filters.addFilter(new SizeFilter(1));
            if (this.reducePointError > 0.0) {
                filters.addFilter(new DouglasPeuckerFilter(this.reducePointError));
            }
        }
        filters.addFilter(new LineSplitterFilter());
        filters.addFilter(new RemoveEmpty());
        filters.addFilter(new RemoveObsoletePointsFilter());
        filters.addFilter(new LinePreparerFilter(div));
        filters.addFilter(new LineAddFilter(div, map, this.doRoads));
        for (MapLine line : lines) {
            if (line.getMinResolution() > res || line.getMaxResolution() < res) continue;
            filters.startFilter(line);
        }
    }

    private void processShapes(Map map, Subdivision div, List<MapShape> shapes) {
        div.startShapes();
        int res = div.getResolution();
        FilterConfig config = new FilterConfig();
        config.setResolution(res);
        config.setLevel(div.getZoom().getLevel());
        config.setRoutable(this.doRoads);
        if (this.mergeShapes) {
            ShapeMergeFilter shapeMergeFilter = new ShapeMergeFilter(res);
            List<MapShape> mergedShapes = shapeMergeFilter.merge(shapes);
            shapes = mergedShapes;
        }
        LayerFilterChain filters = new LayerFilterChain(config);
        if (this.enableLineCleanFilters && res < 24) {
            filters.addFilter(new PreserveHorizontalAndVerticalLinesFilter());
            filters.addFilter(new RoundCoordsFilter());
            int sizefilterVal = this.getMinSizePolygonForResolution(res);
            if (sizefilterVal > 0) {
                filters.addFilter(new SizeFilter(sizefilterVal));
            }
            if (this.reducePointErrorPolygon > 0.0) {
                filters.addFilter(new DouglasPeuckerFilter(this.reducePointErrorPolygon));
            }
        }
        filters.addFilter(new PolygonSplitterFilter());
        filters.addFilter(new RemoveEmpty());
        filters.addFilter(new RemoveObsoletePointsFilter());
        filters.addFilter(new LinePreparerFilter(div));
        filters.addFilter(new ShapeAddFilter(div, map));
        for (MapShape shape : shapes) {
            if (shape.getMinResolution() > res || shape.getMaxResolution() < res) continue;
            filters.startFilter(shape);
        }
    }

    Highway makeHighway(Map map, String ref) {
        Highway hw;
        if (this.getDefaultRegion(null) == null) {
            log.warn((Object)("Highway " + ref + " has no region (define a default region to zap this warning)"));
        }
        if ((hw = this.highways.get(ref)) == null) {
            LBLFile lblFile = map.getLblFile();
            log.info((Object)("creating highway " + ref));
            hw = lblFile.createHighway(this.getDefaultRegion(null), ref);
            this.highways.put(ref, hw);
        }
        return hw;
    }

    private static int getMaxBits(MapDataSource src) {
        int topshift = Integer.numberOfLeadingZeros(src.getBounds().getMaxDimension());
        int minShift = Math.max(17 - topshift, 0);
        return 24 - minShift;
    }

    public void setDoRoads(boolean doRoads) {
        this.doRoads = doRoads;
    }

    public void setEnableLineCleanFilters(boolean enable) {
        this.enableLineCleanFilters = enable;
    }

    private int getMinSizePolygonForResolution(int res) {
        if (this.polygonSizeLimitsOpt == null) {
            return this.minSizePolygon;
        }
        if (this.polygonSizeLimits == null) {
            this.polygonSizeLimits = new HashMap();
            String[] desc = this.polygonSizeLimitsOpt.split("[, \\t\\n]+");
            int count = 0;
            for (String s : desc) {
                String[] keyVal = s.split("[=:]");
                if (keyVal == null || keyVal.length < 2) {
                    System.err.println("incorrect polygon-size-limits specification " + this.polygonSizeLimitsOpt);
                    continue;
                }
                try {
                    int key = Integer.parseInt(keyVal[0]);
                    int value = Integer.parseInt(keyVal[1]);
                    Integer testDup = this.polygonSizeLimits.put(key, value);
                    if (testDup != null) {
                        System.err.println("duplicate resolution value in polygon-size-limits specification " + this.polygonSizeLimitsOpt);
                        continue;
                    }
                }
                catch (NumberFormatException e) {
                    System.err.println("polygon-size-limits specification not all numbers " + keyVal[count]);
                }
                ++count;
            }
        }
        if (this.polygonSizeLimits != null) {
            for (int r = res; r <= 24; ++r) {
                Integer limit = this.polygonSizeLimits.get(r);
                if (limit == null) continue;
                if (r != res) {
                    this.polygonSizeLimits.put(res, limit);
                }
                return limit;
            }
            return 0;
        }
        return this.minSizePolygon;
    }

    private static class ShapeAddFilter
    extends BaseFilter
    implements MapFilter {
        private final Subdivision div;
        private final Map map;

        ShapeAddFilter(Subdivision div, Map map) {
            this.div = div;
            this.map = map;
        }

        @Override
        public void doFilter(MapElement element, MapFilterChain next) {
            ExtTypeAttributes eta;
            MapShape shape = (MapShape)element;
            assert (shape.getPoints().size() < 255) : "too many points";
            Polygon pg = this.div.createPolygon(shape.getName());
            pg.addCoords(shape.getPoints());
            pg.setType(shape.getType());
            if (element.hasExtendedType() && (eta = element.getExtTypeAttributes()) != null) {
                eta.processLabels(this.map.getLblFile());
                pg.setExtTypeAttributes(eta);
            }
            this.map.addMapObject(pg);
        }
    }

    private class LineAddFilter
    extends BaseFilter
    implements MapFilter {
        private final Subdivision div;
        private final Map map;
        private final boolean doRoads;

        LineAddFilter(Subdivision div, Map map, boolean doRoads) {
            this.div = div;
            this.map = map;
            this.doRoads = doRoads;
        }

        @Override
        public void doFilter(MapElement element, MapFilterChain next) {
            MapLine line = (MapLine)element;
            assert (line.getPoints().size() < 255) : "too many points";
            Polyline pl = this.div.createLine(line.getLabels());
            if (element.hasExtendedType()) {
                ExtTypeAttributes eta = element.getExtTypeAttributes();
                if (eta != null) {
                    eta.processLabels(this.map.getLblFile());
                    pl.setExtTypeAttributes(eta);
                }
            } else {
                this.div.setPolylineNumber(pl);
            }
            pl.setDirection(line.isDirection());
            pl.addCoords(line.getPoints());
            pl.setType(line.getType());
            if (this.doRoads && line instanceof MapRoad) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding road def: " + line.getName()));
                }
                MapRoad road = (MapRoad)line;
                RoadDef roaddef = road.getRoadDef();
                pl.setRoadDef(roaddef);
                if (road.hasSegmentsFollowing()) {
                    pl.setLastSegment(false);
                }
                roaddef.addPolylineRef(pl);
            }
            this.map.addMapObject(pl);
        }
    }

    private static class SourceSubdiv {
        private final MapDataSource source;
        private final Subdivision subdiv;

        SourceSubdiv(MapDataSource ds, Subdivision subdiv) {
            this.source = ds;
            this.subdiv = subdiv;
        }

        public MapDataSource getSource() {
            return this.source;
        }

        public Subdivision getSubdiv() {
            return this.subdiv;
        }
    }
}

