/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.Arrays;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.MapObject;

public abstract class MapElement {
    private String[] labels;
    private int type;
    private int minResolution = 24;
    private int maxResolution = 24;
    private ExtTypeAttributes extTypeAttributes;
    private String zip;
    private String country;
    private String region;
    private String city;
    private String street;
    private String phone;
    private String houseNumber;
    private String isIn;

    protected MapElement() {
        this.labels = new String[4];
    }

    protected MapElement(MapElement orig) {
        this.labels = Arrays.copyOf(orig.labels, 4);
        this.type = orig.type;
        this.minResolution = orig.minResolution;
        this.maxResolution = orig.maxResolution;
        this.extTypeAttributes = orig.extTypeAttributes;
        this.zip = orig.zip;
        this.country = orig.country;
        this.region = orig.region;
        this.city = orig.city;
        this.street = orig.street;
        this.phone = orig.phone;
        this.houseNumber = orig.houseNumber;
        this.isIn = orig.isIn;
    }

    public abstract MapElement copy();

    public String getName() {
        return this.labels[0];
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setName(String name) {
        this.labels[0] = name;
    }

    public void add2Name(String name) {
        for (int i = 1; i < 4; ++i) {
            if (this.labels[i] != null) continue;
            this.labels[i] = name;
            break;
        }
    }

    public void setLabels(String[] labels) {
        this.labels = Arrays.copyOf(labels, 4);
    }

    public ExtTypeAttributes getExtTypeAttributes() {
        return this.extTypeAttributes;
    }

    public void setExtTypeAttributes(ExtTypeAttributes eta) {
        this.extTypeAttributes = eta;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        if (phone.startsWith("00")) {
            phone = phone.replaceFirst("00", "+");
        }
        this.phone = phone;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getIsIn() {
        return this.isIn;
    }

    public void setIsIn(String isIn) {
        if (isIn != null) {
            this.isIn = isIn.toUpperCase();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isSimilar(MapElement other) {
        if (this.minResolution != other.minResolution) {
            return false;
        }
        if (this.maxResolution != other.maxResolution) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        if (thisName == null && otherName == null) {
            return true;
        }
        return thisName != null && otherName != null && thisName.equals(otherName);
    }

    public boolean hasExtendedType() {
        return MapObject.hasExtendedType(this.type);
    }

    public abstract Coord getLocation();

    public int getMinResolution() {
        return this.minResolution;
    }

    public void setMinResolution(int minResolution) {
        this.minResolution = minResolution;
    }

    public int getMaxResolution() {
        return this.maxResolution;
    }

    public void setMaxResolution(int maxResolution) {
        this.maxResolution = maxResolution;
    }
}

