/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.util.Java2DConverter;

public class PolygonClipper {
    public static List<List<Coord>> clip(Area bbox, List<Coord> coords) {
        if (bbox == null) {
            return null;
        }
        boolean foundOutside = false;
        for (Coord co : coords) {
            if (bbox.contains(co)) continue;
            foundOutside = true;
            break;
        }
        if (!foundOutside) {
            return null;
        }
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap(coords.size());
        for (int i = 1; i < coords.size(); ++i) {
            Coord co = coords.get(i);
            map.put(Utils.coord2Long(co), (Object)co);
        }
        java.awt.geom.Area bbarea = Java2DConverter.createBoundsArea(bbox);
        java.awt.geom.Area shape = Java2DConverter.createArea(coords);
        shape.intersect(bbarea);
        List<List<Coord>> shapes = Java2DConverter.areaToShapes(shape);
        for (List<Coord> sh : shapes) {
            for (int i = 0; i < sh.size(); ++i) {
                Coord co = sh.get(i);
                Coord origCoord = (Coord)map.get(Utils.coord2Long(co));
                if (origCoord != null) {
                    sh.set(i, origCoord);
                    continue;
                }
                map.put(Utils.coord2Long(co), (Object)co);
            }
        }
        return shapes;
    }
}

