/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.reader.plugin.MapReader;

public class MapMaker
implements MapProcessor {
    private static final Logger log = Logger.getLogger(MapMaker.class);
    private Sort sort;
    private final boolean createOverviewFiles;

    public MapMaker(boolean createOverviewFiles) {
        this.createOverviewFiles = createOverviewFiles;
    }

    @Override
    public String makeMap(CommandArgs args, String filename) {
        try {
            LoadableMapDataSource src = this.loadFromFile(args, filename);
            this.sort = args.getSort();
            log.info("Making Road Name POIs for", filename);
            this.makeRoadNamePOIS(args, src);
            if (this.createOverviewFiles) {
                if (src.overviewMapLevels() != null) {
                    this.makeMap(args, src, "ovm_");
                } else {
                    String fname = OverviewBuilder.getOverviewImgName(args.getMapname());
                    File f = new File(fname);
                    if (f.exists() && f.isFile()) {
                        f.delete();
                    }
                }
            }
            return this.makeMap(args, src, "");
        }
        catch (FormatException e) {
            System.err.println("Bad file format: " + filename);
            System.err.println(e.getMessage());
            return filename;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open file: " + filename);
            return filename;
        }
    }

    private String makeMap(CommandArgs args, LoadableMapDataSource src, String mapNamePrefix) {
        if (src.getBounds().isEmpty()) {
            return null;
        }
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(args.getBlockSize());
        params.setMapDescription(args.getDescription());
        log.info("Started making", args.getMapname(), "(" + args.getDescription() + ")");
        try {
            Map map = Map.createMap(mapNamePrefix + args.getMapname(), args.getOutputDir(), params, args.getMapname(), this.sort);
            this.setOptions(map, args);
            MapBuilder builder = new MapBuilder();
            builder.config(args.getProperties());
            if (!"ovm_".equals(mapNamePrefix) && (args.getProperties().containsKey("route") || args.getProperties().containsKey("net"))) {
                builder.setDoRoads(true);
            }
            builder.makeMap(map, src);
            String outName = map.getFilename();
            log.info("finished making map", outName, "closing");
            map.close();
            return outName;
        }
        catch (FileExistsException e) {
            throw new MapFailedException("File exists already", e);
        }
        catch (FileNotWritableException e) {
            throw new MapFailedException("Could not create or write to file", e);
        }
    }

    private void setOptions(Map map, CommandArgs args) {
        map.config(args.getProperties());
        String s = args.getCharset();
        if (s != null) {
            map.setLabelCharset(s, args.isForceUpper());
        }
        Sort sort = args.getSort();
        map.setSort(sort);
    }

    private LoadableMapDataSource loadFromFile(CommandArgs args, String name) throws FileNotFoundException, FormatException {
        LoadableMapDataSource src = MapReader.createMapReader(name);
        src.config(args.getProperties());
        log.info("Started loading", name);
        src.load(name);
        log.info("Finished loading", name);
        return src;
    }

    void makeRoadNamePOIS(CommandArgs args, LoadableMapDataSource src) {
        String rnp = args.get("road-name-pois", null);
        if (rnp != null) {
            rnp = rnp.toUpperCase();
            int rnpt = 25610;
            if (rnp.length() > 0) {
                rnpt = Integer.decode(rnp);
            }
            HashMap<String, List<MapRoad>> namedRoads = new HashMap<String, List<MapRoad>>();
            for (MapLine l : src.getLines()) {
                MapRoad mapRoad;
                String rn;
                if (!l.isRoad() || (rn = (mapRoad = (MapRoad)l).getName()) == null) continue;
                ArrayList<MapRoad> rl = (ArrayList<MapRoad>)namedRoads.get(rn);
                if (rl == null) {
                    rl = new ArrayList<MapRoad>();
                    namedRoads.put(rn, rl);
                }
                rl.add(mapRoad);
            }
            ArrayList<SortKey<MapRoad>> rnpRoads = new ArrayList<SortKey<MapRoad>>();
            for (List<MapRoad> list : this.findConnectedRoadsWithSameName(namedRoads)) {
                MapRoad r = list.get(0);
                String key = r.getName();
                List<Coord> points = r.getPoints();
                if (!points.isEmpty()) {
                    key = key + "_" + points.get(0);
                }
                rnpRoads.add(this.sort.createSortKey(r, key));
            }
            Collections.sort(rnpRoads);
            for (SortKey sortKey : rnpRoads) {
                src.getPoints().add(this.makeRoadNamePOI((MapRoad)sortKey.getObject(), rnpt));
            }
        }
    }

    private boolean roadsAreJoined(MapLine r1, MapLine r2) {
        if (!r1.getBounds().intersects(r2.getBounds())) {
            return false;
        }
        if (r1 != r2) {
            for (Coord c1 : r1.getPoints()) {
                for (Coord c2 : r2.getPoints()) {
                    if (c1 != c2 && !c1.highPrecEquals(c2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<List<MapRoad>> findConnectedRoadsWithSameName(java.util.Map<String, List<MapRoad>> namedRoads) {
        HashSet<List<MapRoad>> roadGroups = new HashSet<List<MapRoad>>();
        for (List<MapRoad> allRoadsWithSameName : namedRoads.values()) {
            HashMap<MapRoad, List> roadGroupMap = new HashMap<MapRoad, List>();
            for (int i = 0; i < allRoadsWithSameName.size(); ++i) {
                boolean roadWasJoined = false;
                for (int j = 0; j < allRoadsWithSameName.size(); ++j) {
                    MapRoad rj;
                    MapRoad ri;
                    if (i == j || !this.roadsAreJoined(ri = allRoadsWithSameName.get(i), rj = allRoadsWithSameName.get(j))) continue;
                    roadWasJoined = true;
                    ArrayList<MapRoad> groupi = (ArrayList<MapRoad>)roadGroupMap.get(ri);
                    List groupj = (List)roadGroupMap.get(rj);
                    if (groupi == null) {
                        if (groupj == null) {
                            groupi = new ArrayList<MapRoad>();
                            groupi.add(ri);
                            groupi.add(rj);
                            roadGroupMap.put(ri, groupi);
                            roadGroupMap.put(rj, groupi);
                            continue;
                        }
                        groupj.add(ri);
                        roadGroupMap.put(ri, groupj);
                        continue;
                    }
                    if (groupj == null) {
                        groupi.add(rj);
                        roadGroupMap.put(rj, groupi);
                        continue;
                    }
                    if (groupi == groupj) continue;
                    for (MapRoad r : groupj) {
                        roadGroupMap.put(r, groupi);
                    }
                    groupi.addAll(groupj);
                }
                if (roadWasJoined) continue;
                MapRoad ri = allRoadsWithSameName.get(i);
                ArrayList<MapRoad> group = new ArrayList<MapRoad>();
                group.add(ri);
                roadGroupMap.put(ri, group);
            }
            for (List r : roadGroupMap.values()) {
                roadGroups.add(r);
            }
        }
        return roadGroups;
    }

    private MapPoint makeRoadNamePOI(MapRoad road, int type) {
        Coord coord;
        List<Coord> points = road.getPoints();
        int numPoints = points.size();
        if ((numPoints & 1) == 0) {
            int i2 = numPoints / 2;
            int i1 = i2 - 1;
            coord = points.get(i1).makeBetweenPoint(points.get(i2), 0.5);
        } else {
            coord = points.get(numPoints / 2);
        }
        String name = road.getName();
        MapPoint rnp = new MapPoint();
        rnp.setName(name);
        rnp.setRoadNamePOI(true);
        rnp.setType(type);
        rnp.setLocation(coord);
        return rnp;
    }
}

