/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.mkgmap.osmstyle.RuleDetails;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class RuleIndex {
    private final List<RuleDetails> ruleDetails = new ArrayList<RuleDetails>();
    private final Map<Short, TagHelper> tagKeyMap = new HashMap<Short, TagHelper>();
    private TagHelper[] tagKeyArray = null;
    private boolean inited;

    public void addRuleToIndex(RuleDetails rd) {
        assert (!this.inited);
        this.ruleDetails.add(rd);
    }

    public Rule[] getRules() {
        int len = this.ruleDetails.size();
        Rule[] rules = new Rule[len];
        int ruleDetailsSize = this.ruleDetails.size();
        for (int i = 0; i < ruleDetailsSize; ++i) {
            RuleDetails rd = this.ruleDetails.get(i);
            rules[i] = rd.getRule();
        }
        return rules;
    }

    public BitSet getRulesForTag(short tagKey, String tagVal) {
        TagHelper th = this.tagKeyArray != null ? (tagKey >= 0 & tagKey < this.tagKeyArray.length ? this.tagKeyArray[tagKey] : null) : this.tagKeyMap.get(tagKey);
        if (th == null) {
            return new BitSet();
        }
        return th.getBitSet(tagVal);
    }

    public void prepare() {
        if (this.inited) {
            return;
        }
        HashMap<String, BitSet> existKeys = new HashMap<String, BitSet>();
        HashMap<String, BitSet> tagVals = new HashMap<String, BitSet>();
        HashMap<String, BitSet> tagnames = new HashMap<String, BitSet>();
        HashMap<Integer, List<String>> changeTags = new HashMap<Integer, List<String>>();
        for (int i = 0; i < this.ruleDetails.size(); ++i) {
            int ruleNumber = i;
            RuleDetails ruleDetails = this.ruleDetails.get(i);
            String keystring = ruleDetails.getKeystring();
            Set<String> changeableTags = ruleDetails.getChangingTags();
            if (keystring.endsWith("=*")) {
                String key = keystring.substring(0, keystring.length() - 2);
                RuleIndex.addNumberToMap(existKeys, key, ruleNumber);
                RuleIndex.addNumberToMap(tagnames, key, ruleNumber);
            } else {
                RuleIndex.addNumberToMap(tagVals, keystring, ruleNumber);
                int ind = keystring.indexOf(61);
                if (ind >= 0) {
                    String key = keystring.substring(0, ind);
                    RuleIndex.addNumberToMap(tagnames, key, ruleNumber);
                }
            }
            RuleIndex.addChangables(changeTags, changeableTags, ruleNumber);
        }
        for (Map.Entry ent : changeTags.entrySet()) {
            int n = (Integer)ent.getKey();
            List changeTagList = (List)ent.getValue();
            HashSet<String> newChanged = new HashSet<String>(changeTagList);
            do {
                for (String s : new ArrayList(newChanged)) {
                    BitSet set;
                    int ind = s.indexOf(61);
                    if (ind >= 0) {
                        set = (BitSet)tagVals.get(s);
                        String key = s.substring(0, ind);
                        BitSet set1 = (BitSet)existKeys.get(key);
                        if (set == null) {
                            set = set1;
                        } else if (set1 != null) {
                            set.or(set1);
                        }
                    } else {
                        set = (BitSet)tagnames.get(s);
                    }
                    if (set == null || set.isEmpty()) continue;
                    BitSet tmp = new BitSet();
                    tmp.or(set);
                    set = tmp;
                    int i = set.nextSetBit(0);
                    while (i >= 0) {
                        if (i > n) {
                            newChanged.addAll(this.ruleDetails.get(i).getChangingTags());
                        } else {
                            set.clear(i);
                        }
                        i = set.nextSetBit(i + 1);
                    }
                    for (Map m : Arrays.asList(existKeys, tagVals, tagnames)) {
                        Collection bitSets = m.values();
                        for (BitSet bi : bitSets) {
                            if (!bi.get(n)) continue;
                            bi.or(set);
                        }
                    }
                }
                newChanged.removeAll(changeTagList);
                changeTagList.addAll(newChanged);
            } while (!newChanged.isEmpty());
        }
        short highestKey = 0;
        for (Map.Entry entry : existKeys.entrySet()) {
            Short skey = TagDict.getInstance().xlate((String)entry.getKey());
            if (skey > highestKey) {
                highestKey = skey;
            }
            this.tagKeyMap.put(skey, new TagHelper((BitSet)entry.getValue()));
        }
        for (Map.Entry entry : tagVals.entrySet()) {
            TagHelper th;
            String keyString = (String)entry.getKey();
            int ind = keyString.indexOf(61);
            if (ind < 0) continue;
            short key = TagDict.getInstance().xlate(keyString.substring(0, ind));
            String val = keyString.substring(ind + 1);
            if (key > highestKey) {
                highestKey = key;
            }
            if ((th = this.tagKeyMap.get(key)) == null) {
                th = new TagHelper(null);
                this.tagKeyMap.put(key, th);
            }
            th.addTag(val, (BitSet)entry.getValue());
        }
        if (highestKey > 0 && highestKey < 1024) {
            this.tagKeyArray = new TagHelper[highestKey + 1];
            for (Map.Entry<Object, Object> entry : this.tagKeyMap.entrySet()) {
                this.tagKeyArray[((Short)entry.getKey()).shortValue()] = (TagHelper)entry.getValue();
            }
            this.tagKeyMap.clear();
        }
        this.inited = true;
    }

    private static void addNumberToMap(Map<String, BitSet> map, String key, int ruleNumber) {
        BitSet set = map.get(key);
        if (set == null) {
            set = new BitSet();
            map.put(key, set);
        }
        set.set(ruleNumber);
    }

    private static void addChangables(Map<Integer, List<String>> changeTags, Set<String> changeableTags, int ruleNumber) {
        List<String> tags = changeTags.get(ruleNumber);
        if (tags == null) {
            tags = new ArrayList<String>();
            changeTags.put(ruleNumber, tags);
        }
        tags.addAll(changeableTags);
    }

    public List<RuleDetails> getRuleDetails() {
        return this.ruleDetails;
    }

    private class TagHelper {
        final BitSet exists;
        Map<String, BitSet> tagVals;

        public TagHelper(BitSet exits) {
            this.exists = exits;
        }

        public void addTag(String val, BitSet value) {
            if (this.tagVals == null) {
                this.tagVals = new HashMap<String, BitSet>();
            }
            if (this.exists != null) {
                BitSet merged = new BitSet();
                merged.or(this.exists);
                merged.or(value);
                this.tagVals.put(val, merged);
            } else {
                this.tagVals.put(val, value);
            }
        }

        public BitSet getBitSet(String tagVal) {
            BitSet set;
            if (this.tagVals != null && (set = this.tagVals.get(tagVal)) != null) {
                return (BitSet)set.clone();
            }
            if (this.exists != null) {
                return (BitSet)this.exists.clone();
            }
            return new BitSet();
        }
    }
}

