/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.dem;

public class Brent {
    private static final double epsilon = 3.0E-10;

    public static double zero(Function f, double x1, double x2) {
        return Brent.zero(f, x1, x2, 1.0E-8, 100);
    }

    public static double zero(Function f, double x1, double x2, double tol, int maxit) {
        double a = x1;
        double b = x2;
        double c = x2;
        double fa = f.eval(a);
        double fb = f.eval(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new ArithmeticException("Root must be bracketed");
        }
        double fc = fb;
        double d = 0.0;
        double e = 0.0;
        for (int iterations = 0; iterations < maxit; ++iterations) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tolerance = 6.0E-10 * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tolerance || fb == 0.0) {
                return b;
            }
            if (Math.abs(e) >= tolerance && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xm * q - Math.abs(tolerance * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tolerance ? (b += d) : (b += xm >= 0.0 ? tolerance : -tolerance);
            fb = f.eval(b);
        }
        throw new ArithmeticException("Maximum number of iterations exceeded");
    }

    public static interface Function {
        public double eval(double var1);
    }
}

