/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.dem;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.mkgmap.reader.dem.DEM;

public class HGTDEM
extends DEM {
    private MappedByteBuffer buffer;

    public HGTDEM(String dataPath, double minLat, double minLon, double maxLat, double maxLon) {
        this.lat = (int)minLat;
        this.lon = (int)minLon;
        if (maxLat > (double)(this.lat + 1) || maxLon > (double)(this.lon + 1)) {
            throw new ExitException("Area too large (must not span more than one SRTM file)");
        }
        String northSouth = this.lat < 0 ? "S" : "N";
        String eastWest = this.lon > 0 ? "E" : "W";
        String fileName = String.format("%s/%s%02d%s%03d.hgt", dataPath, northSouth, this.lat < 0 ? -this.lat : this.lat, eastWest, this.lon < 0 ? -this.lon : this.lon);
        try {
            FileInputStream is = new FileInputStream(fileName);
            this.buffer = is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 2 * (M + 1) * (M + 1));
        }
        catch (Exception e) {
            throw new ExitException("failed to open " + fileName, e);
        }
    }

    @Override
    public void read(int minLon, int minLat, int maxLon, int maxLat) {
    }

    @Override
    public double ele(int x, int y) {
        return (double)this.buffer.getShort(2 * ((M - y) * (M + 1) + x)) + 1.5;
    }

    public void serializeCopyRight(Writer out) throws IOException {
        out.write("  <copyright>\n");
        out.write("  Contour lines generated from DEM data by NASA\n");
        out.write("  </copyright>\n");
    }
}

