/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryGrid;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.EnhancedProperties;

public class LocationHook
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(LocationHook.class);
    private static final Logger resultLog = Logger.getLogger(LocationHook.class.getName() + ".results");
    private long cntQTSearch = 0L;
    private long cntNotFnd = 0L;
    private long cntwayNotFnd = 0L;
    private BoundaryGrid boundaryGrid;
    private ElementSaver saver;
    private String boundaryDirName;
    private static final Object BOUNDS_CHECK_LOCK = new Object();
    private static String checkedBoundaryDirName;
    private static boolean checkBoundaryDirOk;
    private EnhancedProperties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.boundaryDirName = props.getProperty("bounds");
        if (this.boundaryDirName == null) {
            return false;
        }
        this.props = props;
        this.saver = saver;
        long t1 = System.currentTimeMillis();
        Object object = BOUNDS_CHECK_LOCK;
        synchronized (object) {
            if (this.boundaryDirName.equals(checkedBoundaryDirName)) {
                if (!checkBoundaryDirOk) {
                    log.error((Object)("Disable LocationHook because bounds directory is unusable. Dir: " + this.boundaryDirName));
                    return false;
                }
            } else {
                checkedBoundaryDirName = this.boundaryDirName;
                checkBoundaryDirOk = false;
                List<String> boundaryFiles = BoundaryUtil.getBoundaryDirContent(this.boundaryDirName);
                if (boundaryFiles == null || boundaryFiles.size() == 0) {
                    log.error((Object)("LocationHook is disabled because no bounds files are available. Dir: " + this.boundaryDirName));
                    return false;
                }
                checkBoundaryDirOk = true;
            }
        }
        log.info("Checking bounds dir took", System.currentTimeMillis() - t1, "ms");
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Starting with location hook");
        this.boundaryGrid = new BoundaryGrid(this.boundaryDirName, this.saver.getBoundingBox(), this.props);
        this.processLocationRelevantElements();
        this.boundaryGrid = null;
        long dt = System.currentTimeMillis() - t1;
        log.info((Object)"======= LocationHook Stats =====");
        log.info("QuadTree searches    :", this.cntQTSearch);
        log.info("unsuccesfull         :", this.cntNotFnd);
        log.info("unsuccesfull for ways:", this.cntwayNotFnd);
        log.info("Location hook finished in", dt, "ms");
    }

    private void processLocationRelevantElements() {
        for (Node node : this.saver.getNodes().values()) {
            if (node.getTagCount() <= 0 || !this.saver.getBoundingBox().contains(node.getLocation())) continue;
            this.processElem(node);
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("N", node.getId(), this.locationTagsToString(node));
        }
        for (Way way : this.saver.getWays().values()) {
            if (way.getTagCount() <= 0) continue;
            this.processElem(way);
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("W", way.getId(), this.locationTagsToString(way));
        }
        for (Relation r : this.saver.getRelations().values()) {
            Coord mpCenter;
            if (!(r instanceof MultiPolygonRelation) || (mpCenter = ((MultiPolygonRelation)r).getCofG()) == null || !this.saver.getBoundingBox().contains(mpCenter)) continue;
            Node mpNode = new Node(r.getOriginalId(), mpCenter);
            mpNode.setFakeId();
            this.processElem(mpNode);
            for (String boundsTag : BoundaryQuadTree.mkgmapTagsArray) {
                String tagValue = mpNode.getTag(boundsTag);
                if (tagValue == null) continue;
                r.addTag(boundsTag, tagValue);
            }
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("R", r.getId(), this.locationTagsToString(r));
        }
    }

    private void processElem(Element elem) {
        Tags tags = null;
        if (elem instanceof Node) {
            Node node = (Node)elem;
            tags = this.search(node.getLocation());
        } else if (elem instanceof Way) {
            Way way = (Way)elem;
            int middle = way.getPoints().size() / 2;
            tags = this.search(way.getPoints().get(middle));
            if (tags == null) {
                tags = this.search(way.getPoints().get(0));
            }
            if (tags == null) {
                tags = this.search(way.getPoints().get(way.getPoints().size() - 1));
            }
            if (tags == null) {
                for (int i = 1; i < way.getPoints().size() - 1 && (i == middle || (tags = this.search(way.getPoints().get(i))) == null); ++i) {
                }
            }
            if (tags == null) {
                ++this.cntwayNotFnd;
            }
        }
        if (tags == null) {
            ++this.cntNotFnd;
        } else {
            Iterator<Map.Entry<Short, String>> tagIter = tags.entryShortIterator();
            while (tagIter.hasNext()) {
                Map.Entry<Short, String> tag = tagIter.next();
                if (elem.getTag(tag.getKey()) != null) continue;
                elem.addTag(tag.getKey(), tag.getValue());
            }
        }
    }

    private Tags search(Coord co) {
        if (this.saver.getBoundingBox().contains(co)) {
            ++this.cntQTSearch;
            return this.boundaryGrid.get(co);
        }
        return null;
    }

    private String locationTagsToString(Element elem) {
        StringBuilder res = new StringBuilder();
        for (int i = BoundaryQuadTree.mkgmapTagsArray.length - 1; i >= 0; --i) {
            String tagVal = elem.getTag(BoundaryQuadTree.mkgmapTagsArray[i]);
            if (tagVal != null) {
                res.append(tagVal);
            }
            res.append(";");
        }
        return res.toString();
    }
}

