/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.List;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.util.EnhancedProperties;

public class RelationStyleHook
extends OsmReadingHooksAdaptor {
    private Style style;
    private ElementSaver saver;
    List<String> nameTagList;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        this.nameTagList = LocatorUtil.getNameTags(props);
        return super.init(saver, props);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public void end() {
        Rule relationRules = this.style.getRelationRules();
        for (Relation rel : this.saver.getRelations().values()) {
            if (this.nameTagList != null) {
                for (String t : this.nameTagList) {
                    String val = rel.getTag(t);
                    if (val == null) continue;
                    rel.addTag("name", val);
                    break;
                }
            }
            relationRules.resolveType(rel, TypeResult.NULL_RESULT);
            if (!(rel instanceof RestrictionRelation)) continue;
            ((RestrictionRelation)rel).eval(this.saver.getBoundingBox());
        }
        super.end();
    }
}

