/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.reader.osm.CoastlineFileLoader;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.OsmMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.SeaPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.xml.Osm5PrecompSeaDataSource;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;

public class SeaGenerator
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(SeaGenerator.class);
    private boolean generateSeaUsingMP = true;
    private int maxCoastlineGap;
    private boolean allowSeaSectors = true;
    private boolean extendSeaSectors;
    private String[] landTag = new String[]{"natural", "land"};
    private boolean floodblocker;
    private int fbGap = 40;
    private double fbRatio = 0.5;
    private int fbThreshold = 20;
    private boolean fbDebug;
    private ElementSaver saver;
    private List<Way> shoreline = new ArrayList<Way>();
    private boolean roadsReachBoundary;
    private boolean generateSeaBackground = true;
    private String[] coastlineFilenames;
    private StyleImpl fbRules;
    public static final int PRECOMP_RASTER = 32768;
    private File precompSeaDir;
    private static final byte SEA_TILE = 115;
    private static final byte LAND_TILE = 108;
    private static final byte MIXED_TILE = 109;
    private static ThreadLocal<PrecompData> precompIndex = new ThreadLocal();
    private static final int MIN_LAT = Utils.toMapUnit(-90.0);
    private static final int MAX_LAT = Utils.toMapUnit(90.0);
    private static final int MIN_LON = Utils.toMapUnit(-180.0);
    private static final int MAX_LON = Utils.toMapUnit(180.0);
    private static final Pattern keySplitter = Pattern.compile(Pattern.quote("_"));
    private static final List<Class<? extends LoadableMapDataSource>> precompSeaLoader;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        String gs;
        boolean generateSea;
        this.saver = saver;
        String precompSea = props.getProperty("precomp-sea", null);
        if (precompSea != null) {
            this.precompSeaDir = new File(precompSea);
            if (this.precompSeaDir.exists()) {
                if (precompIndex.get() == null) {
                    PrecompData precompData;
                    block41: {
                        precompData = null;
                        String internalPath = null;
                        InputStream indexStream = null;
                        String indexFileName = "index.txt.gz";
                        ZipFile zipFile = null;
                        try {
                            if (this.precompSeaDir.isDirectory()) {
                                File indexFile = new File(this.precompSeaDir, indexFileName);
                                if (!indexFile.exists()) {
                                    indexFileName = "index.txt";
                                    indexFile = new File(this.precompSeaDir, indexFileName);
                                }
                                if (indexFile.exists()) {
                                    indexStream = new FileInputStream(indexFile);
                                }
                            } else if (precompSea.endsWith(".zip")) {
                                zipFile = new ZipFile(this.precompSeaDir);
                                internalPath = "sea/";
                                ZipEntry entry = zipFile.getEntry(internalPath + indexFileName);
                                if (entry == null) {
                                    indexFileName = "index.txt";
                                    entry = zipFile.getEntry(internalPath + indexFileName);
                                }
                                if (entry == null) {
                                    internalPath = "";
                                    indexFileName = "index.txt.gz";
                                    entry = zipFile.getEntry(internalPath + indexFileName);
                                }
                                if (entry != null) {
                                    indexStream = zipFile.getInputStream(entry);
                                } else {
                                    log.error((Object)("Don't know how to read " + this.precompSeaDir));
                                }
                            } else {
                                log.error((Object)("Don't know how to read " + this.precompSeaDir));
                            }
                            if (indexStream == null) break block41;
                            if (indexFileName.endsWith(".gz")) {
                                indexStream = new GZIPInputStream(indexStream);
                            }
                            try {
                                precompData = this.loadIndex(indexStream);
                            }
                            catch (IOException exp) {
                                log.error((Object)("Cannot read index file " + indexFileName), exp);
                            }
                            if (precompData != null) {
                                if (zipFile != null) {
                                    precompData.precompZipFileInternalPath = internalPath;
                                    precompData.zipFile = zipFile;
                                }
                                precompIndex.set(precompData);
                            }
                            indexStream.close();
                        }
                        catch (IOException exp) {
                            log.error((Object)("Cannot read index file " + indexFileName), exp);
                        }
                    }
                    precompIndex.set(precompData);
                }
            } else {
                log.error((Object)("Directory or zip file with precompiled sea does not exist: " + precompSea));
                System.err.println("Directory or zip file with precompiled sea does not exist: " + precompSea);
                this.precompSeaDir = null;
            }
        }
        boolean bl = generateSea = (gs = props.getProperty("generate-sea", null)) != null || precompSea != null;
        if (gs != null) {
            for (String o : gs.split(",")) {
                if ("no-mp".equals(o) || "polygon".equals(o) || "polygons".equals(o)) {
                    this.generateSeaUsingMP = false;
                    continue;
                }
                if ("multipolygon".equals(o)) {
                    this.generateSeaUsingMP = true;
                    continue;
                }
                if (o.startsWith("land-tag=")) {
                    this.landTag = o.substring(9).split("=");
                    continue;
                }
                if (precompSea == null) {
                    if (o.startsWith("close-gaps=")) {
                        this.maxCoastlineGap = (int)Double.parseDouble(o.substring(11));
                        continue;
                    }
                    if ("no-sea-sectors".equals(o)) {
                        this.allowSeaSectors = false;
                        continue;
                    }
                    if ("extend-sea-sectors".equals(o)) {
                        this.allowSeaSectors = false;
                        this.extendSeaSectors = true;
                        continue;
                    }
                    if ("floodblocker".equals(o)) {
                        this.floodblocker = true;
                        continue;
                    }
                    if (o.startsWith("fbgap=")) {
                        this.fbGap = (int)Double.parseDouble(o.substring("fbgap=".length()));
                        continue;
                    }
                    if (o.startsWith("fbratio=")) {
                        this.fbRatio = Double.parseDouble(o.substring("fbratio=".length()));
                        continue;
                    }
                    if (o.startsWith("fbthres=")) {
                        this.fbThreshold = (int)Double.parseDouble(o.substring("fbthres=".length()));
                        continue;
                    }
                    if ("fbdebug".equals(o)) {
                        this.fbDebug = true;
                        continue;
                    }
                    this.printOptionHelpMsg(precompSea != null, o);
                    continue;
                }
                if (o.isEmpty()) continue;
                this.printOptionHelpMsg(precompSea != null, o);
            }
            if (precompSea == null) {
                String coastlineFileOpt;
                if (this.floodblocker) {
                    try {
                        this.fbRules = new StyleImpl(null, "floodblocker");
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Cannot load file floodblocker rules. Continue floodblocking disabled.");
                        this.floodblocker = false;
                    }
                }
                if ((coastlineFileOpt = props.getProperty("coastlinefile", null)) != null) {
                    this.coastlineFilenames = coastlineFileOpt.split(",");
                    CoastlineFileLoader.getCoastlineLoader().setCoastlineFiles(this.coastlineFilenames);
                    CoastlineFileLoader.getCoastlineLoader().loadCoastlines();
                    log.info((Object)"Coastlines loaded");
                } else {
                    this.coastlineFilenames = null;
                }
            }
        }
        return generateSea;
    }

    void printOptionHelpMsg(boolean forPrecompSea, String o) {
        if (!"help".equals(o)) {
            System.err.println("Unknown sea generation option '" + o + "'");
        }
        System.err.println("Known sea generation options " + (forPrecompSea ? "with" : "without") + " --precomp-sea  are:");
        System.err.println("  multipolygon        use a multipolygon (default)");
        System.err.println("  polygons | no-mp    use polygons rather than a multipolygon");
        System.err.println("  land-tag=TAG=VAL    tag to use for land polygons (default natural=land)");
        if (forPrecompSea) {
            return;
        }
        System.err.println("  no-sea-sectors      disable use of \"sea sectors\"");
        System.err.println("  extend-sea-sectors  extend coastline to reach border");
        System.err.println("  close-gaps=NUM      close gaps in coastline that are less than this distance (metres)");
        System.err.println("  floodblocker        enable the floodblocker (for multipolgon only)");
        System.err.println("  fbgap=NUM           points closer to the coastline are ignored for flood blocking (default 40)");
        System.err.println("  fbthres=NUM         min points contained in a polygon to be flood blocked (default 20)");
        System.err.println("  fbratio=NUM         min ratio (points/area size) for flood blocking (default 0.5)");
    }

    private PrecompData loadIndex(InputStream fileStream) throws IOException {
        int indexWidth = (SeaGenerator.getPrecompTileStart(MAX_LON) - SeaGenerator.getPrecompTileStart(MIN_LON)) / 32768;
        int indexHeight = (SeaGenerator.getPrecompTileStart(MAX_LAT) - SeaGenerator.getPrecompTileStart(MIN_LAT)) / 32768;
        PrecompData pi = null;
        LineNumberReader indexReader = new LineNumberReader(new InputStreamReader(fileStream));
        Pattern csvSplitter = Pattern.compile(Pattern.quote(";"));
        String indexLine = null;
        byte[][] indexGrid = new byte[indexWidth + 1][indexHeight + 1];
        boolean detectExt = true;
        String prefix = null;
        String ext = null;
        while ((indexLine = indexReader.readLine()) != null) {
            int prePos;
            if (indexLine.startsWith("#")) continue;
            String[] items = csvSplitter.split(indexLine);
            if (items.length != 2) {
                log.warn("Invalid format in index file name:", indexLine);
                continue;
            }
            String precompKey = items[0];
            byte type = this.updatePrecompSeaTileIndex(precompKey, items[1], indexGrid);
            if (type == 63) {
                log.warn("Invalid format in index file name:", indexLine);
                continue;
            }
            if (type != 109 || (prePos = items[1].indexOf(items[0])) < 0) continue;
            if (detectExt) {
                prefix = items[1].substring(0, prePos);
                ext = items[1].substring(prePos + items[0].length());
                detectExt = false;
                continue;
            }
            StringBuilder sb = new StringBuilder(prefix);
            sb.append(precompKey);
            sb.append(ext);
            if (items[1].equals(sb.toString())) continue;
            log.warn("Unexpected file name in index file:", indexLine);
        }
        pi = new PrecompData();
        PrecompData.access$202(pi, indexGrid);
        pi.precompSeaPrefix = prefix;
        pi.precompSeaExt = ext;
        return pi;
    }

    public static int getPrecompTileStart(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value - rem;
        }
        return value - 32768 - rem;
    }

    public static int getPrecompTileEnd(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value + 32768 - rem;
        }
        return value - rem;
    }

    @Override
    public Set<String> getUsedTags() {
        HashSet<String> usedTags = new HashSet<String>();
        if (this.coastlineFilenames == null) {
            usedTags.add("natural");
        }
        if (this.floodblocker) {
            usedTags.addAll(this.fbRules.getUsedTags());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sea generator used tags: " + usedTags));
        }
        return usedTags;
    }

    @Override
    public void onAddWay(Way way) {
        String natural = way.getTag("natural");
        if (natural != null) {
            if ("coastline".equals(natural)) {
                if (this.precompSeaDir != null) {
                    this.splitCoastLineToLineAndShape(way, natural);
                } else if (this.coastlineFilenames == null) {
                    way.deleteTag("natural");
                    this.shoreline.add(way);
                }
            } else if (natural.contains(";")) {
                String others = null;
                boolean foundCoastline = false;
                for (String n : natural.split(";")) {
                    if ("coastline".equals(n.trim())) {
                        foundCoastline = true;
                        continue;
                    }
                    others = others == null ? n : others + ";" + n;
                }
                if (foundCoastline) {
                    if (this.precompSeaDir != null) {
                        this.splitCoastLineToLineAndShape(way, natural);
                    } else if (this.coastlineFilenames == null) {
                        way.deleteTag("natural");
                        if (others != null) {
                            way.addTag("natural", others);
                        }
                        this.shoreline.add(way);
                    }
                }
            }
        }
    }

    private void splitCoastLineToLineAndShape(Way way, String naturalVal) {
        if (this.precompSeaDir == null) {
            return;
        }
        if (way.hasIdenticalEndPoints()) {
            Way shapeWay = new Way(way.getOriginalId(), way.getPoints());
            shapeWay.setFakeId();
            shapeWay.deleteTag("natural");
            shapeWay.addTag("mkgmap:removed_natural", naturalVal);
            shapeWay.addTag("mkgmap:stylefilter", "polygon");
            this.saver.addWay(shapeWay);
        }
        way.addTag("mkgmap:stylefilter", "polyline");
    }

    private static OsmMapDataSource createTileReader(String filename) {
        for (Class<? extends LoadableMapDataSource> loader : precompSeaLoader) {
            try {
                LoadableMapDataSource src = loader.newInstance();
                if (filename == null || !(src instanceof OsmMapDataSource) || !src.isFileSupported(filename)) continue;
                return (OsmMapDataSource)src;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return new Osm5PrecompSeaDataSource();
    }

    private Collection<Way> loadPrecompTile(InputStream is, String filename) {
        OsmMapDataSource src = SeaGenerator.createTileReader(filename);
        EnhancedProperties props = new EnhancedProperties();
        src.config(props);
        log.info("Started loading coastlines from", filename);
        try {
            src.load(is);
        }
        catch (FormatException e) {
            log.error((Object)("Failed to read " + filename));
            log.error((Object)e);
        }
        log.info("Finished loading coastlines from", filename);
        return src.getElementSaver().getWays().values();
    }

    private List<String> getPrecompKeyNames() {
        Area bounds = this.saver.getBoundingBox();
        ArrayList<String> precompKeys = new ArrayList<String>();
        for (int lat = SeaGenerator.getPrecompTileStart(bounds.getMinLat()); lat < SeaGenerator.getPrecompTileEnd(bounds.getMaxLat()); lat += 32768) {
            for (int lon = SeaGenerator.getPrecompTileStart(bounds.getMinLong()); lon < SeaGenerator.getPrecompTileEnd(bounds.getMaxLong()); lon += 32768) {
                precompKeys.add(lat + "_" + lon);
            }
        }
        return precompKeys;
    }

    private String getTileName(String precompKey) {
        PrecompData pi = precompIndex.get();
        String[] tileCoords = keySplitter.split(precompKey);
        int lat = Integer.valueOf(tileCoords[0]);
        int lon = Integer.valueOf(tileCoords[1]);
        int latIndex = (MAX_LAT - lat) / 32768;
        int lonIndex = (MAX_LON - lon) / 32768;
        byte type = pi.precompIndex[lonIndex][latIndex];
        switch (type) {
            case 115: {
                return "sea";
            }
            case 108: {
                return "land";
            }
            case 109: {
                return pi.precompSeaPrefix + precompKey + pi.precompSeaExt;
            }
        }
        return null;
    }

    private byte updatePrecompSeaTileIndex(String precompKey, String fileName, byte[][] indexGrid) {
        String[] tileCoords = keySplitter.split(precompKey);
        int type = 63;
        if (tileCoords.length == 2) {
            int lat = Integer.valueOf(tileCoords[0]);
            int lon = Integer.valueOf(tileCoords[1]);
            int latIndex = (MAX_LAT - lat) / 32768;
            int lonIndex = (MAX_LON - lon) / 32768;
            type = "sea".equals(fileName) ? 115 : ("land".equals(fileName) ? 108 : 109);
            indexGrid[lonIndex][latIndex] = type;
        }
        return (byte)type;
    }

    private void addPrecompSea() {
        log.info((Object)"Load precompiled sea tiles");
        boolean distinctTilesOnly = true;
        ArrayList<Way> landWays = new ArrayList<Way>();
        ArrayList<Way> seaWays = new ArrayList<Way>();
        List<java.awt.geom.Area> seaOnlyAreas = new ArrayList<java.awt.geom.Area>();
        List<java.awt.geom.Area> landOnlyAreas = new ArrayList<java.awt.geom.Area>();
        ZipFile zipFile = null;
        PrecompData pd = precompIndex.get();
        if (this.precompSeaDir.getName().endsWith(".zip")) {
            zipFile = pd.zipFile;
        }
        for (String precompKey : this.getPrecompKeyNames()) {
            String tileName = this.getTileName(precompKey);
            if (tileName == null) {
                log.error((Object)("Precompile sea tile " + precompKey + " is missing in the index. Skipping."));
                continue;
            }
            if ("sea".equals(tileName) || "land".equals(tileName)) {
                String[] tileCoords = keySplitter.split(precompKey);
                int minLat = Integer.valueOf(tileCoords[0]);
                int minLon = Integer.valueOf(tileCoords[1]);
                Rectangle r = new Rectangle(minLon, minLat, 32768, 32768);
                if ("sea".equals(tileName)) {
                    seaOnlyAreas = this.addWithoutCreatingHoles(seaOnlyAreas, new java.awt.geom.Area(r));
                    continue;
                }
                landOnlyAreas = this.addWithoutCreatingHoles(landOnlyAreas, new java.awt.geom.Area(r));
                continue;
            }
            distinctTilesOnly = false;
            try {
                InputStream is = null;
                if (zipFile != null) {
                    ZipEntry entry = zipFile.getEntry(pd.precompZipFileInternalPath + tileName);
                    if (entry != null) {
                        is = zipFile.getInputStream(entry);
                    } else {
                        log.error((Object)("Preompiled sea tile " + tileName + " not found."));
                    }
                } else {
                    File precompTile = new File(this.precompSeaDir, tileName);
                    is = new FileInputStream(precompTile);
                }
                if (is == null) continue;
                Collection<Way> seaPrecompWays = this.loadPrecompTile(is, tileName);
                if (log.isDebugEnabled()) {
                    log.debug(seaPrecompWays.size(), "precomp sea ways from", tileName, "loaded.");
                }
                for (Way w : seaPrecompWays) {
                    w.setFakeId();
                    if ("land".equals(w.getTag("natural"))) {
                        landWays.add(w);
                        continue;
                    }
                    seaWays.add(w);
                }
            }
            catch (FileNotFoundException exp) {
                log.error((Object)("Preompiled sea tile " + tileName + " not found."));
            }
            catch (Exception exp) {
                log.error((Object)exp);
                exp.printStackTrace();
            }
        }
        landWays.addAll(this.areaToWays(landOnlyAreas, "land"));
        seaWays.addAll(this.areaToWays(seaOnlyAreas, "sea"));
        landOnlyAreas = null;
        seaOnlyAreas = null;
        if (this.landTag != null && !("natural".equals(this.landTag[0]) && "land".equals(this.landTag[1]))) {
            for (Way w : landWays) {
                w.deleteTag("natural");
                w.addTag(this.landTag[0], this.landTag[1]);
            }
        }
        if (this.generateSeaUsingMP || distinctTilesOnly) {
            for (Way w : landWays) {
                this.saver.addWay(w);
            }
            for (Way w : seaWays) {
                this.saver.addWay(w);
            }
        } else {
            Area bounds = this.saver.getBoundingBox();
            Way sea = new Way(FakeIdGenerator.makeFakeId(), bounds.toCoords());
            sea.addTag("natural", "sea");
            for (Way w : landWays) {
                this.saver.addWay(w);
            }
        }
    }

    private List<java.awt.geom.Area> addWithoutCreatingHoles(List<java.awt.geom.Area> areas, java.awt.geom.Area toAdd) {
        LinkedList<java.awt.geom.Area> result = new LinkedList<java.awt.geom.Area>();
        java.awt.geom.Area toMerge = new java.awt.geom.Area(toAdd);
        for (java.awt.geom.Area area : areas) {
            java.awt.geom.Area mergedArea = new java.awt.geom.Area(area);
            mergedArea.add(toMerge);
            if (!mergedArea.isSingular()) {
                result.add(area);
                continue;
            }
            toMerge = mergedArea;
        }
        int dimNew = Math.max(toMerge.getBounds().width, toMerge.getBounds().height);
        boolean added = false;
        for (int i = 0; i < result.size(); ++i) {
            java.awt.geom.Area area = (java.awt.geom.Area)result.get(i);
            if (dimNew >= Math.max(area.getBounds().width, area.getBounds().height)) continue;
            result.add(i, toMerge);
            added = true;
            break;
        }
        if (!added) {
            result.add(toMerge);
        }
        return result;
    }

    private List<Way> areaToWays(List<java.awt.geom.Area> areas, String type) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (java.awt.geom.Area area : areas) {
            List<List<Coord>> shapes = Java2DConverter.areaToShapes(area);
            for (List<Coord> points : shapes) {
                Way w = new Way(FakeIdGenerator.makeFakeId(), points);
                w.addTag("natural", type);
                ways.add(w);
            }
        }
        return ways;
    }

    public static ArrayList<Way> joinWays(Collection<Way> segments) {
        ArrayList<Way> joined = new ArrayList<Way>((int)Math.ceil((double)segments.size() * 0.5));
        IdentityHashMap<Coord, Way> beginMap = new IdentityHashMap<Coord, Way>();
        for (Way w : segments) {
            if (w.hasIdenticalEndPoints()) {
                joined.add(w);
                continue;
            }
            if (w.getPoints() != null && w.getPoints().size() > 1) {
                List<Coord> points = w.getPoints();
                beginMap.put(points.get(0), w);
                continue;
            }
            log.info("Discard coastline way", w.getId(), "because consists of less than 2 points");
        }
        segments.clear();
        int merged = 1;
        block1: while (merged > 0) {
            merged = 0;
            for (Way w1 : beginMap.values()) {
                Way wm;
                if (w1.hasIdenticalEndPoints()) {
                    log.error((Object)("joinWays2: Way " + w1 + " is closed but contained in the begin map"));
                    joined.add(w1);
                    beginMap.remove(w1.getPoints().get(0));
                    merged = 1;
                    continue block1;
                }
                List<Coord> points1 = w1.getPoints();
                Way w2 = (Way)beginMap.get(points1.get(points1.size() - 1));
                if (w2 == null) continue;
                log.info("merging: ", beginMap.size(), w1.getId(), w2.getId());
                List<Coord> points2 = w2.getPoints();
                if (FakeIdGenerator.isFakeId(w1.getId())) {
                    wm = w1;
                } else {
                    wm = new Way(w1.getOriginalId());
                    wm.setFakeId();
                    wm.getPoints().addAll(points1);
                    beginMap.put(points1.get(0), wm);
                }
                wm.getPoints().addAll(points2.subList(1, points2.size()));
                beginMap.remove(points2.get(0));
                ++merged;
                if (!wm.hasIdenticalEndPoints()) continue block1;
                joined.add(wm);
                beginMap.remove(wm.getPoints().get(0));
                continue block1;
            }
        }
        log.info(joined.size(), "closed ways.", beginMap.size(), "unclosed ways.");
        joined.addAll(beginMap.values());
        return joined;
    }

    @Override
    public void end() {
        if (this.precompSeaDir != null) {
            this.addPrecompSea();
            return;
        }
        Area seaBounds = this.saver.getBoundingBox();
        if (this.coastlineFilenames == null) {
            log.info("Shorelines before join", this.shoreline.size());
            this.shoreline = SeaGenerator.joinWays(this.shoreline);
        } else {
            this.shoreline.addAll(CoastlineFileLoader.getCoastlineLoader().getCoastlines(seaBounds));
            log.info("Shorelines from extra file:", this.shoreline.size());
        }
        int closedS = 0;
        int unclosedS = 0;
        for (Way w : this.shoreline) {
            if (w.hasIdenticalEndPoints()) {
                ++closedS;
                continue;
            }
            ++unclosedS;
        }
        log.info("Closed shorelines", closedS);
        log.info("Unclosed shorelines", unclosedS);
        this.clipShorlineSegments(this.shoreline, seaBounds);
        log.info("generating sea, seaBounds=", seaBounds);
        int minLat = seaBounds.getMinLat();
        int maxLat = seaBounds.getMaxLat();
        int minLong = seaBounds.getMinLong();
        int maxLong = seaBounds.getMaxLong();
        Coord nw = new Coord(minLat, minLong);
        Coord ne = new Coord(minLat, maxLong);
        Coord sw = new Coord(maxLat, minLong);
        Coord se = new Coord(maxLat, maxLong);
        if (this.shoreline.isEmpty()) {
            long landId = FakeIdGenerator.makeFakeId();
            Way land = new Way(landId, seaBounds.toCoords());
            land.addTag(this.landTag[0], this.landTag[1]);
            this.saver.addWay(land);
            return;
        }
        long multiId = FakeIdGenerator.makeFakeId();
        GeneralRelation seaRelation = null;
        if (this.generateSeaUsingMP) {
            log.debug("Generate seabounds relation", multiId);
            seaRelation = new GeneralRelation(multiId);
            seaRelation.addTag("type", "multipolygon");
            seaRelation.addTag("natural", "sea");
        }
        ArrayList<Way> islands = new ArrayList<Way>();
        this.handleIslands(this.shoreline, seaBounds, islands);
        NavigableMap<EdgeHit, Way> hitMap = this.findIntesectionPoints(this.shoreline, seaBounds, seaRelation);
        boolean shorelineReachesBoundary = this.createInnerWays(seaBounds, islands, hitMap);
        if (!shorelineReachesBoundary && this.roadsReachBoundary) {
            this.generateSeaBackground = false;
        }
        List<Way> antiIslands = this.removeAntiIslands(seaRelation, islands);
        if (islands.isEmpty()) {
            this.generateSeaBackground = false;
        }
        if (this.generateSeaBackground) {
            for (Way ai : antiIslands) {
                boolean containedByLand = false;
                for (Way i : islands) {
                    if (!i.containsPointsOf(ai)) continue;
                    containedByLand = true;
                    break;
                }
                if (containedByLand) continue;
                ai.deleteTag("natural");
                ai.addTag(this.landTag[0], this.landTag[1]);
                if (this.generateSeaUsingMP) {
                    assert (seaRelation != null);
                    seaRelation.addElement("inner", ai);
                }
                log.warn("Converting anti-island starting at", ai.getPoints().get(0).toOSMURL(), "into an island as it is surrounded by water");
            }
            long seaId = FakeIdGenerator.makeFakeId();
            Way sea = new Way(seaId);
            sea.addPoint(new Coord(nw.getLatitude() - 1, nw.getLongitude() - 1));
            sea.addPoint(new Coord(sw.getLatitude() + 1, sw.getLongitude() - 1));
            sea.addPoint(new Coord(se.getLatitude() + 1, se.getLongitude() + 1));
            sea.addPoint(new Coord(ne.getLatitude() - 1, ne.getLongitude() + 1));
            sea.addPoint(sea.getPoints().get(0));
            sea.addTag("natural", "sea");
            log.info("sea: ", sea);
            this.saver.addWay(sea);
            if (this.generateSeaUsingMP) {
                assert (seaRelation != null);
                seaRelation.addElement("outer", sea);
            }
        } else {
            long landId = FakeIdGenerator.makeFakeId();
            Way land = new Way(landId, seaBounds.toCoords());
            land.addTag(this.landTag[0], this.landTag[1]);
            this.saver.addWay(land);
            if (this.generateSeaUsingMP) {
                seaRelation.addElement("inner", land);
            }
        }
        if (this.generateSeaUsingMP) {
            SeaPolygonRelation coastRel = this.saver.createSeaPolyRelation(seaRelation);
            coastRel.setFloodBlocker(this.floodblocker);
            if (this.floodblocker) {
                coastRel.setFloodBlockerGap(this.fbGap);
                coastRel.setFloodBlockerRatio(this.fbRatio);
                coastRel.setFloodBlockerThreshold(this.fbThreshold);
                coastRel.setFloodBlockerRules(this.fbRules.getWayRules());
                coastRel.setLandTag(this.landTag[0], this.landTag[1]);
                coastRel.setDebug(this.fbDebug);
            }
            this.saver.addRelation(coastRel);
        }
        this.shoreline = null;
    }

    private void clipShorlineSegments(List<Way> shoreline, Area bounds) {
        ArrayList<Way> toBeRemoved = new ArrayList<Way>();
        ArrayList<Way> toBeAdded = new ArrayList<Way>();
        for (Way segment : shoreline) {
            List<Coord> points = segment.getPoints();
            List<List<Coord>> clipped = LineClipper.clip(bounds, points);
            if (clipped == null) continue;
            log.info("clipping", segment);
            toBeRemoved.add(segment);
            for (List<Coord> pts : clipped) {
                Way shore = new Way(segment.getOriginalId(), pts);
                shore.setFakeId();
                toBeAdded.add(shore);
            }
        }
        log.info("clipping: adding", toBeAdded.size(), ", removing", toBeRemoved.size());
        shoreline.removeAll(toBeRemoved);
        shoreline.addAll(toBeAdded);
    }

    private void handleIslands(List<Way> shoreline, Area seaBounds, List<Way> islands) {
        Way w;
        Iterator<Way> it = shoreline.iterator();
        while (it.hasNext()) {
            w = it.next();
            if (!w.hasIdenticalEndPoints()) continue;
            log.info("adding island", w);
            islands.add(w);
            it.remove();
        }
        this.closeGaps(shoreline, seaBounds);
        it = shoreline.iterator();
        while (it.hasNext()) {
            w = it.next();
            if (!w.hasIdenticalEndPoints()) continue;
            log.debug((Object)"island after concatenating");
            islands.add(w);
            it.remove();
        }
    }

    private boolean createInnerWays(Area seaBounds, List<Way> islands, NavigableMap<EdgeHit, Way> hitMap) {
        NavigableSet<EdgeHit> hits = hitMap.navigableKeySet();
        boolean shorelineReachesBoundary = false;
        while (!hits.isEmpty()) {
            EdgeHit hit;
            long id = FakeIdGenerator.makeFakeId();
            Way w = new Way(id);
            this.saver.addWay(w);
            EdgeHit hFirst = hit = (EdgeHit)hits.first();
            do {
                EdgeHit hNext;
                Way segment = (Way)hitMap.get(hit);
                log.info("current hit:", hit);
                if (segment != null) {
                    log.info("adding:", segment);
                    for (Coord p : segment.getPoints()) {
                        w.addPointIfNotEqualToLastPoint(p);
                    }
                    hNext = this.getEdgeHit(seaBounds, segment.getPoints().get(segment.getPoints().size() - 1));
                } else {
                    Coord p;
                    EdgeHit corner;
                    int i;
                    w.addPointIfNotEqualToLastPoint(hit.getPoint(seaBounds));
                    hNext = hits.higher(hit);
                    if (hNext == null) {
                        hNext = hFirst;
                    }
                    if (hit.compareTo(hNext) < 0) {
                        log.info("joining: ", hit, hNext);
                        for (i = hit.edge; i < hNext.edge; ++i) {
                            corner = new EdgeHit(i, 1.0);
                            p = corner.getPoint(seaBounds);
                            log.debug("way: ", corner, p);
                            w.addPointIfNotEqualToLastPoint(p);
                        }
                    } else if (hit.compareTo(hNext) > 0) {
                        log.info("joining: ", hit, hNext);
                        for (i = hit.edge; i < 4; ++i) {
                            corner = new EdgeHit(i, 1.0);
                            p = corner.getPoint(seaBounds);
                            log.debug("way: ", corner, p);
                            w.addPointIfNotEqualToLastPoint(p);
                        }
                        for (i = 0; i < hNext.edge; ++i) {
                            corner = new EdgeHit(i, 1.0);
                            p = corner.getPoint(seaBounds);
                            log.debug("way: ", corner, p);
                            w.addPointIfNotEqualToLastPoint(p);
                        }
                    }
                    w.addPointIfNotEqualToLastPoint(hNext.getPoint(seaBounds));
                }
                hits.remove(hit);
                hit = hNext;
            } while (!hits.isEmpty() && !hit.equals(hFirst));
            if (!w.hasIdenticalEndPoints()) {
                w.addPoint(w.getPoints().get(0));
            }
            log.info((Object)("adding non-island landmass, hits.size()=" + hits.size()));
            islands.add(w);
            shorelineReachesBoundary = true;
        }
        return shorelineReachesBoundary;
    }

    private List<Way> removeAntiIslands(Relation seaRelation, List<Way> islands) {
        ArrayList<Way> antiIslands = new ArrayList<Way>();
        for (Way w : islands) {
            if (!FakeIdGenerator.isFakeId(w.getId())) {
                Way w1 = new Way(w.getOriginalId());
                w1.setFakeId();
                w1.getPoints().addAll(w.getPoints());
                for (Map.Entry<String, String> tagEntry : w.getTagEntryIterator()) {
                    if (!tagEntry.getKey().equals("name") && !tagEntry.getKey().contains("name")) continue;
                    w1.addTag(tagEntry.getKey(), tagEntry.getValue());
                }
                w = w1;
            }
            if (Way.clockwise(w.getPoints())) {
                w.addTag("natural", "water");
                antiIslands.add(w);
                this.saver.addWay(w);
                continue;
            }
            w.addTag(this.landTag[0], this.landTag[1]);
            this.saver.addWay(w);
            if (!this.generateSeaUsingMP) continue;
            seaRelation.addElement("inner", w);
        }
        islands.removeAll(antiIslands);
        return antiIslands;
    }

    private NavigableMap<EdgeHit, Way> findIntesectionPoints(List<Way> shoreline, Area seaBounds, Relation seaRelation) {
        assert (!this.generateSeaUsingMP || seaRelation != null);
        TreeMap<EdgeHit, Way> hitMap = new TreeMap<EdgeHit, Way>();
        for (Way w : shoreline) {
            List<Coord> points = w.getPoints();
            Coord pStart = points.get(0);
            Coord pEnd = points.get(points.size() - 1);
            EdgeHit hStart = this.getEdgeHit(seaBounds, pStart);
            EdgeHit hEnd = this.getEdgeHit(seaBounds, pEnd);
            if (hStart == null || hEnd == null) {
                boolean nearlyClosed;
                double length = 0.0;
                Coord p0 = pStart;
                for (Coord p1 : points.subList(1, points.size() - 1)) {
                    length += p0.distance(p1);
                    p0 = p1;
                }
                boolean bl = nearlyClosed = pStart.distance(pEnd) < 0.1 * length;
                if (nearlyClosed) {
                    points.add(pStart);
                    if (!FakeIdGenerator.isFakeId(w.getId())) {
                        Way w1 = new Way(w.getOriginalId());
                        w1.setFakeId();
                        w1.getPoints().addAll(w.getPoints());
                        for (Map.Entry<String, String> tagEntry : w.getTagEntryIterator()) {
                            if (!tagEntry.getKey().equals("name") && !tagEntry.getKey().contains("name")) continue;
                            w1.addTag(tagEntry.getKey(), tagEntry.getValue());
                        }
                        w = w1;
                    }
                    w.addTag(this.landTag[0], this.landTag[1]);
                    this.saver.addWay(w);
                    if (!this.generateSeaUsingMP) continue;
                    seaRelation.addElement("inner", w);
                    continue;
                }
                if (this.allowSeaSectors) {
                    Way sea;
                    if (seaRelation != null) {
                        sea = new Way(seaRelation.getOriginalId());
                        sea.setFakeId();
                    } else {
                        sea = new Way(FakeIdGenerator.makeFakeId());
                    }
                    sea.getPoints().addAll(points);
                    sea.addPoint(new Coord(pEnd.getLatitude(), pStart.getLongitude()));
                    sea.addPoint(pStart);
                    sea.addTag("natural", "sea");
                    log.info("sea: ", sea);
                    this.saver.addWay(sea);
                    if (this.generateSeaUsingMP) {
                        seaRelation.addElement("outer", sea);
                    }
                    this.generateSeaBackground = false;
                    continue;
                }
                if (this.extendSeaSectors) {
                    if (null == hStart) {
                        hStart = this.getNextEdgeHit(seaBounds, pStart);
                        w.getPoints().add(0, hStart.getPoint(seaBounds));
                    }
                    if (null == hEnd) {
                        hEnd = this.getNextEdgeHit(seaBounds, pEnd);
                        w.getPoints().add(hEnd.getPoint(seaBounds));
                    }
                    log.debug("hits (second try): ", hStart, hEnd);
                    hitMap.put(hStart, w);
                    hitMap.put(hEnd, null);
                    continue;
                }
                w.addTag("natural", "coastline");
                if (!w.hasIdenticalEndPoints()) {
                    log.error((Object)"adding sea shape that is not really closed");
                }
                this.saver.addWay(w);
                continue;
            }
            log.debug("hits: ", hStart, hEnd);
            hitMap.put(hStart, w);
            hitMap.put(hEnd, null);
        }
        return hitMap;
    }

    private EdgeHit getEdgeHit(Area a, Coord p) {
        return this.getEdgeHit(a, p, 10);
    }

    private EdgeHit getEdgeHit(Area a, Coord p, int tolerance) {
        int lat = p.getLatitude();
        int lon = p.getLongitude();
        int minLat = a.getMinLat();
        int maxLat = a.getMaxLat();
        int minLong = a.getMinLong();
        int maxLong = a.getMaxLong();
        log.info((Object)String.format("getEdgeHit: (%d %d) (%d %d %d %d)", lat, lon, minLat, minLong, maxLat, maxLong));
        if (lat <= minLat + tolerance) {
            return new EdgeHit(0, (double)(lon - minLong) / (double)(maxLong - minLong));
        }
        if (lon >= maxLong - tolerance) {
            return new EdgeHit(1, (double)(lat - minLat) / (double)(maxLat - minLat));
        }
        if (lat >= maxLat - tolerance) {
            return new EdgeHit(2, (double)(maxLong - lon) / (double)(maxLong - minLong));
        }
        if (lon <= minLong + tolerance) {
            return new EdgeHit(3, (double)(maxLat - lat) / (double)(maxLat - minLat));
        }
        return null;
    }

    private EdgeHit getNextEdgeHit(Area a, Coord p) {
        int lat = p.getLatitude();
        int lon = p.getLongitude();
        int minLat = a.getMinLat();
        int maxLat = a.getMaxLat();
        int minLong = a.getMinLong();
        int maxLong = a.getMaxLong();
        log.info((Object)String.format("getNextEdgeHit: (%d %d) (%d %d %d %d)", lat, lon, minLat, minLong, maxLat, maxLong));
        int min = lat - minLat;
        int i = 0;
        double l = (double)(lon - minLong) / (double)(maxLong - minLong);
        if (maxLong - lon < min) {
            min = maxLong - lon;
            i = 1;
            l = (double)(lat - minLat) / (double)(maxLat - minLat);
        }
        if (maxLat - lat < min) {
            min = maxLat - lat;
            i = 2;
            l = (double)(maxLong - lon) / (double)(maxLong - minLong);
        }
        if (lon - minLong < min) {
            i = 3;
            l = (double)(maxLat - lat) / (double)(maxLat - minLat);
        }
        return new EdgeHit(i, l);
    }

    private void closeGaps(List<Way> ways, Area bounds) {
        if (this.maxCoastlineGap > 0) {
            boolean changed = true;
            block0: while (changed) {
                changed = false;
                for (Way w1 : ways) {
                    Way wm;
                    List<Coord> points1;
                    Coord w1e;
                    if (w1.hasIdenticalEndPoints() || bounds.onBoundary(w1e = (points1 = w1.getPoints()).get(points1.size() - 1))) continue;
                    Way nearest = null;
                    double smallestGap = Double.MAX_VALUE;
                    for (Way w2 : ways) {
                        double gap;
                        List<Coord> points2;
                        Coord w2s;
                        if (w1 == w2 || w2.hasIdenticalEndPoints() || bounds.onBoundary(w2s = (points2 = w2.getPoints()).get(0)) || !((gap = w1e.distance(w2s)) < smallestGap)) continue;
                        nearest = w2;
                        smallestGap = gap;
                    }
                    if (nearest == null || !(smallestGap < (double)this.maxCoastlineGap)) continue;
                    Coord w2s = nearest.getPoints().get(0);
                    log.warn((Object)("Bridging " + (int)smallestGap + "m gap in coastline from " + w1e.toOSMURL() + " to " + w2s.toOSMURL()));
                    if (FakeIdGenerator.isFakeId(w1.getId())) {
                        wm = w1;
                    } else {
                        wm = new Way(w1.getOriginalId());
                        wm.setFakeId();
                        ways.remove(w1);
                        ways.add(wm);
                        wm.getPoints().addAll(points1);
                        wm.copyTags(w1);
                    }
                    wm.getPoints().addAll(nearest.getPoints());
                    ways.remove(nearest);
                    Way w = new Way(FakeIdGenerator.makeFakeId());
                    w.addTag("natural", "mkgmap:coastline-gap");
                    w.addPoint(w1e);
                    w.addPoint(w2s);
                    this.saver.addWay(w);
                    changed = true;
                    continue block0;
                }
            }
        }
    }

    static {
        String[] sources = new String[]{"uk.me.parabola.mkgmap.reader.osm.bin.OsmBinPrecompSeaDataSource", "uk.me.parabola.mkgmap.reader.osm.xml.Osm5PrecompSeaDataSource"};
        precompSeaLoader = new ArrayList<Class<? extends LoadableMapDataSource>>();
        for (String source : sources) {
            try {
                Class<?> c = Class.forName(source);
                precompSeaLoader.add(c);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }

    class PrecompData {
        private byte[][] precompIndex;
        private String precompSeaExt;
        private String precompSeaPrefix;
        private String precompZipFileInternalPath;
        private ZipFile zipFile;

        PrecompData() {
        }

        static /* synthetic */ byte[][] access$202(PrecompData x0, byte[][] x1) {
            x0.precompIndex = x1;
            return x1;
        }
    }

    private static class EdgeHit
    implements Comparable<EdgeHit> {
        private final int edge;
        private final double t;

        EdgeHit(int edge, double t) {
            this.edge = edge;
            this.t = t;
        }

        @Override
        public int compareTo(EdgeHit o) {
            if (this.edge < o.edge) {
                return -1;
            }
            if (this.edge > o.edge) {
                return 1;
            }
            if (this.t > o.t) {
                return 1;
            }
            if (this.t < o.t) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof EdgeHit) {
                EdgeHit h = (EdgeHit)o;
                return h.edge == this.edge && Double.compare(h.t, this.t) == 0;
            }
            return false;
        }

        private Coord getPoint(Area a) {
            log.info("getPoint: ", this, a);
            switch (this.edge) {
                case 0: {
                    return new Coord(a.getMinLat(), (int)((double)a.getMinLong() + this.t * (double)(a.getMaxLong() - a.getMinLong())));
                }
                case 1: {
                    return new Coord((int)((double)a.getMinLat() + this.t * (double)(a.getMaxLat() - a.getMinLat())), a.getMaxLong());
                }
                case 2: {
                    return new Coord(a.getMaxLat(), (int)((double)a.getMaxLong() - this.t * (double)(a.getMaxLong() - a.getMinLong())));
                }
                case 3: {
                    return new Coord((int)((double)a.getMaxLat() - this.t * (double)(a.getMaxLat() - a.getMinLat())), a.getMinLong());
                }
            }
            throw new MapFailedException("illegal state");
        }

        public String toString() {
            return "EdgeHit " + this.edge + "@" + this.t;
        }
    }
}

