/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class Tags
implements Iterable<String> {
    private static final int INIT_SIZE = 8;
    private static final TagDict tagDict = TagDict.getInstance();
    private short keySize;
    private short capacity;
    private short size;
    private short[] keys = new short[8];
    private String[] values = new String[8];

    public Tags() {
        this.capacity = (short)8;
    }

    public String get(String key) {
        short k = tagDict.xlate(key);
        int ind = this.keyPos(k);
        if (ind < 0) {
            return null;
        }
        return this.values[ind];
    }

    public String get(short key) {
        int ind = this.keyPos(key);
        if (ind < 0) {
            return null;
        }
        return this.values[ind];
    }

    public int size() {
        return this.size;
    }

    public String put(String key, String value) {
        assert (key != null) : "key is null";
        short dictIdx = tagDict.xlate(key);
        return this.put(dictIdx, value);
    }

    public String put(short key, String value) {
        assert (value != null) : "value is null";
        this.ensureSpace();
        int ind = this.keyPos(key);
        if (ind < 0) assert (false) : "keyPos(" + key + ") returns null - size = " + this.keySize + ", capacity = " + this.capacity;
        this.keys[ind] = key;
        String old = this.values[ind];
        if (old == null) {
            this.keySize = (short)(this.keySize + 1);
            this.size = (short)(this.size + 1);
        }
        this.values[ind] = value;
        return old;
    }

    public String remove(short key) {
        int k = this.keyPos(key);
        if (k >= 0 && this.values[k] != null) {
            String old = this.values[k];
            this.values[k] = null;
            this.size = (short)(this.size - 1);
            return old;
        }
        return null;
    }

    public String remove(String key) {
        short kd = tagDict.xlate(key);
        return this.remove(kd);
    }

    public Tags copy() {
        Tags cp = new Tags();
        cp.keySize = this.keySize;
        cp.size = this.size;
        cp.capacity = this.capacity;
        cp.keys = Arrays.copyOf(this.keys, this.keys.length);
        cp.values = Arrays.copyOf(this.values, this.values.length);
        return cp;
    }

    private void ensureSpace() {
        while (this.keySize + 1 >= this.capacity) {
            short ncap = (short)(this.capacity * 2);
            short[] okey = this.keys;
            String[] oval = this.values;
            this.keys = new short[ncap];
            this.values = new String[ncap];
            this.capacity = ncap;
            this.keySize = 0;
            this.size = 0;
            for (int i = 0; i < okey.length; ++i) {
                short k = okey[i];
                String v = oval[i];
                if (k == 0 || v == null) continue;
                int ind = this.keyPos(k);
                this.keys[ind] = k;
                this.values[ind] = v;
                this.keySize = (short)(this.keySize + 1);
                this.size = (short)(this.size + 1);
            }
        }
        assert (this.keySize < this.capacity);
    }

    private int keyPos(short key) {
        int k;
        int i = k = key & this.capacity - 1;
        do {
            if (this.keys[i] == 0 || this.keys[i] == key) {
                return i;
            }
            if (++i < this.capacity) continue;
            i = 0;
        } while (i != k);
        return -1;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int pos;

            @Override
            public boolean hasNext() {
                for (int i = this.pos; i < Tags.this.capacity; ++i) {
                    if (Tags.this.values[i] == null) continue;
                    this.pos = i;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                if (this.pos < Tags.this.capacity) {
                    for (int i = this.pos; i < Tags.this.capacity; ++i) {
                        if (Tags.this.values[i] == null) continue;
                        this.pos = i + 1;
                        return tagDict.get(Tags.this.keys[i]) + "=" + Tags.this.values[i];
                    }
                    this.pos = Tags.this.capacity;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Map.Entry<String, String>> entryIterator() {
        return new Iterator<Map.Entry<String, String>>(){
            private int pos;

            @Override
            public boolean hasNext() {
                for (int i = this.pos; i < Tags.this.capacity; ++i) {
                    if (Tags.this.values[i] == null) continue;
                    this.pos = i;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(tagDict.get(Tags.this.keys[this.pos]), Tags.this.values[this.pos]);
                ++this.pos;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Map.Entry<Short, String>> entryShortIterator() {
        return new Iterator<Map.Entry<Short, String>>(){
            private int pos;

            @Override
            public boolean hasNext() {
                for (int i = this.pos; i < Tags.this.capacity; ++i) {
                    if (Tags.this.values[i] == null) continue;
                    this.pos = i;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<Short, String> next() {
                AbstractMap.SimpleEntry<Short, String> entry = new AbstractMap.SimpleEntry<Short, String>(Tags.this.keys[this.pos], Tags.this.values[this.pos]);
                ++this.pos;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, String> getTagsWithPrefix(String prefix, boolean removePrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        int prefixLen = prefix.length();
        for (int i = 0; i < this.capacity; ++i) {
            String k;
            if (this.keys[i] == 0 || (k = tagDict.get(this.keys[i])) == null || !k.startsWith(prefix)) continue;
            if (removePrefix) {
                map.put(k.substring(prefixLen), this.values[i]);
                continue;
            }
            map.put(k, this.values[i]);
        }
        return map;
    }

    public void removeAll() {
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
        this.keySize = 0;
        this.size = 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        Iterator<Map.Entry<String, String>> tagIter = this.entryIterator();
        while (tagIter.hasNext()) {
            Map.Entry<String, String> tag = tagIter.next();
            if (s.length() > 1) {
                s.append("; ");
            }
            s.append(tag.getKey());
            s.append("=");
            s.append(tag.getValue());
        }
        s.append("]");
        return s.toString();
    }

    public int expand(short[] keyArray, String[] tagVals) {
        if (tagVals == null) {
            return 0;
        }
        int maxKey = tagVals.length - 1;
        int cntTags = 0;
        for (int i = 0; i < this.capacity; ++i) {
            short tagKey = this.keys[i];
            if (tagKey == 0 || this.values[i] == null || tagKey > maxKey) continue;
            tagVals[tagKey] = this.values[i];
            keyArray[cntTags++] = tagKey;
        }
        return cntTags;
    }
}

