/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.polish.PolishTurnRestriction;
import uk.me.parabola.mkgmap.reader.polish.RestrictionHelper;
import uk.me.parabola.mkgmap.reader.polish.RoadHelper;

public class PolishMapDataSource
extends MapperBasedMapDataSource
implements LoadableMapDataSource {
    private static final Logger log = Logger.getLogger(PolishMapDataSource.class);
    private static final String READING_CHARSET = "iso-8859-1";
    private static final int S_IMG_ID = 1;
    private static final int S_POINT = 2;
    private static final int S_POLYLINE = 3;
    private static final int S_POLYGON = 4;
    private static final int S_RESTRICTION = 5;
    private MapPoint point;
    private MapLine polyline;
    private MapShape shape;
    private PolishTurnRestriction restriction;
    private List<Coord> points;
    private final RoadHelper roadHelper = new RoadHelper();
    private final RestrictionHelper restrictionHelper = new RestrictionHelper();
    private Map<String, String> extraAttributes;
    private String copyright;
    private int section;
    private LevelInfo[] levels;
    private int endLevel;
    private char elevUnits;
    private static final double METERS_TO_FEET = 3.2808399;
    private int lineNo;
    private boolean havePolygon4B;
    private Boolean driveOnLeft;
    private CharsetDecoder dec;
    Long2ObjectOpenHashMap<Coord> coordMap = new Long2ObjectOpenHashMap();

    @Override
    public boolean isFileSupported(String name) {
        return name.endsWith(".mp") || name.endsWith(".MP") || name.endsWith(".mp.gz");
    }

    @Override
    public void load(String name) throws FileNotFoundException, FormatException {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(Utils.openFile(name), READING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new FormatException("Unrecognised charset iso-8859-1");
        }
        this.dec = Charset.forName("utf-8").newDecoder();
        this.dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                ++this.lineNo;
                if (line.trim().isEmpty() || line.charAt(0) == ';') continue;
                if (line.startsWith("[END")) {
                    this.endSection();
                    continue;
                }
                if (line.charAt(0) == '[') {
                    this.sectionStart(line);
                    continue;
                }
                this.processLine(line);
            }
            this.restrictionHelper.processAndAddRestrictions(this.roadHelper, this.mapper);
        }
        catch (IOException e) {
            throw new FormatException("Reading file failed", e);
        }
        this.addBackground(this.havePolygon4B);
        this.coordMap = null;
    }

    @Override
    public LevelInfo[] mapLevels() {
        if (this.levels == null) {
            this.levels = new LevelInfo[]{new LevelInfo(3, 17), new LevelInfo(2, 18), new LevelInfo(1, 22), new LevelInfo(0, 24)};
        }
        this.levels[0].setTop(true);
        return this.levels;
    }

    @Override
    public LevelInfo[] overviewMapLevels() {
        return null;
    }

    @Override
    public String[] copyrightMessages() {
        return new String[]{this.copyright};
    }

    private void sectionStart(String line) {
        String name = line.substring(1, line.length() - 1);
        log.debug("section name", name);
        this.extraAttributes = null;
        if (name.equals("IMG ID")) {
            this.section = 1;
        } else if (name.equals("POI") || name.equals("RGN10") || name.equals("RGN20")) {
            this.point = new MapPoint();
            this.section = 2;
        } else if (name.equals("POLYLINE") || name.equals("RGN40")) {
            this.polyline = new MapLine();
            this.roadHelper.clear();
            this.section = 3;
        } else if (name.equals("POLYGON") || name.equals("RGN80")) {
            this.shape = new MapShape();
            this.section = 4;
        } else if (name.equals("Restrict")) {
            this.restriction = new PolishTurnRestriction();
            this.section = 5;
        } else {
            log.info((Object)("Ignoring " + name + " section"));
        }
    }

    private void endSection() {
        switch (this.section) {
            case 1: {
                break;
            }
            case 2: {
                if (this.extraAttributes != null && this.point.hasExtendedType()) {
                    this.point.setExtTypeAttributes(this.makeExtTypeAttributes());
                }
                this.mapper.addToBounds(this.point.getLocation());
                this.mapper.addPoint(this.point);
                break;
            }
            case 3: {
                if (this.points == null) break;
                if (this.roadHelper.isRoad()) {
                    this.polyline.setPoints(this.points);
                    this.mapper.addRoad(this.roadHelper.makeRoad(this.polyline));
                    break;
                }
                if (this.extraAttributes != null && this.polyline.hasExtendedType()) {
                    this.polyline.setExtTypeAttributes(this.makeExtTypeAttributes());
                }
                int maxPointsInLine = 250;
                if (this.points.size() > 250) {
                    ArrayList<Coord> segPoints = new ArrayList<Coord>(250);
                    for (Coord p : this.points) {
                        segPoints.add(p);
                        if (segPoints.size() != 250) continue;
                        MapLine seg = this.polyline.copy();
                        seg.setPoints(segPoints);
                        this.mapper.addLine(seg);
                        segPoints = new ArrayList(250);
                        segPoints.add(p);
                    }
                    if (segPoints.isEmpty()) break;
                    this.polyline.setPoints(segPoints);
                    this.mapper.addLine(this.polyline);
                    break;
                }
                this.polyline.setPoints(this.points);
                this.mapper.addLine(this.polyline);
                break;
            }
            case 4: {
                if (this.points == null) break;
                if (this.points.get(0) != this.points.get(this.points.size() - 1)) {
                    this.points.add(this.points.get(0));
                }
                this.shape.setPoints(this.points);
                if (this.extraAttributes != null && this.shape.hasExtendedType()) {
                    this.shape.setExtTypeAttributes(this.makeExtTypeAttributes());
                }
                this.mapper.addShape(this.shape);
                break;
            }
            case 5: {
                this.restrictionHelper.addRestriction(this.restriction);
                break;
            }
            case 0: {
                break;
            }
            default: {
                log.warn("unexpected default in switch", this.section);
            }
        }
        this.section = 0;
        this.endLevel = 0;
        this.points = null;
    }

    private void processLine(String line) {
        String[] nameVal = line.split("=", 2);
        if (nameVal.length != 2) {
            log.warn((Object)("short line? " + line));
            return;
        }
        String name = nameVal[0];
        String value = nameVal[1];
        log.debug("LINE: ", name, "|", value);
        switch (this.section) {
            case 1: {
                this.imgId(name, value);
                break;
            }
            case 2: {
                if (this.isCommonValue(this.point, name, value)) break;
                this.point(name, value);
                break;
            }
            case 3: {
                if (this.isCommonValue(this.polyline, name, value)) break;
                this.line(name, value);
                break;
            }
            case 4: {
                if (this.isCommonValue(this.shape, name, value)) break;
                this.shape(name, value);
                break;
            }
            case 5: {
                this.restriction(name, value);
                break;
            }
            default: {
                log.debug((Object)"line ignored");
            }
        }
    }

    private void point(String name, String value) {
        if (name.equals("Type")) {
            int type = Integer.decode(value);
            this.point.setType(type);
        } else if (name.equals("SubType")) {
            int subtype = Integer.decode(value);
            int type = this.point.getType();
            if (type <= 255) {
                this.point.setType(type << 8 | subtype);
            }
        } else if (name.startsWith("Data") || name.startsWith("Origin")) {
            Coord co = this.makeCoord(value);
            this.setResolution(this.point, name);
            this.point.setLocation(co);
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    private void line(String name, String value) {
        if (name.equals("Type")) {
            this.polyline.setType(Integer.decode(value));
        } else if (name.startsWith("Data")) {
            List<Coord> newPoints = this.coordsFromString(value);
            if (this.polyline.getType() == 32 || this.polyline.getType() == 33 || this.polyline.getType() == 34) {
                this.fixElevation();
            }
            this.setResolution(this.polyline, name);
            if (this.points != null) {
                log.error((Object)("Line " + this.polyline.getName() + " has multiple Data lines - concatenating the points"));
                this.points.addAll(newPoints);
            } else {
                this.points = newPoints;
            }
        } else if (name.equals("RoadID")) {
            this.roadHelper.setRoadId(Integer.parseInt(value));
        } else if (name.startsWith("Nod")) {
            this.roadHelper.addNode(value);
        } else if (name.equals("RouteParam") || name.equals("RouteParams")) {
            this.roadHelper.setParam(value);
        } else if (name.equals("DirIndicator")) {
            this.polyline.setDirection(Integer.parseInt(value) > 0);
        } else if (name.startsWith("Numbers")) {
            this.roadHelper.addNumbers(value);
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    private List<Coord> coordsFromString(String value) {
        String[] ords = value.split("\\) *, *\\(");
        ArrayList<Coord> points = new ArrayList<Coord>();
        for (String s : ords) {
            Coord co = this.makeCoord(s);
            if (log.isDebugEnabled()) {
                log.debug(" L: ", co);
            }
            this.mapper.addToBounds(co);
            points.add(co);
        }
        log.debug((Object)(points.size() + " points from " + value));
        return points;
    }

    private void fixElevation() {
        if (this.elevUnits == 'm') {
            String h = this.polyline.getName();
            try {
                int n = Integer.parseInt(h);
                n = (int)((double)n * 3.2808399);
                this.polyline.setName(String.valueOf(n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void shape(String name, String value) {
        if (name.equals("Type")) {
            int type = Integer.decode(value);
            this.shape.setType(type);
            if (type == 75) {
                this.havePolygon4B = true;
            }
        } else if (name.startsWith("Data")) {
            List<Coord> newPoints = this.coordsFromString(value);
            if (this.points != null) {
                this.points.addAll(newPoints);
            } else {
                this.points = newPoints;
            }
            this.setResolution(this.shape, name);
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    private boolean isCommonValue(MapElement elem, String name, String value) {
        if (name.equals("Label")) {
            elem.setName(PolishMapDataSource.unescape(this.recode(value)));
        } else if (name.equals("Label2") || name.equals("Label3")) {
            elem.add2Name(PolishMapDataSource.unescape(this.recode(value)));
        } else if (name.equals("Levels") || name.equals("EndLevel") || name.equals("LevelsNumber")) {
            try {
                this.endLevel = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.endLevel = 0;
            }
        } else if (name.equals("ZipCode")) {
            elem.setZip(this.recode(value));
        } else if (name.equals("CityName")) {
            elem.setCity(this.recode(value));
        } else if (name.equals("StreetDesc")) {
            elem.setStreet(this.recode(value));
        } else if (name.equals("HouseNumber")) {
            elem.setHouseNumber(this.recode(value));
        } else if (name.equals("is_in")) {
            elem.setIsIn(this.recode(value));
        } else if (name.equals("Phone")) {
            elem.setPhone(this.recode(value));
        } else if (name.equals("CountryName")) {
            elem.setCountry(PolishMapDataSource.unescape(this.recode(value)));
        } else if (name.equals("RegionName")) {
            elem.setRegion(this.recode(value));
        } else {
            return false;
        }
        return true;
    }

    public static String unescape(String s) {
        int ind = s.indexOf("~[");
        if (ind < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        if (ind > 0) {
            sb.append(s.substring(0, ind));
        }
        char[] buf = s.toCharArray();
        while (ind < buf.length) {
            if (ind < buf.length - 2 && buf[ind] == '~' && buf[ind + 1] == '[') {
                StringBuffer num = new StringBuffer();
                ind += 2;
                while (ind < buf.length && buf[ind++] != ']') {
                    num.append(buf[ind - 1]);
                }
                try {
                    int inum = Integer.decode(num.toString());
                    if (inum == 6956) {
                        inum = 28;
                    }
                    if (inum >= 42) {
                        inum -= 41;
                    }
                    sb.append((char)inum);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            sb.append(buf[ind]);
            ++ind;
        }
        return sb.toString();
    }

    private String recode(String value) {
        if (this.dec != null) {
            try {
                byte[] bytes = value.getBytes(READING_CHARSET);
                ByteBuffer buf = ByteBuffer.wrap(bytes);
                CharBuffer out = this.dec.decode(buf);
                return out.toString();
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"no support for iso-8859-1");
            }
            catch (CharacterCodingException e) {
                log.error((Object)"error decoding label", e);
            }
        }
        return value;
    }

    private void setResolution(MapElement elem, String name) {
        if (this.endLevel > 0) {
            elem.setMinResolution(this.extractResolution(this.endLevel));
            elem.setMaxResolution(this.extractResolution(name));
        } else {
            int res = this.extractResolution(name);
            elem.setMinResolution(res);
            elem.setMaxResolution(res);
        }
    }

    private int extractResolution(String name) {
        int level = Integer.valueOf(name.substring(name.charAt(0) == 'O' ? 6 : 4));
        return this.extractResolution(level);
    }

    private int extractResolution(int level) {
        int nlevels = this.levels.length;
        if (level >= nlevels) {
            level = nlevels - 1;
        }
        LevelInfo li = this.levels[nlevels - level - 1];
        return li.getBits();
    }

    private void imgId(String name, String value) {
        if (name.equals("Copyright")) {
            this.copyright = value;
        } else if (name.equals("Levels")) {
            int nlev = Integer.valueOf(value);
            this.levels = new LevelInfo[nlev];
        } else if (name.startsWith("Level")) {
            int level = Integer.valueOf(name.substring(5));
            int bits = Integer.valueOf(value);
            LevelInfo info = new LevelInfo(level, bits);
            int nlevels = this.levels.length;
            if (level >= nlevels) {
                return;
            }
            this.levels[nlevels - level - 1] = info;
        } else if (name.startsWith("Elevation")) {
            char fc = value.charAt(0);
            if (fc == 'm' || fc == 'M') {
                this.elevUnits = (char)109;
            }
        } else if (name.equals("CodePage")) {
            this.dec = Charset.forName("cp" + value).newDecoder();
            this.dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        } else if (name.endsWith("LeftSideTraffic")) {
            if ("Y".equals(value)) {
                this.setDriveOnLeft(true);
            } else if ("N".equals(value)) {
                this.setDriveOnLeft(false);
            }
        }
    }

    private Coord makeCoord(String value) {
        String[] fields = value.split("[(,)]");
        int i = 0;
        if (fields[0].isEmpty()) {
            i = 1;
        }
        Double f1 = Double.valueOf(fields[i]);
        Double f2 = Double.valueOf(fields[i + 1]);
        Coord co = new Coord(f1, f2);
        long key = Utils.coord2Long(co);
        Coord co2 = (Coord)this.coordMap.get(key);
        if (co2 != null) {
            return co2;
        }
        this.coordMap.put(key, (Object)co);
        return co;
    }

    private ExtTypeAttributes makeExtTypeAttributes() {
        HashMap<String, String> eta = new HashMap<String, String>();
        int colour = 0;
        int style = 0;
        for (Map.Entry<String, String> entry : this.extraAttributes.entrySet()) {
            String u;
            String v = entry.getValue();
            if (entry.getKey().equals("Depth")) {
                u = this.extraAttributes.get("DepthUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("depth", v);
                continue;
            }
            if (entry.getKey().equals("Height")) {
                u = this.extraAttributes.get("HeightUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height", v);
                continue;
            }
            if (entry.getKey().equals("HeightAboveFoundation")) {
                u = this.extraAttributes.get("HeightAboveFoundationUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height-above-foundation", v);
                continue;
            }
            if (entry.getKey().equals("HeightAboveDatum")) {
                u = this.extraAttributes.get("HeightAboveDatumUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height-above-datum", v);
                continue;
            }
            if (entry.getKey().equals("Color")) {
                colour = Integer.decode(v);
                continue;
            }
            if (entry.getKey().equals("Style")) {
                style = Integer.decode(v);
                continue;
            }
            if (entry.getKey().equals("Position")) {
                eta.put("position", v);
                continue;
            }
            if (entry.getKey().equals("FoundationColor")) {
                eta.put("color", v);
                continue;
            }
            if (entry.getKey().equals("Light")) {
                eta.put("light", v);
                continue;
            }
            if (entry.getKey().equals("LightType")) {
                eta.put("type", v);
                continue;
            }
            if (entry.getKey().equals("Period")) {
                eta.put("period", v);
                continue;
            }
            if (entry.getKey().equals("Note")) {
                eta.put("note", v);
                continue;
            }
            if (entry.getKey().equals("LocalDesignator")) {
                eta.put("local-desig", v);
                continue;
            }
            if (entry.getKey().equals("InternationalDesignator")) {
                eta.put("int-desig", v);
                continue;
            }
            if (entry.getKey().equals("FacilityPoint")) {
                eta.put("facilities", v);
                continue;
            }
            if (entry.getKey().equals("Racon")) {
                eta.put("racon", v);
                continue;
            }
            if (!entry.getKey().equals("LeadingAngle")) continue;
            eta.put("leading-angle", v);
        }
        if (colour != 0 || style != 0) {
            eta.put("style", "0x" + Integer.toHexString(style << 8 | colour));
        }
        return new ExtTypeAttributes(eta, "Line " + this.lineNo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restriction(String name, String value) {
        try {
            if (!this.restriction.isValid()) return;
            if (name.equals("Nod")) {
                this.restriction.setNodId(Long.valueOf(value));
                return;
            }
            if (name.equals("TraffPoints")) {
                String[] traffPoints = value.split(",");
                if (traffPoints.length == 3) {
                    this.restriction.setFromNodId(Long.valueOf(traffPoints[0]));
                    this.restriction.setToNodId(Long.valueOf(traffPoints[2]));
                    return;
                } else if (traffPoints.length < 3) {
                    this.restriction.setValid(false);
                    log.error((Object)("Invalid restriction definition. " + this.restriction));
                    return;
                } else {
                    this.restriction.setValid(false);
                    log.info((Object)"Restrictions composed from 3 or more roads are not yet supported");
                }
                return;
            }
            if (name.equals("TraffRoads")) {
                String[] traffRoads = value.split(",");
                this.restriction.setRoadIdA(Long.valueOf(traffRoads[0]));
                this.restriction.setRoadIdB(Long.valueOf(traffRoads[1]));
                return;
            }
            if (name.equals("RestrParam")) {
                this.restriction.setExceptMask(this.getRestrictionExceptionMask(value));
                return;
            }
            if (!name.equals("Time")) return;
        }
        catch (NumberFormatException ex) {
            this.restriction.setValid(false);
            log.error((Object)("Invalid restriction definition. " + this.restriction));
        }
    }

    private byte getRestrictionExceptionMask(String value) {
        String[] params = value.split(",");
        byte exceptMask = 0;
        if (params.length > 0 && params.length <= 8) {
            block10: for (int i = 0; i < params.length; ++i) {
                if (!"1".equals(params[i])) continue;
                switch (i) {
                    case 0: {
                        exceptMask = (byte)(exceptMask | 0xFFFFFF80);
                        continue block10;
                    }
                    case 1: {
                        exceptMask = (byte)(exceptMask | 8);
                        continue block10;
                    }
                    case 2: {
                        exceptMask = (byte)(exceptMask | 4);
                        continue block10;
                    }
                    case 3: {
                        exceptMask = (byte)(exceptMask | 0x20);
                        continue block10;
                    }
                    case 4: {
                        exceptMask = (byte)(exceptMask | 0x40);
                        continue block10;
                    }
                    case 5: {
                        exceptMask = (byte)(exceptMask | 1);
                        continue block10;
                    }
                    case 6: {
                        exceptMask = (byte)(exceptMask | 2);
                        continue block10;
                    }
                    case 7: {
                        exceptMask = (byte)(exceptMask | 0x10);
                    }
                }
            }
        } else {
            log.error((Object)("Invalid RestrParam definition. -> " + value));
        }
        return exceptMask;
    }
}

