/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.mkgmap.general.MapDetails;
import uk.me.parabola.mkgmap.reader.polish.PolishTurnRestriction;
import uk.me.parabola.mkgmap.reader.polish.RoadHelper;

public class RestrictionHelper {
    private final List<PolishTurnRestriction> allRestrictions = new ArrayList<PolishTurnRestriction>();

    public void processAndAddRestrictions(RoadHelper roadHelper, MapDetails mapper) {
        Map<Long, CoordNode> allNodes = roadHelper.getNodeCoords();
        for (PolishTurnRestriction tr : this.allRestrictions) {
            GeneralRouteRestriction grr = new GeneralRouteRestriction("not", tr.getExceptMask(), Long.toString(tr.getNodId()));
            grr.setFromNode(allNodes.get(tr.getFromNodId()));
            grr.setFromWayId(tr.getRoadIdA());
            grr.setToNode(allNodes.get(tr.getToNodId()));
            if (tr.getViaNodId() != 0L) {
                grr.setViaNodes(Arrays.asList(allNodes.get(tr.getNodId()), allNodes.get(tr.getViaNodId())));
                grr.setViaWayIds(Arrays.asList(tr.getRoadIdB()));
                grr.setToWayId(tr.getRoadIdC());
            } else {
                grr.setViaNodes(Arrays.asList(allNodes.get(tr.getNodId())));
                grr.setToWayId(tr.getRoadIdB());
            }
            mapper.addRestriction(grr);
        }
    }

    public void addRestriction(PolishTurnRestriction restriction) {
        this.allRestrictions.add(restriction);
    }
}

