/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.app.typ.AlphaAdder;
import uk.me.parabola.imgfmt.app.typ.BitmapImage;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.Image;
import uk.me.parabola.imgfmt.app.typ.Rgb;
import uk.me.parabola.imgfmt.app.typ.TrueImage;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypElement;
import uk.me.parabola.imgfmt.app.typ.Xpm;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class CommonSection {
    private static final Set<String> seen = new HashSet<String>();
    protected final TypData data;
    private boolean hasXpm;

    protected CommonSection(TypData data) {
        this.data = data;
    }

    protected boolean commonKey(TokenScanner scanner, TypElement current, String name, String value) {
        if (name.equalsIgnoreCase("Type")) {
            try {
                int ival = Integer.decode(value);
                if (ival >= 256) {
                    current.setType(ival >>> 8);
                    current.setSubType(ival & 0xFF);
                }
                current.setType(ival & 0xFF);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number " + value);
            }
        } else if (name.equalsIgnoreCase("SubType")) {
            try {
                int ival = Integer.decode(value);
                current.setSubType(ival);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number for sub type " + value);
            }
        } else if (name.toLowerCase().startsWith("string")) {
            try {
                current.addLabel(value);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number in " + value);
            }
        } else if (name.equalsIgnoreCase("Xpm")) {
            Xpm xpm = this.readXpm(scanner, value, current.simpleBitmap());
            current.setXpm(xpm);
        } else if (name.equalsIgnoreCase("FontStyle")) {
            int font = this.decodeFontStyle(value);
            current.setFontStyle(font);
        } else if (!name.equalsIgnoreCase("CustomColor") && !name.equals("ExtendedLabels")) {
            if (name.equalsIgnoreCase("DaycustomColor")) {
                current.setDayFontColor(value);
            } else if (name.equalsIgnoreCase("NightcustomColor")) {
                current.setNightCustomColor(value);
            } else if (!name.equalsIgnoreCase("Comment")) {
                return false;
            }
        }
        return true;
    }

    protected int decodeFontStyle(String value) {
        if (value.startsWith("NoLabel") || value.equalsIgnoreCase("nolabel")) {
            return 1;
        }
        if (value.equalsIgnoreCase("SmallFont") || value.equalsIgnoreCase("Small")) {
            return 2;
        }
        if (value.equalsIgnoreCase("NormalFont") || value.equalsIgnoreCase("Normal")) {
            return 3;
        }
        if (value.equalsIgnoreCase("LargeFont") || value.equalsIgnoreCase("Large")) {
            return 4;
        }
        if (value.equalsIgnoreCase("Default")) {
            return 0;
        }
        this.warnUnknown("font value " + value);
        return 0;
    }

    private void parseXpmHeader(TokenScanner scanner, ColourInfo info, String header) {
        TokenScanner s2 = new TokenScanner("string", new StringReader(header));
        if (s2.checkToken("\"")) {
            s2.nextToken();
        }
        try {
            info.setWidth(s2.nextInt());
            info.setHeight(s2.nextInt());
            info.setNumberOfColours(s2.nextInt());
            info.setCharsPerPixel(s2.nextInt());
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(scanner, "Bad number in XPM header " + header);
        }
    }

    protected ColourInfo readColourInfo(TokenScanner scanner, String header) {
        ColourInfo colourInfo = new ColourInfo();
        this.parseXpmHeader(scanner, colourInfo, header);
        for (int i = 0; i < colourInfo.getNumberOfColours(); ++i) {
            scanner.validateNext("\"");
            int cpp = colourInfo.getCharsPerPixel();
            Token token = scanner.nextRawToken();
            String colourTag = token.getValue();
            while (colourTag.length() < cpp) {
                colourTag = colourTag + scanner.nextRawToken().getValue();
            }
            colourTag = colourTag.substring(0, cpp);
            scanner.validateNext("c");
            String colour = scanner.nextValue();
            if (colour.charAt(0) == '#') {
                colour = scanner.nextValue();
                colourInfo.addColour(colourTag, new Rgb(colour));
            } else if (colour.equalsIgnoreCase("none")) {
                colourInfo.addTransparent(colourTag);
            } else {
                throw new SyntaxException(scanner, "Unrecognised colour: " + colour);
            }
            scanner.validateNext("\"");
            this.readExtraColourInfo(scanner, colourInfo);
        }
        return colourInfo;
    }

    private void readExtraColourInfo(TokenScanner scanner, AlphaAdder colour) {
        Token tok;
        while (!scanner.isEndOfFile() && !(tok = scanner.nextRawToken()).isEol()) {
            String word = tok.getValue();
            if (!word.endsWith("alpha")) continue;
            scanner.validateNext("=");
            String aval = scanner.nextValue();
            try {
                int alpha = Integer.decode(aval);
                alpha = 255 - ((alpha << 4) + alpha);
                colour.addAlpha(alpha);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number for alpha value " + aval);
            }
        }
    }

    protected BitmapImage readImage(TokenScanner scanner, ColourInfo colourInfo) {
        StringBuffer sb = new StringBuffer();
        int width = colourInfo.getWidth();
        int height = colourInfo.getHeight();
        int cpp = colourInfo.getCharsPerPixel();
        for (int i = 0; i < height; ++i) {
            String line = scanner.readLine();
            if (line.isEmpty()) {
                throw new SyntaxException(scanner, "Invalid blank line in bitmap.");
            }
            if (line.charAt(0) != '\"') {
                throw new SyntaxException(scanner, "xpm bitmap line must start with a quote: " + line);
            }
            if (line.length() < 1 + width * cpp) {
                throw new SyntaxException(scanner, "short image line: " + line);
            }
            line = line.substring(1, 1 + width * cpp);
            sb.append(line);
            for (int cidx = 0; cidx < width * cpp; cidx += cpp) {
                String tag = line.substring(cidx, cidx + cpp);
                try {
                    colourInfo.getIndex(tag);
                    continue;
                }
                catch (Exception e) {
                    throw new SyntaxException(scanner, String.format("Tag '%s' is not one of the defined colour pixels", tag));
                }
            }
        }
        if (sb.length() != width * height * cpp) {
            throw new SyntaxException(scanner, "Got " + sb.length() + " of image data, " + "expected " + width * height * cpp);
        }
        return new BitmapImage(colourInfo, sb.toString());
    }

    private Image readTrueImage(TokenScanner scanner, ColourInfo colourInfo) {
        int width = colourInfo.getWidth();
        int height = colourInfo.getHeight();
        int[] image = new int[width * height];
        int nPixels = width * height;
        int count = 0;
        while (count < nPixels) {
            scanner.validateNext("\"");
            count = this.readTrueImageLine(scanner, image, count);
        }
        if (scanner.checkToken("\"")) {
            int transPixel = image[0];
            for (int i = 1; i < nPixels; ++i) {
                int pix = image[i];
                if (pix == transPixel) {
                    pix &= 0xFFFFFF00;
                }
                image[i - 1] = pix;
            }
            scanner.validateNext("\"");
            this.readTrueImageLine(scanner, image, nPixels - 1);
        }
        return new TrueImage(colourInfo, image);
    }

    private int readTrueImageLine(TokenScanner scanner, final int[] image, int count) {
        do {
            scanner.validateNext("#");
            String col = scanner.nextValue();
            try {
                int val = (int)Long.parseLong(col, 16);
                if (col.length() <= 6) {
                    val = (val << 8) + 255;
                }
                image[count++] = val;
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Not a valid colour value ");
            }
        } while (scanner.checkToken("#"));
        scanner.validateNext("\"");
        final int lastColourIndex = count - 1;
        this.readExtraColourInfo(scanner, new AlphaAdder(){

            @Override
            public void addAlpha(int alpha) {
                image[lastColourIndex] = image[lastColourIndex] & 0xFFFFFF00 | alpha & 0xFF;
            }
        });
        return count;
    }

    protected Xpm readXpm(TokenScanner scanner, String header, boolean simple) {
        ColourInfo colourInfo = this.readColourInfo(scanner, header);
        String msg = colourInfo.analyseColours(simple);
        if (msg != null) {
            throw new SyntaxException(scanner, msg);
        }
        Xpm xpm = new Xpm();
        xpm.setColourInfo(colourInfo);
        int height = colourInfo.getHeight();
        int width = colourInfo.getWidth();
        if (height > 0 && width > 0) {
            colourInfo.setHasBitmap(true);
            Image image = colourInfo.getNumberOfColours() == 0 ? this.readTrueImage(scanner, colourInfo) : this.readImage(scanner, colourInfo);
            xpm.setImage(image);
        }
        this.hasXpm = true;
        return xpm;
    }

    protected void warnUnknown(String name) {
        if (seen.contains(name)) {
            return;
        }
        seen.add(name);
        System.out.printf("Warning: tag '%s' not known\n", name);
    }

    protected void validate(TokenScanner scanner) {
        if (!this.hasXpm) {
            throw new SyntaxException(scanner, "No XPM tag in section");
        }
    }
}

