/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.util.ElementQuadTreeNode;

public class ElementQuadTree {
    private final ElementQuadTreeNode root;

    public ElementQuadTree(Area bbox, Collection<Element> elements) {
        this.root = new ElementQuadTreeNode(bbox, elements);
    }

    public void remove(Element element) {
        this.root.remove(element);
    }

    public Set<Element> get(Area bbox) {
        return this.root.get(bbox, new HashSet<Element>());
    }

    public Set<Element> get(java.awt.geom.Area polygon) {
        return this.root.get(new ElementQuadTreeNode.ElementQuadTreePolygon(polygon), new HashSet<Element>());
    }

    public Set<Element> get(Collection<List<Coord>> polygons) {
        return this.root.get(new ElementQuadTreeNode.ElementQuadTreePolygon(polygons), new HashSet<Element>());
    }

    public int getDepth() {
        return this.root.getDepth();
    }

    public Set<Element> get(List<Coord> polygon) {
        if (polygon.size() < 3) {
            return new HashSet<Element>();
        }
        if (!polygon.get(0).equals(polygon.get(polygon.size() - 1))) {
            return new HashSet<Element>();
        }
        return this.root.get(new ElementQuadTreeNode.ElementQuadTreePolygon(polygon), new HashSet<Element>());
    }

    public long getCoordSize() {
        return this.root.getSize();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public void clear() {
        this.root.clear();
    }
}

