/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr28Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr21
extends Mdr2x {
    public Mdr21(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        Sort sort = this.getConfig().getSort();
        ArrayList<SortKey<Mdr7Record>> keys = new ArrayList<SortKey<Mdr7Record>>();
        HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
        for (Mdr7Record s : inStreets) {
            String string;
            Mdr13Record region;
            Mdr5Record city = s.getCity();
            if (city == null || (region = city.getMdrRegion()) == null || (string = region.getName()) == null) continue;
            keys.add(sort.createSortKey(s, string, s.getIndex(), cache));
        }
        Collections.sort(keys);
        String lastName = null;
        int lastMapid = 0;
        int record = 0;
        for (SortKey sortKey : keys) {
            Mdr7Record street = (Mdr7Record)sortKey.getObject();
            String name = street.getName();
            int mapid = street.getMapIndex();
            if (mapid == lastMapid && name.equals(lastName)) continue;
            ++record;
            this.streets.add(street);
            Mdr13Record mdrRegion = street.getCity().getMdrRegion();
            if (mdrRegion != null) {
                Mdr28Record mdr28 = mdrRegion.getMdr28();
                mdr28.setMdr21(record);
            }
            lastMapid = mapid;
            lastName = name;
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return true;
    }

    @Override
    public int getExtraValue() {
        return 71680;
    }
}

