/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.NamedRecord;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class PrefixIndex
extends MdrSection {
    private final int prefixLength;
    private int maxIndex;
    private final List<Mdr8Record> index = new ArrayList<Mdr8Record>();

    public PrefixIndex(MdrConfig config, int prefixLength) {
        this.setConfig(config);
        this.prefixLength = prefixLength;
    }

    public void createFromList(List<? extends NamedRecord> list, boolean grouped) {
        this.maxIndex = list.size();
        Sort sort = this.getConfig().getSort();
        Collator collator = sort.getCollator();
        collator.setStrength(0);
        String lastCountryName = null;
        String lastPrefix = "";
        int inRecord = 0;
        int outRecord = 0;
        for (NamedRecord namedRecord : list) {
            String countryName;
            Mdr5Record city;
            ++inRecord;
            String prefix = this.getPrefix(namedRecord.getName());
            if (collator.compare(prefix, lastPrefix) == 0) continue;
            ++outRecord;
            Mdr8Record ind = new Mdr8Record();
            ind.setPrefix(prefix);
            ind.setRecordNumber(inRecord);
            this.index.add(ind);
            lastPrefix = prefix;
            if (!grouped || (city = ((Mdr7Record)namedRecord).getCity()) == null || (countryName = city.getCountryName()).equals(lastCountryName)) continue;
            city.getMdrCountry().getMdr29().setMdr17(outRecord);
            lastCountryName = countryName;
        }
    }

    public void createFromList(List<? extends NamedRecord> list) {
        this.createFromList(list, false);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = PrefixIndex.numberToPointerSize(this.maxIndex);
        Charset charset = this.getConfig().getSort().getCharset();
        for (Mdr8Record s : this.index) {
            writer.put(s.getPrefix().getBytes(charset), 0, this.prefixLength);
            this.putN(writer, size, s.getRecordNumber());
        }
    }

    @Override
    public int getItemSize() {
        return this.prefixLength + PrefixIndex.numberToPointerSize(this.maxIndex);
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }

    private String getPrefix(String in) {
        StringBuilder sb = new StringBuilder();
        char[] chars = in.toCharArray();
        int ci = 0;
        for (int i = 0; i < this.prefixLength; ++i) {
            char c = '\u0000';
            while (ci < chars.length) {
                c = chars[ci++];
                if (ci == 1 && c == ' ' || c < 32) continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }
}

