/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.net.Abandon;

class VarBitWriter {
    private final BitWriter bw;
    private final int minWidth;
    int bitWidth;
    boolean negative;
    boolean signed;

    VarBitWriter(BitWriter bw, int minWidth) {
        this.bw = bw;
        this.minWidth = minWidth;
    }

    public VarBitWriter(BitWriter bw, int minWidth, boolean negative, boolean signed, int width) {
        this(bw, minWidth);
        this.negative = negative;
        this.signed = signed;
        if (width > minWidth) {
            this.bitWidth = width - minWidth;
        }
    }

    public void write(int n) {
        if (!this.checkFit(n)) {
            throw new Abandon("number does not fit bit space available");
        }
        if (n < 0 && this.negative) {
            n = -n;
        }
        if (this.signed) {
            int mask = (1 << this.minWidth + this.bitWidth + 2) - 1;
            n &= mask;
        }
        this.bw.putn(n, this.minWidth + this.bitWidth + (this.signed ? 1 : 0));
    }

    boolean checkFit(int n) {
        if (this.negative) {
            if (n > 0) {
                return false;
            }
            n = -n;
        } else if (this.signed && n < 0) {
            n = -1 - n;
        }
        int mask = (1 << this.minWidth + this.bitWidth) - 1;
        return n == (n & mask);
    }

    public void writeFormat() {
        this.bw.put1(this.negative);
        this.bw.put1(this.signed);
        this.bw.putn(this.bitWidth, 4);
    }
}

