/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.srt.SRTFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.MpsFile;
import uk.me.parabola.imgfmt.mps.MpsFileReader;
import uk.me.parabola.imgfmt.mps.ProductBlock;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.FileKind;
import uk.me.parabola.mkgmap.combiners.MdrBuilder;

public class GmapsuppBuilder
implements Combiner {
    private static final Logger log = Logger.getLogger(GmapsuppBuilder.class);
    private static final String GMAPSUPP = "gmapsupp.img";
    private static final int ENTRY_SIZE = 240;
    private static final int DIRECTORY_OFFSET_ENTRY = 2;
    private final Map<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    private String areaName;
    private String mapsetName;
    private String overallDescription = "Combined map";
    private String outputDir;
    private MpsFile mpsFile;
    private boolean createIndex;
    private final Map<Integer, MdrBuilder> mdrBuilderMap = new LinkedHashMap<Integer, MdrBuilder>();
    private final Map<Integer, Sort> sortMap = new LinkedHashMap<Integer, Sort>();
    private boolean splitName;

    @Override
    public void init(CommandArgs args) {
        this.areaName = args.get("area-name", null);
        this.mapsetName = args.get("mapset-name", "OSM map set");
        this.overallDescription = args.getDescription();
        this.outputDir = args.getOutputDir();
        this.splitName = args.get("split-name-index", false);
    }

    private MdrBuilder addMdrFile(int familyId, Sort sort, String outputDir) {
        MdrBuilder mdrBuilder = this.mdrBuilderMap.get(familyId);
        if (mdrBuilder != null) {
            return mdrBuilder;
        }
        mdrBuilder = new MdrBuilder();
        mdrBuilder.initForDevice(sort, outputDir, this.splitName);
        this.mdrBuilderMap.put(familyId, mdrBuilder);
        return mdrBuilder;
    }

    private void addSrtFile(int familyId, FileInfo info) {
        Sort prevSort = this.sortMap.get(familyId);
        Sort sort = info.getSort();
        if (prevSort == null) {
            if (info.getKind() == FileKind.IMG_KIND) {
                this.sortMap.put(familyId, sort);
            }
        } else {
            if (prevSort.getCodepage() != sort.getCodepage()) {
                System.err.printf("WARNING: input file '%s' has a different code page (%d rather than %d)\n", info.getFilename(), sort.getCodepage(), prevSort.getCodepage());
            }
            if (info.hasSortOrder() && prevSort.getSortOrderId() != sort.getSortOrderId()) {
                System.err.printf("WARNING: input file '%s' has a different sort order (%x rather than %x\n", info.getFilename(), sort.getSortOrderId(), prevSort.getSortOrderId());
            }
        }
    }

    @Override
    public void onMapEnd(FileInfo info) {
        this.files.put(info.getFilename(), info);
        if (info.isImg()) {
            int familyId = info.getFamilyId();
            if (this.createIndex) {
                MdrBuilder mdrBuilder = this.addMdrFile(familyId, info.getSort(), info.getOutputDir());
                mdrBuilder.onMapEnd(info);
            }
            this.addSrtFile(familyId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinish() {
        for (MdrBuilder mdrBuilder : this.mdrBuilderMap.values()) {
            mdrBuilder.onFinishForDevice();
        }
        FileSystem imgFs = null;
        try {
            imgFs = this.createGmapsupp();
            this.addAllFiles(imgFs);
            for (Map.Entry<Integer, MdrBuilder> ent : this.mdrBuilderMap.entrySet()) {
                this.addFile(imgFs, ent.getValue().getFileName(), String.format("%08d.MDR", ent.getKey()));
            }
            this.writeSrtFile(imgFs);
            this.writeMpsFile();
        }
        catch (FileNotWritableException e) {
            log.warn((Object)"Could not create gmapsupp file");
            System.err.println("Could not create gmapsupp file");
        }
        finally {
            Utils.closeFile(imgFs);
        }
    }

    private void writeSrtFile(FileSystem imgFs) throws FileNotWritableException {
        for (Map.Entry<Integer, Sort> ent : this.sortMap.entrySet()) {
            Sort sort = ent.getValue();
            int familyId = ent.getKey();
            if (sort.getId1() == 0 && sort.getId2() == 0) {
                return;
            }
            ImgChannel channel = null;
            try {
                channel = imgFs.create(String.format("%08d.SRT", familyId));
                SRTFile srtFile = new SRTFile(channel);
                srtFile.setSort(sort);
                srtFile.write();
                srtFile.close();
            }
            catch (FileExistsException e) {
                try {
                    log.error((Object)"could not create SRT file as it exists already");
                    throw new FileNotWritableException("already existed", e);
                }
                catch (Throwable throwable) {
                    Utils.closeFile(channel);
                    throw throwable;
                }
            }
            Utils.closeFile(channel);
        }
    }

    private void writeMpsFile() throws FileNotWritableException {
        try {
            this.mpsFile.sync();
            this.mpsFile.close();
        }
        catch (IOException e) {
            throw new FileNotWritableException("Could not finish write to MPS file", e);
        }
    }

    private MapBlock makeMapBlock(FileInfo info) {
        MapBlock mb = new MapBlock();
        mb.setMapNumber(info.getMapnameAsInt());
        mb.setHexNumber(info.getHexname());
        mb.setMapDescription(info.getDescription());
        mb.setAreaName(this.areaName != null ? this.areaName : "Area " + info.getMapname());
        mb.setSeriesName(info.getSeriesName());
        mb.setIds(info.getFamilyId(), info.getProductId());
        return mb;
    }

    private ProductBlock makeProductBlock(FileInfo info) {
        ProductBlock pb = new ProductBlock();
        pb.setFamilyId(info.getFamilyId());
        pb.setProductId(info.getProductId());
        pb.setDescription(info.getFamilyName());
        return pb;
    }

    private void addAllFiles(FileSystem outfs) {
        for (FileInfo info : this.files.values()) {
            String filename = info.getFilename();
            switch (info.getKind()) {
                case IMG_KIND: {
                    this.addImg(outfs, filename);
                    this.addMpsEntry(info);
                    break;
                }
                case GMAPSUPP_KIND: {
                    this.addImg(outfs, filename);
                    this.addMpsFile(info);
                    break;
                }
                case APP_KIND: 
                case TYP_KIND: {
                    this.addFile(outfs, filename);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMpsFile(FileInfo info) {
        String name = info.getFilename();
        FileSystem fs = null;
        try {
            fs = ImgFS.openFs(name);
            MpsFileReader mr = new MpsFileReader(fs.open(info.getMpsName(), "r"));
            for (MapBlock block : mr.getMaps()) {
                this.mpsFile.addMap(block);
            }
            for (ProductBlock b : mr.getProducts()) {
                this.mpsFile.addProduct(b);
            }
            mr.close();
        }
        catch (IOException e) {
            log.error((Object)"Could not read MPS file from gmapsupp", e);
        }
        finally {
            Utils.closeFile(fs);
        }
    }

    private void addMpsEntry(FileInfo info) {
        this.mpsFile.addMap(this.makeMapBlock(info));
        this.mpsFile.addProduct(this.makeProductBlock(info));
    }

    private MpsFile createMpsFile(FileSystem outfs) throws FileNotWritableException {
        try {
            ImgChannel channel = outfs.create("MAKEGMAP.MPS");
            return new MpsFile(channel);
        }
        catch (FileExistsException e) {
            log.error((Object)"could not create MPS file as it already exists");
            throw new FileNotWritableException("already existed", e);
        }
    }

    private void addFile(FileSystem outfs, String filename) {
        String imgname = this.createImgFilename(filename);
        this.addFile(outfs, filename, imgname);
    }

    private void addFile(FileSystem outfs, String filename, String imgname) {
        FileImgChannel chan = new FileImgChannel(filename, "r");
        try {
            this.copyFile(chan, outfs, imgname);
        }
        catch (IOException e) {
            log.error((Object)("Could not write file " + filename));
        }
    }

    private String createImgFilename(String pathname) {
        File f = new File(pathname);
        String name = f.getName().toUpperCase(Locale.ENGLISH);
        int dot = name.lastIndexOf(46);
        String base = name.substring(0, dot);
        String ext = name.substring(dot + 1);
        if (base.length() > 8) {
            base = base.substring(0, 8);
        }
        if (ext.length() > 3) {
            ext = ext.substring(0, 3);
        }
        return base + '.' + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImg(FileSystem outfs, String filename) {
        try (FileSystem infs = ImgFS.openFs(filename);){
            this.copyAllFiles(infs, outfs);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Could not open file " + filename));
        }
    }

    private void copyAllFiles(FileSystem infs, FileSystem outfs) {
        List<DirectoryEntry> entries = infs.list();
        for (DirectoryEntry ent : entries) {
            String ext = ent.getExt();
            if (ext.equals("   ") || ext.equals("MPS")) continue;
            String inname = ent.getFullName();
            try {
                this.copyFile(inname, infs, outfs);
            }
            catch (IOException e) {
                log.warn("Could not copy " + inname, e);
            }
        }
    }

    private FileSystem createGmapsupp() throws FileNotWritableException {
        BlockInfo bi = this.calcBlockSize();
        int blockSize = bi.blockSize;
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(blockSize);
        params.setMapDescription(this.overallDescription);
        params.setDirectoryStartEntry(2);
        params.setGmapsupp(true);
        int reserveBlocks = (int)Math.ceil((double)bi.reserveEntries * 512.0 / (double)blockSize);
        params.setReservedDirectoryBlocks(reserveBlocks);
        FileSystem outfs = ImgFS.createFs(Utils.joinPath(this.outputDir, GMAPSUPP), params);
        this.mpsFile = this.createMpsFile(outfs);
        this.mpsFile.setMapsetName(this.mapsetName);
        return outfs;
    }

    private void copyFile(String inName, FileSystem infs, FileSystem outfs) throws IOException {
        ImgChannel fin = infs.open(inName, "r");
        this.copyFile(fin, outfs, inName);
    }

    private void copyFile(ImgChannel fin, FileSystem outfs, String inName) throws IOException {
        ImgChannel fout = outfs.create(inName);
        this.copyFile(fin, fout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(ImgChannel fin, ImgChannel fout) throws IOException {
        try {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            while (fin.read(buf) > 0) {
                buf.flip();
                fout.write(buf);
                buf.compact();
            }
        }
        finally {
            fin.close();
            fout.close();
        }
    }

    private BlockInfo calcBlockSize() {
        int[] ints;
        for (int bs : ints = new int[]{512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000}) {
            int totBlocks = 0;
            int totHeaderEntries = 0;
            for (FileInfo info : this.files.values()) {
                totBlocks += info.getNumBlocks(bs);
                int slots = info.getNumHeaderEntries(bs);
                log.info("adding", slots, "slots for", info.getFilename());
                totHeaderEntries += slots;
            }
            int mpsSize = this.files.size() * 80 + 100;
            int mpsBlocks = (mpsSize + (bs - 1)) / bs;
            int mpsSlots = (mpsBlocks + 240 - 1) / 240;
            totBlocks += mpsBlocks;
            totHeaderEntries += mpsSlots;
            if (this.createIndex) {
                for (MdrBuilder mdrBuilder : this.mdrBuilderMap.values()) {
                    int sz = mdrBuilder.getSize();
                    int mdrBlocks = (sz + (bs - 1)) / bs;
                    int mdrSlots = (mdrBlocks + 240 - 1) / 240;
                    totBlocks += mdrBlocks;
                    totHeaderEntries += mdrSlots;
                }
            }
            for (int i = 0; i < this.sortMap.size(); ++i) {
                int sz = 1024;
                int mdrBlocks = (sz + (bs - 1)) / bs;
                int mdrSlots = (mdrBlocks + 240 - 1) / 240;
                totBlocks += mdrBlocks;
                totHeaderEntries += mdrSlots;
            }
            int totHeaderBlocks = (totHeaderEntries += 3) * 512 / bs;
            log.info("total blocks for", bs, "is", totHeaderBlocks, "based on slots=", totHeaderEntries);
            if (totBlocks + totHeaderEntries >= 65534 || totHeaderBlocks > 240) continue;
            return new BlockInfo(bs, totHeaderEntries);
        }
        throw new IllegalArgumentException("Could not select a suitable block size. Try to reduce the number of splits.");
    }

    public void setCreateIndex(boolean create) {
        this.createIndex = create;
    }

    private static class BlockInfo {
        private final int blockSize;
        private final int reserveEntries;

        private BlockInfo(int blockSize, int reserveEntries) {
            this.blockSize = blockSize;
            this.reserveEntries = reserveEntries;
        }
    }
}

