/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapShape;

public class DouglasPeuckerFilter
implements MapFilter {
    private final double filterDistance;
    private double maxErrorDistance;
    private int resolution;
    private int level;

    public DouglasPeuckerFilter(double filterDistance) {
        this.filterDistance = filterDistance;
    }

    @Override
    public void init(FilterConfig config) {
        this.resolution = config.getResolution();
        this.level = config.getLevel();
        this.maxErrorDistance = this.filterDistance * (double)(1 << config.getShift());
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        if (this.resolution == 24) {
            next.doFilter(element);
            return;
        }
        MapLine line = (MapLine)element;
        List<Coord> points = line.getPoints();
        ArrayList<Coord> coords = new ArrayList<Coord>(points.size());
        coords.addAll(points);
        int endIndex = coords.size() - 1;
        if (this.level == 0 || line instanceof MapShape) {
            for (int i = endIndex - 1; i > 0; --i) {
                Coord p = (Coord)coords.get(i);
                if (!p.preserved()) continue;
                this.douglasPeucker(coords, i, endIndex, this.maxErrorDistance);
                endIndex = i;
            }
        }
        this.douglasPeucker(coords, 0, endIndex, this.maxErrorDistance);
        if (coords.size() == points.size()) {
            next.doFilter(line);
        } else {
            MapLine newline = line.copy();
            newline.setPoints(coords);
            next.doFilter(newline);
        }
    }

    protected void douglasPeucker(List<Coord> points, int startIndex, int endIndex, double allowedError) {
        int i;
        if (startIndex >= endIndex) {
            return;
        }
        double maxDistance = 0.0;
        int maxIndex = endIndex;
        Coord a = points.get(startIndex);
        Coord b = points.get(endIndex);
        for (i = endIndex - 1; i > startIndex; --i) {
            Coord p = points.get(i);
            double distance = p.shortestDistToLineSegment(a, b);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = i;
        }
        if (maxDistance > allowedError) {
            this.douglasPeucker(points, maxIndex, endIndex, allowedError);
            this.douglasPeucker(points, startIndex, maxIndex, allowedError);
        } else {
            if (a.highPrecEquals(b) && !points.get(endIndex).preserved()) {
                ++endIndex;
            }
            if (endIndex - startIndex > 4) {
                points.subList(startIndex + 1, endIndex).clear();
                return;
            }
            for (i = endIndex - 1; i > startIndex; --i) {
                points.remove(i);
            }
        }
    }
}

