/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.filters.BaseFilter;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.util.Java2DConverter;

public class PolygonSplitterBase
extends BaseFilter {
    protected static final int MAX_SIZE = Short.MAX_VALUE;
    private int shift;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
    }

    protected void split(MapShape shape, List<MapShape> outputs) {
        Rectangle r2;
        Rectangle r1;
        Area area = Java2DConverter.createArea(shape.getPoints());
        Rectangle bounds = area.getBounds();
        if (bounds.isEmpty()) {
            return;
        }
        int half = 1 << this.shift - 1;
        int mask = ~((1 << this.shift) - 1);
        if (bounds.width > bounds.height) {
            int halfWidth = bounds.width / 2;
            if (this.shift != 0 && ((halfWidth = halfWidth + half & mask) == 0 || halfWidth == bounds.width)) {
                halfWidth = bounds.width / 2;
            }
            r1 = new Rectangle(bounds.x, bounds.y, halfWidth, bounds.height);
            r2 = new Rectangle(bounds.x + halfWidth, bounds.y, bounds.width - halfWidth, bounds.height);
        } else {
            int halfHeight = bounds.height / 2;
            if (this.shift != 0 && ((halfHeight = halfHeight + half & mask) == 0 || halfHeight == bounds.height)) {
                halfHeight = bounds.height / 2;
            }
            r1 = new Rectangle(bounds.x, bounds.y, bounds.width, halfHeight);
            r2 = new Rectangle(bounds.x, bounds.y + halfHeight, bounds.width, bounds.height - halfHeight);
        }
        Area clipper = new Area(r1);
        clipper.intersect(area);
        this.areaToShapes(shape, clipper, outputs);
        clipper = new Area(r2);
        clipper.intersect(area);
        this.areaToShapes(shape, clipper, outputs);
    }

    private void areaToShapes(MapShape origShape, Area area, List<MapShape> outputs) {
        List<List<Coord>> subShapePoints = Java2DConverter.areaToShapes(area);
        for (List<Coord> subShape : subShapePoints) {
            MapShape s = origShape.copy();
            s.setPoints(subShape);
            outputs.add(s);
        }
    }
}

