/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.MultiIdentityHashMap;

public class RoadMerger {
    private static final Logger log = Logger.getLogger(RoadMerger.class);
    private static final double MAX_MERGE_ANGLE = 130.0;
    private final MultiIdentityHashMap<Coord, Long> restrictions = new MultiIdentityHashMap();
    private final MultiIdentityHashMap<Coord, ConvertedWay> startPoints = new MultiIdentityHashMap();
    private final MultiIdentityHashMap<Coord, ConvertedWay> endPoints = new MultiIdentityHashMap();
    private static final Set<String> mergeTagsEqualValue = new HashSet<String>(){
        {
            this.add("mkgmap:label:1");
            this.add("mkgmap:label:2");
            this.add("mkgmap:label:3");
            this.add("mkgmap:label:4");
            this.add("mkgmap:postal_code");
            this.add("mkgmap:city");
            this.add("mkgmap:region");
            this.add("mkgmap:country");
            this.add("mkgmap:is_in");
            this.add("mkgmap:skipSizeFilter");
            this.add("mkgmap:synthesised");
            this.add("mkgmap:highest-resolution-only");
            this.add("mkgmap:flare-check");
        }
    };

    private static boolean stringEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    private void workoutRestrictionRelations(List<RestrictionRelation> restrictionRels) {
        for (RestrictionRelation rel : restrictionRels) {
            Set<Long> restrictionWayIds = rel.getWayIds();
            for (Coord via : rel.getViaCoords()) {
                HashSet roadAtVia = new HashSet();
                roadAtVia.addAll(this.startPoints.get(via));
                roadAtVia.addAll(this.endPoints.get(via));
                for (ConvertedWay r : roadAtVia) {
                    long wayId = r.getWay().getId();
                    if (!restrictionWayIds.contains(wayId)) continue;
                    this.restrictions.add(via, wayId);
                }
            }
        }
    }

    private void workoutThroughRoutes(List<Relation> throughRouteRelations) {
        for (Relation relation : throughRouteRelations) {
            Node node = null;
            Element w1 = null;
            Way w2 = null;
            for (Map.Entry<String, Element> member : relation.getElements()) {
                if (member.getValue() instanceof Node) {
                    if (node == null) {
                        node = (Node)member.getValue();
                        continue;
                    }
                    log.warn((Object)("Through route relation " + relation.toBrowseURL() + " has more than 1 node"));
                    continue;
                }
                if (!(member.getValue() instanceof Way)) continue;
                Way w = (Way)member.getValue();
                if (w1 == null) {
                    w1 = w;
                    continue;
                }
                if (w2 == null) {
                    w2 = w;
                    continue;
                }
                log.warn((Object)("Through route relation " + relation.toBrowseURL() + " has more than 2 ways"));
            }
            if (node == null) {
                log.warn((Object)("Through route relation " + relation.toBrowseURL() + " is missing the junction node"));
            }
            if (w1 == null || w2 == null) {
                log.warn((Object)("Through route relation " + relation.toBrowseURL() + " should reference 2 ways that meet at the junction node"));
            }
            if (node == null || w1 == null || w2 == null) continue;
            this.restrictions.add(node.getLocation(), w1.getId());
            this.restrictions.add(node.getLocation(), w2.getId());
        }
    }

    private boolean hasRestriction(Coord c, Way w) {
        if (w.isViaWay()) {
            return true;
        }
        Object wayRestrictions = this.restrictions.get(c);
        return wayRestrictions.contains(w.getId());
    }

    private void mergeRoads(ConvertedWay road1, ConvertedWay road2) {
        String WayPOI1;
        List<Coord> points1 = road1.getWay().getPoints();
        List<Coord> points2 = road2.getWay().getPoints();
        Coord mergePoint = points2.get(0);
        Coord endPoint = points2.get(points2.size() - 1);
        this.startPoints.removeMapping(mergePoint, road2);
        this.endPoints.removeMapping(endPoint, road2);
        this.endPoints.removeMapping(mergePoint, road1);
        points1.addAll(points2.subList(1, points2.size()));
        this.endPoints.add(endPoint, road1);
        String wayPOI2 = road2.getWay().getTag("mkgmap:way-poi-node-ids");
        if (wayPOI2 != null && !wayPOI2.equals(WayPOI1 = road1.getWay().getTag("mkgmap:way-poi-node-ids"))) {
            if (WayPOI1 == null) {
                WayPOI1 = "";
            }
            road1.getWay().addTag("mkgmap:way-poi-node-ids", WayPOI1 + wayPOI2);
        }
        mergePoint.decHighwayCount();
        assert (!this.restrictions.get(endPoint).contains(road2.getWay().getId()));
    }

    public List<ConvertedWay> merge(List<ConvertedWay> convertedWays, List<RestrictionRelation> restrictions, List<Relation> throughRouteRelations) {
        ArrayList<ConvertedWay> result = new ArrayList<ConvertedWay>();
        ArrayList<ConvertedWay> roadsToMerge = new ArrayList<ConvertedWay>(convertedWays.size());
        for (int i = 0; i < convertedWays.size(); ++i) {
            ConvertedWay cw = convertedWays.get(i);
            if (!cw.isValid() || !cw.isRoad()) continue;
            roadsToMerge.add(cw);
        }
        int noRoadsBeforeMerge = roadsToMerge.size();
        int noMerges = 0;
        ArrayList<Coord> mergePoints = new ArrayList<Coord>();
        for (ConvertedWay road : roadsToMerge) {
            Coord end;
            List<Coord> points = road.getWay().getPoints();
            Coord start = points.get(0);
            if (start == (end = points.get(points.size() - 1))) {
                result.add(road);
                continue;
            }
            mergePoints.add(start);
            mergePoints.add(end);
            this.startPoints.add(start, road);
            this.endPoints.add(end, road);
        }
        this.workoutRestrictionRelations(restrictions);
        this.workoutThroughRoutes(throughRouteRelations);
        Set mergeCompletedPoints = Collections.newSetFromMap(new IdentityHashMap());
        for (Coord mergePoint : mergePoints) {
            if (mergeCompletedPoints.contains(mergePoint)) continue;
            Object startRoads = this.startPoints.get(mergePoint);
            Object endRoads = this.endPoints.get(mergePoint);
            if (endRoads.isEmpty() || startRoads.isEmpty()) {
                mergeCompletedPoints.add(mergePoint);
                continue;
            }
            double bestAngle = Double.MAX_VALUE;
            ConvertedWay mergeRoad1 = null;
            ConvertedWay mergeRoad2 = null;
            Iterator i$ = endRoads.iterator();
            while (i$.hasNext()) {
                ConvertedWay road1 = (ConvertedWay)i$.next();
                if (this.hasRestriction(mergePoint, road1.getWay())) continue;
                List<Coord> points1 = road1.getWay().getPoints();
                Iterator i$2 = startRoads.iterator();
                while (i$2.hasNext()) {
                    List<Coord> points2;
                    ConvertedWay road2 = (ConvertedWay)i$2.next();
                    if (this.hasRestriction(mergePoint, road2.getWay()) || this.hasRestriction((points2 = road2.getWay().getPoints()).get(points2.size() - 1), road2.getWay()) || !RoadMerger.isMergeable(mergePoint, road1, road2)) continue;
                    double angle = Math.abs(Utils.getAngle(points1.get(points1.size() - 2), mergePoint, points2.get(1)));
                    log.debug("Road", road1.getWay().getId(), "and road", road2.getWay().getId(), "are mergeable with angle", angle);
                    if (!(angle < bestAngle)) continue;
                    mergeRoad1 = road1;
                    mergeRoad2 = road2;
                    bestAngle = angle;
                }
            }
            if (mergeRoad1 != null && mergeRoad2 != null) {
                log.debug("Merge", mergeRoad1.getWay().getId(), "and", mergeRoad2.getWay().getId(), "with angle", bestAngle);
                this.mergeRoads(mergeRoad1, mergeRoad2);
                ++noMerges;
                continue;
            }
            mergeCompletedPoints.add(mergePoint);
        }
        for (List mergedRoads : this.endPoints.values()) {
            result.addAll(mergedRoads);
        }
        Collections.sort(result, new Comparator<ConvertedWay>(){

            @Override
            public int compare(ConvertedWay o1, ConvertedWay o2) {
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        int noRoadsAfterMerge = result.size();
        log.info("Roads before/after merge:", noRoadsBeforeMerge, "/", noRoadsAfterMerge);
        int percentage = (int)Math.round((double)(noRoadsBeforeMerge - noRoadsAfterMerge) * 100.0 / (double)noRoadsBeforeMerge);
        log.info("Road network reduced by", percentage, "%", noMerges, "merges");
        return result;
    }

    private static boolean isMergeable(Coord mergePoint, ConvertedWay road1, ConvertedWay road2) {
        if (road1.getRoadClass() != road2.getRoadClass()) {
            return false;
        }
        if (road1.getRoadSpeed() != road2.getRoadSpeed()) {
            return false;
        }
        Way way1 = road1.getWay();
        Way way2 = road2.getWay();
        if (road1.getAccess() != road2.getAccess()) {
            if (log.isDebugEnabled()) {
                RoadMerger.reportFirstDifferentTag(way1, way2, road1.getAccess(), road2.getAccess(), AccessTagsAndBits.ACCESS_TAGS);
            }
            return false;
        }
        if (road1.getRouteFlags() != road2.getRouteFlags()) {
            if (log.isDebugEnabled()) {
                RoadMerger.reportFirstDifferentTag(way1, way2, road1.getRouteFlags(), road2.getRouteFlags(), AccessTagsAndBits.ROUTE_TAGS);
            }
            return false;
        }
        Coord cStart = road1.getWay().getPoints().get(0);
        Coord cEnd = road1.getWay().getPoints().get(road1.getWay().getPoints().size() - 1);
        if (cStart != mergePoint && cEnd != mergePoint) {
            return false;
        }
        Coord cOtherStart = way2.getPoints().get(0);
        Coord cOtherEnd = way2.getPoints().get(way2.getPoints().size() - 1);
        if (cOtherStart != mergePoint && cOtherEnd != mergePoint) {
            return false;
        }
        if (cStart == cOtherEnd) {
            return false;
        }
        if (!RoadMerger.isGTypeMergeable(road1.getGType(), road2.getGType())) {
            return false;
        }
        if (road1.isOneway()) {
            assert (road2.isOneway());
            if (cStart == mergePoint == (cOtherStart == mergePoint)) {
                log.warn("oneway with different direction", way1.getId(), way2.getId());
                return false;
            }
        }
        if (!RoadMerger.isWayMergeable(mergePoint, way1, way2)) {
            return false;
        }
        return RoadMerger.isAngleOK(mergePoint, way1, way2);
    }

    private static void reportFirstDifferentTag(Way way1, Way way2, byte flags1, byte flags2, Map<String, Byte> tagMaskMap) {
        for (Map.Entry<String, Byte> entry : tagMaskMap.entrySet()) {
            byte mask = entry.getValue();
            if ((flags1 & mask) == (flags2 & mask)) continue;
            String tagKey = entry.getKey();
            log.debug(entry.getKey(), "does not match", way1.getId(), "(" + way1.getTag(tagKey) + ")", way2.getId(), "(" + way2.getTag(tagKey) + ")");
            return;
        }
    }

    private static boolean isGTypeMergeable(GType type1, GType type2) {
        if (type1.getType() != type2.getType()) {
            return false;
        }
        if (type1.getMinResolution() != type2.getMinResolution()) {
            return false;
        }
        if (type1.getMaxResolution() != type2.getMaxResolution()) {
            return false;
        }
        if (type1.getMinLevel() != type2.getMinLevel()) {
            return false;
        }
        return type1.getMaxLevel() == type2.getMaxLevel();
    }

    private static boolean isWayMergeable(Coord mergePoint, Way way1, Way way2) {
        for (String tagname : mergeTagsEqualValue) {
            String tag2;
            String tag1 = way1.getTag(tagname);
            if (RoadMerger.stringEquals(tag1, tag2 = way2.getTag(tagname))) continue;
            if (log.isDebugEnabled()) {
                log.debug(tagname, "does not match", way1.getId(), "(" + tag1 + ")", way2.getId(), "(" + tag2 + ")");
            }
            return false;
        }
        return true;
    }

    private static boolean isAngleOK(Coord mergePoint, Way way1, Way way2) {
        Coord cOnWay2;
        Coord cOnWay1 = way1.getPoints().get(0) == mergePoint ? way1.getPoints().get(1) : way1.getPoints().get(way1.getPoints().size() - 2);
        double angle = Math.abs(Utils.getAngle(cOnWay1, mergePoint, cOnWay2 = way2.getPoints().get(0) == mergePoint ? way2.getPoints().get(1) : way2.getPoints().get(way2.getPoints().size() - 2)));
        if (angle > 130.0) {
            log.info("Do not merge ways", way1.getId(), "and", way2.getId(), "because they span a too big angle", angle, "\u00b0");
            return false;
        }
        return true;
    }
}

