/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.ActionRule;
import uk.me.parabola.mkgmap.osmstyle.ExpressionRule;
import uk.me.parabola.mkgmap.osmstyle.RuleDetails;
import uk.me.parabola.mkgmap.osmstyle.RuleIndex;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractBinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LinkedBinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LinkedOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.mkgmap.reader.osm.WatchableTypeResult;

public class RuleSet
implements Rule,
Iterable<Rule> {
    private static final Logger log = Logger.getLogger(RuleSet.class);
    private Rule[] rules;
    private Rule finalizeRule;
    int cacheId;
    boolean compiled = false;
    private RuleIndex index = new RuleIndex();
    private final Set<String> usedTags = new HashSet<String>();

    @Override
    public void resolveType(Element el, TypeResult result) {
        this.cacheId = this.resolveType(this.cacheId, el, result);
    }

    @Override
    public int resolveType(int cacheId, Element el, TypeResult result) {
        WatchableTypeResult a = new WatchableTypeResult(result);
        if (!this.compiled || cacheId == Integer.MAX_VALUE) {
            this.compile();
        }
        ++cacheId;
        BitSet candidates = new BitSet();
        for (Map.Entry<Short, String> tagEntry : el.getFastTagEntryIterator()) {
            BitSet rules = this.index.getRulesForTag(tagEntry.getKey(), tagEntry.getValue());
            if (rules == null || rules.isEmpty()) continue;
            candidates.or(rules);
        }
        int i = candidates.nextSetBit(0);
        while (i >= 0) {
            a.reset();
            cacheId = this.rules[i].resolveType(cacheId, el, a);
            if (a.isResolved()) {
                return cacheId;
            }
            i = candidates.nextSetBit(i + 1);
        }
        return cacheId;
    }

    @Override
    public Iterator<Rule> iterator() {
        if (this.rules == null) {
            this.prepare();
        }
        return Arrays.asList(this.rules).iterator();
    }

    public void add(String keystring, Rule rule, Set<String> changeableTags) {
        this.compiled = false;
        this.index.addRuleToIndex(new RuleDetails(keystring, rule, changeableTags));
    }

    public void addAll(RuleSet rs) {
        for (RuleDetails rd : rs.index.getRuleDetails()) {
            this.add(rd.getKeystring(), rd.getRule(), rd.getChangingTags());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Rule rule : this.rules) {
            sb.append(rule.toString());
        }
        return sb.toString();
    }

    public void merge(RuleSet rs) {
        RuleIndex newIndex = new RuleIndex();
        for (RuleDetails rd : this.index.getRuleDetails()) {
            newIndex.addRuleToIndex(rd);
        }
        for (RuleDetails rd : rs.index.getRuleDetails()) {
            newIndex.addRuleToIndex(rd);
        }
        this.index = newIndex;
        this.rules = newIndex.getRules();
        this.addUsedTags(rs.usedTags);
        this.compiled = false;
    }

    public void prepare() {
        this.index.prepare();
        this.rules = this.index.getRules();
        this.compile();
    }

    public Set<String> getUsedTags() {
        return this.usedTags;
    }

    public void addUsedTags(Collection<String> usedTags) {
        this.usedTags.addAll(usedTags);
    }

    private void compile() {
        HashMap<String, Op> tests = new HashMap<String, Op>();
        for (Rule rule : this.rules) {
            Op op;
            if (rule instanceof ExpressionRule) {
                op = ((ExpressionRule)rule).getOp();
            } else if (rule instanceof ActionRule) {
                op = ((ActionRule)rule).getOp();
            } else {
                log.error((Object)"unexpected rule instance");
                continue;
            }
            if (op instanceof AbstractBinaryOp) {
                AbstractBinaryOp binOp = (AbstractBinaryOp)op;
                binOp.setFirst(this.compileOp(tests, binOp.getFirst()));
                binOp.setSecond(this.compileOp(tests, binOp.getSecond()));
                op = this.compileOp(tests, binOp);
            } else if (op instanceof AbstractOp) {
                op = this.compileOp(tests, op);
            } else if (op instanceof LinkedBinaryOp) {
                ((LinkedBinaryOp)op).setFirst(this.compileOp(tests, ((LinkedBinaryOp)op).getFirst()));
                ((LinkedBinaryOp)op).setSecond(this.compileOp(tests, ((LinkedBinaryOp)op).getSecond()));
            } else if (op instanceof LinkedOp) {
                Op wrappedOp = this.compileOp(tests, ((LinkedOp)op).getFirst());
                op.setFirst(wrappedOp);
            } else {
                log.error((Object)"unexpected op instance");
                continue;
            }
            if (rule instanceof ExpressionRule) {
                ((ExpressionRule)rule).setOp(op);
                continue;
            }
            if (rule instanceof ActionRule) {
                ((ActionRule)rule).setOp(op);
                continue;
            }
            log.error((Object)"unexpected rule instance");
        }
        this.cacheId = 0;
        this.compiled = true;
    }

    private Op compileOp(HashMap<String, Op> tests, Op op) {
        if (op instanceof AbstractBinaryOp) {
            AbstractBinaryOp binOp = (AbstractBinaryOp)op;
            binOp.setFirst(this.compileOp(tests, binOp.getFirst()));
            binOp.setSecond(this.compileOp(tests, binOp.getSecond()));
        }
        if (op instanceof LinkedOp) {
            return op;
        }
        String test = op.toString();
        Op commonOp = tests.get(test);
        if (commonOp == null) {
            if (op instanceof AbstractOp) {
                ((AbstractOp)op).resetCache();
            }
            tests.put(test, op);
            commonOp = op;
        }
        return commonOp;
    }

    @Override
    public void setFinalizeRule(Rule finalizeRule) {
        if (this.rules == null) {
            throw new IllegalStateException("First call prepare() before setting the finalize rules");
        }
        for (Rule rule : this.rules) {
            rule.setFinalizeRule(finalizeRule);
        }
        this.compiled = false;
        this.finalizeRule = finalizeRule;
    }

    @Override
    public void printStats(String header) {
        if (this.rules == null) {
            return;
        }
        for (Rule rule : this.rules) {
            rule.printStats(header);
        }
        if (this.finalizeRule != null) {
            this.finalizeRule.printStats(header);
        }
    }
}

