/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Java2DConverter;

public class MultiPolygonRelation
extends Relation {
    private static final Logger log = Logger.getLogger(MultiPolygonRelation.class);
    public static final String STYLE_FILTER_TAG = "mkgmap:stylefilter";
    public static final String STYLE_FILTER_LINE = "polyline";
    public static final String STYLE_FILTER_POLYGON = "polygon";
    public static final String MP_CREATED_TAG = "mkgmap:mp_created";
    private final Map<Long, Way> tileWayMap;
    private final Map<Long, String> roleMap = new HashMap<Long, String>();
    private Map<Long, Way> mpPolygons = new LinkedHashMap<Long, Way>();
    protected ArrayList<BitSet> containsMatrix;
    protected ArrayList<JoinedWay> polygons;
    protected Set<JoinedWay> intersectingPolygons;
    protected double largestSize;
    protected JoinedWay largestOuterPolygon;
    protected Set<Way> outerWaysForLineTagging;
    protected Map<String, String> outerTags;
    private final Area bbox;
    protected java.awt.geom.Area bboxArea;
    private Coord cOfG = null;
    private double mpAreaSize = 0.0;
    private static final double OVERLAP_TOLERANCE_DISTANCE = 2.0;
    protected BitSet unfinishedPolygons;
    protected BitSet innerPolygons;
    protected BitSet taggedInnerPolygons;
    protected BitSet outerPolygons;
    protected BitSet taggedOuterPolygons;
    private static final int CUT_POINT_CLASSIFICATION_GOOD_THRESHOLD = 131072;
    private static final int CUT_POINT_CLASSIFICATION_BAD_THRESHOLD = 16384;
    private static final AreaComparator COMP_LONG_START = new AreaComparator(true, CoordinateAxis.LONGITUDE);
    private static final AreaComparator COMP_LONG_STOP = new AreaComparator(false, CoordinateAxis.LONGITUDE);
    private static final AreaComparator COMP_LAT_START = new AreaComparator(true, CoordinateAxis.LATITUDE);
    private static final AreaComparator COMP_LAT_STOP = new AreaComparator(false, CoordinateAxis.LATITUDE);

    public MultiPolygonRelation(Relation other, Map<Long, Way> wayMap, Area bbox) {
        this.tileWayMap = wayMap;
        this.bbox = bbox;
        this.setId(other.getId());
        this.copyTags(other);
        if (log.isDebugEnabled()) {
            log.debug("Construct multipolygon", this.toBrowseURL(), this.toTagString());
        }
        for (Map.Entry<String, Element> pair : other.getElements()) {
            String role = pair.getKey();
            Element el = pair.getValue();
            if (log.isDebugEnabled()) {
                log.debug(" ", role, el.toBrowseURL(), el.toTagString());
            }
            if (this.roleMap.containsKey(el.getId())) {
                log.warn("repeated member with id ", el.getId(), "in multipolygon relation", this.getId(), "is ignored");
                continue;
            }
            this.addElement(role, el);
            this.roleMap.put(el.getId(), role);
        }
    }

    public Coord getCofG() {
        return this.cOfG;
    }

    protected String getRole(Element element) {
        String role = this.roleMap.get(element.getId());
        if (role != null && ("outer".equals(role) || "inner".equals(role))) {
            return role;
        }
        return null;
    }

    private boolean joinWays(JoinedWay joinWay, JoinedWay tempWay, boolean checkOnly) {
        boolean reverseTempWay = false;
        int insIdx = -1;
        int firstTmpIdx = 1;
        boolean joinable = false;
        if (joinWay.getPoints().get(0) == tempWay.getPoints().get(0)) {
            insIdx = 0;
            reverseTempWay = true;
            firstTmpIdx = 1;
            joinable = true;
        } else if (joinWay.getPoints().get(joinWay.getPoints().size() - 1) == tempWay.getPoints().get(0)) {
            insIdx = joinWay.getPoints().size();
            reverseTempWay = false;
            firstTmpIdx = 1;
            joinable = true;
        } else if (joinWay.getPoints().get(0) == tempWay.getPoints().get(tempWay.getPoints().size() - 1)) {
            insIdx = 0;
            reverseTempWay = false;
            firstTmpIdx = 0;
            joinable = true;
        } else if (joinWay.getPoints().get(joinWay.getPoints().size() - 1) == tempWay.getPoints().get(tempWay.getPoints().size() - 1)) {
            insIdx = joinWay.getPoints().size();
            reverseTempWay = true;
            firstTmpIdx = 0;
            joinable = true;
        }
        if (!checkOnly && joinable) {
            int lastIdx = tempWay.getPoints().size();
            if (firstTmpIdx == 0) {
                --lastIdx;
            }
            List<Coord> tempCoords = tempWay.getPoints().subList(firstTmpIdx, lastIdx);
            if (reverseTempWay) {
                tempCoords = new ArrayList<Coord>(tempCoords);
                Collections.reverse(tempCoords);
            }
            joinWay.getPoints().addAll(insIdx, tempCoords);
            joinWay.addWay(tempWay);
        }
        return joinable;
    }

    protected ArrayList<JoinedWay> joinWays(List<Way> segments) {
        ArrayList<JoinedWay> joinedWays = new ArrayList<JoinedWay>();
        if (segments == null || segments.isEmpty()) {
            return joinedWays;
        }
        ArrayList<JoinedWay> unclosedWays = new ArrayList<JoinedWay>();
        for (Way orgSegment : segments) {
            JoinedWay jw = new JoinedWay(orgSegment);
            this.roleMap.put(jw.getId(), this.getRole(orgSegment));
            if (orgSegment.isClosed()) {
                if (!orgSegment.isComplete()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Close incomplete but closed polygon:", orgSegment);
                    }
                    jw.closeWayArtificially();
                }
                assert (jw.hasIdenticalEndPoints()) : "way is not closed";
                joinedWays.add(jw);
                continue;
            }
            unclosedWays.add(jw);
        }
        while (!unclosedWays.isEmpty()) {
            JoinedWay joinWay = (JoinedWay)unclosedWays.remove(0);
            if (joinWay.hasIdenticalEndPoints() || unclosedWays.isEmpty()) {
                joinedWays.add(joinWay);
                continue;
            }
            boolean joined = false;
            Way wrongRoleWay = null;
            String joinRole = this.getRole(joinWay);
            for (JoinedWay tempWay : unclosedWays) {
                if (tempWay.hasIdenticalEndPoints()) continue;
                String tempRole = this.getRole(tempWay);
                if (!"outer".equals(joinRole) && !"inner".equals(joinRole) || !"outer".equals(tempRole) && !"inner".equals(tempRole) || joinRole != null && joinRole.equals(tempRole)) {
                    joined = this.joinWays(joinWay, tempWay, false);
                } else if ((wrongRoleWay == null || wrongRoleWay.getPoints().size() < tempWay.getPoints().size()) && this.joinWays(joinWay, tempWay, true)) {
                    wrongRoleWay = tempWay;
                }
                if (!joined) continue;
                unclosedWays.remove(tempWay);
                break;
            }
            if (!joined && wrongRoleWay != null) {
                log.warn((Object)("Join ways with different roles. Multipolygon: " + this.toBrowseURL()));
                log.warn("Way1 Role:", this.getRole(joinWay));
                this.logWayURLs(Level.WARNING, "-", joinWay);
                log.warn("Way2 Role:", this.getRole(wrongRoleWay));
                this.logWayURLs(Level.WARNING, "-", wrongRoleWay);
                joined = this.joinWays(joinWay, (JoinedWay)wrongRoleWay, false);
                if (joined) {
                    unclosedWays.remove(wrongRoleWay);
                    break;
                }
            }
            if (joined) {
                if (joinWay.hasIdenticalEndPoints()) {
                    joinedWays.add(joinWay);
                    continue;
                }
                if (unclosedWays.isEmpty()) {
                    joinedWays.add(joinWay);
                    continue;
                }
                unclosedWays.add(0, joinWay);
                continue;
            }
            joinedWays.add(joinWay);
        }
        return joinedWays;
    }

    protected void closeWays(ArrayList<JoinedWay> wayList) {
        for (JoinedWay way : wayList) {
            if (way.hasIdenticalEndPoints() || way.getPoints().size() < 3) continue;
            Coord p1 = way.getPoints().get(0);
            Coord p2 = way.getPoints().get(way.getPoints().size() - 1);
            if (!this.bbox.insideBoundary(p1) && !this.bbox.insideBoundary(p2) && (p1.getLatitude() <= this.bbox.getMinLat() && p2.getLatitude() <= this.bbox.getMinLat() || p1.getLatitude() >= this.bbox.getMaxLat() && p2.getLatitude() >= this.bbox.getMaxLat() || p1.getLongitude() <= this.bbox.getMinLong() && p2.getLongitude() <= this.bbox.getMinLong() || p1.getLongitude() >= this.bbox.getMaxLong() && p2.getLongitude() >= this.bbox.getMaxLong())) {
                way.closeWayArtificially();
                log.info("Endpoints of way", way, "are both outside the bbox. Closing it directly.");
                continue;
            }
            Line2D.Float closingLine = new Line2D.Float(p1.getLongitude(), p1.getLatitude(), p2.getLongitude(), p2.getLatitude());
            boolean intersects = false;
            Coord lastPoint = null;
            for (Coord thisPoint : way.getPoints().subList(1, way.getPoints().size() - 1)) {
                if (lastPoint != null && closingLine.intersectsLine(lastPoint.getLongitude(), lastPoint.getLatitude(), thisPoint.getLongitude(), thisPoint.getLatitude())) {
                    intersects = true;
                    break;
                }
                lastPoint = thisPoint;
            }
            if (intersects) continue;
            if (log.isInfoEnabled()) {
                log.info("Closing way", way);
                log.info("from", way.getPoints().get(0).toOSMURL());
                log.info("to", way.getPoints().get(way.getPoints().size() - 1).toOSMURL());
            }
            way.closeWayArtificially();
        }
    }

    protected boolean connectUnclosedWays(List<JoinedWay> allWays) {
        ArrayList<JoinedWay> unclosed = new ArrayList<JoinedWay>();
        for (JoinedWay w : allWays) {
            if (w.hasIdenticalEndPoints()) continue;
            unclosed.add(w);
        }
        if (unclosed.size() >= 2) {
            log.debug("Checking", unclosed.size(), "unclosed ways for connections outside the bbox");
            IdentityHashMap<Coord, JoinedWay> outOfBboxPoints = new IdentityHashMap<Coord, JoinedWay>();
            for (JoinedWay w : unclosed) {
                Coord c2;
                Coord c1 = w.getPoints().get(0);
                if (!this.bbox.insideBoundary(c1)) {
                    log.debug("Point", c1, "of way", w.getId(), "outside bbox");
                    outOfBboxPoints.put(c1, w);
                }
                if (this.bbox.insideBoundary(c2 = w.getPoints().get(w.getPoints().size() - 1))) continue;
                log.debug("Point", c2, "of way", w.getId(), "outside bbox");
                outOfBboxPoints.put(c2, w);
            }
            if (outOfBboxPoints.size() < 2) {
                log.debug(outOfBboxPoints.size(), "point outside the bbox. No connection possible.");
                return false;
            }
            ArrayList<ConnectionData> coordPairs = new ArrayList<ConnectionData>();
            ArrayList coords = new ArrayList(outOfBboxPoints.keySet());
            for (int i = 0; i < coords.size(); ++i) {
                for (int j = i + 1; j < coords.size(); ++j) {
                    ConnectionData cd = new ConnectionData();
                    cd.c1 = (Coord)coords.get(i);
                    cd.c2 = (Coord)coords.get(j);
                    cd.w1 = (JoinedWay)outOfBboxPoints.get(cd.c1);
                    cd.w2 = (JoinedWay)outOfBboxPoints.get(cd.c2);
                    if (this.lineCutsBbox(cd.c1, cd.c2)) {
                        Coord edgePoint1 = new Coord(cd.c1.getLatitude(), cd.c2.getLongitude());
                        Coord edgePoint2 = new Coord(cd.c2.getLatitude(), cd.c1.getLongitude());
                        if (!this.lineCutsBbox(cd.c1, edgePoint1) && !this.lineCutsBbox(edgePoint1, cd.c2)) {
                            cd.imC = edgePoint1;
                        } else {
                            if (this.lineCutsBbox(cd.c1, edgePoint2) || this.lineCutsBbox(edgePoint2, cd.c2)) continue;
                            cd.imC = edgePoint1;
                        }
                        cd.distance = cd.c1.distance(cd.imC) + cd.imC.distance(cd.c2);
                    } else {
                        cd.distance = cd.c1.distance(cd.c2);
                    }
                    coordPairs.add(cd);
                }
            }
            if (coordPairs.isEmpty()) {
                log.debug((Object)"All potential connections cross the bbox. No connection possible.");
                return false;
            }
            ConnectionData minCon = Collections.min(coordPairs, new Comparator<ConnectionData>(){

                @Override
                public int compare(ConnectionData o1, ConnectionData o2) {
                    return Double.compare(o1.distance, o2.distance);
                }
            });
            if (minCon.w1 == minCon.w2) {
                log.debug("Close a gap in way", minCon.w1);
                if (minCon.imC != null) {
                    minCon.w1.getPoints().add(minCon.imC);
                }
                minCon.w1.closeWayArtificially();
            } else {
                log.debug("Connect", minCon.w1, "with", minCon.w2);
                if (minCon.w1.getPoints().get(0) == minCon.c1) {
                    Collections.reverse(minCon.w1.getPoints());
                }
                if (minCon.w2.getPoints().get(0) != minCon.c2) {
                    Collections.reverse(minCon.w2.getPoints());
                }
                minCon.w1.getPoints().addAll(minCon.w2.getPoints());
                minCon.w1.addWay(minCon.w2);
                allWays.remove(minCon.w2);
                return true;
            }
        }
        return false;
    }

    protected void removeUnclosedWays(ArrayList<JoinedWay> wayList) {
        Iterator<JoinedWay> it = wayList.iterator();
        boolean firstWarn = true;
        while (it.hasNext()) {
            String role;
            JoinedWay tempWay = it.next();
            if (tempWay.hasIdenticalEndPoints()) continue;
            boolean inBbox = tempWay.intersects(this.bbox);
            if (inBbox) {
                if (firstWarn) {
                    log.warn("Cannot join the following ways to closed polygons. Multipolygon", this.toBrowseURL(), this.toTagString());
                    firstWarn = false;
                }
                this.logWayURLs(Level.WARNING, "- way:", tempWay);
                this.logFakeWayDetails(Level.WARNING, tempWay);
            }
            it.remove();
            if (!inBbox || (role = this.getRole(tempWay)) != null && !"".equals(role) && !"outer".equals(role)) continue;
            this.outerWaysForLineTagging.addAll(tempWay.getOriginalWays());
        }
    }

    protected void removeWaysOutsideBbox(ArrayList<JoinedWay> wayList) {
        ListIterator<JoinedWay> wayIter = wayList.listIterator();
        while (wayIter.hasNext()) {
            JoinedWay w = wayIter.next();
            boolean remove = true;
            for (Coord c : w.getPoints()) {
                if (!this.bbox.contains(c)) continue;
                remove = false;
                break;
            }
            if (remove && w.getBounds().contains(this.bboxArea.getBounds())) {
                remove = false;
            }
            if (!remove) continue;
            if (log.isDebugEnabled()) {
                log.debug("Remove way", w.getId(), "because it is completely outside the bounding box.");
            }
            wayIter.remove();
        }
    }

    private BitSet findOutmostPolygons(BitSet candidates, BitSet roleFilter) {
        BitSet realCandidates = (BitSet)candidates.clone();
        realCandidates.and(roleFilter);
        return this.findOutmostPolygons(realCandidates);
    }

    protected BitSet findOutmostPolygons(BitSet candidates) {
        BitSet outmostPolygons = new BitSet();
        int candidateIndex = candidates.nextSetBit(0);
        while (candidateIndex >= 0) {
            boolean isOutmost = true;
            int otherCandidateIndex = candidates.nextSetBit(0);
            while (otherCandidateIndex >= 0) {
                if (this.contains(otherCandidateIndex, candidateIndex)) {
                    isOutmost = false;
                    break;
                }
                otherCandidateIndex = candidates.nextSetBit(otherCandidateIndex + 1);
            }
            if (isOutmost) {
                outmostPolygons.set(candidateIndex);
            }
            candidateIndex = candidates.nextSetBit(candidateIndex + 1);
        }
        return outmostPolygons;
    }

    protected ArrayList<PolygonStatus> getPolygonStatus(BitSet outmostPolygons, String defaultRole) {
        ArrayList<PolygonStatus> polygonStatusList = new ArrayList<PolygonStatus>();
        int polyIndex = outmostPolygons.nextSetBit(0);
        while (polyIndex >= 0) {
            JoinedWay polygon = this.polygons.get(polyIndex);
            String role = this.getRole(polygon);
            if (role == null || "".equals(role)) {
                role = defaultRole;
            }
            polygonStatusList.add(new PolygonStatus("outer".equals(role), polyIndex, polygon));
            polyIndex = outmostPolygons.nextSetBit(polyIndex + 1);
        }
        if (polygonStatusList.size() > 2) {
            Collections.sort(polygonStatusList, new Comparator<PolygonStatus>(){

                @Override
                public int compare(PolygonStatus o1, PolygonStatus o2) {
                    if (o1.outer != o2.outer) {
                        return o1.outer ? -1 : 1;
                    }
                    return o1.polygon.getPoints().size() - o2.polygon.getPoints().size();
                }
            });
        }
        return polygonStatusList;
    }

    protected List<Way> getSourceWays() {
        ArrayList<Way> allWays = new ArrayList<Way>();
        for (Map.Entry<String, Element> r_e : this.getElements()) {
            if (r_e.getValue() instanceof Way) {
                if (((Way)r_e.getValue()).getPoints().isEmpty()) {
                    log.warn("Way", r_e.getValue(), "has no points and cannot be used for the multipolygon", this.toBrowseURL());
                    continue;
                }
                allWays.add((Way)r_e.getValue());
                continue;
            }
            if (r_e.getValue() instanceof Node && ("admin_centre".equals(r_e.getKey()) || "label".equals(r_e.getKey()))) continue;
            log.warn("Non way member in role", r_e.getKey(), r_e.getValue().toBrowseURL(), "in multipolygon", this.toBrowseURL(), this.toTagString());
        }
        return allWays;
    }

    @Override
    public void processElements() {
        BitSet outmostPolygons;
        boolean outmostInnerFound;
        log.info("Processing multipolygon", this.toBrowseURL());
        List<Way> allWays = this.getSourceWays();
        if (!this.isMpProcessable(allWays)) {
            log.info("Do not process multipolygon", this.getId(), "because it has no style relevant tags.");
            return;
        }
        this.bboxArea = Java2DConverter.createBoundsArea(this.getBbox());
        this.polygons = this.joinWays(allWays);
        this.outerWaysForLineTagging = new HashSet<Way>();
        this.outerTags = new HashMap<String, String>();
        this.closeWays(this.polygons);
        while (this.connectUnclosedWays(this.polygons)) {
            this.closeWays(this.polygons);
        }
        this.removeUnclosedWays(this.polygons);
        if (this.polygons.isEmpty()) {
            log.info((Object)("Multipolygon " + this.toBrowseURL() + " does not contain a closed polygon."));
            this.tagOuterWays();
            this.cleanup();
            return;
        }
        this.removeWaysOutsideBbox(this.polygons);
        if (this.polygons.isEmpty()) {
            log.info("Multipolygon", this.toBrowseURL(), "is completely outside the bounding box. It is not processed.");
            this.tagOuterWays();
            this.cleanup();
            return;
        }
        this.intersectingPolygons = new HashSet<JoinedWay>();
        this.createContainsMatrix(this.polygons);
        this.unfinishedPolygons = new BitSet(this.polygons.size());
        this.unfinishedPolygons.set(0, this.polygons.size());
        this.innerPolygons = new BitSet();
        this.taggedInnerPolygons = new BitSet();
        this.outerPolygons = new BitSet();
        this.taggedOuterPolygons = new BitSet();
        int wi = 0;
        for (Way way : this.polygons) {
            String role = this.getRole(way);
            if ("inner".equals(role)) {
                this.innerPolygons.set(wi);
                this.taggedInnerPolygons.set(wi);
            } else if ("outer".equals(role)) {
                this.outerPolygons.set(wi);
                this.taggedOuterPolygons.set(wi);
            } else {
                this.innerPolygons.set(wi);
                this.outerPolygons.set(wi);
            }
            ++wi;
        }
        if (this.outerPolygons.isEmpty()) {
            log.warn("Multipolygon", this.toBrowseURL(), "does not contain any way tagged with role=outer or empty role.");
            this.cleanup();
            return;
        }
        LinkedBlockingQueue<PolygonStatus> polygonWorkingQueue = new LinkedBlockingQueue<PolygonStatus>();
        BitSet bitSet = new BitSet();
        BitSet nestedInnerPolygons = new BitSet();
        BitSet outmostInnerPolygons = new BitSet();
        do {
            outmostInnerFound = false;
            outmostPolygons = this.findOutmostPolygons(this.unfinishedPolygons);
            if (!outmostPolygons.intersects(this.taggedInnerPolygons)) continue;
            outmostInnerPolygons.or(outmostPolygons);
            outmostInnerPolygons.and(this.taggedInnerPolygons);
            if (log.isDebugEnabled()) {
                log.debug((Object)("wrong inner polygons: " + outmostInnerPolygons));
            }
            this.unfinishedPolygons.andNot(outmostInnerPolygons);
            outmostPolygons.andNot(outmostInnerPolygons);
            outmostInnerFound = true;
        } while (outmostInnerFound);
        if (!outmostPolygons.isEmpty()) {
            polygonWorkingQueue.addAll(this.getPolygonStatus(outmostPolygons, "outer"));
        }
        boolean outmostPolygonProcessing = true;
        while (!polygonWorkingQueue.isEmpty()) {
            List<Way> singularOuterPolygons;
            boolean processPolygon;
            double outerAreaSize;
            BitSet holeIndexes;
            boolean holesOk;
            PolygonStatus currentPolygon = (PolygonStatus)polygonWorkingQueue.poll();
            this.unfinishedPolygons.clear(currentPolygon.index);
            BitSet bitSet2 = new BitSet();
            bitSet2.or(this.containsMatrix.get(currentPolygon.index));
            bitSet2.and(this.unfinishedPolygons);
            do {
                holeIndexes = this.findOutmostPolygons(bitSet2);
                holesOk = true;
                if (currentPolygon.outer) {
                    if (!holeIndexes.intersects(this.taggedOuterPolygons)) continue;
                    BitSet addOuterNestedPolygons = new BitSet();
                    addOuterNestedPolygons.or(holeIndexes);
                    addOuterNestedPolygons.and(this.taggedOuterPolygons);
                    bitSet.or(addOuterNestedPolygons);
                    holeIndexes.andNot(addOuterNestedPolygons);
                    this.unfinishedPolygons.andNot(addOuterNestedPolygons);
                    bitSet2.andNot(addOuterNestedPolygons);
                    holesOk = false;
                    continue;
                }
                if (!holeIndexes.intersects(this.taggedInnerPolygons)) continue;
                BitSet addInnerNestedPolygons = new BitSet();
                addInnerNestedPolygons.or(holeIndexes);
                addInnerNestedPolygons.and(this.taggedInnerPolygons);
                nestedInnerPolygons.or(addInnerNestedPolygons);
            } while (!holesOk);
            ArrayList<PolygonStatus> holes = this.getPolygonStatus(holeIndexes, currentPolygon.outer ? "inner" : "outer");
            polygonWorkingQueue.addAll(holes);
            if (currentPolygon.outer) {
                this.outerWaysForLineTagging.addAll(currentPolygon.polygon.getOriginalWays());
            }
            if ((outerAreaSize = currentPolygon.polygon.getSizeOfArea()) > this.largestSize) {
                for (PolygonStatus hole : holes) {
                    outerAreaSize -= hole.polygon.getSizeOfArea();
                }
                if (outerAreaSize > this.largestSize) {
                    this.largestOuterPolygon = currentPolygon.polygon;
                    this.largestSize = outerAreaSize;
                }
            }
            if (!(processPolygon = currentPolygon.outer || !holes.isEmpty())) continue;
            if (holes.isEmpty()) {
                singularOuterPolygons = Collections.singletonList(new JoinedWay(currentPolygon.polygon));
            } else {
                ArrayList<Way> innerWays = new ArrayList<Way>(holes.size());
                for (PolygonStatus polygonStatus : holes) {
                    innerWays.add(polygonStatus.polygon);
                }
                singularOuterPolygons = this.cutOutInnerPolygons(currentPolygon.polygon, innerWays);
            }
            if (singularOuterPolygons.isEmpty()) continue;
            if (currentPolygon.outer && this.hasStyleRelevantTags(this)) {
                for (Way p : singularOuterPolygons) {
                    p.copyTags(this);
                    p.deleteTag("type");
                }
                this.removeTagsInOrgWays(this, currentPolygon.polygon);
            } else {
                currentPolygon.polygon.mergeTagsFromOrgWays();
                for (Way p : singularOuterPolygons) {
                    p.copyTags(currentPolygon.polygon);
                }
                this.removeTagsInOrgWays((Element)currentPolygon.polygon, currentPolygon.polygon);
            }
            if (currentPolygon.outer && outmostPolygonProcessing) {
                Way outerWay = singularOuterPolygons.get(0);
                for (Map.Entry entry : outerWay.getTagEntryIterator()) {
                    this.outerTags.put((String)entry.getKey(), (String)entry.getValue());
                }
                outmostPolygonProcessing = false;
            }
            for (Way mpWay : singularOuterPolygons) {
                if (log.isDebugEnabled()) {
                    log.debug(mpWay.getId(), mpWay.toTagString());
                }
                mpWay.addTag(STYLE_FILTER_TAG, STYLE_FILTER_POLYGON);
                mpWay.addTag(MP_CREATED_TAG, "true");
                if (currentPolygon.outer) {
                    mpWay.addTag("mkgmap:mp_role", "outer");
                    if (this.isAreaSizeCalculated()) {
                        this.mpAreaSize += MultiPolygonRelation.calcAreaSize(mpWay.getPoints());
                    }
                } else {
                    mpWay.addTag("mkgmap:mp_role", "inner");
                }
                this.getMpPolygons().put(mpWay.getId(), mpWay);
            }
        }
        if (log.isLoggable(Level.WARNING) && outmostInnerPolygons.cardinality() + this.unfinishedPolygons.cardinality() + bitSet.cardinality() + nestedInnerPolygons.cardinality() >= 1) {
            log.warn("Multipolygon", this.toBrowseURL(), this.toTagString(), "contains errors.");
            BitSet outerUnusedPolys = new BitSet();
            outerUnusedPolys.or(this.unfinishedPolygons);
            outerUnusedPolys.or(outmostInnerPolygons);
            outerUnusedPolys.or(bitSet);
            outerUnusedPolys.or(nestedInnerPolygons);
            outerUnusedPolys.or(this.unfinishedPolygons);
            outerUnusedPolys.and(this.outerPolygons);
            for (JoinedWay w : this.getWaysFromPolygonList(outerUnusedPolys)) {
                this.outerWaysForLineTagging.addAll(w.getOriginalWays());
            }
            this.runIntersectionCheck(this.unfinishedPolygons);
            this.runOutmostInnerPolygonCheck(outmostInnerPolygons);
            this.runNestedOuterPolygonCheck(bitSet);
            this.runNestedInnerPolygonCheck(nestedInnerPolygons);
            this.runWrongInnerPolygonCheck(this.unfinishedPolygons, this.innerPolygons);
            List<JoinedWay> list = this.getWaysFromPolygonList(this.unfinishedPolygons);
            for (JoinedWay w : list) {
                log.warn("Polygon", w, "is not processed due to an unknown reason.");
                this.logWayURLs(Level.WARNING, "-", w);
            }
        }
        if (!this.hasStyleRelevantTags(this)) {
            for (Map.Entry entry : this.outerTags.entrySet()) {
                this.addTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Way way : this.outerWaysForLineTagging) {
            Way lineTagWay = new Way(this.getOriginalId(), way.getPoints());
            lineTagWay.setFakeId();
            lineTagWay.addTag(STYLE_FILTER_TAG, STYLE_FILTER_LINE);
            lineTagWay.addTag(MP_CREATED_TAG, "true");
            for (Map.Entry<String, String> tag : this.outerTags.entrySet()) {
                lineTagWay.addTag(tag.getKey(), tag.getValue());
                if (!tag.getValue().equals(way.getTag(tag.getKey()))) continue;
                this.removeTagsInOrgWays(way, tag.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("Add line way", lineTagWay.getId(), lineTagWay.toTagString());
            }
            this.tileWayMap.put(lineTagWay.getId(), lineTagWay);
        }
        this.postProcessing();
        this.cleanup();
    }

    protected void postProcessing() {
        if (this.isAreaSizeCalculated()) {
            String mpAreaSizeStr = new DecimalFormat("0.0####################", DecimalFormatSymbols.getInstance(Locale.US)).format(this.mpAreaSize);
            for (Way w : this.mpPolygons.values()) {
                if (!"outer".equals(w.getTag("mkgmap:mp_role"))) continue;
                w.addTag("mkgmap:cache_area_size", mpAreaSizeStr);
            }
        }
        for (Way way : this.mpPolygons.values()) {
            way.deleteTag("mkgmap:mp_role");
        }
        this.tileWayMap.putAll(this.mpPolygons);
        if (this.largestOuterPolygon != null) {
            for (Map.Entry entry : this.getElements()) {
                if (!(entry.getValue() instanceof Node) || !"label".equals(entry.getKey())) continue;
                this.cOfG = ((Node)entry.getValue()).getLocation();
                break;
            }
            if (this.cOfG == null) {
                this.cOfG = this.largestOuterPolygon.getCofG();
            }
        }
    }

    private void runIntersectionCheck(BitSet unfinishedPolys) {
        if (this.intersectingPolygons.isEmpty()) {
            return;
        }
        log.warn((Object)"Some polygons are intersecting. This is not allowed in multipolygons.");
        boolean oneOufOfBbox = false;
        for (JoinedWay polygon : this.intersectingPolygons) {
            int pi = this.polygons.indexOf(polygon);
            unfinishedPolys.clear(pi);
            boolean outOfBbox = false;
            for (Coord c : polygon.getPoints()) {
                if (this.bbox.contains(c)) continue;
                outOfBbox = true;
                oneOufOfBbox = true;
                break;
            }
            this.logWayURLs(Level.WARNING, outOfBbox ? "*" : "-", polygon);
        }
        for (JoinedWay polygon : this.intersectingPolygons) {
            this.logFakeWayDetails(Level.WARNING, polygon);
        }
        if (oneOufOfBbox) {
            log.warn((Object)"Some of these intersections/overlaps may be caused by incomplete data on bounding box edges (*).");
        }
    }

    private void runNestedOuterPolygonCheck(BitSet nestedOuterPolygons) {
        int wiIndex = nestedOuterPolygons.nextSetBit(0);
        while (wiIndex >= 0) {
            JoinedWay outerWay = this.polygons.get(wiIndex);
            log.warn("Polygon", outerWay, "carries role outer but lies inside an outer polygon. Potentially its role should be inner.");
            this.logFakeWayDetails(Level.WARNING, outerWay);
            wiIndex = nestedOuterPolygons.nextSetBit(wiIndex + 1);
        }
    }

    private void runNestedInnerPolygonCheck(BitSet nestedInnerPolygons) {
        int wiIndex = nestedInnerPolygons.nextSetBit(0);
        while (wiIndex >= 0) {
            JoinedWay innerWay = this.polygons.get(wiIndex);
            log.warn("Polygon", innerWay, "carries role", this.getRole(innerWay), "but lies inside an inner polygon. Potentially its role should be outer.");
            this.logFakeWayDetails(Level.WARNING, innerWay);
            wiIndex = nestedInnerPolygons.nextSetBit(wiIndex + 1);
        }
    }

    private void runOutmostInnerPolygonCheck(BitSet outmostInnerPolygons) {
        int wiIndex = outmostInnerPolygons.nextSetBit(0);
        while (wiIndex >= 0) {
            JoinedWay innerWay = this.polygons.get(wiIndex);
            log.warn("Polygon", innerWay, "carries role", this.getRole(innerWay), "but is not inside any other polygon. Potentially it does not belong to this multipolygon.");
            this.logFakeWayDetails(Level.WARNING, innerWay);
            wiIndex = outmostInnerPolygons.nextSetBit(wiIndex + 1);
        }
    }

    private void runWrongInnerPolygonCheck(BitSet unfinishedPolygons, BitSet innerPolygons) {
        BitSet wrongInnerPolygons = this.findOutmostPolygons(unfinishedPolygons, innerPolygons);
        if (log.isDebugEnabled()) {
            log.debug("unfinished", unfinishedPolygons);
            log.debug("inner", innerPolygons);
            log.debug("wrong", wrongInnerPolygons);
        }
        if (!wrongInnerPolygons.isEmpty()) {
            int wiIndex = wrongInnerPolygons.nextSetBit(0);
            while (wiIndex >= 0) {
                BitSet containedPolygons = new BitSet();
                containedPolygons.or(unfinishedPolygons);
                containedPolygons.and(this.containsMatrix.get(wiIndex));
                JoinedWay innerWay = this.polygons.get(wiIndex);
                if (containedPolygons.isEmpty()) {
                    log.warn("Polygon", innerWay, "carries role", this.getRole(innerWay), "but is not inside any outer polygon. Potentially it does not belong to this multipolygon.");
                    this.logFakeWayDetails(Level.WARNING, innerWay);
                } else {
                    log.warn("Polygon", innerWay, "carries role", this.getRole(innerWay), "but is not inside any outer polygon. Potentially the roles are interchanged with the following", containedPolygons.cardinality() > 1 ? "ways" : "way", ".");
                    int wrIndex = containedPolygons.nextSetBit(0);
                    while (wrIndex >= 0) {
                        this.logWayURLs(Level.WARNING, "-", this.polygons.get(wrIndex));
                        unfinishedPolygons.set(wrIndex);
                        wrongInnerPolygons.set(wrIndex);
                        wrIndex = containedPolygons.nextSetBit(wrIndex + 1);
                    }
                    this.logFakeWayDetails(Level.WARNING, innerWay);
                }
                unfinishedPolygons.clear(wiIndex);
                wrongInnerPolygons.clear(wiIndex);
                wiIndex = wrongInnerPolygons.nextSetBit(wiIndex + 1);
            }
        }
    }

    protected void cleanup() {
        this.mpPolygons = null;
        this.roleMap.clear();
        this.containsMatrix = null;
        this.polygons = null;
        this.bboxArea = null;
        this.intersectingPolygons = null;
        this.outerWaysForLineTagging = null;
        this.outerTags = null;
        this.unfinishedPolygons = null;
        this.innerPolygons = null;
        this.taggedInnerPolygons = null;
        this.outerPolygons = null;
        this.taggedOuterPolygons = null;
        this.largestOuterPolygon = null;
    }

    private CutPoint calcNextCutPoint(AreaCutData areaData) {
        if (areaData.innerAreas == null || areaData.innerAreas.isEmpty()) {
            return null;
        }
        Rectangle2D outerBounds = areaData.outerArea.getBounds2D();
        if (areaData.innerAreas.size() == 1) {
            CutPoint cutPoint1 = new CutPoint(CoordinateAxis.LATITUDE, outerBounds);
            cutPoint1.addArea(areaData.innerAreas.get(0));
            CutPoint cutPoint2 = new CutPoint(CoordinateAxis.LONGITUDE, outerBounds);
            cutPoint2.addArea(areaData.innerAreas.get(0));
            if (cutPoint1.compareTo(cutPoint2) > 0) {
                return cutPoint1;
            }
            return cutPoint2;
        }
        ArrayList<java.awt.geom.Area> innerStart = new ArrayList<java.awt.geom.Area>(areaData.innerAreas);
        for (CoordinateAxis axis : CoordinateAxis.values()) {
            CutPoint edgeCutPoint = new CutPoint(axis, outerBounds);
            Collections.sort(innerStart, axis == CoordinateAxis.LONGITUDE ? COMP_LONG_START : COMP_LAT_START);
            for (java.awt.geom.Area anInnerStart : innerStart) {
                if (axis.getStart30(anInnerStart) > axis.getStart30(outerBounds)) break;
                edgeCutPoint.addArea(anInnerStart);
            }
            if (edgeCutPoint.getNumberOfAreas() > 0) {
                return edgeCutPoint;
            }
            Collections.sort(innerStart, axis == CoordinateAxis.LONGITUDE ? COMP_LONG_STOP : COMP_LAT_STOP);
            for (java.awt.geom.Area anInnerStart : innerStart) {
                if (axis.getStop30(anInnerStart) < axis.getStop30(outerBounds)) break;
                edgeCutPoint.addArea(anInnerStart);
            }
            if (edgeCutPoint.getNumberOfAreas() <= 0) continue;
            return edgeCutPoint;
        }
        ArrayList<CutPoint> bestCutPoints = new ArrayList<CutPoint>(CoordinateAxis.values().length);
        for (CoordinateAxis axis : CoordinateAxis.values()) {
            CutPoint bestCutPoint = new CutPoint(axis, outerBounds);
            CutPoint currentCutPoint = new CutPoint(axis, outerBounds);
            Collections.sort(innerStart, axis == CoordinateAxis.LONGITUDE ? COMP_LONG_START : COMP_LAT_START);
            for (java.awt.geom.Area anInnerStart : innerStart) {
                currentCutPoint.addArea(anInnerStart);
                if (currentCutPoint.compareTo(bestCutPoint) <= 0) continue;
                bestCutPoint = currentCutPoint.duplicate();
            }
            bestCutPoints.add(bestCutPoint);
        }
        return (CutPoint)Collections.max(bestCutPoints);
    }

    private List<Way> cutOutInnerPolygons(Way outerPolygon, List<Way> innerPolygons) {
        if (innerPolygons.isEmpty()) {
            JoinedWay outerWay = new JoinedWay(outerPolygon);
            if (log.isDebugEnabled()) {
                log.debug("Way", outerPolygon.getId(), "splitted to way", outerWay.getId());
            }
            return Collections.singletonList(outerWay);
        }
        LinkedList<AreaCutData> areasToCut = new LinkedList<AreaCutData>();
        ArrayList<java.awt.geom.Area> finishedAreas = new ArrayList<java.awt.geom.Area>(innerPolygons.size());
        List<java.awt.geom.Area> outerAreas = this.createAreas(outerPolygon, true);
        ArrayList<java.awt.geom.Area> innerAreas = new ArrayList<java.awt.geom.Area>(innerPolygons.size() + 2);
        for (Way innerPolygon : innerPolygons) {
            innerAreas.addAll(this.createAreas(innerPolygon, false));
        }
        if (innerAreas.isEmpty()) {
            finishedAreas.addAll(outerAreas);
        } else if (outerAreas.size() == 1) {
            AreaCutData initialCutData = new AreaCutData();
            initialCutData.outerArea = outerAreas.get(0);
            initialCutData.innerAreas = innerAreas;
            areasToCut.add(initialCutData);
        } else {
            for (java.awt.geom.Area outerArea : outerAreas) {
                AreaCutData initialCutData = new AreaCutData();
                initialCutData.outerArea = outerArea;
                initialCutData.innerAreas = new ArrayList<java.awt.geom.Area>(innerAreas.size());
                for (java.awt.geom.Area innerArea : innerAreas) {
                    if (!outerArea.getBounds2D().intersects(innerArea.getBounds2D())) continue;
                    initialCutData.innerAreas.add(innerArea);
                }
                if (initialCutData.innerAreas.isEmpty()) {
                    finishedAreas.add(outerArea);
                    continue;
                }
                areasToCut.add(initialCutData);
            }
        }
        while (!areasToCut.isEmpty()) {
            AreaCutData areaCutData = (AreaCutData)areasToCut.poll();
            CutPoint cutPoint = this.calcNextCutPoint(areaCutData);
            if (cutPoint == null) {
                finishedAreas.add(areaCutData.outerArea);
                continue;
            }
            assert (cutPoint.getNumberOfAreas() > 0) : "Number of cut areas == 0 in mp " + this.getId();
            if (cutPoint.getAreas().size() == 1) {
                areaCutData.outerArea.subtract(cutPoint.getAreas().get(0));
            } else {
                Path2D.Double path = new Path2D.Double();
                for (java.awt.geom.Area cutArea : cutPoint.getAreas()) {
                    path.append(cutArea, false);
                }
                java.awt.geom.Area combinedCutAreas = new java.awt.geom.Area(path);
                areaCutData.outerArea.subtract(combinedCutAreas);
            }
            if (areaCutData.outerArea.isEmpty()) continue;
            block5: for (java.awt.geom.Area cutArea : cutPoint.getAreas()) {
                ListIterator<java.awt.geom.Area> areaIter = areaCutData.innerAreas.listIterator();
                while (areaIter.hasNext()) {
                    java.awt.geom.Area a = areaIter.next();
                    if (a != cutArea) continue;
                    areaIter.remove();
                    continue block5;
                }
            }
            if (areaCutData.outerArea.isSingular()) {
                if (areaCutData.innerAreas.isEmpty()) {
                    finishedAreas.add(areaCutData.outerArea);
                    continue;
                }
                areasToCut.add(areaCutData);
                continue;
            }
            Rectangle2D r1 = cutPoint.getCutRectangleForArea(areaCutData.outerArea, true);
            Rectangle2D r2 = cutPoint.getCutRectangleForArea(areaCutData.outerArea, false);
            java.awt.geom.Area a1 = new java.awt.geom.Area(r1);
            java.awt.geom.Area a2 = new java.awt.geom.Area(r2);
            a1.intersect(areaCutData.outerArea);
            a2.intersect(areaCutData.outerArea);
            if (areaCutData.innerAreas.isEmpty()) {
                finishedAreas.addAll(Java2DConverter.areaToSingularAreas(a1));
                finishedAreas.addAll(Java2DConverter.areaToSingularAreas(a2));
                continue;
            }
            ArrayList<java.awt.geom.Area> cuttedAreas = new ArrayList<java.awt.geom.Area>();
            cuttedAreas.addAll(Java2DConverter.areaToSingularAreas(a1));
            cuttedAreas.addAll(Java2DConverter.areaToSingularAreas(a2));
            for (java.awt.geom.Area nextOuterArea : cuttedAreas) {
                ArrayList<java.awt.geom.Area> nextInnerAreas = null;
                for (java.awt.geom.Area nonProcessedInner : areaCutData.innerAreas) {
                    if (!nextOuterArea.intersects(nonProcessedInner.getBounds2D())) continue;
                    if (nextInnerAreas == null) {
                        nextInnerAreas = new ArrayList<java.awt.geom.Area>();
                    }
                    nextInnerAreas.add(nonProcessedInner);
                }
                if (nextInnerAreas == null || nextInnerAreas.isEmpty()) {
                    finishedAreas.add(nextOuterArea);
                    continue;
                }
                AreaCutData outCutData = new AreaCutData();
                outCutData.outerArea = nextOuterArea;
                outCutData.innerAreas = nextInnerAreas;
                areasToCut.add(outCutData);
            }
        }
        ArrayList<Way> cuttedOuterPolygon = new ArrayList<Way>(finishedAreas.size());
        Long2ObjectOpenHashMap commonCoordMap = new Long2ObjectOpenHashMap();
        for (java.awt.geom.Area area : finishedAreas) {
            Way w = this.singularAreaToWay(area, this.getOriginalId());
            if (w == null) continue;
            w.setFakeId();
            int n = w.getPoints().size();
            for (int i = 0; i < n; ++i) {
                Coord p = w.getPoints().get(i);
                long key = Utils.coord2Long(p);
                Coord replacement = (Coord)commonCoordMap.get(key);
                if (replacement == null) {
                    commonCoordMap.put(key, (Object)p);
                    continue;
                }
                assert (p.highPrecEquals(replacement));
                w.getPoints().set(i, replacement);
            }
            w.copyTags(outerPolygon);
            cuttedOuterPolygon.add(w);
            if (!log.isDebugEnabled()) continue;
            log.debug("Way", outerPolygon.getId(), "splitted to way", w.getId());
        }
        return cuttedOuterPolygon;
    }

    private List<java.awt.geom.Area> createAreas(Way w, boolean clipBbox) {
        java.awt.geom.Area area = Java2DConverter.createArea(w.getPoints());
        if (clipBbox && !this.bboxArea.contains(area.getBounds2D())) {
            area.intersect(this.bboxArea);
        }
        List<java.awt.geom.Area> areaList = Java2DConverter.areaToSingularAreas(area);
        if (log.isDebugEnabled()) {
            log.debug("Bbox clipped way", w.getId() + "=>", areaList.size(), "distinct area(s).");
        }
        return areaList;
    }

    private Way singularAreaToWay(java.awt.geom.Area area, long wayId) {
        List<Coord> points = Java2DConverter.singularAreaToPoints(area);
        if (points == null || points.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Empty area", wayId + ".", this.toBrowseURL());
            }
            return null;
        }
        return new Way(wayId, points);
    }

    protected boolean hasStyleRelevantTags(Element element) {
        if (element instanceof MultiPolygonRelation && element.tagIsLikeYes("mkgmap:tagsincomplete")) {
            return true;
        }
        for (Map.Entry<String, String> tagEntry : element.getTagEntryIterator()) {
            String tagName = tagEntry.getKey();
            boolean isStyleRelevant = !(element instanceof Relation && tagName.equals("type")) && !tagName.startsWith("mkgmap:");
            if (!isStyleRelevant) continue;
            return true;
        }
        return false;
    }

    private boolean isMpProcessable(Collection<Way> ways) {
        if (this.hasStyleRelevantTags(this)) {
            return true;
        }
        for (Way w : ways) {
            if (!this.hasStyleRelevantTags(w)) continue;
            return true;
        }
        return false;
    }

    protected void createContainsMatrix(List<JoinedWay> polygonList) {
        this.containsMatrix = new ArrayList();
        for (int i = 0; i < polygonList.size(); ++i) {
            this.containsMatrix.add(new BitSet());
        }
        long t1 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("createContainsMatrix listSize:", polygonList.size());
        }
        ArrayList<BitSet> finishedMatrix = new ArrayList<BitSet>(polygonList.size());
        for (int i = 0; i < polygonList.size(); ++i) {
            BitSet matrixRow = new BitSet();
            matrixRow.set(i);
            finishedMatrix.add(matrixRow);
        }
        for (int rowIndex = 0; rowIndex < polygonList.size(); ++rowIndex) {
            JoinedWay potentialOuterPolygon = polygonList.get(rowIndex);
            BitSet containsColumns = this.containsMatrix.get(rowIndex);
            BitSet finishedCol = (BitSet)finishedMatrix.get(rowIndex);
            WayAndLazyPolygon lazyPotOuterPolygon = new WayAndLazyPolygon(potentialOuterPolygon);
            int colIndex = finishedCol.nextClearBit(0);
            while (colIndex >= 0 && colIndex < polygonList.size()) {
                JoinedWay innerPolygon = polygonList.get(colIndex);
                if (potentialOuterPolygon.getBounds().intersects(innerPolygon.getBounds())) {
                    boolean contains = this.contains(lazyPotOuterPolygon, innerPolygon);
                    if (contains) {
                        containsColumns.set(colIndex);
                        ((BitSet)finishedMatrix.get(colIndex)).set(rowIndex);
                        containsColumns.or(this.containsMatrix.get(colIndex));
                        finishedCol.or(containsColumns);
                    }
                } else {
                    ((BitSet)finishedMatrix.get(colIndex)).set(rowIndex);
                    ((BitSet)finishedMatrix.get(rowIndex)).set(colIndex);
                }
                finishedCol.set(colIndex);
                colIndex = finishedCol.nextClearBit(colIndex + 1);
            }
        }
        if (log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            log.debug("createMatrix for", polygonList.size(), "polygons took", t2 - t1, "ms");
            log.debug((Object)"Containsmatrix:");
            int i = 0;
            boolean noContained = true;
            for (BitSet b : this.containsMatrix) {
                if (!b.isEmpty()) {
                    log.debug(i, "contains", b);
                    noContained = false;
                }
                ++i;
            }
            if (noContained) {
                log.debug((Object)"Matrix is empty");
            }
        }
    }

    private boolean contains(int polygonIndex1, int polygonIndex2) {
        return this.containsMatrix.get(polygonIndex1).get(polygonIndex2);
    }

    private boolean contains(WayAndLazyPolygon polygon1, JoinedWay polygon2) {
        if (!polygon1.getWay().hasIdenticalEndPoints()) {
            return false;
        }
        if (!polygon1.getWay().getBounds().contains(polygon2.getBounds())) {
            return false;
        }
        boolean onePointContained = false;
        boolean allOnLine = true;
        for (Coord px : polygon2.getPoints()) {
            if (polygon1.getPolygon().contains(px.getHighPrecLon(), px.getHighPrecLat())) {
                onePointContained = true;
                if (this.locatedOnLine(px, polygon1.getWay().getPoints())) continue;
                allOnLine = false;
                break;
            }
            if (!this.bbox.contains(px) || this.locatedOnLine(px, polygon1.getWay().getPoints())) continue;
            return false;
        }
        if (allOnLine) {
            onePointContained = false;
            ArrayList<Coord> middlePoints2 = new ArrayList<Coord>(polygon2.getPoints().size());
            Coord p1 = null;
            for (Coord p2 : polygon2.getPoints()) {
                if (p1 != null) {
                    Coord pm = p1.makeBetweenPoint(p2, 0.5);
                    middlePoints2.add(pm);
                }
                p1 = p2;
            }
            for (Coord px : middlePoints2) {
                if (polygon1.getPolygon().contains(px.getHighPrecLon(), px.getHighPrecLat())) {
                    onePointContained = true;
                    break;
                }
                if (!this.bbox.contains(px) || this.locatedOnLine(px, polygon1.getWay().getPoints())) continue;
                return false;
            }
        }
        if (!onePointContained) {
            return false;
        }
        Iterator<Coord> it1 = polygon1.getWay().getPoints().iterator();
        Coord p1_1 = it1.next();
        while (it1.hasNext()) {
            int lonField;
            Coord p1_2 = p1_1;
            p1_1 = it1.next();
            if (!polygon2.linePossiblyIntersectsWay(p1_1, p1_2)) continue;
            int lonMin = Math.min(p1_1.getLongitude(), p1_2.getLongitude());
            int lonMax = Math.max(p1_1.getLongitude(), p1_2.getLongitude());
            int latMin = Math.min(p1_1.getLatitude(), p1_2.getLatitude());
            int latMax = Math.max(p1_1.getLatitude(), p1_2.getLatitude());
            Iterator<Coord> it2 = polygon2.getPoints().iterator();
            Coord p2_1 = it2.next();
            int n = p2_1.getLongitude() < lonMin ? -1 : (lonField = p2_1.getLongitude() > lonMax ? 1 : 0);
            int latField = p2_1.getLatitude() < latMin ? -1 : (p2_1.getLatitude() > latMax ? 1 : 0);
            int prevLonField = lonField;
            int prevLatField = latField;
            while (it2.hasNext()) {
                boolean intersects;
                Coord p2_2 = p2_1;
                p2_1 = it2.next();
                int changes = 0;
                if (lonField >= 0 && p1_1.getLongitude() < lonMin || lonField <= 0 && p1_1.getLongitude() > lonMax) {
                    ++changes;
                    int n2 = p1_1.getLongitude() < lonMin ? -1 : (lonField = p1_1.getLongitude() > lonMax ? 1 : 0);
                }
                if (latField >= 0 && p1_1.getLatitude() < latMin || latField <= 0 && p1_1.getLatitude() > latMax) {
                    ++changes;
                    latField = p1_1.getLatitude() < latMin ? -1 : (p1_1.getLatitude() > latMax ? 1 : 0);
                }
                boolean intersectionPossible = changes == 2 || latField == 0 && lonField == 0 || prevLatField == 0 && prevLonField == 0;
                boolean bl = intersects = intersectionPossible && this.linesCutEachOther(p1_1, p1_2, p2_1, p2_2);
                if (intersects) {
                    if (polygon1.getWay().isClosedArtificially() && !it1.hasNext() || polygon2.isClosedArtificially() && !it2.hasNext()) {
                        log.info("Polygon", polygon1, "may contain polygon", polygon2, ". Ignoring artificial generated intersection.");
                    } else if (!(this.bbox.contains(p1_1) && this.bbox.contains(p1_2) && this.bbox.contains(p2_1) && this.bbox.contains(p2_2))) {
                        log.info("Polygon", polygon1, "may contain polygon", polygon2, ". Ignoring because at least one point is outside the bounding box.");
                    } else {
                        this.intersectingPolygons.add(polygon1.getWay());
                        this.intersectingPolygons.add(polygon2);
                        return false;
                    }
                }
                prevLonField = lonField;
                prevLatField = latField;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean locatedOnLine(Coord p, List<Coord> points) {
        Coord cp1 = null;
        for (Coord cp2 : points) {
            if (p.highPrecEquals(cp2)) {
                return true;
            }
            try {
                double dist;
                if (cp1 == null || p.getHighPrecLon() < Math.min(cp1.getHighPrecLon(), cp2.getHighPrecLon()) || p.getHighPrecLon() > Math.max(cp1.getHighPrecLon(), cp2.getHighPrecLon()) || p.getHighPrecLat() < Math.min(cp1.getHighPrecLat(), cp2.getHighPrecLat()) || p.getHighPrecLat() > Math.max(cp1.getHighPrecLat(), cp2.getHighPrecLat()) || !((dist = Line2D.ptSegDistSq(cp1.getHighPrecLon(), cp1.getHighPrecLat(), cp2.getHighPrecLon(), cp2.getHighPrecLat(), p.getHighPrecLon(), p.getHighPrecLat())) <= 2.0)) continue;
                log.debug("Point", p, "is located on line between", cp1, "and", cp2, ". Distance:", dist);
                boolean bl = true;
                return bl;
            }
            finally {
                cp1 = cp2;
            }
        }
        return false;
    }

    private boolean lineCutsBbox(Coord p1_1, Coord p1_2) {
        Coord nw = new Coord(this.bbox.getMaxLat(), this.bbox.getMinLong());
        Coord sw = new Coord(this.bbox.getMinLat(), this.bbox.getMinLong());
        Coord se = new Coord(this.bbox.getMinLat(), this.bbox.getMaxLong());
        Coord ne = new Coord(this.bbox.getMaxLat(), this.bbox.getMaxLong());
        return this.linesCutEachOther(nw, sw, p1_1, p1_2) || this.linesCutEachOther(sw, se, p1_1, p1_2) || this.linesCutEachOther(se, ne, p1_1, p1_2) || this.linesCutEachOther(ne, nw, p1_1, p1_2);
    }

    private boolean linesCutEachOther(Coord p1_1, Coord p1_2, Coord p2_1, Coord p2_2) {
        int width1 = p1_2.getLongitude() - p1_1.getLongitude();
        int width2 = p2_2.getLongitude() - p2_1.getLongitude();
        int height1 = p1_2.getLatitude() - p1_1.getLatitude();
        int height2 = p2_2.getLatitude() - p2_1.getLatitude();
        int denominator = height2 * width1 - width2 * height1;
        if (denominator == 0) {
            return false;
        }
        int x1Mx3 = p1_1.getLongitude() - p2_1.getLongitude();
        int y1My3 = p1_1.getLatitude() - p2_1.getLatitude();
        double isx = (double)(width2 * y1My3 - height2 * x1Mx3) / (double)denominator;
        if (isx < 0.0 || isx > 1.0) {
            return false;
        }
        double isy = (double)(width1 * y1My3 - height1 * x1Mx3) / (double)denominator;
        return !(isy < 0.0) && !(isy > 1.0);
    }

    private List<JoinedWay> getWaysFromPolygonList(BitSet selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JoinedWay> wayList = new ArrayList<JoinedWay>(selection.cardinality());
        int i = selection.nextSetBit(0);
        while (i >= 0) {
            wayList.add(this.polygons.get(i));
            i = selection.nextSetBit(i + 1);
        }
        return wayList;
    }

    private void logWayURLs(Level level, String preMsg, Way way) {
        if (log.isLoggable(level)) {
            if (way instanceof JoinedWay) {
                if (((JoinedWay)way).getOriginalWays().isEmpty()) {
                    log.warn("Way", way, "does not contain any original ways");
                }
                for (Way segment : ((JoinedWay)way).getOriginalWays()) {
                    if (preMsg == null || preMsg.length() == 0) {
                        log.log(level, (Object)segment.toBrowseURL());
                        continue;
                    }
                    log.log(level, preMsg, segment.toBrowseURL());
                }
            } else if (preMsg == null || preMsg.length() == 0) {
                log.log(level, (Object)way.toBrowseURL());
            } else {
                log.log(level, preMsg, way.toBrowseURL());
            }
        }
    }

    private void logFakeWayDetails(Level logLevel, JoinedWay fakeWay) {
        if (!log.isLoggable(logLevel)) {
            return;
        }
        if (!FakeIdGenerator.isFakeId(this.getId())) {
            return;
        }
        boolean containsOrgFakeWay = false;
        for (Way orgWay : fakeWay.getOriginalWays()) {
            if (!FakeIdGenerator.isFakeId(orgWay.getId())) continue;
            containsOrgFakeWay = true;
        }
        if (!containsOrgFakeWay) {
            return;
        }
        for (Way orgWay : fakeWay.getOriginalWays()) {
            log.log(logLevel, " Way", orgWay.getId(), "is composed of other artificial ways. Details:");
            log.log(logLevel, "  Start:", orgWay.getPoints().get(0).toOSMURL());
            if (orgWay.hasEqualEndPoints()) {
                int mid = orgWay.getPoints().size() / 2;
                log.log(logLevel, "  Mid:  ", orgWay.getPoints().get(mid).toOSMURL());
                continue;
            }
            log.log(logLevel, "  End:  ", orgWay.getPoints().get(orgWay.getPoints().size() - 1).toOSMURL());
        }
    }

    protected void tagOuterWays() {
        Map<Object, Object> tags;
        if (this.hasStyleRelevantTags(this)) {
            tags = new HashMap();
            for (Map.Entry entry : this.getTagEntryIterator()) {
                tags.put(entry.getKey(), entry.getValue());
            }
        } else {
            tags = JoinedWay.getMergedTags(this.outerWaysForLineTagging);
        }
        for (Way way : this.outerWaysForLineTagging) {
            Way lineTagWay = new Way(this.getOriginalId(), way.getPoints());
            lineTagWay.setFakeId();
            lineTagWay.addTag(STYLE_FILTER_TAG, STYLE_FILTER_LINE);
            lineTagWay.addTag(MP_CREATED_TAG, "true");
            for (Map.Entry<Object, Object> tag : tags.entrySet()) {
                lineTagWay.addTag((String)tag.getKey(), (String)tag.getValue());
                if (!((String)tag.getValue()).equals(way.getTag((String)tag.getKey()))) continue;
                this.removeTagsInOrgWays(way, (String)tag.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("Add line way", lineTagWay.getId(), lineTagWay.toTagString());
            }
            this.tileWayMap.put(lineTagWay.getId(), lineTagWay);
        }
    }

    private void removeTagsInOrgWays(Element tagElement, JoinedWay way) {
        for (Map.Entry<String, String> tag : tagElement.getTagEntryIterator()) {
            this.removeTagInOrgWays(way, tag.getKey(), tag.getValue());
        }
    }

    private void removeTagInOrgWays(JoinedWay way, String tagname, String tagvalue) {
        for (Way w : way.getOriginalWays()) {
            if (w instanceof JoinedWay) {
                this.removeTagInOrgWays((JoinedWay)w, tagname, tagvalue);
                continue;
            }
            boolean remove = false;
            if (tagname == null) {
                remove = true;
            } else if (tagvalue == null) {
                remove = w.getTag(tagname) != null;
            } else if (tagvalue.equals(w.getTag(tagname))) {
                remove = true;
            }
            if (!remove) continue;
            if (tagname == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Will remove all tags from", w.getId(), w.toTagString());
                }
                this.removeTagsInOrgWays(w, tagname);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Will remove", tagname + "=" + w.getTag(tagname), "from way", w.getId(), w.toTagString());
            }
            this.removeTagsInOrgWays(w, tagname);
        }
    }

    protected void removeTagsInOrgWays(Way way, String tag) {
        if (tag == null) {
            way.addTag("mkgmap:removetags", "mkgmap:ALL");
            return;
        }
        if (tag.isEmpty()) {
            return;
        }
        String removedTagsTag = way.getTag("mkgmap:removetags");
        if ("mkgmap:ALL".equals(removedTagsTag)) {
            return;
        }
        if (removedTagsTag == null) {
            way.addTag("mkgmap:removetags", tag);
        } else if (!removedTagsTag.equals(tag)) {
            way.addTag("mkgmap:removetags", removedTagsTag + ";" + tag);
        }
    }

    protected boolean isAreaSizeCalculated() {
        return true;
    }

    protected Map<Long, Way> getTileWayMap() {
        return this.tileWayMap;
    }

    protected Map<Long, Way> getMpPolygons() {
        return this.mpPolygons;
    }

    protected Area getBbox() {
        return this.bbox;
    }

    public static double calcAreaSize(List<Coord> polygon) {
        if (polygon.size() < 4 || polygon.get(0) != polygon.get(polygon.size() - 1)) {
            return 0.0;
        }
        long area = 0L;
        Iterator<Coord> polyIter = polygon.iterator();
        Coord c2 = polyIter.next();
        while (polyIter.hasNext()) {
            Coord c1 = c2;
            c2 = polyIter.next();
            area += (long)(c2.getHighPrecLon() + c1.getHighPrecLon()) * (long)(c1.getHighPrecLat() - c2.getHighPrecLat());
        }
        double areaSize = (double)area / 8192.0;
        return Math.abs(areaSize);
    }

    private static class AreaComparator
    implements Comparator<java.awt.geom.Area> {
        private final CoordinateAxis axis;
        private final boolean startPoint;

        public AreaComparator(boolean startPoint, CoordinateAxis axis) {
            this.startPoint = startPoint;
            this.axis = axis;
        }

        @Override
        public int compare(java.awt.geom.Area o1, java.awt.geom.Area o2) {
            if (o1 == o2) {
                return 0;
            }
            if (this.startPoint) {
                int cmp = this.axis.getStart30(o1) - this.axis.getStart30(o2);
                if (cmp == 0) {
                    return this.axis.getStop30(o1) - this.axis.getStop30(o2);
                }
                return cmp;
            }
            int cmp = this.axis.getStop30(o1) - this.axis.getStop30(o2);
            if (cmp == 0) {
                return this.axis.getStart30(o1) - this.axis.getStart30(o2);
            }
            return cmp;
        }
    }

    private static enum CoordinateAxis {
        LATITUDE(false),
        LONGITUDE(true);

        private final boolean useX;

        private CoordinateAxis(boolean useX) {
            this.useX = useX;
        }

        public int getStart30(java.awt.geom.Area area) {
            return this.getStart30(area.getBounds2D());
        }

        public int getStart30(Rectangle2D rect) {
            double val = this.useX ? rect.getX() : rect.getY();
            return (int)Math.round(val * 64.0);
        }

        public int getStop30(java.awt.geom.Area area) {
            return this.getStop30(area.getBounds2D());
        }

        public int getStop30(Rectangle2D rect) {
            double val = this.useX ? rect.getMaxX() : rect.getMaxY();
            return (int)Math.round(val * 64.0);
        }

        public double getSizeOfSide(Rectangle2D rect) {
            if (this.useX) {
                int lat30 = (int)Math.round(rect.getY() * 64.0);
                Coord c1 = Coord.makeHighPrecCoord(lat30, this.getStart30(rect));
                Coord c2 = Coord.makeHighPrecCoord(lat30, this.getStop30(rect));
                return c1.distance(c2);
            }
            int lon30 = (int)Math.round(rect.getX() * 64.0);
            Coord c1 = Coord.makeHighPrecCoord(this.getStart30(rect), lon30);
            Coord c2 = Coord.makeHighPrecCoord(this.getStop30(rect), lon30);
            return c1.distance(c2);
        }
    }

    private static class CutPoint
    implements Comparable<CutPoint> {
        private int startPoint30 = Integer.MAX_VALUE;
        private int stopPoint30 = Integer.MIN_VALUE;
        private Integer cutPoint30 = null;
        private final LinkedList<java.awt.geom.Area> areas;
        private final Comparator<java.awt.geom.Area> comparator;
        private final CoordinateAxis axis;
        private Rectangle2D bounds;
        private final Rectangle2D outerBounds;
        private Double minAspectRatio;

        public CutPoint(CoordinateAxis axis, Rectangle2D outerBounds) {
            this.axis = axis;
            this.outerBounds = outerBounds;
            this.areas = new LinkedList();
            this.comparator = axis == CoordinateAxis.LONGITUDE ? COMP_LONG_STOP : COMP_LAT_STOP;
        }

        public CutPoint duplicate() {
            CutPoint newCutPoint = new CutPoint(this.axis, this.outerBounds);
            newCutPoint.areas.addAll(this.areas);
            newCutPoint.startPoint30 = this.startPoint30;
            newCutPoint.stopPoint30 = this.stopPoint30;
            return newCutPoint;
        }

        private boolean isGoodCutPoint() {
            return this.getCutPoint30() % 131072 == 0;
        }

        private boolean isBadCutPoint() {
            int d2;
            int d1 = this.getCutPoint30() - this.startPoint30;
            return Math.min(d1, d2 = this.stopPoint30 - this.getCutPoint30()) < 16384;
        }

        private boolean isStartCut() {
            return this.startPoint30 <= this.axis.getStart30(this.outerBounds);
        }

        private boolean isStopCut() {
            return this.stopPoint30 >= this.axis.getStop30(this.outerBounds);
        }

        private int getCutPoint30() {
            int cut2;
            int cut1;
            int cutMod;
            if (this.cutPoint30 != null) {
                return this.cutPoint30;
            }
            if (this.startPoint30 == this.stopPoint30) {
                this.cutPoint30 = this.startPoint30;
                return this.cutPoint30;
            }
            if (this.isStartCut()) {
                this.cutPoint30 = this.startPoint30;
                return this.cutPoint30;
            }
            if (this.isStopCut()) {
                this.cutPoint30 = this.startPoint30;
                return this.cutPoint30;
            }
            int midOuter30 = this.axis.getStart30(this.outerBounds) + (this.axis.getStop30(this.outerBounds) - this.axis.getStart30(this.outerBounds)) / 2;
            this.cutPoint30 = midOuter30;
            if (midOuter30 < this.startPoint30) {
                this.cutPoint30 = this.startPoint30;
                if ((this.cutPoint30 & 0xFFFE0000) + 131072 <= this.stopPoint30) {
                    this.cutPoint30 = (this.cutPoint30 & 0xFFFE0000) + 131072;
                }
            } else if (midOuter30 > this.stopPoint30) {
                this.cutPoint30 = this.stopPoint30;
                if ((this.cutPoint30 & 0xFFFE0000) >= this.startPoint30) {
                    this.cutPoint30 = this.cutPoint30 & 0xFFFE0000;
                }
            }
            if ((cutMod = this.cutPoint30 % 131072) == 0) {
                return this.cutPoint30;
            }
            int n = cut1 = cutMod > 0 ? this.cutPoint30 - cutMod : this.cutPoint30 - 131072 - cutMod;
            if (cut1 >= this.startPoint30 && cut1 <= this.stopPoint30) {
                this.cutPoint30 = cut1;
                return this.cutPoint30;
            }
            int n2 = cut2 = cutMod > 0 ? this.cutPoint30 + 131072 - cutMod : this.cutPoint30 - cutMod;
            if (cut2 >= this.startPoint30 && cut2 <= this.stopPoint30) {
                this.cutPoint30 = cut2;
                return this.cutPoint30;
            }
            return this.cutPoint30;
        }

        public Rectangle2D getCutRectangleForArea(java.awt.geom.Area toCut, boolean firstRect) {
            return this.getCutRectangleForArea(toCut.getBounds2D(), firstRect);
        }

        public Rectangle2D getCutRectangleForArea(Rectangle2D areaRect, boolean firstRect) {
            double cp = (double)this.getCutPoint30() / 64.0;
            if (this.axis == CoordinateAxis.LONGITUDE) {
                double newWidth = cp - areaRect.getX();
                if (firstRect) {
                    return new Rectangle2D.Double(areaRect.getX(), areaRect.getY(), newWidth, areaRect.getHeight());
                }
                return new Rectangle2D.Double(areaRect.getX() + newWidth, areaRect.getY(), areaRect.getWidth() - newWidth, areaRect.getHeight());
            }
            double newHeight = cp - areaRect.getY();
            if (firstRect) {
                return new Rectangle2D.Double(areaRect.getX(), areaRect.getY(), areaRect.getWidth(), newHeight);
            }
            return new Rectangle2D.Double(areaRect.getX(), areaRect.getY() + newHeight, areaRect.getWidth(), areaRect.getHeight() - newHeight);
        }

        public List<java.awt.geom.Area> getAreas() {
            return this.areas;
        }

        public void addArea(java.awt.geom.Area area) {
            while (!this.areas.isEmpty() && this.axis.getStop30(this.areas.getFirst()) < this.axis.getStart30(area)) {
                this.areas.removeFirst();
            }
            this.areas.add(area);
            Collections.sort(this.areas, this.comparator);
            this.startPoint30 = this.axis.getStart30(Collections.max(this.areas, this.axis == CoordinateAxis.LONGITUDE ? COMP_LONG_START : COMP_LAT_START));
            this.stopPoint30 = this.axis.getStop30(this.areas.getFirst());
            this.bounds = null;
            this.cutPoint30 = null;
            this.minAspectRatio = null;
        }

        public int getNumberOfAreas() {
            return this.areas.size();
        }

        public double getMinAspectRatio() {
            if (this.minAspectRatio == null) {
                Rectangle2D r1 = this.getCutRectangleForArea(this.outerBounds, true);
                double s1_1 = CoordinateAxis.LATITUDE.getSizeOfSide(r1);
                double s1_2 = CoordinateAxis.LONGITUDE.getSizeOfSide(r1);
                double ar1 = Math.min(s1_1, s1_2) / Math.max(s1_1, s1_2);
                Rectangle2D r2 = this.getCutRectangleForArea(this.outerBounds, false);
                double s2_1 = CoordinateAxis.LATITUDE.getSizeOfSide(r2);
                double s2_2 = CoordinateAxis.LONGITUDE.getSizeOfSide(r2);
                double ar2 = Math.min(s2_1, s2_2) / Math.max(s2_1, s2_2);
                this.minAspectRatio = Math.min(ar1, ar2);
            }
            return this.minAspectRatio;
        }

        @Override
        public int compareTo(CutPoint o) {
            double ss2;
            if (this == o) {
                return 0;
            }
            if (this.isStartCut() && !o.isStartCut()) {
                return 1;
            }
            if (!this.isStartCut() && o.isStartCut()) {
                return -1;
            }
            if (this.isStopCut() && !o.isStopCut()) {
                return 1;
            }
            if (!this.isStopCut() && o.isStopCut()) {
                return -1;
            }
            if (this.getNumberOfAreas() == 0) {
                if (o.getNumberOfAreas() == 0) {
                    return 0;
                }
                return -1;
            }
            if (o.getNumberOfAreas() == 0) {
                return 1;
            }
            if (this.isBadCutPoint() != o.isBadCutPoint()) {
                if (this.isBadCutPoint()) {
                    return -1;
                }
                return 1;
            }
            double dAR = this.getMinAspectRatio() - o.getMinAspectRatio();
            if (dAR != 0.0) {
                return dAR > 0.0 ? 1 : -1;
            }
            if (this.isGoodCutPoint() != o.isGoodCutPoint()) {
                if (this.isGoodCutPoint()) {
                    return 1;
                }
                return -1;
            }
            double ss1 = this.axis.getSizeOfSide(this.getBounds2D());
            if (ss1 - (ss2 = o.axis.getSizeOfSide(o.getBounds2D())) != 0.0) {
                return Double.compare(ss1, ss2);
            }
            int ndiff = this.getNumberOfAreas() - o.getNumberOfAreas();
            return ndiff;
        }

        private Rectangle2D getBounds2D() {
            if (this.bounds == null) {
                this.bounds = new Rectangle2D.Double();
                for (java.awt.geom.Area a : this.areas) {
                    this.bounds.add(a.getBounds2D());
                }
            }
            return this.bounds;
        }

        public String toString() {
            return (Object)((Object)this.axis) + " " + this.getNumberOfAreas() + " " + this.startPoint30 + " " + this.stopPoint30 + " " + this.getCutPoint30();
        }
    }

    private static class AreaCutData {
        java.awt.geom.Area outerArea;
        List<java.awt.geom.Area> innerAreas;

        private AreaCutData() {
        }
    }

    public static class PolygonStatus {
        public final boolean outer;
        public final int index;
        public final JoinedWay polygon;

        public PolygonStatus(boolean outer, int index, JoinedWay polygon) {
            this.outer = outer;
            this.index = index;
            this.polygon = polygon;
        }

        public String toString() {
            return this.polygon + "_" + this.outer;
        }
    }

    public static final class JoinedWay
    extends Way {
        private final List<Way> originalWays;
        private boolean closedArtificially;
        private int minLat;
        private int maxLat;
        private int minLon;
        private int maxLon;
        private Rectangle bounds;

        public JoinedWay(Way originalWay) {
            super(originalWay.getOriginalId(), originalWay.getPoints());
            this.setFakeId();
            this.originalWays = new ArrayList<Way>();
            this.addWay(originalWay);
            Coord c0 = originalWay.getPoints().get(0);
            this.minLat = this.maxLat = c0.getLatitude();
            this.minLon = this.maxLon = c0.getLongitude();
            this.updateBounds(originalWay.getPoints());
        }

        public void addPoint(int index, Coord point) {
            this.getPoints().add(index, point);
            this.updateBounds(point);
        }

        @Override
        public void addPoint(Coord point) {
            super.addPoint(point);
            this.updateBounds(point);
        }

        private void updateBounds(List<Coord> pointList) {
            for (Coord c : pointList) {
                this.updateBounds(c.getLatitude(), c.getLongitude());
            }
        }

        private void updateBounds(JoinedWay other) {
            this.updateBounds(other.minLat, other.minLon);
            this.updateBounds(other.maxLat, other.maxLon);
        }

        private void updateBounds(int lat, int lon) {
            if (lat < this.minLat) {
                this.minLat = lat;
                this.bounds = null;
            } else if (lat > this.maxLat) {
                this.maxLat = lat;
                this.bounds = null;
            }
            if (lon < this.minLon) {
                this.minLon = lon;
                this.bounds = null;
            } else if (lon > this.maxLon) {
                this.maxLon = lon;
                this.bounds = null;
            }
        }

        private void updateBounds(Coord point) {
            this.updateBounds(point.getLatitude(), point.getLongitude());
        }

        public boolean intersects(Area bbox) {
            return this.maxLat >= bbox.getMinLat() && this.minLat <= bbox.getMaxLat() && this.maxLon >= bbox.getMinLong() && this.minLon <= bbox.getMaxLong();
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = new Rectangle(this.minLon - 1, this.minLat - 1, this.maxLon - this.minLon + 2, this.maxLat - this.minLat + 2);
            }
            return this.bounds;
        }

        public boolean linePossiblyIntersectsWay(Coord p1, Coord p2) {
            return this.getBounds().intersectsLine(p1.getLongitude(), p1.getLatitude(), p2.getLongitude(), p2.getLatitude());
        }

        public void addWay(Way way) {
            if (way instanceof JoinedWay) {
                for (Way w : ((JoinedWay)way).getOriginalWays()) {
                    this.addWay(w);
                }
                this.updateBounds((JoinedWay)way);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Joined", this.getId(), "with", way.getId());
                }
                this.originalWays.add(way);
            }
        }

        public void closeWayArtificially() {
            this.addPoint(this.getPoints().get(0));
            this.closedArtificially = true;
        }

        public boolean isClosedArtificially() {
            return this.closedArtificially;
        }

        public static Map<String, String> getMergedTags(Collection<Way> ways) {
            HashMap<String, String> mergedTags = new HashMap<String, String>();
            boolean first = true;
            for (Way way : ways) {
                if (first) {
                    for (Map.Entry<String, String> tag : way.getTagEntryIterator()) {
                        mergedTags.put(tag.getKey(), tag.getValue());
                    }
                    first = false;
                    continue;
                }
                ArrayList tagsToRemove = null;
                for (Map.Entry entry : mergedTags.entrySet()) {
                    String wayTagValue = way.getTag((String)entry.getKey());
                    if (((String)entry.getValue()).equals(wayTagValue) || wayTagValue == null) continue;
                    if (tagsToRemove == null) {
                        tagsToRemove = new ArrayList();
                    }
                    tagsToRemove.add(entry.getKey());
                }
                if (tagsToRemove == null) continue;
                for (String string : tagsToRemove) {
                    mergedTags.remove(string);
                }
            }
            return mergedTags;
        }

        public void mergeTagsFromOrgWays() {
            if (log.isDebugEnabled()) {
                log.debug("Way", this.getId(), "merge tags from", this.getOriginalWays().size(), "ways");
            }
            this.removeAllTags();
            Map<String, String> mergedTags = JoinedWay.getMergedTags(this.getOriginalWays());
            for (Map.Entry<String, String> tag : mergedTags.entrySet()) {
                this.addTag(tag.getKey(), tag.getValue());
            }
        }

        public List<Way> getOriginalWays() {
            return this.originalWays;
        }

        public double getSizeOfArea() {
            return MultiPolygonRelation.calcAreaSize(this.getPoints());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append(this.getId());
            sb.append("(");
            sb.append(this.getPoints().size());
            sb.append("P)(");
            boolean first = true;
            for (Way w : this.getOriginalWays()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(w.getId());
                sb.append("[");
                sb.append(w.getPoints().size());
                sb.append("P]");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private static class WayAndLazyPolygon {
        private final JoinedWay way;
        private Polygon polygon;

        public WayAndLazyPolygon(JoinedWay way) {
            this.way = way;
        }

        public final JoinedWay getWay() {
            return this.way;
        }

        public final Polygon getPolygon() {
            if (this.polygon == null) {
                this.polygon = Java2DConverter.createHighPrecPolygon(this.way.getPoints());
            }
            return this.polygon;
        }
    }

    protected static class ConnectionData {
        public Coord c1;
        public Coord c2;
        public JoinedWay w1;
        public JoinedWay w2;
        public Coord imC;
        public double distance;
    }
}

