/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.util.Java2DConverter;

public class BoundaryRelation
extends MultiPolygonRelation {
    private static final Logger log = Logger.getLogger(BoundaryRelation.class);
    private java.awt.geom.Area outerResultArea;
    private Boundary boundary;

    public BoundaryRelation(Relation other, Map<Long, Way> wayMap, Area bbox) {
        super(other, wayMap, bbox);
    }

    public Boundary getBoundary() {
        if (this.boundary == null) {
            if (this.outerResultArea == null) {
                return null;
            }
            this.boundary = new Boundary(this.outerResultArea, this.getTagEntryIterator(), "r" + this.getId());
            this.outerResultArea = null;
        }
        return this.boundary;
    }

    @Override
    public void processElements() {
        BitSet outmostPolygons;
        boolean outmostInnerFound;
        log.info("Processing multipolygon", this.toBrowseURL());
        List<Way> allWays = this.getSourceWays();
        this.bboxArea = Java2DConverter.createBoundsArea(this.getBbox());
        this.polygons = this.joinWays(allWays);
        this.outerWaysForLineTagging = new HashSet();
        this.outerTags = new HashMap();
        this.removeOutOfBbox(this.polygons);
        boolean changed = true;
        while (changed) {
            changed = false;
            while (this.connectUnclosedWays(this.polygons)) {
                changed = true;
            }
            this.closeWays(this.polygons);
        }
        this.removeUnclosedWays(this.polygons);
        if (this.polygons.isEmpty()) {
            log.info((Object)("Multipolygon " + this.toBrowseURL() + " does not contain a closed polygon."));
            this.tagOuterWays();
            this.cleanup();
            return;
        }
        this.removeWaysOutsideBbox(this.polygons);
        if (this.polygons.isEmpty()) {
            log.info((Object)("Multipolygon " + this.toBrowseURL() + " is completely outside the bounding box. It is not processed."));
            this.tagOuterWays();
            this.cleanup();
            return;
        }
        this.intersectingPolygons = new HashSet();
        this.createContainsMatrix(this.polygons);
        this.unfinishedPolygons = new BitSet(this.polygons.size());
        this.unfinishedPolygons.set(0, this.polygons.size());
        this.innerPolygons = new BitSet();
        this.taggedInnerPolygons = new BitSet();
        this.outerPolygons = new BitSet();
        this.taggedOuterPolygons = new BitSet();
        int wi = 0;
        for (Way w : this.polygons) {
            String role = this.getRole(w);
            if ("inner".equals(role)) {
                this.innerPolygons.set(wi);
                this.taggedInnerPolygons.set(wi);
            } else if ("outer".equals(role)) {
                this.outerPolygons.set(wi);
                this.taggedOuterPolygons.set(wi);
            } else {
                this.innerPolygons.set(wi);
                this.outerPolygons.set(wi);
            }
            ++wi;
        }
        if (this.outerPolygons.isEmpty()) {
            log.warn("Multipolygon", this.toBrowseURL(), "does not contain any way tagged with role=outer or empty role.");
            this.cleanup();
            return;
        }
        LinkedBlockingQueue<MultiPolygonRelation.PolygonStatus> polygonWorkingQueue = new LinkedBlockingQueue<MultiPolygonRelation.PolygonStatus>();
        BitSet nestedOuterPolygons = new BitSet();
        BitSet nestedInnerPolygons = new BitSet();
        BitSet outmostInnerPolygons = new BitSet();
        do {
            outmostInnerFound = false;
            outmostPolygons = this.findOutmostPolygons(this.unfinishedPolygons);
            if (!outmostPolygons.intersects(this.taggedInnerPolygons)) continue;
            outmostInnerPolygons.or(outmostPolygons);
            outmostInnerPolygons.and(this.taggedInnerPolygons);
            if (log.isDebugEnabled()) {
                log.debug((Object)("wrong inner polygons: " + outmostInnerPolygons));
            }
            this.unfinishedPolygons.andNot(outmostInnerPolygons);
            outmostPolygons.andNot(outmostInnerPolygons);
            outmostInnerFound = true;
        } while (outmostInnerFound);
        if (!outmostPolygons.isEmpty()) {
            polygonWorkingQueue.addAll(this.getPolygonStatus(outmostPolygons, "outer"));
        }
        boolean outmostPolygonProcessing = true;
        this.outerResultArea = new java.awt.geom.Area();
        while (!polygonWorkingQueue.isEmpty()) {
            BitSet holeIndexes;
            boolean holesOk;
            MultiPolygonRelation.PolygonStatus currentPolygon = (MultiPolygonRelation.PolygonStatus)polygonWorkingQueue.poll();
            this.unfinishedPolygons.clear(currentPolygon.index);
            BitSet bitSet = new BitSet();
            bitSet.or((BitSet)this.containsMatrix.get(currentPolygon.index));
            bitSet.and(this.unfinishedPolygons);
            do {
                holeIndexes = this.findOutmostPolygons(bitSet);
                holesOk = true;
                if (currentPolygon.outer) {
                    if (!holeIndexes.intersects(this.taggedOuterPolygons)) continue;
                    BitSet addOuterNestedPolygons = new BitSet();
                    addOuterNestedPolygons.or(holeIndexes);
                    addOuterNestedPolygons.and(this.taggedOuterPolygons);
                    nestedOuterPolygons.or(addOuterNestedPolygons);
                    holeIndexes.andNot(addOuterNestedPolygons);
                    this.unfinishedPolygons.andNot(addOuterNestedPolygons);
                    bitSet.andNot(addOuterNestedPolygons);
                    holesOk = false;
                    continue;
                }
                if (!holeIndexes.intersects(this.taggedInnerPolygons)) continue;
                BitSet addInnerNestedPolygons = new BitSet();
                addInnerNestedPolygons.or(holeIndexes);
                addInnerNestedPolygons.and(this.taggedInnerPolygons);
                nestedInnerPolygons.or(addInnerNestedPolygons);
            } while (!holesOk);
            ArrayList<MultiPolygonRelation.PolygonStatus> holes = this.getPolygonStatus(holeIndexes, currentPolygon.outer ? "inner" : "outer");
            polygonWorkingQueue.addAll(holes);
            if (currentPolygon.outer) {
                this.outerWaysForLineTagging.addAll(currentPolygon.polygon.getOriginalWays());
            }
            if (currentPolygon.outer) {
                java.awt.geom.Area toAdd = Java2DConverter.createArea(currentPolygon.polygon.getPoints());
                if (this.outerResultArea.isEmpty()) {
                    this.outerResultArea = toAdd;
                } else {
                    this.outerResultArea.add(toAdd);
                }
                for (Way outerWay : currentPolygon.polygon.getOriginalWays()) {
                    if (outmostPolygonProcessing) {
                        for (Map.Entry<String, String> entry : outerWay.getTagEntryIterator()) {
                            this.outerTags.put(entry.getKey(), entry.getValue());
                        }
                        outmostPolygonProcessing = false;
                        continue;
                    }
                    for (String string : new ArrayList(this.outerTags.keySet())) {
                        if (((String)this.outerTags.get(string)).equals(outerWay.getTag(string))) continue;
                        this.outerTags.remove(string);
                    }
                }
                continue;
            }
            this.outerResultArea.subtract(Java2DConverter.createArea(currentPolygon.polygon.getPoints()));
        }
        if (this.hasStyleRelevantTags(this)) {
            this.outerTags.clear();
            for (Map.Entry<Object, Object> entry : this.getTagEntryIterator()) {
                if ("type".equals(entry.getKey())) continue;
                this.outerTags.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<Object, Object> entry : this.outerTags.entrySet()) {
                this.addTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Way way : this.outerWaysForLineTagging) {
            for (Map.Entry tag : this.outerTags.entrySet()) {
                if (!((String)tag.getValue()).equals(way.getTag((String)tag.getKey()))) continue;
                this.removeTagsInOrgWays(way, (String)tag.getKey());
            }
        }
        this.postProcessing();
        this.cleanup();
    }

    @Override
    protected boolean connectUnclosedWays(List<MultiPolygonRelation.JoinedWay> allWays) {
        ArrayList<MultiPolygonRelation.JoinedWay> unclosed = new ArrayList<MultiPolygonRelation.JoinedWay>();
        for (MultiPolygonRelation.JoinedWay w : allWays) {
            if (w.hasIdenticalEndPoints()) continue;
            unclosed.add(w);
        }
        if (unclosed.size() >= 2) {
            log.debug("Checking", unclosed.size(), "unclosed ways for connections outside the bbox");
            IdentityHashMap<Coord, MultiPolygonRelation.JoinedWay> outOfBboxPoints = new IdentityHashMap<Coord, MultiPolygonRelation.JoinedWay>();
            for (MultiPolygonRelation.JoinedWay w : unclosed) {
                Coord c1 = w.getPoints().get(0);
                outOfBboxPoints.put(c1, w);
                Coord c2 = w.getPoints().get(w.getPoints().size() - 1);
                outOfBboxPoints.put(c2, w);
            }
            if (outOfBboxPoints.size() < 2) {
                log.debug(outOfBboxPoints.size(), "point outside the bbox. No connection possible.");
                return false;
            }
            ArrayList<MultiPolygonRelation.ConnectionData> coordPairs = new ArrayList<MultiPolygonRelation.ConnectionData>();
            ArrayList coords = new ArrayList(outOfBboxPoints.keySet());
            for (int i = 0; i < coords.size(); ++i) {
                for (int j = i + 1; j < coords.size(); ++j) {
                    MultiPolygonRelation.ConnectionData cd = new MultiPolygonRelation.ConnectionData();
                    cd.c1 = (Coord)coords.get(i);
                    cd.c2 = (Coord)coords.get(j);
                    cd.w1 = (MultiPolygonRelation.JoinedWay)outOfBboxPoints.get(cd.c1);
                    cd.w2 = (MultiPolygonRelation.JoinedWay)outOfBboxPoints.get(cd.c2);
                    cd.distance = cd.c1.distance(cd.c2);
                    coordPairs.add(cd);
                }
            }
            if (coordPairs.isEmpty()) {
                log.debug((Object)"All potential connections cross the bbox. No connection possible.");
                return false;
            }
            MultiPolygonRelation.ConnectionData minCon = Collections.min(coordPairs, new Comparator<MultiPolygonRelation.ConnectionData>(){

                @Override
                public int compare(MultiPolygonRelation.ConnectionData o1, MultiPolygonRelation.ConnectionData o2) {
                    return Double.compare(o1.distance, o2.distance);
                }
            });
            if (minCon.distance < this.getMaxCloseDist()) {
                if (minCon.w1 == minCon.w2) {
                    log.debug("Close a gap in way", minCon.w1);
                    if (minCon.imC != null) {
                        minCon.w1.getPoints().add(minCon.imC);
                    }
                    minCon.w1.closeWayArtificially();
                } else {
                    log.debug("Connect", minCon.w1, "with", minCon.w2);
                    if (minCon.w1.getPoints().get(0) == minCon.c1) {
                        Collections.reverse(minCon.w1.getPoints());
                    }
                    if (minCon.w2.getPoints().get(0) != minCon.c2) {
                        Collections.reverse(minCon.w2.getPoints());
                    }
                    minCon.w1.getPoints().addAll(minCon.w2.getPoints());
                    minCon.w1.addWay(minCon.w2);
                    allWays.remove(minCon.w2);
                }
                return true;
            }
        }
        return false;
    }

    private double getMaxCloseDist() {
        double dist = 1000.0;
        String admString = this.getTag("admin_level");
        if ("2".equals(admString)) {
            dist = 50000.0;
        } else if ("3".equals(admString)) {
            dist = 20000.0;
        } else if ("4".equals(admString)) {
            dist = 4000.0;
        }
        return dist;
    }

    @Override
    protected void closeWays(ArrayList<MultiPolygonRelation.JoinedWay> wayList) {
        for (MultiPolygonRelation.JoinedWay way : wayList) {
            double closeDist;
            if (way.hasIdenticalEndPoints() || way.getPoints().size() < 3) continue;
            Coord p1 = way.getPoints().get(0);
            Coord p2 = way.getPoints().get(way.getPoints().size() - 1);
            if (!this.getBbox().insideBoundary(p1) && !this.getBbox().insideBoundary(p2) && (p1.getLatitude() <= this.getBbox().getMinLat() && p2.getLatitude() <= this.getBbox().getMinLat() || p1.getLatitude() >= this.getBbox().getMaxLat() && p2.getLatitude() >= this.getBbox().getMaxLat() || p1.getLongitude() <= this.getBbox().getMinLong() && p2.getLongitude() <= this.getBbox().getMinLong() || p1.getLongitude() >= this.getBbox().getMaxLong() && p2.getLongitude() >= this.getBbox().getMaxLong())) {
                way.closeWayArtificially();
                log.info("Endpoints of way", way, "are both outside the bbox. Closing it directly.");
                continue;
            }
            Line2D.Float closingLine = new Line2D.Float(p1.getLongitude(), p1.getLatitude(), p2.getLongitude(), p2.getLatitude());
            boolean intersects = false;
            Coord lastPoint = null;
            for (Coord thisPoint : way.getPoints().subList(1, way.getPoints().size() - 1)) {
                if (lastPoint != null && closingLine.intersectsLine(lastPoint.getLongitude(), lastPoint.getLatitude(), thisPoint.getLongitude(), thisPoint.getLatitude())) {
                    intersects = true;
                    break;
                }
                lastPoint = thisPoint;
            }
            if (intersects || !((closeDist = way.getPoints().get(0).distance(way.getPoints().get(way.getPoints().size() - 1))) <= this.getMaxCloseDist())) continue;
            log.info("Closing way", way);
            log.info("from", way.getPoints().get(0).toOSMURL());
            log.info("to", way.getPoints().get(way.getPoints().size() - 1).toOSMURL());
            way.closeWayArtificially();
        }
    }

    private void removeOutOfBbox(List<MultiPolygonRelation.JoinedWay> polygons) {
        ListIterator<MultiPolygonRelation.JoinedWay> pIter = polygons.listIterator();
        while (pIter.hasNext()) {
            Coord last;
            MultiPolygonRelation.JoinedWay w = pIter.next();
            Coord first = w.getPoints().get(0);
            if (first == (last = w.getPoints().get(w.getPoints().size() - 1)) || this.getBbox().contains(first) && this.getBbox().contains(last)) continue;
            pIter.remove();
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.getElements().clear();
        ((ArrayList)this.getElements()).trimToSize();
    }
}

