/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.test;

import java.util.ArrayList;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;

class AllElements {
    private static final double ELEMENT_SPACING = 0.002;
    private static final double ELEMENT_SIZE = 0.001;
    private static final int MAX_POINT_TYPE = 127;
    private static final int MAX_POINT_SUB_TYPE = 48;
    private static final int MAX_LINE_TYPE_X = 8;
    private static final int MAX_LINE_TYPE_Y = 8;
    private static final int MAX_SHAPE_TYPE_X = 12;
    private static final int MAX_SHAPE_TYPE_Y = 12;

    AllElements() {
    }

    public void load(MapCollector mapper) {
        double baseLat = 51.7;
        String sBaseLat = System.getenv("BASE_LAT");
        String sBaseLong = System.getenv("BASE_LONG");
        if (sBaseLat != null) {
            baseLat = Double.valueOf(sBaseLat);
        }
        double baseLong = 0.24;
        if (sBaseLong != null) {
            baseLong = Double.valueOf(sBaseLong);
        }
        this.drawTestMap(mapper, baseLat, baseLong);
    }

    private void drawTestMap(MapCollector map, double startLat, double startLong) {
        double lng = startLong;
        this.drawPoints(map, startLat, lng);
        this.drawLines(map, startLat, lng += 0.254);
        this.drawPolygons(map, startLat, lng += 0.016);
    }

    private void drawPoints(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        for (int type = 0; type < 127; ++type) {
            for (int subtype = 0; subtype < 48; ++subtype) {
                MapPoint point = new MapPoint();
                double baseLat = lat + (double)subtype * 0.002;
                double baseLong = lon + (double)type * 0.002;
                point.setMinResolution(10);
                point.setName("0x" + Integer.toHexString(type) + ',' + "0x" + Integer.toHexString(subtype));
                point.setLocation(new Coord(baseLat, baseLong));
                point.setType((type << 8) + subtype);
                mapper.addPoint(point);
                mapper.addToBounds(point.getLocation());
            }
        }
    }

    private void drawLines(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        for (int x = 0; x < 8; ++x) {
            int type;
            for (int y = 0; y < 8 && ((type = x * 8 + y) & 0xC0) == 0; ++y) {
                MapLine line = new MapLine();
                line.setMinResolution(10);
                line.setName("0x" + Integer.toHexString(type));
                double baseLat = lat + (double)y * 0.002;
                double baseLong = lon + (double)x * 0.002;
                ArrayList<Coord> coords = new ArrayList<Coord>();
                Coord co = new Coord(baseLat, baseLong);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat + 0.001, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat + 0.001, baseLong + 0.001 + 5.0E-4);
                coords.add(co);
                mapper.addToBounds(co);
                line.setType(type);
                line.setPoints(coords);
                mapper.addLine(line);
            }
        }
    }

    private void drawPolygons(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        for (int x = 0; x < 12; ++x) {
            int type;
            for (int y = 0; y < 12 && ((type = x * 16 + y) & 0x80) == 0; ++y) {
                MapShape shape = new MapShape();
                shape.setMinResolution(10);
                shape.setName("0x" + Integer.toHexString(type));
                double baseLat = lat + (double)y * 0.002;
                double baseLong = lon + (double)x * 0.002;
                ArrayList<Coord> coords = new ArrayList<Coord>();
                Coord co = new Coord(baseLat, baseLong);
                coords.add(co);
                co = new Coord(baseLat + 0.001, baseLong);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat + 0.001, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat, baseLong);
                coords.add(co);
                mapper.addToBounds(co);
                shape.setType(type);
                shape.setPoints(coords);
                mapper.addShape(shape);
            }
        }
    }
}

