/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import java.io.Reader;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.typ.DrawOrderSection;
import uk.me.parabola.mkgmap.typ.IconSection;
import uk.me.parabola.mkgmap.typ.IdSection;
import uk.me.parabola.mkgmap.typ.IgnoreSection;
import uk.me.parabola.mkgmap.typ.LineSection;
import uk.me.parabola.mkgmap.typ.PointSection;
import uk.me.parabola.mkgmap.typ.PolygonSection;
import uk.me.parabola.mkgmap.typ.ProcessSection;

public class TypTextReader {
    private static final Logger log = Logger.getLogger(TypTextReader.class);
    private final TypData data = new TypData();

    public void read(String filename, Reader r) {
        Token tok;
        TokenScanner scanner = new TokenScanner(filename, r);
        scanner.setCommentChar(null);
        ProcessSection currentSection = null;
        while (!scanner.isEndOfFile() && (tok = scanner.nextToken()).getType() != TokType.EOF) {
            if (tok.isValue(";")) {
                scanner.skipLine();
                continue;
            }
            if (tok.getType() == TokType.SYMBOL) {
                switch (tok.getValue().charAt(0)) {
                    case ';': {
                        scanner.skipLine();
                        break;
                    }
                    case '[': {
                        ProcessSection newSection = this.readSectionType(scanner);
                        if (currentSection != null) {
                            currentSection.finish(scanner);
                        }
                        currentSection = newSection;
                        break;
                    }
                    case '\"': {
                        scanner.skipLine();
                    }
                }
            } else {
                String name = tok.getValue();
                String sep = scanner.nextValue();
                if (!sep.equals("=") && !sep.equals(":")) {
                    throw new SyntaxException(scanner, "Expecting '=' or ':' instead of " + sep);
                }
                String value = scanner.readLine();
                if (currentSection == null) {
                    throw new SyntaxException(scanner, "Missing section start");
                }
                currentSection.processLine(scanner, name, value);
            }
            scanner.skipSpace();
        }
    }

    private ProcessSection readSectionType(TokenScanner scanner) {
        String sectionName = scanner.nextValue().toLowerCase();
        scanner.validateNext("]");
        if ("end".equals(sectionName)) {
            return null;
        }
        if ("_point".equals(sectionName)) {
            return new PointSection(this.data);
        }
        if ("_line".equals(sectionName)) {
            return new LineSection(this.data);
        }
        if ("_polygon".equals(sectionName)) {
            return new PolygonSection(this.data);
        }
        if ("_draworder".equals(sectionName)) {
            return new DrawOrderSection(this.data);
        }
        if ("_icons".equals(sectionName)) {
            return new IconSection(this.data);
        }
        if ("_id".equals(sectionName)) {
            return new IdSection(this.data);
        }
        log.warn((Object)("Unrecognised section " + sectionName));
        return new IgnoreSection(this.data);
    }

    public TypData getData() {
        return this.data;
    }
}

