/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;
import uk.me.parabola.log.Logger;

class Block {
    private static final Logger log = Logger.getLogger(Block.class);
    private final int blockId;
    private int blockLength;
    private byte[] body;
    private StructuredInputStream istream;
    private ByteArrayOutputStream arrayBody;
    private StructuredOutputStream ostream;

    Block(int blockId) {
        this.blockId = blockId;
    }

    Block(int type, byte[] body) {
        this.blockId = type;
        this.body = body;
        this.blockLength = body.length;
        ByteArrayInputStream stream = new ByteArrayInputStream(body);
        this.istream = new StructuredInputStream(stream);
    }

    public int getBlockId() {
        return this.blockId;
    }

    byte[] getBody() {
        if (this.body == null && this.arrayBody != null) {
            byte[] bytes = this.arrayBody.toByteArray();
            this.blockLength = bytes.length - 3;
            bytes[1] = (byte)(this.blockLength & 0xFF);
            bytes[2] = (byte)(this.blockLength >> 8 & 0xFF);
            return bytes;
        }
        return this.body;
    }

    public StructuredInputStream getInputStream() {
        this.arrayBody = null;
        return this.istream;
    }

    public StructuredOutputStream getOutputStream() {
        if (this.ostream == null) {
            this.arrayBody = new ByteArrayOutputStream();
            this.body = null;
            this.ostream = new StructuredOutputStream(this.arrayBody);
            try {
                this.ostream.write(this.blockId);
                this.ostream.write2(0);
            }
            catch (IOException e) {
                log.warn((Object)"failed writing to array");
            }
        }
        return this.ostream;
    }

    public void write(OutputStream stream) throws IOException {
        byte[] b = this.getBody();
        if (b != null) {
            stream.write(b);
        }
    }
}

