/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.IOException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;
import uk.me.parabola.tdbfmt.Block;

public class OverviewMapBlock {
    private int mapNumber;
    private String mapName;
    private int parentMapNumber;
    private String description;
    private int maxLat;
    private int maxLong;
    private int minLat;
    private int minLong;

    public OverviewMapBlock() {
        this.description = "overview map";
    }

    public OverviewMapBlock(Block block) throws IOException {
        StructuredInputStream ds = block.getInputStream();
        this.mapNumber = ds.read4();
        this.parentMapNumber = ds.read4();
        this.maxLat = ds.read4();
        this.maxLong = ds.read4();
        this.minLat = ds.read4();
        this.minLong = ds.read4();
        this.description = ds.readString();
    }

    public void write(Block block) throws IOException {
        StructuredOutputStream os = block.getOutputStream();
        os.write4(this.mapNumber);
        os.write4(this.parentMapNumber);
        os.write4(this.maxLat);
        os.write4(this.maxLong);
        os.write4(this.minLat);
        os.write4(this.minLong);
        os.writeString(this.description);
    }

    public String toString() {
        return "Overview: " + this.mapNumber + ", parent=" + this.parentMapNumber + " covers " + '(' + this.toDegrees(this.minLat) + ',' + this.toDegrees(this.minLong) + ')' + '(' + this.toDegrees(this.maxLat) + ',' + this.toDegrees(this.maxLong) + ')' + " : " + this.description;
    }

    private double toDegrees(int tdbunits) {
        return (double)tdbunits * 360.0 / Math.pow(2.0, 32.0);
    }

    public void setArea(Area bounds) {
        this.minLat = bounds.getMinLat() << 8;
        this.minLong = bounds.getMinLong() << 8;
        this.maxLat = bounds.getMaxLat() << 8;
        this.maxLong = bounds.getMaxLong() << 8;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
        try {
            this.mapNumber = Integer.parseInt(mapName);
        }
        catch (NumberFormatException e) {
            this.mapNumber = 0;
        }
    }

    protected String getMapName() {
        return this.mapName;
    }

    public void setParentMapNumber(int parentMapNumber) {
        this.parentMapNumber = parentMapNumber;
    }
}

