#tag Window
Begin Window wMain
   BackColor       =   16777215
   Backdrop        =   ""
   CloseButton     =   True
   Composite       =   False
   Frame           =   0
   FullScreen      =   False
   HasBackColor    =   False
   Height          =   311
   ImplicitInstance=   True
   LiveResize      =   True
   MacProcID       =   0
   MaxHeight       =   32000
   MaximizeButton  =   False
   MaxWidth        =   32000
   MenuBar         =   737364252
   MenuBarVisible  =   True
   MinHeight       =   64
   MinimizeButton  =   True
   MinWidth        =   64
   Placement       =   0
   Resizeable      =   False
   Title           =   "OSM Combiner"
   Visible         =   True
   Width           =   408
   Begin PagePanel ppWizard
      AutoDeactivate  =   True
      Enabled         =   True
      Height          =   254
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Left            =   15
      LockBottom      =   ""
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   ""
      LockTop         =   True
      PanelCount      =   3
      Panels          =   ""
      Scope           =   0
      TabIndex        =   0
      TabPanelIndex   =   0
      Top             =   5
      Value           =   1
      Visible         =   True
      Width           =   386
      Begin CheckBox chkGmapsupp
         AutoDeactivate  =   True
         Bold            =   ""
         Caption         =   "#str_gmapsupp"
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   156
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Scope           =   0
         State           =   0
         TabIndex        =   8
         TabPanelIndex   =   3
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   173
         Underline       =   ""
         Value           =   False
         Visible         =   True
         Width           =   230
      End
      Begin Label StaticText3
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   6
         TabPanelIndex   =   3
         Text            =   "#str_typ"
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   133
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   141
      End
      Begin Label stFam
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   0
         TabPanelIndex   =   3
         Text            =   "Family ID (FID):"
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   14
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   141
      End
      Begin Label StaticText1
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   2
         TabPanelIndex   =   3
         Text            =   "#str_name_on_computer"
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   53
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   141
      End
      Begin Label StaticText2
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   4
         TabPanelIndex   =   3
         Text            =   "#str_name_on_device"
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   93
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   141
      End
      Begin Listbox lbIMG
         AutoDeactivate  =   True
         AutoHideScrollbars=   True
         Bold            =   ""
         Border          =   True
         ColumnCount     =   1
         ColumnsResizable=   True
         ColumnWidths    =   ""
         DataField       =   ""
         DataSource      =   ""
         DefaultRowHeight=   -1
         Enabled         =   True
         EnableDrag      =   ""
         EnableDragReorder=   ""
         GridLinesHorizontal=   1
         GridLinesVertical=   1
         HasHeading      =   False
         HeadingIndex    =   -1
         Height          =   212
         HelpTag         =   ""
         Hierarchical    =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         InitialValue    =   ""
         Italic          =   ""
         Left            =   20
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         RequiresSelection=   ""
         Scope           =   0
         ScrollbarHorizontal=   True
         ScrollBarVertical=   True
         SelectionType   =   1
         TabIndex        =   1
         TabPanelIndex   =   2
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   39
         Underline       =   ""
         UseFocusRing    =   True
         Visible         =   True
         Width           =   199
         _ScrollWidth    =   -1
      End
      Begin PushButton pbSelectFolder
         AutoDeactivate  =   True
         Bold            =   ""
         ButtonStyle     =   0
         Cancel          =   ""
         Caption         =   "#str_select_folder"
         Default         =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   112
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Scope           =   0
         TabIndex        =   1
         TabPanelIndex   =   1
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   69
         Underline       =   ""
         Visible         =   True
         Width           =   184
      End
      Begin Label lblWorkFld
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   100
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Multiline       =   True
         Scope           =   0
         Selectable      =   False
         TabIndex        =   2
         TabPanelIndex   =   1
         Text            =   ""
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   121
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   368
      End
      Begin Label Label2
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   20
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   0
         TabPanelIndex   =   2
         Text            =   "#str_drop_files"
         TextAlign       =   0
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   14
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   230
      End
      Begin PushButton pbDel
         AutoDeactivate  =   True
         Bold            =   ""
         ButtonStyle     =   0
         Cancel          =   ""
         Caption         =   "#str_remove_selection"
         Default         =   ""
         Enabled         =   False
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   231
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Scope           =   0
         TabIndex        =   2
         TabPanelIndex   =   2
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   39
         Underline       =   ""
         Visible         =   True
         Width           =   157
      End
      Begin PushButton pbJavaHeap
         AutoDeactivate  =   True
         Bold            =   ""
         ButtonStyle     =   0
         Cancel          =   ""
         Caption         =   "#str_java"
         Default         =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   205
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Scope           =   0
         TabIndex        =   9
         TabPanelIndex   =   3
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   225
         Underline       =   ""
         Visible         =   True
         Width           =   133
      End
      Begin PopupMenu pmTyp
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         InitialValue    =   ""
         Italic          =   ""
         Left            =   156
         ListIndex       =   0
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Scope           =   0
         TabIndex        =   7
         TabPanelIndex   =   3
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   133
         Underline       =   ""
         Visible         =   True
         Width           =   230
      End
      Begin TextField tfDeviceName
         AcceptTabs      =   ""
         Alignment       =   0
         AutoDeactivate  =   True
         AutomaticallyCheckSpelling=   False
         BackColor       =   16777215
         Bold            =   ""
         Border          =   True
         CueText         =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Format          =   ""
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   156
         LimitText       =   0
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Mask            =   ""
         Password        =   ""
         ReadOnly        =   ""
         Scope           =   0
         TabIndex        =   5
         TabPanelIndex   =   3
         TabStop         =   True
         Text            =   "#str_comb_osm"
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   93
         Underline       =   ""
         UseFocusRing    =   True
         Visible         =   True
         Width           =   230
      End
      Begin TextField tfPcName
         AcceptTabs      =   ""
         Alignment       =   0
         AutoDeactivate  =   True
         AutomaticallyCheckSpelling=   False
         BackColor       =   16777215
         Bold            =   ""
         Border          =   True
         CueText         =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Format          =   ""
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   156
         LimitText       =   0
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Mask            =   ""
         Password        =   ""
         ReadOnly        =   ""
         Scope           =   0
         TabIndex        =   3
         TabPanelIndex   =   3
         TabStop         =   True
         Text            =   "#str_comb_osm"
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   53
         Underline       =   ""
         UseFocusRing    =   True
         Visible         =   True
         Width           =   230
      End
      Begin TextField tfFamID
         AcceptTabs      =   ""
         Alignment       =   0
         AutoDeactivate  =   True
         AutomaticallyCheckSpelling=   False
         BackColor       =   16777215
         Bold            =   ""
         Border          =   True
         CueText         =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Format          =   ""
         Height          =   22
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   156
         LimitText       =   5
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Mask            =   "#####"
         Password        =   ""
         ReadOnly        =   False
         Scope           =   0
         TabIndex        =   1
         TabPanelIndex   =   3
         TabStop         =   True
         Text            =   20123
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   14
         Underline       =   ""
         UseFocusRing    =   True
         Visible         =   True
         Width           =   230
      End
      Begin Label Label3
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   231
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Multiline       =   False
         Scope           =   0
         Selectable      =   False
         TabIndex        =   3
         TabPanelIndex   =   2
         Text            =   "#str_num_files"
         TextAlign       =   1
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   128
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   158
      End
      Begin Label lblFiles
         AutoDeactivate  =   True
         Bold            =   ""
         DataField       =   ""
         DataSource      =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   -2147483648
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   260
         LockBottom      =   ""
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   ""
         LockTop         =   True
         Multiline       =   ""
         Scope           =   0
         Selectable      =   False
         TabIndex        =   4
         TabPanelIndex   =   2
         Text            =   0
         TextAlign       =   1
         TextColor       =   0
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   153
         Transparent     =   False
         Underline       =   ""
         Visible         =   True
         Width           =   100
      End
      Begin PushButton pbHelp
         AutoDeactivate  =   True
         Bold            =   ""
         ButtonStyle     =   0
         Cancel          =   ""
         Caption         =   "#str_read_help"
         Default         =   ""
         Enabled         =   True
         Height          =   20
         HelpTag         =   ""
         Index           =   1
         InitialParent   =   "ppWizard"
         Italic          =   ""
         Left            =   112
         LockBottom      =   False
         LockedInPosition=   False
         LockLeft        =   True
         LockRight       =   False
         LockTop         =   True
         Scope           =   0
         TabIndex        =   0
         TabPanelIndex   =   1
         TabStop         =   True
         TextFont        =   "System"
         TextSize        =   0
         TextUnit        =   0
         Top             =   20
         Underline       =   ""
         Visible         =   True
         Width           =   184
      End
   End
   Begin PushButton pbPrev
      AutoDeactivate  =   True
      Bold            =   ""
      ButtonStyle     =   0
      Cancel          =   ""
      Caption         =   "#str_prev"
      Default         =   ""
      Enabled         =   False
      Height          =   20
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Italic          =   ""
      Left            =   20
      LockBottom      =   ""
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   ""
      LockTop         =   True
      Scope           =   0
      TabIndex        =   1
      TabPanelIndex   =   0
      TabStop         =   True
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   271
      Underline       =   ""
      Visible         =   True
      Width           =   95
   End
   Begin PushButton pbNext
      AutoDeactivate  =   True
      Bold            =   ""
      ButtonStyle     =   0
      Cancel          =   ""
      Caption         =   "#str_next"
      Default         =   ""
      Enabled         =   True
      Height          =   20
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Italic          =   ""
      Left            =   132
      LockBottom      =   ""
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   ""
      LockTop         =   True
      Scope           =   0
      TabIndex        =   2
      TabPanelIndex   =   0
      TabStop         =   True
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   271
      Underline       =   ""
      Visible         =   True
      Width           =   95
   End
   Begin PushButton pbHelp
      AutoDeactivate  =   True
      Bold            =   ""
      ButtonStyle     =   0
      Cancel          =   ""
      Caption         =   "?"
      Default         =   ""
      Enabled         =   True
      Height          =   20
      HelpTag         =   ""
      Index           =   0
      InitialParent   =   ""
      Italic          =   ""
      Left            =   356
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      Scope           =   0
      TabIndex        =   4
      TabPanelIndex   =   0
      TabStop         =   True
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   271
      Underline       =   ""
      Visible         =   True
      Width           =   32
   End
   Begin PushButton pbQuit
      AutoDeactivate  =   True
      Bold            =   ""
      ButtonStyle     =   0
      Cancel          =   ""
      Caption         =   "#str_quit"
      Default         =   ""
      Enabled         =   True
      Height          =   20
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Italic          =   ""
      Left            =   244
      LockBottom      =   ""
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   ""
      LockTop         =   True
      Scope           =   0
      TabIndex        =   3
      TabPanelIndex   =   0
      TabStop         =   True
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   271
      Underline       =   ""
      Visible         =   True
      Width           =   95
   End
End
#tag EndWindow

#tag WindowCode
	#tag Event
		Sub Close()
		  Quit
		End Sub
	#tag EndEvent

	#tag Event
		Sub Open()
		  Dim i As Integer
		  Dim t As String
		  
		  #if TargetWin32
		    ResourcesFolder = GetFolderItem("Resources")
		  #else
		    ResourcesFolder = App.ExecutableFile.Parent.Parent.Child("Resources")
		  #endif
		  
		  Left = (Screen(0).AvailableWidth - Width) \ 2
		  Top = (Screen(0).AvailableHeight - Height) \ 2
		  AppTitle = "OSM Combiner"
		  Me.Title = AppTitle + " " + App.ShortVersion
		  
		  JavaBin = GetJava()
		  If JavaBin = "" Then
		    ppWizard.Enabled = False
		    pbNext.Enabled = False
		    Exit Sub
		  End If
		  
		  WorkingFolder = SpecialFolder.Desktop.Child("OSMCombi")
		  lblWorkFld.Text = WorkingFolder.AbsolutePath
		  
		  pmTyp.AddRow str_none
		  For i = 1 To ResourcesFolder.Count
		    t = ResourcesFolder.Item(i).Name
		    If Left(t, 3) = "typ" And Right(t, 4) = ".txt" Then pmTyp.AddRow Mid(t, 4, Len(t) - 7)
		  Next
		  pmTyp.ListIndex = 0
		  lbIMG.AcceptFileDrop(ftImport.All)
		  JavaHeap = 500
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent


	#tag Method, Flags = &h1
		Protected Sub FillList()
		  Dim i As Integer
		  
		  lbIMG.DeleteAllRows
		  For i = 0 To UBound(IMGs)
		    lbIMG.AddRow IMGs(i).Name
		  Next
		  
		  pbNext.Enabled = (lbIMG.ListCount > 0)
		  lblFiles.Caption = Str(lbIMG.ListCount)
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Function GetArea(coords As String) As String
		  Const PI = 3.14159265358979323846264338327950
		  Dim latlon() As String
		  Dim MinLat, MaxLat, MinLon, MaxLon As Double
		  
		  latlon = Split(coords, "|")
		  MaxLat = Val(latlon(0))
		  MaxLon = Val(latlon(1))
		  MinLat = Val(latlon(2))
		  MinLon = Val(latlon(3))
		  
		  Return Format((PI / 180) * 6371 ^ 2 * Abs(Sin(MinLat * PI / 180) - Sin(MaxLat * PI / 180)) * Abs(MinLon - MaxLon), "0000000000")
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Function GetJava() As String
		  Dim s As New Shell
		  Dim jver As Double
		  Dim javamin As Double = 1.6
		  
		  #if TargetWin32
		    Dim f As FolderItem
		    Dim ri As RegistryItem
		    Dim t As String
		    
		    t = """" + ResourcesFolder.Child("javatest.cmd").AbsolutePath + """"
		    s.Execute t.ConvertEncoding(Encodings.WindowsANSI)
		    If Trim(s.Result) <> "" Then
		      Try
		        f = GetFolderItem(Trim(s.Result)).Child("bin").Child("java.exe")
		        t = """" + f.AbsolutePath + """ -version"
		        s.Execute t.ConvertEncoding(Encodings.WindowsANSI)
		        JavaInfo = s.Result
		        If Left(JavaInfo, 12) = "java version" Then
		          jver = Val(Mid(JavaInfo, 15, 3))
		          If jver >= javamin Then Return """" + f.AbsolutePath + """"
		        End If
		      Catch
		      End Try
		    End If
		    
		    Try
		      ri = New RegistryItem("HKEY_CLASSES_ROOT\jarfile\shell\open\command", False)
		      t = Mid(ri.Value(""), 2)
		      t = Left(t, InStr(t, """") - 1)
		      f = GetFolderItem(t).Parent.Child("java.exe")
		      t = """" + f.AbsolutePath + """ -version"
		      s.Execute t.ConvertEncoding(Encodings.WindowsANSI)
		      JavaInfo = s.Result
		      If Left(JavaInfo, 12) = "java version" Then
		        jver = Val(Mid(JavaInfo, 15, 3))
		        If jver >= javamin Then Return """" + f.AbsolutePath + """"
		      End If
		    Catch
		    End Try
		    
		    Try
		      f = SpecialFolder.Windows.Child("System32").Child("java.exe")
		      t = """" + f.AbsolutePath + """ -version"
		      s.Execute t.ConvertEncoding(Encodings.WindowsANSI)
		      JavaInfo = s.Result
		      If Left(JavaInfo, 12) = "java version" Then
		        jver = Val(Mid(JavaInfo, 15, 3))
		        If jver >= javamin Then Return """" + f.AbsolutePath + """"
		      End If
		    Catch
		    End Try
		  #endif
		  
		  s.Execute "java -version"
		  JavaInfo = s.Result
		  If Left(JavaInfo, 12) = "java version" Then
		    jver = Val(Mid(JavaInfo, 15, 3))
		    If jver >= javamin Then Return "java"
		  End If
		  
		  If jver > 0 And jver < javamin Then
		    Call MsgBox(str_java_err_version, 16, AppTitle)
		  Else
		    Call MsgBox(str_java_err_missing, 16, AppTitle)
		  End If
		  Return ""
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndMethod


	#tag Note, Name = LICENCE
		Copyright (C) 2014 JaVaWa
		
		This program is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License version 2 as
		published by the Free Software Foundation.
		
		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.
	#tag EndNote


	#tag Property, Flags = &h0
		Success As Boolean
	#tag EndProperty


#tag EndWindowCode

#tag Events lbIMG
	#tag Event
		Function CellBackgroundPaint(g As Graphics, row As Integer, column As Integer) As Boolean
		  If row Mod 2 = 0 Then
		    g.foreColor = &cFFFFFF
		  Else
		    g.foreColor = &cF1F5FA
		  End If
		  g.FillRect 0, 0, g.width, g.height
		End Function
	#tag EndEvent
	#tag Event
		Sub DropObject(obj As DragItem, action As Integer)
		  If Not WorkingFolder.Exists Then WorkingFolder.CreateAsFolder
		  If Not WorkingFolder.Child("Tiles").Exists Then WorkingFolder.Child("Tiles").CreateAsFolder
		  ReDim DropFiles(-1)
		  If obj.FolderItemAvailable Then
		    App.MouseCursor = System.Cursors.Wait
		    Do
		      If Obj.FolderItem <> Nil Then DropFiles.Append obj.FolderItem
		    Loop Until Not obj.NextItem
		    ppWizard.Enabled = False
		    pbPrev.Enabled = False
		    pbNext.Enabled = False
		    wProgress.Mode = "proc"
		    wProgress.ShowModal
		    NoErr = False
		    FillList
		    ppWizard.Enabled = True
		    pbPrev.Enabled = True
		    App.MouseCursor = Nil
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
	#tag Event
		Sub Change()
		  pbDel.Enabled = (Me.SelCount > 0)
		End Sub
	#tag EndEvent
	#tag Event
		Function KeyDown(Key As String) As Boolean
		  Dim i, j As Integer
		  Dim ovm As FolderItem
		  
		  #if TargetWin32
		    If Asc(Key) = 1 Then
		      For i = 0 To Me.ListCount - 1
		        Me.Selected(i) = True
		      Next
		      Return True
		    End If
		  #else
		    If Keyboard.AsyncCommandKey And Key = "a" Then
		      For i = 0 To Me.ListCount - 1
		        Me.Selected(i) = True
		      Next
		      Return True
		    End If
		  #endif
		  
		  If Asc(Key) = 8 Or Asc(Key) = 127 Then
		    j = Me.ListCount - 1
		    For i  = j DownTo 0
		      If Me.Selected(i) Then
		        Me.RemoveRow i
		        ovm = IMGs(i).Path.Parent.Child("ovm_" + IMGs(i).Path.Name)
		        If ovm.Exists Then ovm.Delete
		        IMGs(i).Path.Delete
		        IMGs.Remove i
		      End If
		    Next
		    Return True
		  End If
		  pbNext.Enabled = (Me.ListCount > 0)
		  
		  lblFiles.Caption = Str(Me.ListCount)
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndEvent
#tag EndEvents
#tag Events pbSelectFolder
	#tag Event
		Sub Action()
		  Dim fldrDlg As New SelectFolderDialog
		  Dim prevF, f As FolderItem
		  
		  prevF = WorkingFolder
		  fldrDlg.InitialDirectory = WorkingFolder
		  fldrDlg.Title = AppTitle
		  f = fldrDlg.showModal
		  If Not (f Is Nil) Then
		    WorkingFolder = f
		    lblWorkFld.Caption = f.AbsolutePath
		    If prevF.AbsolutePath <> WorkingFolder.AbsolutePath Then
		      ReDim IMGs(-1)
		      lbIMG.DeleteAllRows
		    End If
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbDel
	#tag Event
		Sub Action()
		  Dim i As Integer
		  Dim ovm As FolderItem
		  
		  For i = lbIMG.ListCount - 1 DownTo 0
		    If lbIMG.Selected(i) Then
		      lbIMG.RemoveRow i
		      ovm = IMGs(i).Path.Parent.Child("ovm_" + IMGs(i).Path.Name)
		      If ovm.Exists Then ovm.Delete
		      IMGs(i).Path.Delete
		      IMGs.Remove i
		    End If
		  Next
		  
		  pbDel.Enabled = False
		  pbNext.Enabled = (lbIMG.ListCount > 0)
		  
		  lblFiles.Caption = Str(lbIMG.ListCount)
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbJavaHeap
	#tag Event
		Sub Action()
		  wJavaHeap.cboHeap.AddRow "250"
		  wJavaHeap.cboHeap.AddRow "500"
		  wJavaHeap.cboHeap.AddRow "1000"
		  wJavaHeap.cboHeap.AddRow "1400"
		  wJavaHeap.cboHeap.AddRow "2000"
		  wJavaHeap.cboHeap.AddRow "4000"
		  wJavaHeap.cboHeap.AddRow "8000"
		  wJavaHeap.cboHeap.Text = Str(JavaHeap)
		  wJavaHeap.ShowModal
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbHelp
	#tag Event
		Sub Action()
		  wHelp.Title = AppTitle + " - " + str_help
		  wHelp.hvHelp.LoadPage ResourcesFolder.Child("helpindex_" + str_lang + ".html")
		  wHelp.Show
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbPrev
	#tag Event
		Sub Action()
		  pbNext.Enabled = True
		  Select Case ppWizard.Value
		  Case 1
		    ppWizard.Value = 0
		    Me.Enabled = False
		  Case 2
		    ppWizard.Value = 1
		    pbNext.Caption = str_next
		  End Select
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbNext
	#tag Event
		Sub Action()
		  Dim i As Integer
		  Dim s As UInt64
		  Dim d As New MessageDialog
		  Dim b As MessageDialogButton
		  
		  pbPrev.Enabled = True
		  Select Case ppWizard.Value
		  Case 0
		    ppWizard.Value = 1
		    Me.Enabled = (lbIMG.ListCount > 0)
		  Case 1
		    For i = 0 To UBound(IMGs)
		      s = s + IMGs(i).Size
		    Next
		    If s < 3.5 * 2 ^ 30 Then
		      chkGmapsupp.Enabled = True
		    Else
		      chkGmapsupp.Value = False
		      chkGmapsupp.Enabled = False
		    End If
		    
		    ppWizard.Value = 2
		    Me.Caption = str_start
		  Case 2
		    If Val(tfFamID.Text) < 1 Or Val(tfFamID.Text) > 65535 Or Val(tfFamID.Text) = 2041 Then
		      Call MsgBox(str_illegal_id, 16, AppTitle)
		      Exit Sub
		    End If
		    
		    If WorkingFolder.Child(CleanFileName(tfPcName.Text)).Exists Then
		      Call MsgBox(ReturnMsg(str_folder_exists, CleanFileName(tfPcName.Text)), 16, AppTitle)
		      Exit Sub
		    End If
		    
		    Success = False
		    App.MouseCursor = System.Cursors.Wait
		    ppWizard.Enabled = False
		    pbPrev.Enabled = False
		    pbNext.Enabled = False
		    wProgress.Mode = "create"
		    wProgress.ShowModal
		    FillList
		    ppWizard.Enabled = True
		    pbPrev.Enabled = True
		    
		    App.MouseCursor = Nil
		    
		    If Success Then
		      d.icon = MessageDialog.GraphicQuestion
		      d.ActionButton.Caption = str_yes
		      d.AlternateActionButton.Caption = str_no
		      d.AlternateActionButton.Visible = True
		      d.Title = AppTitle
		      d.Message = str_ask_install
		      b = d.ShowModal
		      If b = d.ActionButton Then 
		        #if TargetWin32
		          WorkingFolder.Child(CleanFileName(tfPcName.Text)).Child("install.exe").Launch
		        #else
		          WorkingFolder.Child(CleanFileName(tfPcName.Text) + ".gmap").Launch
		        #endif
		      End If
		      NoErr = False
		      Success = False
		    End If
		  End Select
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbQuit
	#tag Event
		Sub Action()
		  wMain.Close
		End Sub
	#tag EndEvent
#tag EndEvents
