/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;

public class Label {
    public static final Label NULL_LABEL = new Label("");
    public static final Label NULL_OUT_LABEL = new Label(new char[0]);
    private final String text;
    private final char[] encText;
    private int offset;
    public static final Pattern SHIELDS = Pattern.compile("[\u0001-\u0006\u001b-\u001c]");
    private static final Pattern SEPARATORS = Pattern.compile("[\u001d-\u001f]");
    private static final Pattern SQUASH_SPACES = Pattern.compile("\\s\\s+");

    public Label(String text) {
        this.text = text;
        this.encText = null;
    }

    public Label(char[] encText) {
        this.encText = encText;
        this.text = null;
    }

    public int getLength() {
        if (this.text != null) {
            return this.text.length();
        }
        if (this.encText != null) {
            return this.encText.length;
        }
        return 0;
    }

    public String getText() {
        assert (this.text != null);
        return this.text;
    }

    public char[] getEncText() {
        return this.encText;
    }

    public static String stripGarminCodes(String s) {
        if (s == null) {
            return null;
        }
        s = SHIELDS.matcher(s).replaceAll("");
        s = SEPARATORS.matcher(s).replaceAll(" ");
        s = SQUASH_SPACES.matcher(s).replaceAll(" ");
        return s.trim();
    }

    public static String squashSpaces(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return SQUASH_SPACES.matcher(s).replaceAll(" ");
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void write(ImgFileWriter writer, EncodedText encText) {
        assert (encText != null);
        if (encText.getLength() > 0) {
            writer.put(encText.getCtext(), 0, encText.getLength());
        }
    }

    public String toString() {
        return this.text != null ? this.text : "[" + this.offset + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.offset == ((Label)o).offset;
    }

    public int hashCode() {
        return this.offset;
    }
}

