/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class PlacesHeader {
    private static final char COUNTRY_REC_LEN = '\u0003';
    private static final char REGION_REC_LEN = '\u0005';
    private static final char CITY_REC_LEN = '\u0005';
    private static final char POI_INDEX_REC_LEN = '\u0004';
    private static final char POI_TYPE_INDEX_REC_LEN = '\u0004';
    private static final char ZIP_REC_LEN = '\u0003';
    private static final char HIGHWAY_REC_LEN = '\u0006';
    private static final char EXIT_REC_LEN = '\u0005';
    private static final char HIGHWAYDATA_REC_LEN = '\u0003';
    private final Section country = new Section('\u0003');
    private final Section region = new Section(this.country, '\u0005');
    private final Section city = new Section(this.region, '\u0005');
    private final Section poiIndex = new Section(this.city, '\u0004');
    private final Section poiProperties = new Section(this.poiIndex);
    private final Section poiTypeIndex = new Section(this.poiProperties, '\u0004');
    private final Section zip = new Section(this.poiTypeIndex, '\u0003');
    private final Section highway = new Section(this.zip, '\u0006');
    private final Section exitFacility = new Section(this.highway, '\u0005');
    private final Section highwayData = new Section(this.exitFacility, '\u0003');
    private byte POIGlobalFlags;

    void setPOIGlobalFlags(byte flags) {
        this.POIGlobalFlags = flags;
    }

    byte getPOIGlobalFlags() {
        return this.POIGlobalFlags;
    }

    void writeFileHeader(ImgFileWriter writer) {
        writer.putInt(this.country.getPosition());
        writer.putInt(this.country.getSize());
        writer.putChar(this.country.getItemSize());
        writer.putInt(0);
        writer.putInt(this.region.getPosition());
        writer.putInt(this.region.getSize());
        writer.putChar(this.region.getItemSize());
        writer.putInt(0);
        writer.putInt(this.city.getPosition());
        writer.putInt(this.city.getSize());
        writer.putChar(this.city.getItemSize());
        writer.putInt(0);
        writer.putInt(this.poiIndex.getPosition());
        writer.putInt(this.poiIndex.getSize());
        writer.putChar(this.poiIndex.getItemSize());
        writer.putInt(0);
        writer.putInt(this.poiProperties.getPosition());
        writer.putInt(this.poiProperties.getSize());
        writer.put((byte)0);
        writer.put(this.POIGlobalFlags);
        writer.putChar('\u0000');
        writer.put((byte)0);
        writer.putInt(this.poiTypeIndex.getPosition());
        writer.putInt(this.poiTypeIndex.getSize());
        writer.putChar(this.poiTypeIndex.getItemSize());
        writer.putInt(0);
        writer.putInt(this.zip.getPosition());
        writer.putInt(this.zip.getSize());
        writer.putChar(this.zip.getItemSize());
        writer.putInt(0);
        writer.putInt(this.highway.getPosition());
        writer.putInt(this.highway.getSize());
        writer.putChar(this.highway.getItemSize());
        writer.putInt(0);
        writer.putInt(this.exitFacility.getPosition());
        writer.putInt(this.exitFacility.getSize());
        writer.putChar(this.exitFacility.getItemSize());
        writer.putInt(0);
        writer.putInt(this.highwayData.getPosition());
        writer.putInt(this.highwayData.getSize());
        writer.putChar(this.highwayData.getItemSize());
        writer.putInt(0);
    }

    void readFileHeader(ImgFileReader reader) {
        reader.position(31L);
        this.country.readSectionInfo(reader, true);
        reader.getInt();
        this.region.readSectionInfo(reader, true);
        reader.getInt();
        this.city.readSectionInfo(reader, true);
        reader.getInt();
        this.poiIndex.readSectionInfo(reader, true);
        reader.getInt();
        this.poiProperties.readSectionInfo(reader, false);
        reader.get();
        this.POIGlobalFlags = reader.get();
        reader.getChar();
        reader.get();
        this.poiTypeIndex.readSectionInfo(reader, true);
        reader.getInt();
        this.zip.readSectionInfo(reader, true);
        reader.getInt();
        this.highway.readSectionInfo(reader, true);
        reader.getInt();
        this.exitFacility.readSectionInfo(reader, true);
        reader.getInt();
        this.highwayData.readSectionInfo(reader, true);
        reader.getInt();
    }

    int getLastPos() {
        return this.highwayData.getEndPos();
    }

    void setLabelEnd(int pos) {
        this.country.setPosition(pos);
    }

    void endCountries(int pos) {
        this.country.setSize(pos - this.country.getPosition());
    }

    void endRegions(int pos) {
        this.region.setSize(pos - this.region.getPosition());
    }

    void endCity(int pos) {
        this.city.setSize(pos - this.city.getPosition());
    }

    void endPOI(int pos) {
        this.poiProperties.setSize(pos - this.poiProperties.getPosition());
    }

    void endPOIIndex(int pos) {
        this.poiIndex.setSize(pos - this.poiIndex.getPosition());
    }

    void endPOITypeIndex(int pos) {
        this.poiTypeIndex.setSize(pos - this.poiTypeIndex.getPosition());
    }

    void endZip(int pos) {
        this.zip.setSize(pos - this.zip.getPosition());
    }

    void endHighway(int pos) {
        this.highway.setSize(pos - this.highway.getPosition());
    }

    void endExitFacility(int pos) {
        this.exitFacility.setSize(pos - this.exitFacility.getPosition());
    }

    void endHighwayData(int pos) {
        this.highwayData.setSize(pos - this.highwayData.getPosition());
    }

    public int getNumCities() {
        return this.city.getNumItems();
    }

    public int getNumZips() {
        return this.zip.getNumItems();
    }

    public int getPoiPropertiesStart() {
        return this.poiProperties.getPosition();
    }

    public int getPoiPropertiesEnd() {
        return this.poiProperties.getEndPos();
    }

    public int getCitiesStart() {
        return this.city.getPosition();
    }

    public int getCitiesEnd() {
        return this.city.getEndPos();
    }

    public int getNumExits() {
        return this.exitFacility.getNumItems();
    }

    public int getCountriesStart() {
        return this.country.getPosition();
    }

    public int getCountriesEnd() {
        return this.country.getEndPos();
    }

    public int getRegionsStart() {
        return this.region.getPosition();
    }

    public int getRegionsEnd() {
        return this.region.getEndPos();
    }

    public int getNumHighways() {
        return this.highway.getNumItems();
    }

    public int getZipsStart() {
        return this.zip.getPosition();
    }

    public int getZipsEnd() {
        return this.zip.getEndPos();
    }
}

