/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.map;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.NETFileReader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.RGNFileReader;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREFileReader;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;

public class MapReader
implements Closeable {
    private final TREFileReader treFile;
    private final RGNFileReader rgnFile;
    private final LBLFileReader lblFile;
    private final NETFileReader netFile;
    public static final boolean WITH_EXT_TYPE_DATA = true;
    public static final boolean WITHOUT_EXT_TYPE_DATA = false;
    private final Deque<Closeable> toClose = new ArrayDeque<Closeable>();

    public MapReader(String filename) throws FileNotFoundException {
        NETFileReader nr;
        FileSystem fs = ImgFS.openFs(filename);
        this.saveForClose(fs);
        List<DirectoryEntry> entries = fs.list();
        String mapname = null;
        for (DirectoryEntry ent : entries) {
            if (!"TRE".equals(ent.getExt())) continue;
            mapname = ent.getName();
            break;
        }
        if (mapname == null) {
            throw new FileNotFoundException("No TRE entry in img file");
        }
        ImgChannel chan = fs.open(mapname + ".TRE", "r");
        this.treFile = new TREFileReader(chan);
        this.saveForClose(this.treFile, chan);
        chan = fs.open(mapname + ".RGN", "r");
        this.rgnFile = new RGNFileReader(chan);
        this.saveForClose(this.rgnFile, chan);
        chan = fs.open(mapname + ".LBL", "r");
        this.lblFile = new LBLFileReader(chan);
        this.saveForClose(this.lblFile, chan);
        try {
            chan = fs.open(mapname + ".NET", "r");
            nr = new NETFileReader(chan);
            nr.setLabels(this.lblFile);
            nr.setCities(this.lblFile.getCities());
            nr.setZips(this.lblFile.getZips());
            this.saveForClose(nr);
        }
        catch (FileNotFoundException e) {
            nr = null;
        }
        this.netFile = nr;
        this.rgnFile.setNetFile(this.netFile);
        this.rgnFile.setLblFile(this.lblFile);
    }

    public List<Point> pointsForLevel(int level, boolean withExtType) {
        Subdivision[] subdivisions;
        ArrayList<Point> points = new ArrayList<Point>();
        for (Subdivision sd : subdivisions = this.treFile.subdivForLevel(level)) {
            List<Point> subdivPoints = this.rgnFile.pointsForSubdiv(sd, withExtType);
            points.addAll(subdivPoints);
        }
        return points;
    }

    public Zoom[] getLevels() {
        return this.treFile.getMapLevels();
    }

    public String[] getCopyrights() {
        return this.treFile.getCopyrights(this.lblFile);
    }

    public List<Polyline> linesForLevel(int level) {
        Subdivision[] subdivisions;
        ArrayList<Polyline> lines = new ArrayList<Polyline>();
        for (Subdivision div : subdivisions = this.treFile.subdivForLevel(level)) {
            List<Polyline> subdivLines = this.rgnFile.linesForSubdiv(div);
            lines.addAll(subdivLines);
        }
        return lines;
    }

    public List<Polygon> shapesForLevel(int level) {
        Subdivision[] subdivisions;
        ArrayList<Polygon> shapes = new ArrayList<Polygon>();
        for (Subdivision div : subdivisions = this.treFile.subdivForLevel(level)) {
            List<Polygon> subdivShapes = this.rgnFile.shapesForSubdiv(div);
            shapes.addAll(subdivShapes);
        }
        return shapes;
    }

    @Override
    public void close() throws IOException {
        for (Closeable c : this.toClose) {
            Utils.closeFile(c);
        }
    }

    private void saveForClose(Closeable c1, Closeable c2) {
        this.saveForClose(c1);
        this.saveForClose(c2);
    }

    private void saveForClose(Closeable c) {
        this.toClose.push(c);
    }

    public List<City> getCities() {
        return this.lblFile.getCities();
    }

    public List<Country> getCountries() {
        return this.lblFile.getCountries();
    }

    public List<Region> getRegions() {
        return this.lblFile.getRegions();
    }

    public List<Zip> getZips() {
        return this.lblFile.getZips();
    }

    public Area getTreBounds() {
        return this.treFile.getBounds();
    }

    public Map<Integer, String> getLabels() {
        return this.lblFile.getLabels();
    }

    public List<RoadDef> getRoads() {
        if (this.netFile == null) {
            return Collections.emptyList();
        }
        return this.netFile.getRoads();
    }

    public int getEncodingType() {
        return this.lblFile.getEncodingType();
    }
}

