/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr28Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr27
extends MdrSection {
    private final List<Mdr5Record> cities = new ArrayList<Mdr5Record>();

    public Mdr27(MdrConfig config) {
        this.setConfig(config);
    }

    public void sortCities(List<Mdr5Record> list) {
        Sort sort = this.getConfig().getSort();
        ArrayList<SortKey<Mdr5Record>> keys = new ArrayList<SortKey<Mdr5Record>>();
        for (Mdr5Record c : list) {
            Mdr13Record mdrRegion = c.getMdrRegion();
            if (mdrRegion == null) continue;
            SortKey<Mdr5Record> key = sort.createSortKey(c, mdrRegion.getName(), c.getGlobalCityIndex());
            keys.add(key);
        }
        Collections.sort(keys);
        String lastName = null;
        int record = 0;
        for (SortKey<Mdr5Record> key : keys) {
            ++record;
            Mdr5Record city = key.getObject();
            Mdr13Record mdrRegion = city.getMdrRegion();
            Mdr28Record mdr28 = mdrRegion.getMdr28();
            String name = mdr28.getName();
            if (!name.equals(lastName)) {
                mdr28.setMdr27(record);
                lastName = name;
            }
            this.cities.add(city);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = this.getItemSize();
        for (Mdr5Record city : this.cities) {
            this.putN(writer, size, city.getGlobalCityIndex());
        }
    }

    @Override
    public int getItemSize() {
        return this.getSizes().getCitySize();
    }

    @Override
    protected int numberOfItems() {
        return this.cities.size();
    }
}

