/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr6Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr6
extends MdrMapSection {
    private final List<Mdr6Record> zips = new ArrayList<Mdr6Record>();

    public Mdr6(MdrConfig config) {
        this.setConfig(config);
    }

    public void addZip(int mapIndex, Zip zip, int strOff) {
        Mdr6Record record = new Mdr6Record(zip);
        record.setMapIndex(mapIndex);
        record.setStringOffset(strOff);
        this.zips.add(record);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int zipSize = this.getSizes().getZipSize();
        List<SortKey<Mdr6Record>> sortKeys = MdrUtils.sortList(this.getConfig().getSort(), this.zips);
        boolean hasString = this.hasFlag(4);
        int record = 1;
        for (SortKey<Mdr6Record> key : sortKeys) {
            Mdr6Record z = key.getObject();
            this.addIndexPointer(z.getMapIndex(), record++);
            this.putMapIndex(writer, z.getMapIndex());
            this.putN(writer, zipSize, z.getZipIndex());
            if (!hasString) continue;
            this.putStringOffset(writer, z.getStringOffset());
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + sizes.getZipSize();
        if (this.hasFlag(4)) {
            size += sizes.getStrOffSize();
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.zips.size();
    }

    @Override
    public int getExtraValue() {
        return this.getSizes().getZipSize() - 1 & 3 | (this.isForDevice() ? 0 : 4);
    }

    @Override
    public void relabelMaps(Mdr1 maps) {
        this.relabel(maps, this.zips);
    }
}

