/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.app.net.Abandon;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;

class CityZipWriter {
    private ByteArrayOutputStream buf;
    private final String type;
    private final int numItems;
    private final int defaultIndex;

    public CityZipWriter(String type, int defIndex, int numItems) {
        this.type = type;
        this.defaultIndex = defIndex;
        this.numItems = numItems;
        this.buf = new ByteArrayOutputStream();
    }

    public ByteArrayOutputStream getBuffer() {
        return this.buf;
    }

    public boolean compile(List<Numbers> numbers) {
        try {
            int lastNodeIndex = -1;
            int[] prevIndexes = new int[2];
            prevIndexes[1] = -1;
            prevIndexes[0] = -1;
            int[] indexes = new int[2];
            for (Numbers num : numbers) {
                block11: for (int i = 0; i < 2; ++i) {
                    indexes[i] = -1;
                    boolean left = i == 0;
                    switch (this.type) {
                        case "zip": {
                            ZipCodeInfo zipInfo = num.getZipCodeInfo(left);
                            if (zipInfo == null) continue block11;
                            if (zipInfo.getImgZip() != null) {
                                indexes[i] = zipInfo.getImgZip().getIndex();
                                continue block11;
                            }
                            indexes[i] = 0;
                            continue block11;
                        }
                        case "city": {
                            CityInfo cityInfo = num.getCityInfo(left);
                            if (cityInfo == null) continue block11;
                            if (cityInfo.getImgCity() != null) {
                                indexes[i] = cityInfo.getImgCity().getIndex();
                                continue block11;
                            }
                            indexes[i] = 0;
                            continue block11;
                        }
                    }
                }
                if (indexes[0] < 0 && indexes[1] < 0) continue;
                if (lastNodeIndex < 0 && num.getIndex() > 0) {
                    int[] defindexes = new int[]{this.defaultIndex, this.defaultIndex};
                    this.write(0, defindexes, prevIndexes);
                }
                int skip = num.getIndex() - lastNodeIndex - 1;
                assert (this.defaultIndex > 0) : "bad default index";
                lastNodeIndex = num.getIndex();
                if (indexes[0] < 0) {
                    indexes[0] = this.defaultIndex;
                }
                if (indexes[1] < 0) {
                    indexes[1] = this.defaultIndex;
                }
                this.write(skip, indexes, prevIndexes);
            }
        }
        catch (Abandon e) {
            return false;
        }
        return true;
    }

    private void write(int skip, int[] indexes, int[] prevIndexes) {
        int initFlag;
        if (Arrays.equals(indexes, prevIndexes)) {
            return;
        }
        int sidesFlag = 0;
        if (indexes[0] <= 0 && indexes[1] <= 0) {
            sidesFlag |= 4;
            if (indexes[0] == 0) {
                sidesFlag |= 1;
            }
            if (indexes[1] == 0) {
                sidesFlag |= 2;
            }
        } else if (indexes[1] != indexes[0]) {
            if (indexes[0] > 0 && indexes[0] != prevIndexes[0]) {
                sidesFlag |= 1;
            }
            if (indexes[1] > 0 && indexes[1] != prevIndexes[1]) {
                sidesFlag |= 2;
            }
        }
        if ((initFlag = Math.max(skip - 1, 0)) > 31) {
            this.buf.write((byte)(initFlag & 0x1F | 0xE0));
            initFlag >>= 5;
        }
        this.buf.write((byte)((initFlag |= sidesFlag << 5) & 0xFF));
        if ((sidesFlag & 4) == 0) {
            if (indexes[0] > 0 && (sidesFlag == 0 || (sidesFlag & 1) == 1)) {
                this.writeIndex(indexes[0]);
            }
            if (indexes[1] > 0 && (sidesFlag & 2) != 0) {
                this.writeIndex(indexes[1]);
            }
        }
        System.arraycopy(indexes, 0, prevIndexes, 0, indexes.length);
    }

    void writeIndex(int val) {
        if (val <= 0) {
            return;
        }
        if (this.numItems > 255) {
            this.buf.write((byte)val & 0xFF);
            this.buf.write((byte)(val >> 8));
        } else {
            this.buf.write((byte)val);
        }
    }
}

