/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class SRTHeader
extends CommonHeader {
    private static final int HEADER_LEN = 29;
    protected static final int HEADER2_LEN = 16;
    protected static final int HEADER3_LEN = 52;
    protected static final int HEADER3_MULTI_LEN = 92;
    private final Section header = new Section();
    private final Section desc = new Section(this.header);
    private final Section subheader = new Section(this.desc);
    private final Section chartab = new Section('\u0003');
    private final Section expansions = new Section(this.chartab, '\u0002');
    private final Section srt8 = new Section(this.expansions, '\u0005');
    private final Section srt7 = new Section(this.srt8, '\u0004');
    private Sort sort;

    public SRTHeader() {
        super(29, "GARMIN SRT");
        this.header.setPosition(29);
        this.header.setSize(16);
        this.chartab.setPosition(52);
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.putChar('\u0001');
        writer.putInt(this.header.getPosition());
        writer.putChar((char)this.header.getSize());
    }

    SectionWriter makeSectionWriter(ImgFileWriter writer) {
        return new SectionWriter(writer, this.subheader);
    }

    protected void writeHeader2(ImgFileWriter writer) {
        this.desc.writeSectionInfo(writer);
        this.subheader.writeSectionInfo(writer);
    }

    protected void writeHeader3(ImgFileWriter writer) {
        if (this.sort.isMulti()) {
            writer.putChar('\\');
        } else {
            writer.putChar('4');
        }
        writer.putChar((char)this.sort.getId1());
        writer.putChar((char)this.sort.getId2());
        writer.putChar((char)this.sort.getCodepage());
        if (this.sort.isMulti()) {
            writer.putInt(28418);
        } else {
            writer.putInt(8194);
        }
        this.chartab.writeSectionInfo(writer, true, true);
        writer.putChar('\u0000');
        this.expansions.writeSectionInfo(writer, true, true);
        writer.putChar('\u0000');
        writer.putInt(this.chartab.getPosition());
        writer.putInt(0);
        if (this.sort.isMulti()) {
            writer.putInt(1);
            writer.putInt(this.sort.getMaxPage());
            this.srt7.writeSectionInfo(writer, true);
            writer.putChar('\u0000');
            writer.putInt(0);
            this.srt8.writeSectionInfo(writer, true);
            writer.putChar('\u0000');
            writer.putInt(0);
        }
    }

    public void setSort(Sort sort) {
        this.sort = sort;
        if (sort.isMulti()) {
            this.chartab.setPosition(92);
            this.chartab.setItemSize('\u0005');
            this.expansions.setItemSize('\u0004');
        }
    }

    public void endDescription(int position) {
        this.desc.setSize(position - this.desc.getPosition());
        this.subheader.setPosition(position);
    }

    public void endCharTable(int position) {
        this.chartab.setSize(position - this.chartab.getPosition());
    }

    public void endTab2(int postition) {
        this.subheader.setSize(postition - this.subheader.getPosition());
        this.expansions.setSize(postition - this.expansions.getPosition());
    }

    public void endSrt8(int position) {
        this.srt8.setSize(position - this.srt8.getPosition());
    }

    public void endSrt7(int position) {
        this.srt7.setSize(position - this.srt7.getPosition());
    }
}

