/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.trergn.MapValues;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class TREHeader
extends CommonHeader {
    private static final Logger log = Logger.getLogger(TREHeader.class);
    public static final int TRE_120 = 120;
    public static final int TRE_184 = 184;
    private static final int TRE_188 = 188;
    private static final int DEFAULT_HEADER_LEN = 188;
    private static final int DEFAULT_DISPLAY_PRIORITY = 25;
    static final int MAP_LEVEL_REC_SIZE = 4;
    private static final char POLYLINE_REC_LEN = '\u0002';
    private static final char POLYGON_REC_LEN = '\u0002';
    private static final char POINT_REC_LEN = '\u0003';
    private static final char COPYRIGHT_REC_SIZE = '\u0003';
    private static final char EXT_TYPE_OFFSETS_REC_LEN = '\r';
    private static final char EXT_TYPE_OVERVIEWS_REC_LEN = '\u0004';
    static final int SUBDIV_REC_SIZE = 14;
    static final int SUBDIV_REC_SIZE2 = 16;
    public static final int POI_FLAG_TRANSPARENT = 2;
    public static final int POI_FLAG_STREET_BEFORE_HOUSENUMBER = 4;
    public static final int POI_FLAG_POSTALCODE_BEFORE_CITY = 8;
    public static final int POI_FLAG_DRIVE_ON_LEFT = 32;
    private Area area = new Area(0, 0, 0, 0);
    private int mapInfoSize;
    private int mapLevelPos;
    private int mapLevelsSize;
    private int subdivPos;
    private int subdivSize;
    private byte poiDisplayFlags;
    private int displayPriority = 25;
    private final Section copyright = new Section('\u0003');
    private final Section polyline = new Section('\u0002');
    private final Section polygon = new Section('\u0002');
    private final Section points = new Section('\u0003');
    private final Section extTypeOffsets = new Section(this.points, '\r');
    private final Section extTypeOverviews = new Section(this.extTypeOffsets, '\u0004');
    private int numExtTypeAreaTypes;
    private int numExtTypeLineTypes;
    private int numExtTypePointTypes;
    private int mapId;

    public TREHeader() {
        super(188, "GARMIN TRE");
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        assert (reader.position() == 21L);
        int maxLat = reader.get3();
        int maxLon = reader.get3();
        int minLat = reader.get3();
        int minLon = reader.get3();
        if (maxLon < minLon && maxLon == -8388608) {
            maxLon = 0x800000;
        }
        this.setBounds(new Area(minLat, minLon, maxLat, maxLon));
        log.info("read area is", this.getBounds());
        this.mapLevelPos = reader.getInt();
        this.mapLevelsSize = reader.getInt();
        this.subdivPos = reader.getInt();
        this.subdivSize = reader.getInt();
        this.copyright.readSectionInfo(reader, true);
        reader.getInt();
        this.poiDisplayFlags = reader.get();
        this.displayPriority = reader.get3();
        reader.getInt();
        reader.getChar();
        reader.get();
        this.polyline.readSectionInfo(reader, true);
        reader.getInt();
        this.polygon.readSectionInfo(reader, true);
        reader.getInt();
        this.points.readSectionInfo(reader, true);
        reader.getInt();
        int mapInfoOff = this.mapLevelPos;
        if (this.subdivPos < mapInfoOff) {
            mapInfoOff = this.subdivPos;
        }
        if (this.copyright.getPosition() < mapInfoOff) {
            mapInfoOff = this.copyright.getPosition();
        }
        this.mapInfoSize = mapInfoOff - this.getHeaderLength();
        if (this.getHeaderLength() > 116) {
            reader.position(116L);
            this.mapId = reader.getInt();
        }
        if (this.getHeaderLength() > 120) {
            reader.getInt();
            this.extTypeOffsets.readSectionInfo(reader, true);
        }
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put3(this.area.getMaxLat());
        writer.put3(this.area.getMaxLong());
        writer.put3(this.area.getMinLat());
        writer.put3(this.area.getMinLong());
        writer.putInt(this.getMapLevelsPos());
        writer.putInt(this.getMapLevelsSize());
        writer.putInt(this.getSubdivPos());
        writer.putInt(this.getSubdivSize());
        this.copyright.writeSectionInfo(writer);
        writer.putInt(0);
        writer.put(this.getPoiDisplayFlags());
        writer.put3(this.displayPriority);
        writer.putInt(0x110301);
        writer.putChar('\u0001');
        writer.put((byte)0);
        this.polyline.writeSectionInfo(writer);
        writer.putInt(0);
        this.polygon.writeSectionInfo(writer);
        writer.putInt(0);
        this.points.writeSectionInfo(writer);
        writer.putInt(0);
        if (this.getHeaderLength() > 116) {
            writer.putInt(this.getMapId());
        }
        if (this.getHeaderLength() > 120) {
            writer.putInt(0);
            if (this.extTypeOffsets.getSize() == 0) {
                this.extTypeOffsets.setItemSize('\u0000');
            }
            this.extTypeOffsets.writeSectionInfo(writer, true);
            writer.putInt(1543);
            this.extTypeOverviews.writeSectionInfo(writer);
            writer.putChar((char)this.numExtTypeLineTypes);
            writer.putChar((char)this.numExtTypeAreaTypes);
            writer.putChar((char)this.numExtTypePointTypes);
        }
        if (this.getHeaderLength() > 154) {
            MapValues mv = new MapValues(this.mapId, this.getHeaderLength());
            mv.calculate();
            writer.putInt(mv.value(0));
            writer.putInt(mv.value(1));
            writer.putInt(mv.value(2));
            writer.putInt(mv.value(3));
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putChar('\u0000');
            writer.putInt(0);
        }
        writer.position(this.getHeaderLength());
    }

    public void config(EnhancedProperties props) {
        String key = "draw-priority";
        if (props.containsKey(key)) {
            this.setDisplayPriority(props.getProperty(key, 25));
        }
        if (props.containsKey("transparent")) {
            this.poiDisplayFlags = (byte)(this.poiDisplayFlags | 2);
        }
    }

    public void setBounds(Area area) {
        this.area = area;
    }

    public Area getBounds() {
        return this.area;
    }

    public void setMapId(int id) {
        this.mapId = id;
    }

    public void setDriveOnLeft(boolean dol) {
        if (dol) {
            this.poiDisplayFlags = (byte)(this.poiDisplayFlags | 0x20);
        }
    }

    public void addPoiDisplayFlags(byte poiDisplayFlags) {
        this.poiDisplayFlags = (byte)(this.poiDisplayFlags | poiDisplayFlags);
    }

    public int getMapInfoSize() {
        return this.mapInfoSize;
    }

    public void setMapInfoSize(int mapInfoSize) {
        this.mapInfoSize = mapInfoSize;
    }

    public int getMapLevelsPos() {
        return this.mapLevelPos;
    }

    public void setMapLevelPos(int mapLevelPos) {
        this.mapLevelPos = mapLevelPos;
    }

    public int getMapLevelsSize() {
        return this.mapLevelsSize;
    }

    public void setMapLevelsSize(int mapLevelsSize) {
        this.mapLevelsSize = mapLevelsSize;
    }

    public int getSubdivPos() {
        return this.subdivPos;
    }

    public void setSubdivPos(int subdivPos) {
        this.subdivPos = subdivPos;
    }

    public int getSubdivSize() {
        return this.subdivSize;
    }

    public void setSubdivSize(int subdivSize) {
        this.subdivSize = subdivSize;
    }

    public void setCopyrightPos(int copyrightPos) {
        this.copyright.setPosition(copyrightPos);
    }

    public void incCopyrightSize() {
        this.copyright.inc();
    }

    protected byte getPoiDisplayFlags() {
        return this.poiDisplayFlags;
    }

    public void setPolylinePos(int polylinePos) {
        this.polyline.setPosition(polylinePos);
    }

    public void incPolylineSize() {
        this.polyline.inc();
    }

    public void setPolygonPos(int polygonPos) {
        this.polygon.setPosition(polygonPos);
    }

    public void incPolygonSize() {
        this.polygon.inc();
    }

    public void setPointPos(int pointPos) {
        this.points.setPosition(pointPos);
    }

    public void incPointSize() {
        this.points.inc();
    }

    public void setExtTypeOffsetsPos(int pos) {
        this.extTypeOffsets.setPosition(pos);
    }

    public void incExtTypeOffsetsSize() {
        this.extTypeOffsets.inc();
    }

    public void setExtTypeOverviewsPos(int pos) {
        this.extTypeOverviews.setPosition(pos);
    }

    public void incExtTypeOverviewsSize() {
        this.extTypeOverviews.inc();
    }

    public void incNumExtTypeAreaTypes() {
        ++this.numExtTypeAreaTypes;
    }

    public void incNumExtTypeLineTypes() {
        ++this.numExtTypeLineTypes;
    }

    public void incNumExtTypePointTypes() {
        ++this.numExtTypePointTypes;
    }

    public int getMapId() {
        return this.mapId;
    }

    protected void setDisplayPriority(int displayPriority) {
        this.displayPriority = displayPriority;
    }

    public int getDisplayPriority() {
        return this.displayPriority;
    }

    public int getExtTypeOffsetsPos() {
        return this.extTypeOffsets.getPosition();
    }

    public int getExtTypeOffsetsSize() {
        return this.extTypeOffsets.getSize();
    }

    public int getExtTypeSectionSize() {
        return this.extTypeOffsets.getItemSize();
    }

    public Section getCopyrightSection() {
        return this.copyright;
    }
}

