/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mps;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.io.StructuredOutputStream;

public abstract class Block {
    private final int type;
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    protected Block(int type) {
        this.type = type;
    }

    public void write(ImgChannel chan) throws IOException {
        this.writeBody(new StructuredOutputStream(this.output));
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put((byte)this.type);
        char len = this.getLength();
        buf.putChar(len);
        buf.flip();
        chan.write(buf);
        buf = ByteBuffer.allocate(len);
        buf.put(this.output.toByteArray());
        buf.flip();
        chan.write(buf);
    }

    protected abstract void writeBody(StructuredOutputStream var1) throws IOException;

    private char getLength() {
        int len = this.output.toByteArray().length;
        assert (len <= 65535);
        return (char)len;
    }
}

