/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.TREFileReader;
import uk.me.parabola.imgfmt.app.trergn.TREHeader;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.FileKind;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.srt.SrtTextReader;

public class FileInfo {
    private static final Logger log = Logger.getLogger(FileInfo.class);
    private static final int ENTRY_SIZE = 240;
    private static final List<String> KNOWN_FILE_TYPE_EXT = Arrays.asList("TRE", "RGN", "LBL", "NET", "NOD", "TYP");
    private final String filename;
    private FileKind kind;
    private String mapname;
    private int hexname;
    private String innername;
    private String description;
    private int rgnsize;
    private int tresize;
    private int lblsize;
    private int netsize;
    private int nodsize;
    private final List<Integer> fileSizes = new ArrayList<Integer>();
    private String[] licenceInfo;
    private CommandArgs args;
    private String mpsName;
    private int codePage;
    private int sortOrderId;
    private Area bounds;

    private FileInfo(String filename, FileKind kind) {
        this.filename = filename;
        this.kind = kind;
    }

    public String getMapname() {
        return this.mapname;
    }

    protected void setMapname(String mapname) {
        this.mapname = mapname;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public int getRgnsize() {
        return this.rgnsize;
    }

    protected void setRgnsize(int rgnsize) {
        this.rgnsize = rgnsize;
    }

    public int getTresize() {
        return this.tresize;
    }

    protected void setTresize(int tresize) {
        this.tresize = tresize;
    }

    public int getLblsize() {
        return this.lblsize;
    }

    protected void setLblsize(int lblsize) {
        this.lblsize = lblsize;
    }

    public Area getBounds() {
        return this.bounds;
    }

    public static FileInfo getFileInfo(String inputName) throws FileNotFoundException {
        int end = inputName.length();
        String ext = inputName.substring(end - 3).toUpperCase(Locale.ENGLISH);
        FileInfo info = ext.equals("IMG") ? FileInfo.imgInfo(inputName) : ("TYP".equals(ext) ? FileInfo.fileInfo(inputName, FileKind.TYP_KIND) : (KNOWN_FILE_TYPE_EXT.contains(ext) ? FileInfo.fileInfo(inputName, FileKind.APP_KIND) : new FileInfo(inputName, FileKind.UNKNOWN_KIND)));
        return info;
    }

    private static FileInfo fileInfo(String inputName, FileKind kind) {
        FileInfo info = new FileInfo(inputName, kind);
        File f = new File(inputName);
        info.fileSizes.add((int)f.length());
        if (inputName.toLowerCase().endsWith(".lbl")) {
            FileInfo.lblInfo(inputName, info);
        } else if (inputName.toLowerCase().endsWith(".typ")) {
            FileInfo.typInfo(inputName, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void typInfo(String filename, FileInfo info) {
        FileImgChannel chan = new FileImgChannel(filename, "r");
        try {
            BufferedImgFileReader fr = new BufferedImgFileReader(chan);
            fr.position(21L);
            info.setCodePage(fr.getChar());
        }
        finally {
            Utils.closeFile(chan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileInfo imgInfo(String inputName) throws FileNotFoundException {
        try (FileSystem imgFs = ImgFS.openFs(inputName);){
            int dot;
            FileSystemParam params = imgFs.fsparam();
            log.info("Desc", params.getMapDescription());
            log.info("Blocksize", params.getBlockSize());
            FileInfo info = new FileInfo(inputName, FileKind.UNKNOWN_KIND);
            info.setDescription(params.getMapDescription());
            File f = new File(inputName);
            String name = f.getName();
            if (OverviewBuilder.isOverviewImg(name)) {
                name = OverviewBuilder.getMapName(name);
            }
            if ((dot = name.lastIndexOf(46)) < 0) {
                name = "0";
            } else {
                if (dot > name.length()) {
                    dot = name.length();
                }
                if (dot > 8) {
                    dot = 8;
                }
                name = name.substring(0, dot);
            }
            info.setMapname(name);
            boolean hasTre = false;
            List<DirectoryEntry> entries = imgFs.list();
            for (DirectoryEntry ent : entries) {
                if (ent.isSpecial()) continue;
                log.info("file", ent.getFullName());
                String ext = ent.getExt();
                if ("TRE".equals(ext)) {
                    info.setTresize(ent.getSize());
                    info.setInnername(ent.getName());
                    FileInfo.treInfo(imgFs, ent, info);
                    hasTre = true;
                } else if ("RGN".equals(ext)) {
                    int size = ent.getSize();
                    info.setRgnsize(size);
                } else if ("LBL".equals(ext)) {
                    info.setLblsize(ent.getSize());
                    FileInfo.lblInfo(imgFs, ent, info);
                } else if ("NET".equals(ext)) {
                    info.setNetsize(ent.getSize());
                } else if ("NOD".equals(ext)) {
                    info.setNodsize(ent.getSize());
                } else if ("MDR".equals(ext)) {
                    info.setKind(FileKind.MDR_KIND);
                } else if ("MPS".equals(ext)) {
                    info.setKind(FileKind.GMAPSUPP_KIND);
                    info.mpsName = ent.getFullName();
                }
                info.fileSizes.add(ent.getSize());
            }
            if (info.getKind() == FileKind.UNKNOWN_KIND && hasTre) {
                info.setKind(FileKind.IMG_KIND);
            }
            FileInfo fileInfo = info;
            return fileInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void treInfo(FileSystem imgFs, DirectoryEntry ent, FileInfo info) throws FileNotFoundException {
        TREFileReader treFile = null;
        try {
            ImgChannel treChan = imgFs.open(ent.getFullName(), "r");
            treFile = new TREFileReader(treChan);
            info.setBounds(treFile.getBounds());
            info.setLicenceInfo(treFile.getMapInfo());
            info.setHexname(((TREHeader)treFile.getHeader()).getMapId());
        }
        catch (Throwable throwable) {
            Utils.closeFile(treFile);
            throw throwable;
        }
        Utils.closeFile(treFile);
    }

    private static void lblInfo(FileSystem imgFs, DirectoryEntry ent, FileInfo info) throws FileNotFoundException {
        ImgChannel chan = imgFs.open(ent.getFullName(), "r");
        FileInfo.lblInfo(chan, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lblInfo(String filename, FileInfo info) {
        FileImgChannel r = new FileImgChannel(filename, "r");
        try {
            FileInfo.lblInfo(r, info);
        }
        finally {
            Utils.closeFile(r);
        }
    }

    private static void lblInfo(ImgChannel chan, FileInfo info) {
        LBLFileReader lblFile = new LBLFileReader(chan);
        info.setCodePage(lblFile.getCodePage());
        info.setSortOrderId(lblFile.getSortOrderId());
        lblFile.close();
    }

    private void setBounds(Area area) {
        this.bounds = area;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isImg() {
        return this.kind == FileKind.IMG_KIND;
    }

    protected void setKind(FileKind kind) {
        this.kind = kind;
    }

    public FileKind getKind() {
        return this.kind;
    }

    public int getNumHeaderEntries(int blockSize) {
        int totHeaderSlots = 0;
        for (int size : this.fileSizes) {
            int nblocks = (size + (blockSize - 1)) / blockSize;
            totHeaderSlots += (nblocks + 239) / 240;
        }
        return totHeaderSlots;
    }

    public int getNumBlocks(int bs) {
        int totBlocks = 0;
        for (int size : this.fileSizes) {
            int nblocks = (size + (bs - 1)) / bs;
            totBlocks += nblocks;
        }
        return totBlocks;
    }

    public int getMapnameAsInt() {
        try {
            return Integer.valueOf(this.mapname);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void setLicenceInfo(String[] info) {
        this.licenceInfo = info;
    }

    public String[] getLicenseInfo() {
        return this.licenceInfo;
    }

    public int getNetsize() {
        return this.netsize;
    }

    protected void setNetsize(int netsize) {
        this.netsize = netsize;
    }

    public int getNodsize() {
        return this.nodsize;
    }

    protected void setNodsize(int nodsize) {
        this.nodsize = nodsize;
    }

    public void setArgs(CommandArgs args) {
        this.args = args;
    }

    public String getFamilyName() {
        return this.args.get("family-name", "family name");
    }

    public String getSeriesName() {
        return this.args.get("series-name", "series name");
    }

    public int getFamilyId() {
        return this.args.get("family-id", 6324);
    }

    public int getProductId() {
        return this.args.get("product-id", 1);
    }

    public Sort getSort() {
        Sort sort = SrtTextReader.sortForCodepage(this.codePage);
        if (sort == null) {
            sort = this.args.getSort();
        }
        sort.setSortOrderId(this.sortOrderId);
        return sort;
    }

    public String getOutputDir() {
        return this.args.getOutputDir();
    }

    public String getMpsName() {
        return this.mpsName;
    }

    public String getInnername() {
        return this.innername;
    }

    public void setInnername(String name) {
        this.innername = name;
    }

    public void setHexname(int hexname) {
        this.hexname = hexname;
    }

    public int getHexname() {
        return this.hexname;
    }

    public int getCodePage() {
        return this.codePage;
    }

    public void setCodePage(int codePage) {
        this.codePage = codePage;
    }

    public void setSortOrderId(int sortOrderId) {
        this.sortOrderId = sortOrderId;
    }

    public boolean hasSortOrder() {
        return this.sortOrderId != 0;
    }
}

