/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;

public class PreserveHorizontalAndVerticalLinesFilter
implements MapFilter {
    private int shift;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        MapLine line = (MapLine)element;
        if (this.shift != 0) {
            Coord first;
            int minLat = line.getBounds().getMinLat();
            int maxLat = line.getBounds().getMaxLat();
            int minLon = line.getBounds().getMinLong();
            int maxLon = line.getBounds().getMaxLong();
            List<Coord> points = line.getPoints();
            Coord prev = first = points.get(0);
            Coord last = first;
            for (int i = 1; i < points.size(); ++i) {
                last = points.get(i);
                if (last.getLatitude() == prev.getLatitude() && (last.getLatitude() == minLat || last.getLatitude() == maxLat) || last.getLongitude() == prev.getLongitude() && (last.getLongitude() == minLon || last.getLongitude() == maxLon)) {
                    last.preserved(true);
                    prev.preserved(true);
                }
                prev = last;
            }
        }
        next.doFilter(line);
    }
}

