/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.LocatorConfig;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.filters.LineSizeSplitterFilter;
import uk.me.parabola.mkgmap.general.AreaClipper;
import uk.me.parabola.mkgmap.general.Clipper;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapExitPoint;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.osmstyle.RoadMerger;
import uk.me.parabola.mkgmap.osmstyle.WrongAngleFixer;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class StyledConverter
implements OsmConverter {
    private static final Logger log = Logger.getLogger(StyledConverter.class);
    private static final Logger roadLog = Logger.getLogger(StyledConverter.class.getName() + ".roads");
    private final ShortArrayList nameTagList;
    private final MapCollector collector;
    private Clipper clipper = Clipper.NULL_CLIPPER;
    private Area bbox = new Area(-90.0, -180.0, 90.0, 180.0);
    private final List<RestrictionRelation> restrictions = new ArrayList<RestrictionRelation>();
    private final MultiHashMap<Long, RestrictionRelation> wayRelMap = new MultiHashMap();
    private Map<Node, List<Way>> poiRestrictions = new LinkedHashMap<Node, List<Way>>();
    private final List<Relation> throughRouteRelations = new ArrayList<Relation>();
    private static final int MAX_LINE_LENGTH = 40000;
    private static final int MAX_ARC_LENGTH = 20450000;
    private static final int MAX_NODES_IN_WAY = 64;
    private IdentityHashMap<Coord, CoordNode> nodeIdMap = new IdentityHashMap();
    public static final String WAY_POI_NODE_IDS = "mkgmap:way-poi-node-ids";
    private final HashMap<Integer, Map<String, MapPoint>> pointMap;
    private List<ConvertedWay> roads = new ArrayList<ConvertedWay>();
    private List<ConvertedWay> lines = new ArrayList<ConvertedWay>();
    private HashMap<Long, ConvertedWay> modifiedRoads = new HashMap();
    private HashSet<Long> deletedRoads = new HashSet();
    private int nextNodeId = 1;
    private int nextRoadId = 1;
    private HousenumberGenerator housenumberGenerator;
    private final Rule wayRules;
    private final Rule nodeRules;
    private final Rule lineRules;
    private final Rule polygonRules;
    private Style style;
    private String driveOn;
    private Boolean driveOnLeft;
    private int numDriveOnLeftRoads;
    private int numDriveOnRightRoads;
    private int numDriveOnSideUnknown;
    private int numRoads;
    private String countryAbbr;
    private final boolean checkRoundabouts;
    private int reportDeadEnds;
    private final boolean linkPOIsToWays;
    private final boolean mergeRoads;
    private final boolean routable;
    private LineAdder lineAdder = new LineAdder(){

        @Override
        public void add(MapLine element) {
            if (element instanceof MapRoad) {
                StyledConverter.this.collector.addRoad((MapRoad)element);
            } else {
                StyledConverter.this.collector.addLine(element);
            }
        }
    };
    private final WayTypeResult wayTypeResult = new WayTypeResult();
    private static final short styleFilterTagKey = TagDict.getInstance().xlate("mkgmap:stylefilter");
    private static final short makeCycleWayTagKey = TagDict.getInstance().xlate("mkgmap:make-cycle-way");
    private long lastRoadId = 0L;
    private int lineCacheId = 0;
    private BitSet routingWarningWasPrinted = new BitSet();
    private int lineIndex = 0;
    private static final short onewayTagKey = TagDict.getInstance().xlate("oneway");
    private NodeTypeResult nodeTypeResult = new NodeTypeResult();
    private static final short nameTagKey = TagDict.getInstance().xlate("name");
    private static final short[] labelTagKeys = new short[]{TagDict.getInstance().xlate("mkgmap:label:1"), TagDict.getInstance().xlate("mkgmap:label:2"), TagDict.getInstance().xlate("mkgmap:label:3"), TagDict.getInstance().xlate("mkgmap:label:4")};
    private static final short highResOnlyTagKey = TagDict.getInstance().xlate("mkgmap:highest-resolution-only");
    private static final short skipSizeFilterTagKey = TagDict.getInstance().xlate("mkgmap:skipSizeFilter");
    private static final short countryTagKey = TagDict.getInstance().xlate("mkgmap:country");
    private static final short regionTagKey = TagDict.getInstance().xlate("mkgmap:region");
    private static final short cityTagKey = TagDict.getInstance().xlate("mkgmap:city");
    private static final short postal_codeTagKey = TagDict.getInstance().xlate("mkgmap:postal_code");
    private static final short streetTagKey = TagDict.getInstance().xlate("mkgmap:street");
    private static final short housenumberTagKey = TagDict.getInstance().xlate("mkgmap:housenumber");
    private static final short phoneTagKey = TagDict.getInstance().xlate("mkgmap:phone");
    private static final short is_inTagKey = TagDict.getInstance().xlate("mkgmap:is_in");

    public StyledConverter(Style style, MapCollector collector, EnhancedProperties props) {
        this.collector = collector;
        List<String> nameTags = LocatorUtil.getNameTags(props);
        if (nameTags != null) {
            this.nameTagList = new ShortArrayList();
            for (String n : nameTags) {
                this.nameTagList.add(TagDict.getInstance().xlate(n));
            }
        } else {
            this.nameTagList = null;
        }
        this.style = style;
        this.pointMap = new HashMap();
        this.wayRules = style.getWayRules();
        this.nodeRules = style.getNodeRules();
        this.lineRules = style.getLineRules();
        this.polygonRules = style.getPolygonRules();
        this.housenumberGenerator = new HousenumberGenerator(props);
        this.driveOn = props.getProperty("drive-on", null);
        if (this.driveOn == null) {
            this.driveOn = "detect,right";
        }
        switch (this.driveOn) {
            case "left": {
                this.driveOnLeft = true;
                break;
            }
            case "right": {
                this.driveOnLeft = false;
                break;
            }
            case "detect": 
            case "detect,left": 
            case "detect,right": {
                break;
            }
            default: {
                throw new ExitException("invalid parameters for option drive-on:" + this.driveOn);
            }
        }
        this.countryAbbr = props.getProperty("country-abbr", null);
        if (this.countryAbbr != null) {
            this.countryAbbr = this.countryAbbr.toUpperCase();
        }
        this.checkRoundabouts = props.getProperty("check-roundabouts", false);
        this.reportDeadEnds = props.getProperty("report-dead-ends", 1);
        LineAdder overlayAdder = style.getOverlays(this.lineAdder);
        if (overlayAdder != null) {
            this.lineAdder = overlayAdder;
        }
        this.linkPOIsToWays = props.getProperty("link-pois-to-ways", false);
        this.mergeRoads = !props.getProperty("no-mergeroads", false);
        this.routable = props.containsKey("route");
    }

    @Override
    public void convertWay(Way way) {
        Rule rules;
        if (way.getPoints().size() < 2 || way.getTagCount() == 0) {
            this.removeRestrictionsWithWay(Level.WARNING, way, "is ignored");
            return;
        }
        this.preConvertRules(way);
        String styleFilterTag = way.getTag(styleFilterTagKey);
        if ("polyline".equals(styleFilterTag)) {
            rules = this.lineRules;
        } else if ("polygon".equals(styleFilterTag)) {
            rules = this.polygonRules;
        } else {
            if (way.isClosedInOSM() && !way.isComplete() && !way.hasIdenticalEndPoints()) {
                way.getPoints().add(way.getPoints().get(0));
            }
            rules = !way.hasIdenticalEndPoints() || way.getPoints().size() < 4 ? this.lineRules : this.wayRules;
        }
        Way cycleWay = null;
        String cycleWayTag = way.getTag(makeCycleWayTagKey);
        if ("yes".equals(cycleWayTag)) {
            way.deleteTag("mkgmap:make-cycle-way");
            cycleWay = StyledConverter.makeCycleWay(way);
            way.addTag("bicycle", "no");
        }
        this.wayTypeResult.setWay(way);
        this.lineCacheId = rules.resolveType(this.lineCacheId, way, this.wayTypeResult);
        if (!this.wayTypeResult.isMatched()) {
            this.housenumberGenerator.addWay(way);
        }
        if (cycleWay != null) {
            this.wayTypeResult.setWay(cycleWay);
            this.lineCacheId = rules.resolveType(this.lineCacheId, cycleWay, this.wayTypeResult);
            if (!this.wayTypeResult.isMatched()) {
                this.housenumberGenerator.addWay(cycleWay);
            }
        }
        if (this.lastRoadId != way.getId()) {
            this.removeRestrictionsWithWay(Level.WARNING, way, "is not routable");
        } else {
            ConvertedWay cw;
            for (int i = this.lines.size() - 1; i >= 0 && (cw = this.lines.get(i)).getWay().getId() == way.getId(); --i) {
                cw.setOverlay(true);
                int lineType = cw.getGType().getType();
                if (!GType.isSpecialRoutableLineType(lineType) || cw.getGType().getMinLevel() != 0 || this.routingWarningWasPrinted.get(lineType)) continue;
                log.error("routable type", GType.formatType(cw.getGType().getType()), "is used with a non-routable way which was also added as a routable way. This leads to routing errors.", "Try --check-styles to check the style.");
                this.routingWarningWasPrinted.set(lineType);
            }
        }
    }

    private void addConvertedWay(Way way, GType foundType) {
        if (foundType.getFeatureKind() == FeatureKind.POLYGON) {
            this.addShape(way, foundType);
            return;
        }
        boolean wasReversed = false;
        String oneWay = way.getTag(onewayTagKey);
        if (oneWay != null) {
            if ("-1".equals(oneWay) || "reverse".equals(oneWay)) {
                way.reverse();
                wasReversed = true;
                way.addTag(onewayTagKey, "yes");
            }
            if (way.tagIsLikeYes(onewayTagKey)) {
                way.addTag(onewayTagKey, "yes");
                if (foundType.isRoad() && StyledConverter.checkFixmeCoords(way)) {
                    way.addTag("mkgmap:dead-end-check", "false");
                }
            } else {
                way.deleteTag(onewayTagKey);
            }
        }
        ConvertedWay cw = new ConvertedWay(this.lineIndex++, way, foundType);
        cw.setReversed(wasReversed);
        if (cw.isRoad()) {
            this.roads.add(cw);
            ++this.numRoads;
            if (!cw.isFerry()) {
                String country = way.getTag(countryTagKey);
                if (country != null) {
                    boolean drivingSideIsLeft = LocatorConfig.get().getDriveOnLeftFlag(country);
                    if (drivingSideIsLeft) {
                        ++this.numDriveOnLeftRoads;
                    } else {
                        ++this.numDriveOnRightRoads;
                    }
                    if (this.driveOnLeft != null && drivingSideIsLeft != this.driveOnLeft) {
                        log.warn("wrong driving side", way.toBrowseURL());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("assumed driving side is", drivingSideIsLeft ? "left" : "right", way.toBrowseURL());
                    }
                } else {
                    ++this.numDriveOnSideUnknown;
                }
            }
            if (cw.isRoundabout() && wasReversed) {
                log.warn("Roundabout", way.getId(), "has reverse oneway tag (" + way.getPoints().get(0).toOSMURL() + ")");
            }
            this.lastRoadId = way.getId();
        } else {
            this.lines.add(cw);
        }
    }

    @Override
    public void convertNode(Node node) {
        if (node.getTagCount() == 0) {
            return;
        }
        this.preConvertRules(node);
        this.nodeTypeResult.setNode(node);
        this.nodeRules.resolveType(node, this.nodeTypeResult);
        if (!this.nodeTypeResult.isMatched()) {
            this.housenumberGenerator.addNode(node);
        }
    }

    private void preConvertRules(Element el) {
        if (this.nameTagList == null) {
            return;
        }
        Iterator i$ = this.nameTagList.iterator();
        while (i$.hasNext()) {
            short tagKey = (Short)i$.next();
            String val = el.getTag(tagKey);
            if (val == null) continue;
            if (tagKey == nameTagKey) break;
            el.addTag(nameTagKey, val);
            break;
        }
    }

    private static Way makeCycleWay(Way way) {
        Way cycleWay = new Way(way.getId(), way.getPoints());
        cycleWay.copyTags(way);
        cycleWay.addTag("access", "no");
        cycleWay.addTag("bicycle", "yes");
        cycleWay.addTag("mkgmap:synthesised", "yes");
        cycleWay.addTag(onewayTagKey, "no");
        cycleWay.deleteTag("foot");
        cycleWay.deleteTag("motorcar");
        cycleWay.deleteTag("goods");
        cycleWay.deleteTag("hgv");
        cycleWay.deleteTag("bus");
        cycleWay.deleteTag("taxi");
        cycleWay.deleteTag("emergency");
        cycleWay.deleteTag("vehicle");
        cycleWay.deleteTag("motor_vehicle");
        cycleWay.deleteTag("carpool");
        cycleWay.deleteTag("motorcycle");
        cycleWay.deleteTag("psv");
        cycleWay.deleteTag("truck");
        return cycleWay;
    }

    private static void postConvertRules(Element el, GType type) {
        if (type.getDefaultName() != null && el.getName() == null) {
            el.addTag("mkgmap:label:1", type.getDefaultName());
        }
    }

    @Override
    public void setBoundingBox(Area bbox) {
        this.clipper = new AreaClipper(bbox);
        this.bbox = bbox;
        this.collector.addToBounds(new Coord(bbox.getMinLat(), bbox.getMinLong()));
        this.collector.addToBounds(new Coord(bbox.getMaxLat(), bbox.getMaxLong()));
    }

    private void removeRestrictionsWithWay(Level logLevel, Way way, String reason) {
        Object rrList = this.wayRelMap.get(way.getId());
        Iterator i$ = rrList.iterator();
        while (i$.hasNext()) {
            RestrictionRelation rr = (RestrictionRelation)i$.next();
            if (rr.isValidWithoputWay(way.getId())) continue;
            if (log.isLoggable(logLevel)) {
                log.log(logLevel, "restriction", rr.toBrowseURL(), " is ignored because referenced way", way.toBrowseURL(), reason);
            }
            this.restrictions.remove(rr);
        }
    }

    private void mergeRoads() {
        if (!this.mergeRoads) {
            log.info((Object)"Merging roads is disabled");
            return;
        }
        RoadMerger merger = new RoadMerger();
        this.roads = merger.merge(this.roads, this.restrictions, this.throughRouteRelations);
    }

    @Override
    public void end() {
        this.pointMap.clear();
        this.style.reportStats();
        this.driveOnLeft = this.calcDrivingSide();
        this.setHighwayCounts();
        this.findUnconnectedRoads();
        this.rotateClosedWaysToFirstNode();
        this.filterCoordPOI();
        WrongAngleFixer wrongAngleFixer = new WrongAngleFixer(this.bbox);
        wrongAngleFixer.optimizeWays(this.roads, this.lines, this.modifiedRoads, this.deletedRoads, this.restrictions);
        for (ConvertedWay line : this.lines) {
            ConvertedWay modWay;
            if (!line.isValid()) continue;
            Way way = line.getWay();
            if (this.deletedRoads.contains(way.getId())) {
                line.getPoints().clear();
                continue;
            }
            if (!line.isOverlay() || (modWay = this.modifiedRoads.get(way.getId())) == null) continue;
            List<Coord> points = line.getPoints();
            points.clear();
            points.addAll(modWay.getPoints());
            if (modWay.isReversed() == line.isReversed()) continue;
            Collections.reverse(points);
        }
        for (Long wayId : this.deletedRoads) {
            if (!this.wayRelMap.containsKey(wayId)) continue;
            log.warn("Way that is used in valid restriction relation was removed, id:", wayId);
        }
        this.deletedRoads = null;
        this.modifiedRoads = null;
        this.mergeRoads();
        this.resetHighwayCounts();
        this.setHighwayCounts();
        for (ConvertedWay cw : this.lines) {
            if (!cw.isValid()) continue;
            this.addLine(cw.getWay(), cw.getGType());
        }
        this.lines = null;
        if (roadLog.isInfoEnabled()) {
            roadLog.info((Object)"Flags: oneway,no-emergency, no-delivery, no-throughroute, no-truck, no-bike, no-foot, carpool, no-taxi, no-bus, no-car");
            roadLog.info((Object)String.format("%19s %4s %11s %6s %s", "Road-OSM-Id", "Type", "Flags", "Points", "Labels"));
        }
        for (ConvertedWay cw : this.roads) {
            if (!cw.isValid()) continue;
            this.addRoad(cw);
        }
        this.housenumberGenerator.generate(this.lineAdder, this.nextNodeId);
        this.housenumberGenerator = null;
        if (this.routable) {
            this.createRouteRestrictionsFromPOI();
        }
        this.poiRestrictions = null;
        if (this.routable) {
            for (RestrictionRelation rr : this.restrictions) {
                rr.addRestriction(this.collector, this.nodeIdMap);
            }
        }
        this.roads = null;
        if (this.routable) {
            for (Relation relation : this.throughRouteRelations) {
                Node node = null;
                Way w1 = null;
                Way w2 = null;
                for (Map.Entry<String, Element> member : relation.getElements()) {
                    if (member.getValue() instanceof Node) {
                        if (node == null) {
                            node = (Node)member.getValue();
                            continue;
                        }
                        log.warn("Through route relation", relation.toBrowseURL(), "has more than 1 node");
                        continue;
                    }
                    if (!(member.getValue() instanceof Way)) continue;
                    Way w = (Way)member.getValue();
                    if (w1 == null) {
                        w1 = w;
                        continue;
                    }
                    if (w2 == null) {
                        w2 = w;
                        continue;
                    }
                    log.warn("Through route relation", relation.toBrowseURL(), "has more than 2 ways");
                }
                CoordNode coordNode = null;
                if (node == null) {
                    log.warn("Through route relation", relation.toBrowseURL(), "is missing the junction node");
                } else {
                    Coord junctionPoint = node.getLocation();
                    if (this.bbox != null && !this.bbox.contains(junctionPoint)) continue;
                    coordNode = this.nodeIdMap.get(junctionPoint);
                    if (coordNode == null) {
                        log.warn("Through route relation", relation.toBrowseURL(), "junction node at", junctionPoint.toOSMURL(), "is not a routing node");
                    }
                }
                if (w1 == null || w2 == null) {
                    log.warn("Through route relation", relation.toBrowseURL(), "should reference 2 ways that meet at the junction node");
                }
                if (coordNode == null || w1 == null || w2 == null) continue;
                this.collector.addThroughRoute(coordNode.getId(), w1.getId(), w2.getId());
            }
        }
        this.nodeIdMap = null;
        this.throughRouteRelations.clear();
        this.restrictions.clear();
    }

    private Boolean calcDrivingSide() {
        Boolean dol = null;
        log.info("Found", this.numRoads, "roads", this.numDriveOnLeftRoads, "in drive-on-left country,", this.numDriveOnRightRoads, "in drive-on-right country, and", this.numDriveOnSideUnknown, " with unknwon country");
        if (this.numDriveOnLeftRoads > 0 && this.numDriveOnRightRoads > 0) {
            log.error((Object)("Attention: Tile contains both drive-on-left (" + this.numDriveOnLeftRoads + ") and drive-on-right roads (" + this.numDriveOnRightRoads + ")"));
        }
        if (this.driveOn.startsWith("detect")) {
            if ((double)this.numDriveOnSideUnknown > (double)this.numRoads * 0.05) {
                log.warn("Found", this.numDriveOnSideUnknown, "roads with unknown country and driving side");
            }
            dol = this.numDriveOnLeftRoads > this.numDriveOnRightRoads + this.numDriveOnSideUnknown ? Boolean.valueOf(true) : (this.numDriveOnRightRoads > this.numDriveOnLeftRoads + this.numDriveOnSideUnknown ? Boolean.valueOf(false) : (this.driveOn.endsWith("left") ? Boolean.valueOf(true) : Boolean.valueOf(false)));
            log.info("detected value for driving on left flag is:", dol);
        } else {
            dol = "left".equals(this.driveOn);
            if ("left".equals(this.driveOn) && this.numDriveOnLeftRoads == 0 && this.numDriveOnRightRoads > 0) {
                log.warn((Object)"The drive-on-left flag is set but tile contains only drive-on-right roads");
            }
            if ("right".equals(this.driveOn) && this.numDriveOnRightRoads == 0 && this.numDriveOnLeftRoads > 0) {
                log.warn((Object)"The drive-on-left flag is NOT set used but tile contains only drive-on-left roads");
            }
        }
        if (dol == null) {
            dol = false;
        }
        return dol;
    }

    private void rotateClosedWaysToFirstNode() {
        block0: for (ConvertedWay cw : this.roads) {
            Coord p0;
            Way way;
            List<Coord> points;
            if (!cw.isValid() || (points = (way = cw.getWay()).getPoints()).size() < 3 || points.get(0) != points.get(points.size() - 1) || (p0 = points.get(0)).getHighwayCount() > 2) continue;
            for (int i = 1; i < points.size() - 1; ++i) {
                Coord p = points.get(i);
                if (p.getHighwayCount() <= 1) continue;
                p.incHighwayCount();
                points.remove(points.size() - 1);
                p0.decHighwayCount();
                Collections.rotate(points, -i);
                points.add(points.get(0));
                this.modifiedRoads.put(way.getId(), cw);
                continue block0;
            }
        }
    }

    private void checkRoundabout(ConvertedWay cw) {
        if (!cw.isRoundabout()) {
            return;
        }
        Way way = cw.getWay();
        List<Coord> points = way.getPoints();
        if (this.checkRoundabouts && points.size() > 2 && !way.tagIsLikeYes("mkgmap:no-dir-check") && !way.tagIsLikeNo("mkgmap:dir-check")) {
            Coord centre = way.getCofG();
            int dir = 0;
            int i = 0;
            while (i + 1 < points.size()) {
                Coord pi = points.get(i);
                Coord pi1 = points.get(i + 1);
                if (pi.distance(centre) > 2.5 && pi.distance(pi1) > 2.5) {
                    double b;
                    double a = pi.bearingTo(pi1);
                    for (b = pi.bearingTo(centre) - a; b > 180.0; b -= 360.0) {
                    }
                    while (b < -180.0) {
                        b += 360.0;
                    }
                    if (b >= 15.0 && b < 165.0) {
                        ++dir;
                    } else if (b <= -15.0 && b > -165.0) {
                        --dir;
                    }
                }
                i += 3;
            }
            if (dir == 0) {
                log.info((Object)("Roundabout segment " + way.getId() + " direction unknown (see " + points.get(0).toOSMURL() + ")"));
            } else {
                boolean clockwise;
                boolean bl = clockwise = dir > 0;
                if (points.get(0) == points.get(points.size() - 1)) {
                    if (this.driveOnLeft.booleanValue() && !clockwise || !this.driveOnLeft.booleanValue() && clockwise) {
                        log.warn((Object)("Roundabout " + way.getId() + " direction is wrong - reversing it (see " + centre.toOSMURL() + ")"));
                        way.reverse();
                    }
                } else if (this.driveOnLeft.booleanValue() && !clockwise || !this.driveOnLeft.booleanValue() && clockwise) {
                    log.warn((Object)("Roundabout segment " + way.getId() + " direction looks wrong (see " + points.get(0).toOSMURL() + ")"));
                }
            }
        }
    }

    private void createRouteRestrictionsFromPOI() {
        for (Map.Entry<Node, List<Way>> entry : this.poiRestrictions.entrySet()) {
            Node node = entry.getKey();
            Coord p = node.getLocation();
            List<Way> wayList = entry.getValue();
            byte exceptMask = AccessTagsAndBits.evalAccessTags(node);
            LinkedHashMap<Integer, CoordNode> otherNodeIds = new LinkedHashMap<Integer, CoordNode>();
            CoordNode viaNode = null;
            boolean viaIsUnique = true;
            for (Way way : wayList) {
                CoordNode lastNode = null;
                for (Coord co : way.getPoints()) {
                    if (!(co instanceof CoordNode)) continue;
                    CoordNode cn = (CoordNode)co;
                    if (p.highPrecEquals(cn)) {
                        if (viaNode == null) {
                            viaNode = cn;
                        } else if (viaNode != cn) {
                            log.error((Object)("Found multiple points with equal coords as CoordPOI at " + p.toOSMURL()));
                            viaIsUnique = false;
                        }
                        if (lastNode != null) {
                            otherNodeIds.put(lastNode.getId(), lastNode);
                        }
                    } else if (p.highPrecEquals(lastNode)) {
                        otherNodeIds.put(cn.getId(), cn);
                    }
                    lastNode = cn;
                }
            }
            if (viaNode == null) {
                log.error((Object)("Did not find CoordPOI node at " + p.toOSMURL() + " in ways " + wayList));
                continue;
            }
            if (!viaIsUnique) {
                log.error((Object)("Found multiple points with equal coords as CoordPOI at " + p.toOSMURL()));
                continue;
            }
            if (otherNodeIds.size() < 2) {
                log.info((Object)("Access restriction in POI node " + node.toBrowseURL() + " was ignored, has no effect on any connected way"));
                continue;
            }
            GeneralRouteRestriction rr = new GeneralRouteRestriction("no_through", exceptMask, "CoordPOI at " + p.toOSMURL());
            rr.setViaNodes(Arrays.asList(viaNode));
            int added = this.collector.addRestriction(rr);
            if (added == 0) {
                log.info((Object)("Access restriction in POI node " + node.toBrowseURL() + " was ignored, has no effect on any connected way"));
            } else {
                log.info("Access restriction in POI node", node.toBrowseURL(), "was translated to", added, "route restriction(s)");
            }
            if (wayList.size() <= 1 || added <= 2) continue;
            log.warn("Access restriction in POI node", node.toBrowseURL(), "affects routing on multiple ways");
        }
    }

    @Override
    public void convertRelation(Relation relation) {
        if (relation.getTagCount() == 0) {
            return;
        }
        this.housenumberGenerator.addRelation(relation);
        if (relation instanceof RestrictionRelation) {
            RestrictionRelation rr = (RestrictionRelation)relation;
            if (rr.isValid()) {
                this.restrictions.add(rr);
                for (long id : rr.getWayIds()) {
                    this.wayRelMap.add(id, rr);
                }
            }
        } else if ("through_route".equals(relation.getTag("type"))) {
            this.throughRouteRelations.add(relation);
        }
    }

    private void addLine(Way way, GType gt) {
        this.addLine(way, gt, -1);
    }

    private void addLine(Way way, GType gt, int replType) {
        List<Coord> wayPoints = way.getPoints();
        ArrayList<Coord> points = new ArrayList<Coord>(wayPoints.size());
        double lineLength = 0.0;
        Coord lastP = null;
        for (Coord p : wayPoints) {
            if (p.highPrecEquals(lastP)) continue;
            points.add(p);
            if (lastP != null && (lineLength += p.distance(lastP)) >= 40000.0) {
                if (log.isInfoEnabled()) {
                    log.info("Splitting line", way.toBrowseURL(), "at", p.toOSMURL(), "to limit its length to", (long)lineLength + "m");
                }
                this.addLine(way, gt, replType, points);
                points = new ArrayList(wayPoints.size() - points.size() + 1);
                points.add(p);
                lineLength = 0.0;
            }
            lastP = p;
        }
        if (points.size() > 1) {
            this.addLine(way, gt, replType, points);
        }
    }

    private void addLine(Way way, GType gt, int replType, List<Coord> points) {
        MapLine line = new MapLine();
        StyledConverter.elementSetup(line, gt, way);
        if (replType >= 0) {
            line.setType(replType);
        }
        line.setPoints(points);
        if (way.tagIsLikeYes(onewayTagKey)) {
            line.setDirection(true);
        }
        this.clipper.clipLine(line, this.lineAdder);
    }

    private void addShape(Way way, GType gt) {
        if (!way.hasIdenticalEndPoints() && way.hasEqualEndPoints()) {
            log.error((Object)("shape is not closed with identical points " + way.getId()));
        }
        if (!way.hasIdenticalEndPoints()) {
            return;
        }
        MapShape shape = new MapShape(way.getId());
        StyledConverter.elementSetup(shape, gt, way);
        shape.setPoints(way.getPoints());
        this.clipper.clipShape(shape, this.collector);
    }

    private void addPoint(Node node, GType gt) {
        MapPoint mp;
        if (!this.clipper.contains(node.getLocation())) {
            return;
        }
        int type = gt.getType();
        if (type >= 8192 && type < 10240) {
            String ref = node.getTag("exit:road_ref");
            String id = node.getTag("mkgmap:osmid");
            if (ref != null) {
                String to = node.getTag("exit:to");
                MapExitPoint mep = new MapExitPoint(ref, to);
                String fd = node.getTag("exit:facility");
                if (fd != null) {
                    mep.setFacilityDescription(fd);
                }
                if (id != null) {
                    mep.setOSMId(id);
                }
                mp = mep;
            } else {
                mp = new MapPoint();
                if ("motorway_junction".equals(node.getTag("highway"))) {
                    log.warn("Motorway exit", node.getName(), "(" + node.toBrowseURL() + ") has no (motorway) ref! (either make the exit share a node with the motorway or specify the motorway ref with a", "exit:road_ref", "tag)");
                }
            }
        } else {
            mp = new MapPoint();
        }
        StyledConverter.elementSetup(mp, gt, node);
        mp.setLocation(node.getLocation());
        boolean dupPOI = this.checkDuplicatePOI(mp);
        if (dupPOI) {
            if (log.isInfoEnabled()) {
                if (FakeIdGenerator.isFakeId(node.getId())) {
                    log.info("ignmoring duplicate POI with type", GType.formatType(type), mp.getName(), "for generated element with id", node.getId(), "at", mp.getLocation().toDegreeString());
                } else {
                    log.info("ignmoring duplicate POI with type", GType.formatType(type), mp.getName(), "for element", node.toBrowseURL());
                }
            }
            return;
        }
        this.collector.addPoint(mp);
    }

    private boolean checkDuplicatePOI(MapPoint mp) {
        MapPoint old;
        Map<String, MapPoint> typeMap = this.pointMap.get(mp.getType());
        if (typeMap == null) {
            typeMap = new HashMap<String, MapPoint>();
            this.pointMap.put(mp.getType(), typeMap);
        }
        if ((old = typeMap.get(mp.getName())) == null) {
            typeMap.put(mp.getName(), mp);
        } else if (old.getLocation().equals(mp.getLocation())) {
            return true;
        }
        return false;
    }

    private static void elementSetup(MapElement ms, GType gt, Element element) {
        String[] labels = new String[4];
        int noLabels = 0;
        for (int labelNo = 0; labelNo < 4; ++labelNo) {
            String label1 = element.getTag(labelTagKeys[labelNo]);
            String label = Label.squashSpaces(label1);
            if (label == null) continue;
            labels[noLabels] = label;
            ++noLabels;
        }
        if (labels[0] != null) {
            ms.setLabels(labels);
        }
        ms.setType(gt.getType());
        ms.setMinResolution(gt.getMinResolution());
        ms.setMaxResolution(gt.getMaxResolution());
        if (element.tagIsLikeYes(highResOnlyTagKey)) {
            ms.setMinResolution(ms.getMaxResolution());
        }
        if (ms instanceof MapLine && element.tagIsLikeYes(skipSizeFilterTagKey)) {
            ((MapLine)ms).setSkipSizeFilter(true);
        }
        String country = element.getTag(countryTagKey);
        String region = element.getTag(regionTagKey);
        String city = element.getTag(cityTagKey);
        String zip = element.getTag(postal_codeTagKey);
        String street = element.getTag(streetTagKey);
        String houseNumber = element.getTag(housenumberTagKey);
        String phone = element.getTag(phoneTagKey);
        String isIn = element.getTag(is_inTagKey);
        if (country != null) {
            ms.setCountry(country);
        }
        if (region != null) {
            ms.setRegion(region);
        }
        if (city != null) {
            ms.setCity(city);
        }
        if (zip != null) {
            ms.setZip(zip);
        }
        if (street != null) {
            ms.setStreet(street);
        }
        if (houseNumber != null) {
            ms.setHouseNumber(houseNumber);
        }
        if (isIn != null) {
            ms.setIsIn(isIn);
        }
        if (phone != null) {
            ms.setPhone(phone);
        }
        if (MapObject.hasExtendedType(gt.getType())) {
            Map<String, String> xta = element.getTagsWithPrefix("mkgmap:xt-", true);
            xta.putAll(element.getTagsWithPrefix("seamark:", false));
            ms.setExtTypeAttributes(new ExtTypeAttributes(xta, "OSM id " + element.getId()));
        }
    }

    private void addRoad(ConvertedWay cw) {
        List<List<Coord>> lineSegs;
        Way way = cw.getWay();
        if (way.getPoints().size() < 2) {
            log.warn("road has < 2 points", way.getId(), "(discarding)");
            return;
        }
        this.checkRoundabout(cw);
        double stubSegmentLength = 25.0;
        String wayPOI = way.getTag(WAY_POI_NODE_IDS);
        if (wayPOI != null) {
            List<Coord> points = way.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                int splitPos;
                Node node;
                CoordPOI cp;
                Coord p = points.get(i);
                if (p instanceof CoordPOI && ((CoordPOI)p).isUsed()) {
                    cp = (CoordPOI)p;
                    node = cp.getNode();
                    if (wayPOI.contains("[" + node.getId() + "]")) {
                        log.debug("POI", node.getId(), "changes way", way.getId());
                        if (p.getHighwayCount() < 2 && cp.getConvertToViaInRouteRestriction() && i != 0 && i != points.size() - 1) {
                            p.incHighwayCount();
                        }
                        String roadClass = node.getTag("mkgmap:road-class");
                        String roadSpeed = node.getTag("mkgmap:road-speed");
                        if (roadClass != null || roadSpeed != null) {
                            boolean speedChanged;
                            boolean classChanged;
                            Coord splitPoint;
                            double segmentLength = 0.0;
                            int splitPos2 = i + 1;
                            while (splitPos2 + 1 < points.size()) {
                                splitPoint = points.get(splitPos2);
                                if (splitPoint.getHighwayCount() > 1 || (segmentLength += splitPoint.distance(points.get(splitPos2 - 1))) > 20.0) break;
                                ++splitPos2;
                            }
                            if (segmentLength > 35.0) {
                                splitPoint = points.get(splitPos2);
                                Coord prev = points.get(splitPos2 - 1);
                                double dist = splitPoint.distance(prev);
                                double neededLength = 25.0 - (segmentLength - dist);
                                splitPoint = prev.makeBetweenPoint(splitPoint, neededLength / dist);
                                double newDist = splitPoint.distance(prev);
                                segmentLength += newDist - dist;
                                splitPoint.incHighwayCount();
                                points.add(splitPos2, splitPoint);
                            }
                            if (splitPos2 + 1 < points.size() && !way.isViaWay() && StyledConverter.safeToSplitWay(points, splitPos2, i, points.size() - 1)) {
                                Way tail = StyledConverter.splitWayAt(way, splitPos2);
                                this.addRoad(new ConvertedWay(cw, tail));
                            }
                            if ((classChanged = cw.recalcRoadClass(node)) && log.isInfoEnabled()) {
                                log.info("POI changing road class of", way.toBrowseURL(), "to", cw.getRoadClass(), "at", points.get(0).toOSMURL());
                            }
                            if ((speedChanged = cw.recalcRoadSpeed(node)) && log.isInfoEnabled()) {
                                log.info("POI changing road speed of", way.toBrowseURL(), "to", cw.getRoadSpeed(), "at", points.get(0).toOSMURL());
                            }
                        }
                    }
                }
                if (i + 1 >= points.size() || !(points.get(i + 1) instanceof CoordPOI)) continue;
                cp = (CoordPOI)points.get(i + 1);
                node = cp.getNode();
                if (!cp.isUsed() || !wayPOI.contains("[" + node.getId() + "]") || node.getTag("mkgmap:road-class") == null && node.getTag("mkgmap:road-speed") == null) continue;
                double segmentLength = 0.0;
                for (splitPos = i; splitPos >= 0; --splitPos) {
                    Coord splitPoint = points.get(splitPos);
                    if (splitPoint.getHighwayCount() >= 2 || (segmentLength += splitPoint.distance(points.get(splitPos + 1))) > 20.0) break;
                }
                if (segmentLength > 35.0) {
                    Coord splitPoint = points.get(splitPos);
                    Coord prev = points.get(splitPos + 1);
                    double dist = splitPoint.distance(prev);
                    double neededLength = 25.0 - (segmentLength - dist);
                    splitPoint = prev.makeBetweenPoint(splitPoint, neededLength / dist);
                    segmentLength += splitPoint.distance(prev) - dist;
                    splitPoint.incHighwayCount();
                    points.add(++splitPos, splitPoint);
                }
                if (splitPos <= 0 || !StyledConverter.safeToSplitWay(points, splitPos, 0, points.size() - 1)) continue;
                Way tail = StyledConverter.splitWayAt(way, splitPos);
                this.addRoad(new ConvertedWay(cw, tail));
            }
        }
        ArrayList<Way> clippedWays = null;
        if (this.bbox != null && (lineSegs = LineClipper.clip(this.bbox, way.getPoints())) != null) {
            if (lineSegs.isEmpty()) {
                this.removeRestrictionsWithWay(Level.WARNING, way, "ends on tile boundary, restriction is ignored");
            }
            clippedWays = new ArrayList<Way>();
            for (List<Coord> lco : lineSegs) {
                Way nWay = new Way(way.getId());
                nWay.copyTags(way);
                for (Coord co : lco) {
                    nWay.addPoint(co);
                    if (!co.getOnBoundary()) continue;
                    co.incHighwayCount();
                }
                clippedWays.add(nWay);
            }
        }
        if (clippedWays != null) {
            for (Way clippedWay : clippedWays) {
                this.addRoadAfterSplittingLoops(new ConvertedWay(cw, clippedWay));
            }
        } else {
            this.addRoadAfterSplittingLoops(cw);
        }
    }

    private void addRoadAfterSplittingLoops(ConvertedWay cw) {
        Way way = cw.getWay();
        way.getPoints().get(0).incHighwayCount();
        way.getPoints().get(way.getPoints().size() - 1).incHighwayCount();
        boolean wayWasSplit = true;
        while (wayWasSplit) {
            List<Coord> wayPoints = way.getPoints();
            int numPointsInWay = wayPoints.size();
            wayWasSplit = false;
            for (int p1I = 0; !wayWasSplit && p1I < numPointsInWay - 1; ++p1I) {
                Coord p1 = wayPoints.get(p1I);
                if (p1.getHighwayCount() < 2) continue;
                int niceSplitPos = -1;
                for (int p2I = p1I + 1; !wayWasSplit && p2I < numPointsInWay; ++p2I) {
                    int splitI;
                    Coord p2 = wayPoints.get(p2I);
                    if (p1 != p2) {
                        if (p2.getHighwayCount() <= 1) continue;
                        niceSplitPos = p2I;
                        continue;
                    }
                    if (niceSplitPos >= 0 && StyledConverter.safeToSplitWay(wayPoints, niceSplitPos, p1I, p2I)) {
                        splitI = niceSplitPos;
                    } else {
                        for (splitI = p2I - 1; splitI > p1I && !StyledConverter.safeToSplitWay(wayPoints, splitI, p1I, p2I); --splitI) {
                            if (!log.isInfoEnabled()) continue;
                            log.info("Looped way", way.getDebugName(), "can't safely split at point[" + splitI + "], trying the preceeding point");
                        }
                    }
                    if (splitI == p1I) {
                        log.warn("Splitting looped way", way.getDebugName(), "would make a zero length arc, so it will have to be pruned at", wayPoints.get(p2I).toOSMURL());
                        do {
                            log.warn((Object)("  Pruning point[" + p2I + "]"));
                            wayPoints.remove(p2I);
                            if (--p2I + 1 != --numPointsInWay) continue;
                            wayPoints.get(p2I).incHighwayCount();
                        } while (p2I > p1I && p2I + 1 == numPointsInWay && p1.equals(wayPoints.get(p2I)));
                        continue;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Splitting looped way", way.getDebugName(), "at", wayPoints.get(splitI).toOSMURL(), "- it has", numPointsInWay - splitI - 1, "following segment(s).");
                    }
                    Way loopTail = StyledConverter.splitWayAt(way, splitI);
                    ConvertedWay next = new ConvertedWay(cw, loopTail);
                    this.addRoadAfterSplittingLoops(cw);
                    cw = next;
                    way = loopTail;
                    wayWasSplit = true;
                }
            }
            if (wayWasSplit) continue;
            this.addRoadWithoutLoops(cw);
        }
    }

    private static boolean safeToSplitWay(List<Coord> points, int pos, int floor, int ceiling) {
        Coord p;
        int i;
        Coord candidate = points.get(pos);
        if (floor < 0) {
            floor = 0;
        }
        if (ceiling >= points.size()) {
            ceiling = points.size() - 1;
        }
        for (i = pos + 1; i <= ceiling; ++i) {
            p = points.get(i);
            if (i != ceiling && p.getHighwayCount() <= 1) continue;
            if (!candidate.equals(p)) break;
            return false;
        }
        for (i = pos - 1; i >= floor; --i) {
            p = points.get(i);
            if (i != floor && p.getHighwayCount() <= 1) continue;
            if (!candidate.equals(p)) break;
            return false;
        }
        return true;
    }

    private void addRoadWithoutLoops(ConvertedWay cw) {
        Way way = cw.getWay();
        GType gt = cw.getGType();
        ArrayList<Integer> nodeIndices = new ArrayList<Integer>();
        List<Coord> points = way.getPoints();
        Way trailingWay = null;
        String debugWayName = way.getDebugName();
        double arcLength = 0.0;
        class WayBBox {
            int minLat = Integer.MAX_VALUE;
            int maxLat = Integer.MIN_VALUE;
            int minLon = Integer.MAX_VALUE;
            int maxLon = Integer.MIN_VALUE;

            WayBBox() {
            }

            void addPoint(Coord co) {
                int lon;
                int lat = co.getLatitude();
                if (lat < this.minLat) {
                    this.minLat = lat;
                }
                if (lat > this.maxLat) {
                    this.maxLat = lat;
                }
                if ((lon = co.getLongitude()) < this.minLon) {
                    this.minLon = lon;
                }
                if (lon > this.maxLon) {
                    this.maxLon = lon;
                }
            }

            boolean tooBig() {
                return LineSizeSplitterFilter.testDims(this.maxLat - this.minLat, this.maxLon - this.minLon) >= 1.0;
            }
        }
        WayBBox wayBBox = new WayBBox();
        for (int i = 0; i < points.size(); ++i) {
            byte nodeAccess;
            String wayPOI;
            CoordPOI cp;
            Coord p = points.get(i);
            wayBBox.addPoint(p);
            if (i + 1 < points.size()) {
                Coord nextP = points.get(i + 1);
                double d = p.distance(nextP);
                while (true) {
                    int dlat = Math.abs(nextP.getLatitude() - p.getLatitude());
                    int dlon = Math.abs(nextP.getLongitude() - p.getLongitude());
                    if (!(d > 2.045E7) && Math.max(dlat, dlon) < Short.MAX_VALUE) break;
                    double frac = Math.min(0.5, 0.95 * (2.045E7 / d));
                    nextP = p.makeBetweenPoint(nextP, frac);
                    nextP.incHighwayCount();
                    points.add(i + 1, nextP);
                    double newD = p.distance(nextP);
                    if (log.isInfoEnabled()) {
                        log.info("Way", debugWayName, "contains a segment that is", (int)d + "m long but I am adding a new point to reduce its length to", (int)newD + "m");
                    }
                    d = newD;
                }
                wayBBox.addPoint(nextP);
                if (arcLength + d > 2.045E7) {
                    if (i <= 0) {
                        log.error("internal error: long arc segment was not split", debugWayName);
                    }
                    assert (i > 0) : "long arc segment was not split";
                    assert (trailingWay == null) : "trailingWay not null #1";
                    trailingWay = StyledConverter.splitWayAt(way, i);
                    if (log.isInfoEnabled()) {
                        log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "to limit arc length to", (long)arcLength + "m");
                    }
                } else if (wayBBox.tooBig()) {
                    if (i <= 0) {
                        log.error("internal error: arc segment with big bbox not split", debugWayName);
                    }
                    assert (i > 0) : "arc segment with big bbox not split";
                    assert (trailingWay == null) : "trailingWay not null #2";
                    trailingWay = StyledConverter.splitWayAt(way, i);
                    if (log.isInfoEnabled()) {
                        log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "to limit the size of its bounding box");
                    }
                } else {
                    if (p.getHighwayCount() > 1) {
                        arcLength = 0.0;
                    }
                    arcLength += d;
                }
            }
            if (p.getHighwayCount() <= 1) continue;
            CoordNode coordNode = this.nodeIdMap.get(p);
            if (coordNode == null) {
                coordNode = new CoordNode(p, this.nextNodeId++, p.getOnBoundary());
                this.nodeIdMap.put(p, coordNode);
            }
            if (p instanceof CoordPOI && (cp = (CoordPOI)p).getConvertToViaInRouteRestriction() && (wayPOI = way.getTag(WAY_POI_NODE_IDS)) != null && wayPOI.contains("[" + cp.getNode().getId() + "]") && (nodeAccess = AccessTagsAndBits.evalAccessTags(cp.getNode())) != cw.getAccess()) {
                List<Way> wayList = this.poiRestrictions.get(cp.getNode());
                if (wayList == null) {
                    wayList = new ArrayList<Way>();
                    this.poiRestrictions.put(cp.getNode(), wayList);
                }
                wayList.add(way);
            }
            assert (!nodeIndices.contains(i)) : debugWayName + " has multiple nodes for point " + i + " new node is " + p.toOSMURL();
            nodeIndices.add(i);
            if (i + 1 >= points.size() || nodeIndices.size() != 64) continue;
            assert (trailingWay == null) : "trailingWay not null #7";
            trailingWay = StyledConverter.splitWayAt(way, i);
            if (!log.isInfoEnabled()) continue;
            log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "as it has at least", 64, "nodes");
        }
        MapLine line = new MapLine();
        StyledConverter.elementSetup(line, cw.getGType(), way);
        line.setPoints(points);
        MapRoad road = new MapRoad(this.nextRoadId++, way.getId(), line);
        if (!this.routable) {
            road.skipAddToNOD(true);
        }
        boolean doFlareCheck = true;
        if (cw.isRoundabout()) {
            road.setRoundabout(true);
            doFlareCheck = false;
        }
        if (way.tagIsLikeYes("mkgmap:synthesised")) {
            road.setSynthesised(true);
            doFlareCheck = false;
        }
        if (way.tagIsLikeNo("mkgmap:flare-check")) {
            doFlareCheck = false;
        } else if (way.tagIsLikeYes("mkgmap:flare-check")) {
            doFlareCheck = true;
        }
        road.doFlareCheck(doFlareCheck);
        road.setLinkRoad(gt.getType() == 8 || gt.getType() == 9);
        road.setRoadClass(cw.getRoadClass());
        road.setSpeed(cw.getRoadSpeed());
        if (cw.isOneway()) {
            road.setDirection(true);
            road.setOneway();
        }
        road.setAccess(cw.getAccess());
        if (cw.isCarpool()) {
            road.setCarpoolLane();
        }
        if (!cw.isThroughroute()) {
            road.setNoThroughRouting();
        }
        if (cw.isToll()) {
            road.setToll();
        }
        if (cw.isUnpaved()) {
            road.paved(false);
        }
        if (cw.isFerry()) {
            road.ferry(true);
        }
        int numNodes = nodeIndices.size();
        if (way.isViaWay() && numNodes > 2) {
            Object rrList = this.wayRelMap.get(way.getId());
            Iterator i$ = rrList.iterator();
            while (i$.hasNext()) {
                RestrictionRelation rr = (RestrictionRelation)i$.next();
                rr.updateViaWay(way, nodeIndices);
            }
        }
        if (numNodes > 0) {
            for (int i = 0; i < numNodes; ++i) {
                int n = (Integer)nodeIndices.get(i);
                Coord coord = points.get(n);
                CoordNode thisCoordNode = this.nodeIdMap.get(coord);
                assert (thisCoordNode != null) : "Way " + debugWayName + " node " + i + " (point index " + n + ") at " + coord.toOSMURL() + " yields a null coord node";
                boolean boundary = coord.getOnBoundary();
                if (boundary && log.isInfoEnabled()) {
                    log.info("Way", debugWayName + "'s point #" + n, "at", coord.toOSMURL(), "is a boundary node");
                }
                points.set(n, thisCoordNode);
            }
        }
        if (roadLog.isInfoEnabled()) {
            int cmpAccess = (road.getRoadDef().getTabAAccess() & 0xFF) + ((road.getRoadDef().getTabAAccess() & 0xC000) >> 6);
            if (road.isDirection()) {
                cmpAccess |= 0x400;
            }
            String access = String.format("%11s", Integer.toBinaryString(cmpAccess)).replace(' ', '0');
            roadLog.info((Object)String.format("%19d 0x%-2x %11s %6d %s", way.getId(), road.getType(), access, road.getPoints().size(), Arrays.toString(road.getLabels())));
        }
        this.housenumberGenerator.addRoad(way, road);
        if (trailingWay != null) {
            this.addRoadWithoutLoops(new ConvertedWay(cw, trailingWay));
        }
    }

    private static boolean checkFixmeCoords(Way way) {
        if (way.getPoints().get(0).isFixme()) {
            return true;
        }
        return way.getPoints().get(way.getPoints().size() - 1).isFixme();
    }

    private static Way splitWayAt(Way way, int index) {
        int i;
        if (way.isViaWay()) {
            log.warn("via way of restriction is split, restriction will be ignored", way);
        }
        Way trailingWay = new Way(way.getId());
        List<Coord> wayPoints = way.getPoints();
        int numPointsInWay = wayPoints.size();
        for (i = index; i < numPointsInWay; ++i) {
            trailingWay.addPoint(wayPoints.get(i));
        }
        wayPoints.get(index).incHighwayCount();
        trailingWay.copyTags(way);
        for (i = numPointsInWay - 1; i > index; --i) {
            wayPoints.remove(i);
        }
        return trailingWay;
    }

    private void setHighwayCounts() {
        log.info((Object)"Maintaining highway counters");
        long lastId = 0L;
        ArrayList<Way> dupIdHighways = new ArrayList<Way>();
        for (ConvertedWay cw : this.roads) {
            if (!cw.isValid()) continue;
            Way way = cw.getWay();
            if (way.getId() == lastId) {
                log.debug("Road with identical id:", way.getId());
                dupIdHighways.add(way);
                continue;
            }
            lastId = way.getId();
            List<Coord> points = way.getPoints();
            for (Coord p : points) {
                p.incHighwayCount();
            }
        }
        for (Way way : dupIdHighways) {
            List<Coord> points = way.getPoints();
            points.get(0).incHighwayCount();
            points.get(points.size() - 1).incHighwayCount();
            for (int i = 1; i < points.size() - 1; ++i) {
                Coord p = points.get(i);
                if (p.getHighwayCount() <= 1) continue;
                p.incHighwayCount();
            }
        }
    }

    private void resetHighwayCounts() {
        log.info((Object)"Resetting highway counters");
        long lastId = 0L;
        for (ConvertedWay cw : this.roads) {
            Way way;
            if (!cw.isValid() || (way = cw.getWay()).getId() == lastId) continue;
            lastId = way.getId();
            List<Coord> points = way.getPoints();
            for (Coord p : points) {
                p.resetHighwayCount();
            }
        }
    }

    private void findUnconnectedRoads() {
        Way way;
        IdentityHashMap<Coord, HashSet<Way>> connectors = new IdentityHashMap<Coord, HashSet<Way>>(this.roads.size() * 2);
        HashSet<Way> selfConnectors = new HashSet<Way>();
        long lastId = 0L;
        for (ConvertedWay cw : this.roads) {
            way = cw.getWay();
            if (way.getId() == lastId) continue;
            lastId = way.getId();
            for (Coord p : way.getPoints()) {
                boolean wasNew;
                if (p.getHighwayCount() <= 1) continue;
                HashSet<Way> ways = (HashSet<Way>)connectors.get(p);
                if (ways == null) {
                    ways = new HashSet<Way>();
                    connectors.put(p, ways);
                }
                if ((wasNew = ways.add(way)) || this.reportDeadEnds <= 0) continue;
                selfConnectors.add(way);
            }
        }
        Iterator<ConvertedWay> iter = this.roads.iterator();
        while (iter.hasNext()) {
            String replType;
            ConvertedWay cw;
            cw = iter.next();
            if (!cw.isValid()) continue;
            way = cw.getWay();
            if (this.reportDeadEnds > 0 && cw.isOneway() && !way.tagIsLikeNo("mkgmap:dead-end-check")) {
                int[] pointsToCheck;
                List<Coord> points = way.getPoints();
                if (points.get((pointsToCheck = new int[]{0, points.size() - 1})[0]) == points.get(pointsToCheck[1])) continue;
                for (int pos : pointsToCheck) {
                    boolean isDeadEnd = true;
                    boolean isDeadEndOfMultipleWays = true;
                    Coord p = points.get(pos);
                    if (!this.bbox.contains(p) || p.getOnBoundary()) {
                        isDeadEnd = false;
                    } else if (p.getHighwayCount() < 2) {
                        isDeadEndOfMultipleWays = false;
                    } else {
                        HashSet ways = (HashSet)connectors.get(p);
                        if (ways.size() <= 1) {
                            isDeadEndOfMultipleWays = false;
                        }
                        block6: for (Way connectedWay : ways) {
                            Coord otherLast;
                            if (!isDeadEnd) break;
                            if (way == connectedWay) {
                                Coord pTest;
                                if (!selfConnectors.contains(way)) continue;
                                if (pos == 0) {
                                    for (int k = pos + 1; k < points.size() - 1 && (pTest = points.get(k)) != p; ++k) {
                                        if (pTest.getHighwayCount() <= 1) continue;
                                        isDeadEnd = false;
                                        continue block6;
                                    }
                                    continue;
                                }
                                for (int k = pos - 1; k >= 0 && (pTest = points.get(k)) != p; --k) {
                                    if (pTest.getHighwayCount() <= 1) continue;
                                    isDeadEnd = false;
                                    continue block6;
                                }
                                continue;
                            }
                            List<Coord> otherPoints = connectedWay.getPoints();
                            Coord otherFirst = otherPoints.get(0);
                            if (otherFirst == (otherLast = otherPoints.get(otherPoints.size() - 1)) || !connectedWay.tagIsLikeYes(onewayTagKey)) {
                                isDeadEnd = false;
                                continue;
                            }
                            Coord pOther = pos != 0 ? otherLast : otherFirst;
                            if (p == pOther) continue;
                            isDeadEnd = false;
                        }
                    }
                    if (!isDeadEnd || !isDeadEndOfMultipleWays && this.reportDeadEnds <= 1) continue;
                    log.warn((Object)("Oneway road " + way.getId() + " with tags " + way.toTagString() + (pos == 0 ? " comes from" : " goes to") + " nowhere at " + p.toOSMURL()));
                }
            }
            if ((replType = way.getTag("mkgmap:set_unconnected_type")) == null) continue;
            boolean isConnected = false;
            boolean onBoundary = false;
            for (Coord p : way.getPoints()) {
                HashSet ways;
                if (p.getOnBoundary()) {
                    onBoundary = true;
                }
                if (p.getHighwayCount() <= 1 || (ways = (HashSet)connectors.get(p)) == null || ways.size() <= 1) continue;
                isConnected = true;
                break;
            }
            if (isConnected) continue;
            if (onBoundary) {
                log.info("road not connected to other roads but is on boundary:", way.toBrowseURL());
                continue;
            }
            if ("none".equals(replType)) {
                log.info("road not connected to other roads, is ignored:", way.toBrowseURL());
            } else {
                int typeNoConnection = -1;
                try {
                    typeNoConnection = Integer.decode(replType);
                    if (GType.isRoutableLineType(typeNoConnection)) {
                        typeNoConnection = -1;
                        log.error((Object)("type value in mkgmap:set_unconnected_type should not be a routable type:" + replType));
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("invalid type value in mkgmap:set_unconnected_type:", replType);
                }
                if (typeNoConnection != -1) {
                    log.info("road not connected to other roads, added as line with type", replType + ":", way.toBrowseURL());
                    this.addLine(way, cw.getGType(), typeNoConnection);
                } else {
                    log.warn("road not connected to other roads, but replacement type is invalid. Dropped:", way.toBrowseURL());
                }
            }
            iter.remove();
        }
    }

    private void filterCoordPOI() {
        if (!this.linkPOIsToWays) {
            return;
        }
        log.info((Object)"translating CoordPOI");
        for (ConvertedWay cw : this.roads) {
            Way way;
            if (!cw.isValid() || !"true".equals((way = cw.getWay()).getTag("mkgmap:way-has-pois"))) continue;
            String wayPOI = "";
            List<Coord> points = way.getPoints();
            int numPoints = points.size();
            for (int i = 0; i < numPoints; ++i) {
                byte nodeAccess;
                Coord p = points.get(i);
                if (!(p instanceof CoordPOI)) continue;
                CoordPOI cp = (CoordPOI)p;
                Node node = cp.getNode();
                boolean usedInThisWay = false;
                byte wayAccess = cw.getAccess();
                if ((node.getTag("mkgmap:road-class") != null || node.getTag("mkgmap:road-speed") != null) && wayAccess != 1) {
                    usedInThisWay = true;
                }
                if ((nodeAccess = AccessTagsAndBits.evalAccessTags(node)) != -1) {
                    if ((wayAccess & nodeAccess) != wayAccess) {
                        if (p.getHighwayCount() >= 2 || i != 0 && i != numPoints - 1) {
                            usedInThisWay = true;
                            cp.setConvertToViaInRouteRestriction(true);
                        } else {
                            log.info("POI node", node.getId(), "with access restriction is ignored, it is not connected to other routable ways");
                        }
                    } else {
                        log.info("Access restriction in POI node", node.toBrowseURL(), "was ignored for way", way.toBrowseURL());
                    }
                }
                if (!usedInThisWay) continue;
                cp.setUsed(true);
                wayPOI = wayPOI + "[" + node.getId() + "]";
            }
            if (wayPOI.isEmpty()) {
                way.deleteTag("mkgmap:way-has-pois");
                log.info("ignoring CoordPOI(s) for way", way.toBrowseURL(), "because routing is not affected.");
                continue;
            }
            way.addTag(WAY_POI_NODE_IDS, wayPOI);
        }
    }

    @Override
    public Boolean getDriveOnLeft() {
        assert (this.roads == null) : "getDriveOnLeft() should be called after end()";
        return this.driveOnLeft;
    }

    private class NodeTypeResult
    implements TypeResult {
        private Node node;
        private boolean matched;

        private NodeTypeResult() {
        }

        public void setNode(Node node) {
            this.node = node;
            this.matched = false;
        }

        @Override
        public void add(Element el, GType type) {
            this.matched = true;
            if (type.isContinueSearch() && el == this.node) {
                el = this.node.copy();
            }
            StyledConverter.postConvertRules(el, type);
            StyledConverter.this.housenumberGenerator.addNode((Node)el);
            StyledConverter.this.addPoint((Node)el, type);
        }

        public boolean isMatched() {
            return this.matched;
        }
    }

    private class WayTypeResult
    implements TypeResult {
        private Way way;
        private boolean matched;

        private WayTypeResult() {
        }

        public void setWay(Way way) {
            this.way = way;
            this.matched = false;
        }

        @Override
        public void add(Element el, GType type) {
            this.matched = true;
            if (type.isContinueSearch() && el == this.way) {
                el = this.way.copy();
            }
            StyledConverter.postConvertRules(el, type);
            if (!type.isRoad()) {
                StyledConverter.this.housenumberGenerator.addWay((Way)el);
            }
            StyledConverter.this.addConvertedWay((Way)el, type);
        }

        public boolean isMatched() {
            return this.matched;
        }
    }
}

