/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class NotContainedFilter
extends ValueFilter {
    private String separator;
    private short tagKey;

    public NotContainedFilter(String arg) {
        String[] temp = arg.split(":");
        if (temp.length < 2 || temp[1].isEmpty()) {
            throw new SyntaxException("Missing tag to compare in style not-contained command: " + arg);
        }
        this.separator = temp[0].length() > 0 ? temp[0] : ";";
        this.tagKey = TagDict.getInstance().xlate(temp[1]);
    }

    @Override
    public String doFilter(String value, Element el) {
        String[] temp;
        if (value == null) {
            return null;
        }
        String tagValue = el.getTag(this.tagKey);
        if (tagValue == null) {
            return value;
        }
        for (String s : temp = tagValue.split(Pattern.quote(this.separator))) {
            if (!s.equals(value)) continue;
            return null;
        }
        return value;
    }
}

