/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class ValueItem {
    private String tagname;
    private short tagKey;
    private ValueFilter filter;
    private String value;
    private boolean tagname_is_local;

    public ValueItem() {
    }

    public ValueItem(String value) {
        this.value = value;
    }

    public String getValue(Element el, Element local_el) {
        if (this.tagname == null && this.value != null) {
            return this.value;
        }
        if (this.tagname != null) {
            Element e = this.tagname_is_local ? local_el : el;
            String tagval = e.getTag(this.tagKey);
            this.value = this.filter != null ? this.filter.filter(tagval, local_el) : tagval;
        }
        return this.value;
    }

    public void addFilter(ValueFilter f) {
        if (this.filter == null) {
            this.filter = f;
        } else {
            this.filter.add(f);
        }
    }

    public String getTagname() {
        return this.tagname;
    }

    public void setTagname(String tagname, boolean local) {
        this.tagname = tagname;
        this.tagname_is_local = local;
        this.tagKey = TagDict.getInstance().xlate(tagname);
    }

    public String toString() {
        if (this.tagname == null) {
            return this.value;
        }
        if (this.tagname_is_local) {
            return "$(" + this.tagname + ")";
        }
        return "${" + this.tagname + "}";
    }
}

