/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class HousenumberHooks
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(HousenumberHooks.class);
    private ElementSaver saver;
    private Node currentNodeInWay;
    private final List<Node> nodes = new ArrayList<Node>();
    private boolean clearNodes;
    private static final short addrHousenumberTagKey = TagDict.getInstance().xlate("addr:housenumber");
    private static final short addrInterpolationTagKey = TagDict.getInstance().xlate("addr:interpolation");
    public static final short partOfInterpolationTagKey = TagDict.getInstance().xlate("mkgmap:part-of-interpolation");
    public static final short mkgmapNodeIdsTagKey = TagDict.getInstance().xlate("mkgmap:node-ids");

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        if (!props.getProperty("addr-interpolation", true)) {
            return false;
        }
        return props.getProperty("housenumbers", false);
    }

    @Override
    public Set<String> getUsedTags() {
        HashSet<String> usedTags = new HashSet<String>();
        usedTags.add("addr:street");
        usedTags.add("addr:housenumber");
        usedTags.add("addr:interpolation");
        usedTags.add("addr:place");
        return usedTags;
    }

    @Override
    public void onCoordAddedToWay(Way way, long id, Coord co) {
        if (this.clearNodes) {
            this.nodes.clear();
            this.clearNodes = false;
        }
        this.currentNodeInWay = this.saver.getNode(id);
        if (this.currentNodeInWay == null) {
            return;
        }
        if (this.currentNodeInWay.getTag(addrHousenumberTagKey) == null) {
            return;
        }
        this.nodes.add(this.currentNodeInWay);
    }

    @Override
    public void onAddWay(Way way) {
        this.clearNodes = true;
        String ai = way.getTag(addrInterpolationTagKey);
        if (ai == null) {
            return;
        }
        if (this.nodes.size() < 2) {
            log.warn(way.toBrowseURL(), "tag addr:interpolation=" + ai, "is ignored, found less than two valid nodes.");
            return;
        }
        switch (ai) {
            case "odd": 
            case "even": 
            case "all": 
            case "1": 
            case "2": {
                break;
            }
            default: {
                if (log.isInfoEnabled()) {
                    log.warn(way.toBrowseURL(), "tag addr:interpolation=" + ai, "is ignored");
                }
                return;
            }
        }
        StringBuilder sb = new StringBuilder();
        int num = this.nodes.size();
        for (int i = 0; i < num; ++i) {
            Node n = this.nodes.get(i);
            String id = String.valueOf(n.getId());
            sb.append(id);
            if (i + 1 < num) {
                sb.append(",");
            }
            n.addTag(partOfInterpolationTagKey, "1");
        }
        way.addTag(mkgmapNodeIdsTagKey, sb.toString());
    }

    @Override
    public void end() {
        this.nodes.clear();
    }
}

