/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.bin;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import java.util.List;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class OsmBinHandler
extends OsmHandler {
    public OsmBinHandler(EnhancedProperties props) {
    }

    public class BinParser
    extends BinaryParser {
        @Override
        protected void parse(Osmformat.HeaderBlock header) {
            double multiplier = 1.0E-9;
            double maxLon = (double)header.getBbox().getRight() * multiplier;
            double minLon = (double)header.getBbox().getLeft() * multiplier;
            double maxLat = (double)header.getBbox().getTop() * multiplier;
            double minLat = (double)header.getBbox().getBottom() * multiplier;
            for (String s : header.getRequiredFeaturesList()) {
                if (s.equals("OsmSchema-V0.6") || s.equals("DenseNodes")) continue;
                throw new MapFailedException("File requires unknown feature: " + s);
            }
            OsmBinHandler.this.setBBox(minLat, minLon, maxLat, maxLon);
        }

        @Override
        protected void parseNodes(List<Osmformat.Node> nodes) {
            for (Osmformat.Node binNode : nodes) {
                Coord co = new Coord(this.parseLat(binNode.getLat()), this.parseLon(binNode.getLon()));
                long id = binNode.getId();
                OsmBinHandler.this.saver.addPoint(id, co);
                int tagCount = binNode.getKeysCount();
                if (tagCount <= 0) continue;
                Node node = new Node(id, co);
                for (int tid = 0; tid < tagCount; ++tid) {
                    String key = this.getStringById(binNode.getKeys(tid));
                    String val = this.getStringById(binNode.getVals(tid));
                    if ((key = OsmBinHandler.this.keepTag(key, val)) == null) continue;
                    node.addTagFromRawOSM(key, val);
                }
                OsmBinHandler.this.saver.addNode(node);
                OsmBinHandler.this.hooks.onAddNode(node);
            }
        }

        @Override
        protected final void parseDense(Osmformat.DenseNodes nodes) {
            long lastId = 0L;
            long lastLat = 0L;
            long lastLon = 0L;
            int kvid = 0;
            for (int nid = 0; nid < nodes.getIdCount(); ++nid) {
                long lat = nodes.getLat(nid) + lastLat;
                long lon = nodes.getLon(nid) + lastLon;
                long id = nodes.getId(nid) + lastId;
                lastLat = lat;
                lastLon = lon;
                lastId = id;
                Coord co = new Coord(this.parseLat(lat), this.parseLon(lon));
                OsmBinHandler.this.saver.addPoint(id, co);
                if (nodes.getKeysValsCount() <= 0) continue;
                int ntags = 0;
                Element node = null;
                while (nodes.getKeysVals(kvid) != 0) {
                    int keyid = nodes.getKeysVals(kvid++);
                    int valid = nodes.getKeysVals(kvid++);
                    String key = this.getStringById(keyid);
                    String val = this.getStringById(valid);
                    if ((key = OsmBinHandler.this.keepTag(key, val)) == null) continue;
                    if (node == null) {
                        node = new Node(id, co);
                    }
                    node.addTagFromRawOSM(key, val);
                    ++ntags;
                }
                ++kvid;
                if (ntags <= 0) continue;
                OsmBinHandler.this.saver.addNode((Node)node);
                OsmBinHandler.this.hooks.onAddNode((Node)node);
            }
        }

        @Override
        protected void parseWays(List<Osmformat.Way> ways) {
            for (Osmformat.Way binWay : ways) {
                Way way = OsmBinHandler.this.startWay(binWay.getId());
                for (int j = 0; j < binWay.getKeysCount(); ++j) {
                    String key = this.getStringById(binWay.getKeys(j));
                    String val = this.getStringById(binWay.getVals(j));
                    if ((key = OsmBinHandler.this.keepTag(key, val)) == null) continue;
                    way.addTagFromRawOSM(key, val);
                }
                long nid = 0L;
                for (long idDelta : binWay.getRefsList()) {
                    OsmBinHandler.this.addCoordToWay(way, nid += idDelta);
                }
                OsmBinHandler.this.endWay(way);
            }
        }

        @Override
        protected void parseRelations(List<Osmformat.Relation> rels) {
            for (Osmformat.Relation binRel : rels) {
                String relType;
                long id = binRel.getId();
                GeneralRelation rel = new GeneralRelation(id);
                boolean tagsIncomplete = false;
                for (int j = 0; j < binRel.getKeysCount(); ++j) {
                    String key = this.getStringById(binRel.getKeys(j));
                    String val = this.getStringById(binRel.getVals(j));
                    if ((key = "type".equals(key) ? "type" : OsmBinHandler.this.keepTag(key, val)) == null) {
                        tagsIncomplete = true;
                        continue;
                    }
                    rel.addTagFromRawOSM(key, val);
                }
                if (tagsIncomplete && ("multipolygon".equals(relType = rel.getTag("type")) || "boundary".equals(relType))) {
                    rel.addTag("mkgmap:tagsincomplete", "true");
                }
                long lastMid = 0L;
                for (int j = 0; j < binRel.getMemidsCount(); ++j) {
                    long mid;
                    lastMid = mid = lastMid + binRel.getMemids(j);
                    String role = this.getStringById(binRel.getRolesSid(j));
                    Element el = null;
                    if (binRel.getTypes(j) == Osmformat.Relation.MemberType.NODE) {
                        Coord co;
                        el = OsmBinHandler.this.saver.getNode(mid);
                        if (el == null && (co = OsmBinHandler.this.saver.getCoord(mid)) != null) {
                            el = new Node(mid, co);
                            OsmBinHandler.this.saver.addNode((Node)el);
                        }
                    } else if (binRel.getTypes(j) == Osmformat.Relation.MemberType.WAY) {
                        el = OsmBinHandler.this.saver.getWay(mid);
                    } else if (binRel.getTypes(j) == Osmformat.Relation.MemberType.RELATION) {
                        el = OsmBinHandler.this.saver.getRelation(mid);
                        if (el == null) {
                            OsmBinHandler.this.saver.deferRelation(mid, rel, role);
                        }
                    } else assert (false);
                    if (el == null) continue;
                    rel.addElement(role, el);
                }
                OsmBinHandler.this.saver.addRelation(rel);
            }
        }

        @Override
        public void complete() {
        }
    }
}

