/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryElement;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.GpxCreator;
import uk.me.parabola.util.Java2DConverter;

public class BoundaryFile2Gpx {
    private final String boundaryFileName;
    private final BoundaryQuadTree bqt;

    public BoundaryFile2Gpx(String boundaryDirName, String boundaryFileName) {
        this.boundaryFileName = boundaryFileName;
        this.bqt = BoundaryUtil.loadQuadTree(boundaryDirName, boundaryFileName);
    }

    public void saveEmptyAreas(int admLevel) {
        Area tileArea = Java2DConverter.createBoundsArea(BoundaryUtil.getBbox(this.boundaryFileName));
        Area coveredArea = this.bqt.getCoveredArea(admLevel);
        tileArea.subtract(coveredArea);
        String levelId = "admin_level";
        levelId = admLevel < 12 ? levelId + admLevel : levelId + "notset";
        if (tileArea.isEmpty()) {
            System.out.println(levelId + " is covered completely.");
        } else {
            String gpxBasename = "gpx/" + this.boundaryFileName + "/uncovered/" + levelId + "/";
            List<List<Coord>> emptyPolys = Java2DConverter.areaToShapes(tileArea);
            Collections.reverse(emptyPolys);
            int i = 0;
            for (List<Coord> emptyPart : emptyPolys) {
                String attr = Way.clockwise(emptyPart) ? "o" : "i";
                GpxCreator.createGpx(gpxBasename + i + "_" + attr, emptyPart);
                ++i;
            }
        }
    }

    public void saveAsGpx() {
        System.out.println("Start converting " + this.boundaryFileName);
        Map<String, Tags> bTags = this.bqt.getTagsMap();
        Map<String, List<Area>> areas = this.bqt.getAreas();
        Iterator<Map.Entry<String, Tags>> tagIter = bTags.entrySet().iterator();
        while (tagIter.hasNext()) {
            Map.Entry<String, Tags> entry = tagIter.next();
            List<Area> aList = areas.get(entry.getKey());
            if (aList != null && !aList.isEmpty()) continue;
            System.err.println("no area info for " + entry.getKey());
            tagIter.remove();
        }
        for (int adminlevel = 2; adminlevel < 12; ++adminlevel) {
            String admLevel;
            boolean found = false;
            for (Map.Entry<String, Tags> entry : bTags.entrySet()) {
                admLevel = entry.getValue().get("admin_level");
                if (admLevel == null || !admLevel.equals(String.valueOf(adminlevel))) continue;
                found = true;
                break;
            }
            if (!found) {
                System.out.println("No boundary with admin_level=" + adminlevel + " found.");
                continue;
            }
            for (Map.Entry<String, Tags> entry : bTags.entrySet()) {
                admLevel = entry.getValue().get("admin_level");
                if (admLevel == null) {
                    admLevel = "notset";
                }
                String bId = entry.getKey();
                String gpxBasename = "gpx/" + this.boundaryFileName + "/covered/admin_level=" + admLevel + "/" + admLevel + "_" + bId + "_";
                Path2D.Double path = new Path2D.Double();
                List<Area> aList = areas.get(bId);
                for (Area area : aList) {
                    path.append(area, false);
                }
                int i = 0;
                List<BoundaryElement> bElements = BoundaryUtil.splitToElements(new Area(path), bId);
                for (BoundaryElement be : bElements) {
                    String gpxFile = gpxBasename;
                    gpxFile = be.isOuter() ? gpxFile + "o_" + i : "i_" + i;
                    GpxCreator.createGpx(gpxFile, be.getPoints());
                    ++i;
                }
            }
            this.saveEmptyAreas(adminlevel);
        }
        System.out.println("Finished " + this.boundaryFileName);
    }

    public static void main(String[] args) {
        List<String> boundaryFileNames;
        String boundaryDirName = args[0];
        System.out.println(boundaryDirName);
        File boundaryDir = new File(boundaryDirName);
        if (boundaryDir.isFile() && boundaryDir.getName().endsWith(".bnd")) {
            boundaryDirName = boundaryDir.getParent();
            if (boundaryDirName == null) {
                boundaryDirName = ".";
            }
            boundaryFileNames = new ArrayList<String>();
            boundaryFileNames.add(boundaryDir.getName());
        } else {
            boundaryFileNames = BoundaryUtil.getBoundaryDirContent(boundaryDirName);
        }
        for (String boundaryFileName : boundaryFileNames) {
            BoundaryFile2Gpx converter = new BoundaryFile2Gpx(boundaryDirName, boundaryFileName);
            converter.saveAsGpx();
        }
    }
}

