/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.srt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.srt.SRTFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class SrtTextReader {
    private static final int IN_INITIAL = 0;
    private static final int IN_CHARACTER = 1;
    private static final int IN_EXPAND = 2;
    private final Sort sort = new Sort();
    private CharsetEncoder encoder;
    private int pos1;
    private int pos2;
    private int pos3;
    private int state;
    private String cflags = "";

    public SrtTextReader(Reader r) throws IOException {
        this("stream", r);
    }

    private SrtTextReader(String filename) throws IOException {
        this(filename, new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
    }

    private SrtTextReader(String filename, Reader r) throws IOException {
        this.read(filename, r);
    }

    public static Sort sortForCodepage(int codepage) {
        String name = "sort/cp" + codepage + ".txt";
        InputStream is = Sort.class.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            if (codepage == 1252) {
                throw new ExitException("No sort description for code-page 1252 available");
            }
            Sort defaultSort = SrtTextReader.sortForCodepage(1252);
            defaultSort.setCodepage(codepage);
            defaultSort.setDescription("Default sort");
            return defaultSort;
        }
        try {
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            SrtTextReader sr = new SrtTextReader(r);
            return sr.getSort();
        }
        catch (IOException e) {
            return SrtTextReader.sortForCodepage(codepage);
        }
    }

    public void read(String filename, Reader r) {
        TokenScanner scanner = new TokenScanner(filename, r);
        this.resetPos();
        this.state = 0;
        while (!scanner.isEndOfFile()) {
            Token tok = scanner.nextToken();
            if (tok.isValue("#")) {
                scanner.skipLine();
                continue;
            }
            switch (this.state) {
                case 0: {
                    this.initialState(scanner, tok);
                    break;
                }
                case 1: {
                    this.characterState(scanner, tok);
                    break;
                }
                case 2: {
                    this.expandState(scanner, tok);
                }
            }
        }
        this.sort.finish();
    }

    private void initialState(TokenScanner scanner, Token tok) {
        String val = tok.getValue();
        TokType type = tok.getType();
        if (type == TokType.TEXT) {
            switch (val) {
                case "codepage": {
                    int codepage = scanner.nextInt();
                    this.sort.setCodepage(codepage);
                    this.encoder = this.sort.getCharset().newEncoder();
                    break;
                }
                case "description": {
                    this.sort.setDescription(scanner.nextWord());
                    break;
                }
                case "id1": {
                    this.sort.setId1(scanner.nextInt());
                    break;
                }
                case "id2": {
                    this.sort.setId2(scanner.nextInt());
                    break;
                }
                case "multi": {
                    this.sort.setMulti(true);
                    break;
                }
                case "code": 
                case "characters": {
                    if (this.encoder == null) {
                        throw new SyntaxException(scanner, "Missing codepage declaration before code");
                    }
                    this.state = 1;
                    scanner.skipSpace();
                    break;
                }
                case "expand": {
                    this.state = 2;
                    scanner.skipSpace();
                    break;
                }
                default: {
                    throw new SyntaxException(scanner, "Unrecognised command " + val);
                }
            }
        }
    }

    private void characterState(TokenScanner scanner, Token tok) {
        String val = tok.getValue();
        TokType type = tok.getType();
        if (type == TokType.TEXT) {
            switch (val) {
                case "flags": {
                    scanner.validateNext("=");
                    this.cflags = scanner.nextWord();
                    break;
                }
                case "pos": {
                    scanner.validateNext("=");
                    try {
                        int newPos = Integer.decode(scanner.nextWord());
                        if (newPos < this.pos1) {
                            throw new SyntaxException(scanner, "cannot set primary position backwards, was " + this.pos1);
                        }
                        this.pos1 = newPos;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new SyntaxException(scanner, "invalid integer for position");
                    }
                }
                case "pos2": {
                    scanner.validateNext("=");
                    this.pos2 = Integer.decode(scanner.nextWord());
                    break;
                }
                case "pos3": {
                    scanner.validateNext("=");
                    this.pos3 = Integer.decode(scanner.nextWord());
                    break;
                }
                case "code": 
                case "characters": {
                    this.advancePos();
                    break;
                }
                case "expand": {
                    this.state = 2;
                    break;
                }
                default: {
                    this.addCharacter(scanner, val);
                    break;
                }
            }
        } else if (type == TokType.SYMBOL) {
            switch (val) {
                case "=": {
                    break;
                }
                case ",": {
                    ++this.pos3;
                    break;
                }
                case ";": {
                    this.pos3 = 1;
                    ++this.pos2;
                    break;
                }
                case "<": {
                    this.advancePos();
                    break;
                }
                default: {
                    this.addCharacter(scanner, val);
                }
            }
        }
    }

    private void expandState(TokenScanner scanner, Token tok) {
        Token t;
        String val = tok.getValue();
        Code code = new Code(scanner, val).read();
        String s = scanner.nextValue();
        if (!s.equals("to")) {
            throw new SyntaxException(scanner, "Expected the word 'to' in expand command");
        }
        ArrayList<Integer> expansionList = new ArrayList<Integer>();
        while (!scanner.isEndOfFile() && !(t = scanner.nextRawToken()).isEol()) {
            if (t.isWhiteSpace()) continue;
            Code r = new Code(scanner, t.getValue()).read();
            expansionList.add(r.getBval());
        }
        this.sort.addExpansion(code.getBval(), this.charFlags(code.getCval()), expansionList);
        this.state = 0;
    }

    private void addCharacter(TokenScanner scanner, String val) {
        Code code = new Code(scanner, val).read();
        this.setSortcode(code.getBval());
    }

    private void setSortcode(int ch) {
        int flags = this.charFlags(ch);
        if (this.cflags.contains("0")) {
            flags = 0;
        }
        this.sort.add(ch, this.pos1, this.pos2, this.pos3, flags);
        this.cflags = "";
    }

    private int charFlags(int ch) {
        int flags = 0;
        if (Character.isLetter(ch) && (Character.getType(ch) & 4) == 0) {
            flags = 1;
        }
        if (Character.isDigit(ch)) {
            flags = 2;
        }
        return flags;
    }

    private void resetPos() {
        this.pos1 = 0;
        this.pos2 = 0;
        this.pos3 = 0;
    }

    private void advancePos() {
        this.pos1 = this.pos1 == 0 ? 1 : (this.pos1 += this.pos2);
        this.pos2 = 1;
        this.pos3 = 1;
    }

    public Sort getSort() {
        return this.sort;
    }

    public static void main(String[] args) throws IOException {
        String infile = "in.txt";
        if (args.length > 0) {
            infile = args[0];
        }
        String outfile = "out.srt";
        if (args.length > 1) {
            outfile = args[1];
        }
        FileImgChannel chan = new FileImgChannel(outfile, "rw");
        SRTFile sf = new SRTFile(chan);
        SrtTextReader tr = new SrtTextReader(infile);
        Sort sort1 = tr.getSort();
        sf.setSort(sort1);
        sf.write();
        sf.close();
        chan.close();
    }

    private class Code {
        private final TokenScanner scanner;
        private final String val;
        private int cval;
        private int bval;

        public Code(TokenScanner scanner, String val) {
            this.scanner = scanner;
            this.val = val;
        }

        public int getBval() {
            return this.bval;
        }

        public int getCval() {
            return this.cval;
        }

        public Code read() {
            try {
                this.cval = this.val.length() == 1 ? (int)this.val.charAt(0) : Integer.parseInt(this.val, 16);
                if (SrtTextReader.this.sort.isMulti()) {
                    this.bval = this.cval;
                } else {
                    CharBuffer cbuf = CharBuffer.wrap(new char[]{(char)this.cval});
                    ByteBuffer out = SrtTextReader.this.encoder.encode(cbuf);
                    if (out.remaining() > 1) {
                        throw new SyntaxException(this.scanner, "more than one character resulted from conversion of " + this.val);
                    }
                    this.bval = out.get() & 0xFF;
                }
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(this.scanner, "Not a valid hex number " + this.val);
            }
            catch (CharacterCodingException e) {
                throw new SyntaxException(this.scanner, "Character not valid in character set '" + this.val + "'");
            }
            return this;
        }

        public String toString() {
            return String.format("%x", this.cval);
        }
    }
}

